/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class DatabaseOutdatedCheckBuffer
implements Disposable {
    private final Project myProject;
    private final Map<LocalDataSource, Set<BasicElement>> myScheduled;
    private final MergingUpdateQueue myQueue;

    public static DatabaseOutdatedCheckBuffer getInstance(@NotNull Project project) {
        if (project == null) {
            DatabaseOutdatedCheckBuffer.$$$reportNull$$$0(0);
        }
        return (DatabaseOutdatedCheckBuffer)project.getService(DatabaseOutdatedCheckBuffer.class);
    }

    public DatabaseOutdatedCheckBuffer(@NotNull Project project) {
        if (project == null) {
            DatabaseOutdatedCheckBuffer.$$$reportNull$$$0(1);
        }
        this.myScheduled = new HashMap<LocalDataSource, Set<BasicElement>>();
        this.myProject = project;
        project.getMessageBus().connect((Disposable)this).subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map<LocalDataSource, Set<BasicElement>> map2 = DatabaseOutdatedCheckBuffer.this.myScheduled;
                synchronized (map2) {
                    DatabaseOutdatedCheckBuffer.this.myScheduled.remove(dataSource);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseOutdatedCheckBuffer$1", "dataSourceRemoved"));
            }
        });
        this.myQueue = new MergingUpdateQueue("DS outdated check", 5000, true, null, (Disposable)this);
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleOutdatedCheck(@NotNull LocalDataSource ds, @NotNull BasicElement basic) {
        if (ds == null) {
            DatabaseOutdatedCheckBuffer.$$$reportNull$$$0(2);
        }
        if (basic == null) {
            DatabaseOutdatedCheckBuffer.$$$reportNull$$$0(3);
        }
        if (!ds.shouldCheckOutdated() || !ds.isAutoSynchronize()) {
            return;
        }
        if (!DatabaseOutdatedCheckBuffer.checkElement(ds, basic)) {
            return;
        }
        Map<LocalDataSource, Set<BasicElement>> map2 = this.myScheduled;
        synchronized (map2) {
            this.myScheduled.computeIfAbsent(ds, x -> new LinkedHashSet()).add(basic);
        }
        this.scheduleUpdate(ds);
    }

    private void scheduleUpdate(@NotNull LocalDataSource ds) {
        if (ds == null) {
            DatabaseOutdatedCheckBuffer.$$$reportNull$$$0(4);
        }
        this.myQueue.queue(Update.create((Object)ds, () -> this.update(ds)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(@NotNull LocalDataSource ds) {
        Set<BasicElement> probablyOutdatedElements;
        if (ds == null) {
            DatabaseOutdatedCheckBuffer.$$$reportNull$$$0(5);
        }
        Map<LocalDataSource, Set<BasicElement>> map2 = this.myScheduled;
        synchronized (map2) {
            probablyOutdatedElements = this.myScheduled.remove(ds);
        }
        if (!ds.shouldCheckOutdated()) {
            return;
        }
        List elementsToCheck = JBIterable.from(probablyOutdatedElements).filter(b -> !((BasicModElement)b).isDropped() && DatabaseOutdatedCheckBuffer.checkElement(ds, b)).toList();
        if (elementsToCheck.isEmpty()) {
            return;
        }
        List tasks = IntrospectionTasks.prepareCheckOutdatedTasks((String)ds.getUniqueId(), (Collection)elementsToCheck);
        DataSourceUtil.performAutoSyncTask((LoaderContext)LoaderContext.selectTasks((Project)this.myProject, (LocalDataSource)ds, (Collection)tasks));
    }

    private static boolean checkElement(@NotNull LocalDataSource ds, BasicElement b) {
        if (ds == null) {
            DatabaseOutdatedCheckBuffer.$$$reportNull$$$0(6);
        }
        return !b.isOutdated() && DBIntrospectorFactory.isOutdatedCheckSupported((Dbms)ds.getDbms(), (boolean)ds.useJdbcIntrospector(), (BasicElement)b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basic";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DatabaseOutdatedCheckBuffer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleOutdatedCheck";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleUpdate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

