/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.CommonBundle;
import com.intellij.database.BasicModelRegistry;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.connectivity.dataSource.BasicDataSourceManager;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.migration.ConsolesMigrationUtilsKt;
import com.intellij.database.dataSource.DataSourceExportImportHelperKt;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.dbimport.DbElementDnDTarget;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DataSourceManagerUi;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DatabaseSettingBooleanVal;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.RegistryBooleanVal;
import com.intellij.database.util.common.BooleanVal;
import com.intellij.database.util.sequences.EmptyMatSequence;
import com.intellij.database.util.sequences.MatSequence;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.util.tree.AbstractTree;
import com.intellij.database.view.AsyncTreeFilterModel;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseCopyPasteProvider;
import com.intellij.database.view.DatabaseDocumentationService;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseTreeContext;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DatabaseViewPanel;
import com.intellij.database.view.DatabaseViewPanel$getSelectedNodes$;
import com.intellij.database.view.DatabaseViewTreeComponent;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.DvFolderDropTarget;
import com.intellij.database.view.TreeFilterModel;
import com.intellij.database.view.TreeFilterSearch;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvErsatzFamilyNode;
import com.intellij.database.view.structure.DvFolderDeleteProvider;
import com.intellij.database.view.structure.DvMutableViewOptions;
import com.intellij.database.view.structure.DvRootDsGroup;
import com.intellij.database.view.structure.DvSimpleDsGroup;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeNodeRankFun;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.platform.ide.documentation.ActionsKt;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u0091\u00012\u00020\u00012\u00020\u0002:\n\u008d\u0001\u008e\u0001\u008f\u0001\u0090\u0001\u0091\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010@\u001a\u00020AJ\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CJ\f\u0010E\u001a\b\u0012\u0004\u0012\u00020F0CJ\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020F0C2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020D0CH\u0002J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020F0C2\u0006\u0010J\u001a\u00020DH\u0002J\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LH\u0002J\b\u0010N\u001a\u00020OH\u0002J\b\u0010P\u001a\u00020OH\u0014J\u0006\u0010Q\u001a\u00020OJ\b\u0010R\u001a\u00020OH\u0002J\u0016\u0010S\u001a\u00020O2\u0006\u0010J\u001a\u00020D2\u0006\u0010T\u001a\u00020UJ\u0014\u0010S\u001a\u0006\u0012\u0002\b\u00030V2\b\u0010J\u001a\u0004\u0018\u00010DJ\u0006\u0010W\u001a\u00020OJ\f\u0010X\u001a\b\u0012\u0004\u0012\u00020D0YJ \u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020[0Y0V2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020D0\\J\u001c\u0010]\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010^0V2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020D0\\J\u000e\u0010_\u001a\u00020O2\u0006\u0010`\u001a\u00020aJ\u0016\u0010b\u001a\u00020O2\u000e\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010D0\\J\u0014\u0010c\u001a\u0004\u0018\u00010D2\b\u0010d\u001a\u0004\u0018\u00010eH\u0007J\u001a\u0010c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010D0Y2\n\u0010f\u001a\u0006\u0012\u0002\b\u00030\\J\u001a\u0010c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010D0Y2\n\u0010f\u001a\u0006\u0012\u0002\b\u00030LJ\b\u0010g\u001a\u00020OH\u0002J\b\u0010h\u001a\u00020;H\u0002J\b\u0010i\u001a\u00020OH\u0016J\u000e\u0010j\u001a\u00020O2\u0006\u0010k\u001a\u00020lJ\u0010\u0010m\u001a\u00020O2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010n\u001a\u00020O2\u0006\u0010o\u001a\u00020pH\u0016J\u0018\u0010q\u001a\u0004\u0018\u00010r2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020u0tH\u0002J\u000e\u0010v\u001a\b\u0012\u0004\u0012\u00020u0tH\u0002J\u0013\u0010w\u001a\b\u0012\u0004\u0012\u00020M0xH\u0002\u00a2\u0006\u0002\u0010yJ\u001a\u0010z\u001a\u0004\u0018\u00010{2\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020UH\u0002J\u001c\u0010\u007f\u001a\u0004\u0018\u00010{2\u0006\u0010J\u001a\u00020D2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0002J-\u0010]\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010^0V2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020D0\\2\u0006\u0010T\u001a\u00020U2\u0007\u0010\u0082\u0001\u001a\u00020UJ\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u0011\u0010\u0085\u0001\u001a\u00020O2\b\u0010\u0086\u0001\u001a\u00030\u0084\u0001J\u0016\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\b\u0010d\u001a\u0004\u0018\u00010[H\u0002J\u0016\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u0088\u00012\b\u0010d\u001a\u0004\u0018\u00010eH\u0002J\u0013\u0010\u008a\u0001\u001a\u00020O2\n\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0012\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0012\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0012\u001a\u0004\b$\u0010%R\u0014\u0010'\u001a\u00020(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00102\u001a\u0002038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u00020;8\u0001X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006\u0092\u0001"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "options", "Lcom/intellij/database/view/structure/DvMutableViewOptions;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/view/structure/DvMutableViewOptions;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myContext", "Lcom/intellij/database/view/DatabaseTreeContext;", "myStructureService", "Lcom/intellij/database/view/structure/DvTreeStructureService;", "getMyStructureService", "()Lcom/intellij/database/view/structure/DvTreeStructureService;", "myStructureService$delegate", "Lkotlin/Lazy;", "myWrappingService", "Lcom/intellij/database/view/DatabaseNodeWrappingService;", "getMyWrappingService", "()Lcom/intellij/database/view/DatabaseNodeWrappingService;", "myWrappingService$delegate", "myModelRegistry", "Lcom/intellij/database/BasicModelRegistry;", "getMyModelRegistry", "()Lcom/intellij/database/BasicModelRegistry;", "myModelRegistry$delegate", "myDbModelRegistry", "Lcom/intellij/database/DbModelRegistry;", "getMyDbModelRegistry", "()Lcom/intellij/database/DbModelRegistry;", "myDbModelRegistry$delegate", "myDocService", "Lcom/intellij/database/view/DatabaseDocumentationService;", "getMyDocService", "()Lcom/intellij/database/view/DatabaseDocumentationService;", "myDocService$delegate", "myTree", "Lcom/intellij/database/view/DatabaseViewTreeComponent;", "getMyTree", "()Lcom/intellij/database/view/DatabaseViewTreeComponent;", "copyPasteProvider", "Lcom/intellij/database/view/DatabaseCopyPasteProvider;", "getCopyPasteProvider", "()Lcom/intellij/database/view/DatabaseCopyPasteProvider;", "myStructure", "Lcom/intellij/database/view/DatabaseStructure;", "myViewOptions", "asyncModel", "Lcom/intellij/ui/tree/AsyncTreeModel;", "getAsyncModel", "()Lcom/intellij/ui/tree/AsyncTreeModel;", "myFilterTreeModel", "Lcom/intellij/database/view/TreeFilterModel;", "myAutoScrollHandler", "Lcom/intellij/database/view/DatabaseViewPanel$MyAutoScrollFromSourceHandler;", "myToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getMyToolbar$intellij_database_impl", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "setMyToolbar$intellij_database_impl", "(Lcom/intellij/openapi/actionSystem/ActionToolbar;)V", "getTree", "Lcom/intellij/ui/treeStructure/Tree;", "getSelectedNodes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/database/model/basic/BasicNode;", "getSelectedElements", "Lcom/intellij/database/model/basic/BasicElement;", "refineAndExpandNodesAsElements", "nodes", "refineNodeAsElements", "node", "getRelatedDataSourceNodes", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/view/DataSourceNode;", "initComponents", "", "updateEmptyText", "refreshView", "invokeRefresh", "selectNode", "requestFocus", "", "Lorg/jetbrains/concurrency/Promise;", "deselectElements", "collectExpandedNodes", "", "expandNodes", "Ljavax/swing/tree/TreePath;", "", "selectNodes", "Ljava/lang/Void;", "selectElementFromEditor", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "collapseNodes", "unwrap", "o", "", "objects", "enableDnD", "createToolbar", "dispose", "setupToolWindow", "toolWindow", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "setupGearMenu", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getDropElementProvider", "Lcom/intellij/ide/DeleteProvider;", "ranks", "Ljava/util/EnumSet;", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getNodeRanks", "getRelatedDataSource", "", "()[Lcom/intellij/database/view/DataSourceNode;", "findDndTargetAt", "Lcom/intellij/ide/dnd/DnDTarget;", "point", "Ljava/awt/Point;", "strict", "getDnDTarget1", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "forceShowToolWindow", "getState", "Lorg/jdom/Element;", "loadState", "state", "getTreePathPresentationText", "", "getNodePresentationText", "showSchemaManagerGotIt", "ds", "Lcom/intellij/database/model/DasDataSource;", "MyDnDTarget", "MyDnDSource", "MyTransferable", "MyAutoScrollFromSourceHandler", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseViewPanel.kt\ncom/intellij/database/view/DatabaseViewPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 SequenceFun.kt\ncom/intellij/database/util/sequences/SequenceFun\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,932:1\n30#2,2:933\n30#2,2:958\n30#2,2:960\n30#2,2:962\n30#2,2:964\n55#3:935\n49#3:937\n477#4:936\n11561#5:938\n11896#5,3:939\n808#6,11:942\n37#7,2:953\n37#7,2:955\n37#7,2:966\n37#7,2:968\n1#8:957\n*S KotlinDebug\n*F\n+ 1 DatabaseViewPanel.kt\ncom/intellij/database/view/DatabaseViewPanel\n*L\n847#1:933,2\n120#1:958,2\n121#1:960,2\n123#1:962,2\n124#1:964,2\n142#1:935\n150#1:937\n145#1:936\n410#1:938\n410#1:939,3\n411#1:942,11\n421#1:953,2\n422#1:955,2\n450#1:966,2\n455#1:968,2\n*E\n"})
public class DatabaseViewPanel
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseTreeContext myContext;
    @NotNull
    private final Lazy myStructureService$delegate;
    @NotNull
    private final Lazy myWrappingService$delegate;
    @NotNull
    private final Lazy myModelRegistry$delegate;
    @NotNull
    private final Lazy myDbModelRegistry$delegate;
    @NotNull
    private final Lazy myDocService$delegate;
    @NotNull
    private final DatabaseViewTreeComponent myTree;
    @NotNull
    private final DatabaseCopyPasteProvider copyPasteProvider;
    @NotNull
    private final DatabaseStructure myStructure;
    @NotNull
    private final DvMutableViewOptions myViewOptions;
    @NotNull
    private final AsyncTreeModel asyncModel;
    @NotNull
    private final TreeFilterModel myFilterTreeModel;
    @NotNull
    private final MyAutoScrollFromSourceHandler myAutoScrollHandler;
    public ActionToolbar myToolbar;
    @NotNull
    private static final DataKey<MyAutoScrollFromSourceHandler> AUTO_SCROLL_HANDLER = DataKey.Companion.create("AUTO_SCROLL_HANDLER");
    @NotNull
    private static final BooleanVal ourFilterIsEnabledCheck = (BooleanVal)new RegistryBooleanVal("database.view.filter.enabled");
    @NotNull
    private static final BooleanVal ourFilterIsStickyCheck = (BooleanVal)new DatabaseSettingBooleanVal(DatabaseViewPanel::ourFilterIsStickyCheck$lambda$0);
    @NotNull
    private static final Logger ourLogger;
    @NotNull
    private static final BasicNode[] EMPTY_NODES_ARRAY;
    @NotNull
    private static final BasicElement[] EMPTY_ELEMENTS_ARRAY;
    @NotNull
    private static final DataSourceNode[] EMPTY_DSN_ARRAY;

    public DatabaseViewPanel(@NotNull Project project, @NotNull DvMutableViewOptions options) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(true, true);
        this.project = project;
        this.myStructureService$delegate = LazyKt.lazy(() -> DatabaseViewPanel.myStructureService_delegate$lambda$0(this));
        this.myWrappingService$delegate = LazyKt.lazy(() -> DatabaseViewPanel.myWrappingService_delegate$lambda$0(this));
        this.myModelRegistry$delegate = LazyKt.lazy(DatabaseViewPanel::myModelRegistry_delegate$lambda$0);
        this.myDbModelRegistry$delegate = LazyKt.lazy(() -> DatabaseViewPanel.myDbModelRegistry_delegate$lambda$0(this));
        this.myDocService$delegate = LazyKt.lazy(() -> DatabaseViewPanel.myDocService_delegate$lambda$0(this));
        this.myContext = new DatabaseTreeContext(this.project, () -> DatabaseViewPanel._init_$lambda$0(this));
        this.myViewOptions = options;
        this.myAutoScrollHandler = new MyAutoScrollFromSourceHandler(this.project, this);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.myStructure = new DatabaseStructure((DvTreeStructure)object);
        this.myTree = new DatabaseViewTreeComponent(this.myContext, (DvViewOptions)this.myViewOptions);
        this.asyncModel = new AsyncTreeModel((TreeModel)((Object)this.myStructure), (Disposable)this);
        this.myFilterTreeModel = new AsyncTreeFilterModel(this.asyncModel, (JTree)((Object)this.myTree));
        this.myTree.setModel(this.myFilterTreeModel);
        this.copyPasteProvider = new DatabaseCopyPasteProvider(this.myContext, (Tree)this.myTree);
        this.myTree.setCopyPasteProvider(this.copyPasteProvider);
        this.initComponents();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = DbPsiFacade.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> DatabaseViewPanel._init_$lambda$1(this, arg_0));
        JdbcDriverManager.getDriverManager((Project)this.project).addModificationTrackerListener(arg_0 -> DatabaseViewPanel._init_$lambda$2(this, arg_0), (Disposable)this);
        this.enableDnD();
        this.getMyStructureService().setOnStructureChanged(() -> DatabaseViewPanel._init_$lambda$3(this));
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(DatabaseConnectionManager.Companion.getTOPIC(), (arg_0, arg_1) -> DatabaseViewPanel._init_$lambda$4(this, arg_0, arg_1));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DvTreeStructureService getMyStructureService() {
        Lazy lazy = this.myStructureService$delegate;
        return (DvTreeStructureService)lazy.getValue();
    }

    private final DatabaseNodeWrappingService getMyWrappingService() {
        Lazy lazy = this.myWrappingService$delegate;
        return (DatabaseNodeWrappingService)lazy.getValue();
    }

    private final BasicModelRegistry getMyModelRegistry() {
        Lazy lazy = this.myModelRegistry$delegate;
        return (BasicModelRegistry)lazy.getValue();
    }

    private final DbModelRegistry getMyDbModelRegistry() {
        Lazy lazy = this.myDbModelRegistry$delegate;
        return (DbModelRegistry)lazy.getValue();
    }

    private final DatabaseDocumentationService getMyDocService() {
        Lazy lazy = this.myDocService$delegate;
        return (DatabaseDocumentationService)lazy.getValue();
    }

    @NotNull
    protected final DatabaseViewTreeComponent getMyTree() {
        return this.myTree;
    }

    @NotNull
    public final DatabaseCopyPasteProvider getCopyPasteProvider() {
        return this.copyPasteProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public final AsyncTreeModel getAsyncModel() {
        return this.asyncModel;
    }

    @ApiStatus.Internal
    @NotNull
    public final ActionToolbar getMyToolbar$intellij_database_impl() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar != null) {
            return actionToolbar;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myToolbar");
        return null;
    }

    public final void setMyToolbar$intellij_database_impl(@NotNull ActionToolbar actionToolbar) {
        Intrinsics.checkNotNullParameter((Object)actionToolbar, (String)"<set-?>");
        this.myToolbar = actionToolbar;
    }

    @NotNull
    public final Tree getTree() {
        return (Tree)this.myTree;
    }

    @NotNull
    public final Sequence<BasicNode> getSelectedNodes() {
        Object[] objectArray = this.myTree.getSelectionPaths();
        if (objectArray == null) {
            boolean $i$f$emptyMatSequence = false;
            return (Sequence)((MatSequence)EmptyMatSequence.INSTANCE);
        }
        Object[] selectionPaths = objectArray;
        Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])selectionPaths), DatabaseViewPanel::getSelectedNodes$lambda$0);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getSelectedNodes$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return sequence;
    }

    @NotNull
    public final Sequence<BasicElement> getSelectedElements() {
        Sequence<BasicNode> nodes;
        Sequence<BasicNode> $this$isEmpty$iv = nodes = this.getSelectedNodes();
        boolean $i$f$isEmpty = false;
        if (!SequenceFun.isNotEmpty($this$isEmpty$iv)) {
            return SequencesKt.emptySequence();
        }
        return this.refineAndExpandNodesAsElements(nodes);
    }

    private final Sequence<BasicElement> refineAndExpandNodesAsElements(Sequence<? extends BasicNode> nodes) {
        return SequencesKt.flatMap(nodes, arg_0 -> DatabaseViewPanel.refineAndExpandNodesAsElements$lambda$0(this, arg_0));
    }

    private final Sequence<BasicElement> refineNodeAsElements(BasicNode node) {
        BasicNode basicNode = node;
        return basicNode instanceof BasicElement ? SequencesKt.sequenceOf((Object)node) : (basicNode instanceof Family || basicNode instanceof DvErsatzFamilyNode ? this.refineAndExpandNodesAsElements((Sequence<? extends BasicNode>)this.getMyStructureService().childrenOf(node)) : (basicNode instanceof DataSourceNode ? UtilKt.sequenceOfNotNull((Object)((DataSourceNode)node).getModelRoot()) : SequencesKt.emptySequence()));
    }

    private final JBIterable<DataSourceNode> getRelatedDataSourceNodes() {
        JBIterable jBIterable = UtilKt.asJBIterable((Object[])this.myTree.getSelectionPaths()).filterMap(arg_0 -> DatabaseViewPanel.getRelatedDataSourceNodes$lambda$1(DatabaseViewPanel::getRelatedDataSourceNodes$lambda$0, arg_0)).unique();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"unique(...)");
        return jBIterable;
    }

    private final void initComponents() {
        block3: {
            this.myTree.getSelectionModel().setSelectionMode(4);
            this.myTree.setShowsRootHandles(true);
            this.updateEmptyText();
            EditSourceOnDoubleClickHandler.install$default((JTree)((JTree)((Object)this.myTree)), null, (int)2, null);
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
            TreeUtil.installActions((JTree)((JTree)((Object)this.myTree)));
            TreeFilterSearch ss = TreeFilterSearch.Companion.installOn((JTree)((Object)this.myTree), this.myFilterTreeModel, arg_0 -> DatabaseViewPanel.initComponents$lambda$1(arg_0 -> DatabaseViewPanel.initComponents$lambda$0(this, arg_0), arg_0));
            ss.setFilterIsEnabledCheck(ourFilterIsEnabledCheck);
            ss.setFilterIsStickyCheck(ourFilterIsStickyCheck);
            ss.setStickyStateHolder(this.myViewOptions.getFilterStickyState());
            ss.setNothingFoundTextProvider(DatabaseBundle.messagePointer((String)"tree.filer.nothingFound", (Object[])new Object[0]));
            SpeedSearchComparator ssComparator = ss.getComparator();
            this.myFilterTreeModel.setMatcher(new TreeFilterModel.Matcher(ssComparator, this){
                final /* synthetic */ SpeedSearchComparator $ssComparator;
                final /* synthetic */ DatabaseViewPanel this$0;
                {
                    this.$ssComparator = $ssComparator;
                    this.this$0 = $receiver;
                }

                public boolean matches(Object node, String input) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                    String string = DatabaseViewPanel.access$getNodePresentationText(this.this$0, node);
                    if (string == null) {
                        string = "";
                    }
                    return this.$ssComparator.matchingDegree(input, string) > 0;
                }
            });
            this.myTree.setRootVisible(false);
            PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this.myTree)), (String)"DatabaseViewPopupMenu", (String)"DatabaseViewPopup");
            JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane(null);
            Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
            JScrollPane scrollPane = jScrollPane;
            scrollPane.setViewport((JViewport)this.myTree.getViewport());
            this.setContent(scrollPane);
            this.setMyToolbar$intellij_database_impl(this.createToolbar());
            this.setToolbar(this.getMyToolbar$intellij_database_impl().getComponent());
            this.myAutoScrollHandler.install();
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction("DatabaseView.ForestNodeShiftUpAction");
            if (anAction != null) {
                anAction.registerCustomShortcutSet((JComponent)((Object)this.myTree), (Disposable)this);
            }
            AnAction anAction2 = actionManager.getAction("DatabaseView.ForestNodeShiftDownAction");
            if (anAction2 != null) {
                anAction2.registerCustomShortcutSet((JComponent)((Object)this.myTree), (Disposable)this);
            }
            AnAction anAction3 = actionManager.getAction("DatabaseView.ForestNodeShiftLeftAction");
            if (anAction3 != null) {
                anAction3.registerCustomShortcutSet((JComponent)((Object)this.myTree), (Disposable)this);
            }
            AnAction anAction4 = actionManager.getAction("DatabaseView.ForestNodeShiftRightAction");
            if (anAction4 == null) break block3;
            anAction4.registerCustomShortcutSet((JComponent)((Object)this.myTree), (Disposable)this);
        }
    }

    protected void updateEmptyText() {
        if (DbPsiFacade.getInstance((Project)this.project).getDataSources().isEmpty()) {
            AnAction action = ActionManager.getInstance().getAction("NewElement");
            this.myTree.getEmptyText().clear();
            this.myTree.getEmptyText().appendLine(DatabaseBundle.message((String)"DatabaseView.create.data.source.promotion.0", (Object[])new Object[0]));
            this.myTree.getEmptyText().appendLine(DatabaseBundle.message((String)"DatabaseView.create.data.source.promotion.1", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> DatabaseViewPanel.updateEmptyText$lambda$0(this, action, arg_0));
            String string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
            String shortcut = string;
            if (!(((CharSequence)shortcut).length() == 0)) {
                this.myTree.getEmptyText().appendText(" (" + shortcut + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES, null);
            }
        } else {
            this.myTree.getEmptyText().setText(CommonBundle.getLoadingTreeNodeText());
        }
    }

    public final void refreshView() {
        this.updateEmptyText();
        this.myStructure.refreshAll();
    }

    private final void invokeRefresh() {
        ApplicationManager.getApplication().invokeLater(() -> DatabaseViewPanel.invokeRefresh$lambda$0(this));
    }

    public final void selectNode(@NotNull BasicNode node, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (requestFocus) {
            AsyncPromise res2 = new AsyncPromise();
            Runnable continuation = () -> DatabaseViewPanel.selectNode$lambda$0(this, node, res2);
            ToolWindow window = Companion.getDatabaseToolWindow(this.project);
            window.activate(continuation);
        } else {
            this.selectNode(node);
        }
    }

    @NotNull
    public final Promise<?> selectNode(@Nullable BasicNode node) {
        BasicNode basicNode = node;
        return basicNode != null ? this.selectNodes(SetsKt.setOf((Object)basicNode)) : Promises.resolvedPromise();
    }

    public final void deselectElements() {
        this.selectNodes(SetsKt.emptySet());
    }

    @NotNull
    public final List<BasicNode> collectExpandedNodes() {
        List expanded = new ArrayList();
        int n = this.myTree.getRowCount();
        for (int i = 0; i < n; ++i) {
            BasicNode node;
            if (!this.myTree.isExpanded(i)) continue;
            Object object = this.myTree.getPathForRow(i).getLastPathComponent();
            BasicNode basicNode = node = object instanceof BasicNode ? (BasicNode)object : null;
            if (node == null) continue;
            ((Collection)expanded).add(node);
        }
        return expanded;
    }

    @NotNull
    public final Promise<List<TreePath>> expandNodes(@NotNull Collection<? extends BasicNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        AsyncTreeModel treeModel = this.asyncModel;
        List list = JBIterable.from((Iterable)nodes).map(arg_0 -> DatabaseViewPanel.expandNodes$lambda$1(arg_0 -> DatabaseViewPanel.expandNodes$lambda$0(treeModel, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List promises = list;
        Promise collectedPromise = Promises.collectResults((Collection)promises, (boolean)true);
        Promise promise = collectedPromise.onProcessed(arg_0 -> DatabaseViewPanel.expandNodes$lambda$3(arg_0 -> DatabaseViewPanel.expandNodes$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onProcessed(...)");
        return promise;
    }

    @NotNull
    public final Promise<Void> selectNodes(@NotNull Collection<? extends BasicNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        AsyncTreeModel treeModel = this.asyncModel;
        List list = JBIterable.from((Iterable)nodes).map(arg_0 -> DatabaseViewPanel.selectNodes$lambda$1(arg_0 -> DatabaseViewPanel.selectNodes$lambda$0(treeModel, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List promises = list;
        Promise collectedPromise = Promises.collectResults((Collection)promises, (boolean)true);
        Promise promise = collectedPromise.onProcessed(arg_0 -> DatabaseViewPanel.selectNodes$lambda$3(arg_0 -> DatabaseViewPanel.selectNodes$lambda$2(this, arg_0), arg_0)).then(arg_0 -> DatabaseViewPanel.selectNodes$lambda$5(DatabaseViewPanel::selectNodes$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    public final void selectElementFromEditor(@NotNull FileEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.myAutoScrollHandler.selectElementFromEditorInner(editor2, true);
    }

    public final void collapseNodes(@NotNull Collection<? extends BasicNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        AsyncTreeModel treeModel = this.asyncModel;
        for (BasicNode basicNode : nodes) {
            Promise treePathPromise;
            Intrinsics.checkNotNullExpressionValue((Object)treeModel.getTreePath((Object)basicNode), (String)"getTreePath(...)");
            treePathPromise.onProcessed(arg_0 -> DatabaseViewPanel.collapseNodes$lambda$1(arg_0 -> DatabaseViewPanel.collapseNodes$lambda$0(this, arg_0), arg_0));
        }
    }

    @Contract(value="null->null")
    @Nullable
    public final BasicNode unwrap(@Nullable Object o) {
        if (o instanceof BasicNode) {
            return (BasicNode)o;
        }
        BasicNode unwrappedNode = o instanceof PsiElement ? this.getMyWrappingService().unwrap((Object)((PsiElement)o)) : null;
        return unwrappedNode;
    }

    @NotNull
    public final List<BasicNode> unwrap(@NotNull Collection<?> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        JBIterable jBIterable = JBIterable.from((Iterable)objects);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        return this.unwrap(jBIterable);
    }

    @NotNull
    public final List<BasicNode> unwrap(@NotNull JBIterable<?> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        List list = objects.filterMap(arg_0 -> DatabaseViewPanel.unwrap$lambda$0(this, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    private final void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)((Object)this.myTree));
            DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(), (JComponent)((Object)this.myTree));
        }
    }

    private final ActionToolbar createToolbar() {
        ActionManagerEx actionManager = ActionManagerEx.Companion.getInstanceEx();
        AnAction anAction = actionManager.getAction("DatabaseViewToolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup group = (ActionGroup)anAction;
        ActionToolbar toolbar = actionManager.createActionToolbar("DatabaseViewToolbar", group, true, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myTree));
        return toolbar;
    }

    public void dispose() {
        this.removeAll();
    }

    public final void setupToolWindow(@NotNull ToolWindowEx toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.setupGearMenu(toolWindow);
        AnAction consoleTitleAction2 = (AnAction)new DumbAwareAction(this){
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setVisible(!this.this$0.isToolbarVisible());
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = UtilKt.asJBIterable((Object[])this.this$0.getMyTree().getSelectionPaths()).map(arg_0 -> setupToolWindow.consoleTitleAction.1.actionPerformed$lambda$1(setupToolWindow.consoleTitleAction.1::actionPerformed$lambda$0, arg_0)).filterNotNull().filter(Conditions.notNull()).unique();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unique(...)");
                object = (Iterable)object;
                DatabaseViewPanel databaseViewPanel = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DataSourceNode it = (DataSourceNode)element$iv;
                    boolean bl = false;
                    DatabaseEditorHelper.openConsoleFile(databaseViewPanel.getProject(), it.dataSource);
                }
            }

            private static final DataSourceNode actionPerformed$lambda$0(TreePath it) {
                return com.intellij.database.view.DatabaseViewPanel$Companion.access$findDsnInPath(DatabaseViewPanel.Companion, it);
            }

            private static final DataSourceNode actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
                return (DataSourceNode)$tmp0.invoke(p0);
            }
        };
        Presentation presentation = consoleTitleAction2.getTemplatePresentation();
        String string = DatabaseBundle.message((String)"action.OpenConsole.text.legacy", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message((String)"action.OpenConsole.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        presentation.setText(ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(string, string2));
        consoleTitleAction2.getTemplatePresentation().setIcon(DatabaseIcons.ConsoleRun);
        AnAction refreshTitleAction2 = (AnAction)new DumbAwareAction(this){
            private final AnAction baseAction;
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
                AnAction anAction = ActionManager.getInstance().getAction("DatabaseView.Refresh");
                Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
                this.baseAction = anAction;
                ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"DatabaseView.Refresh");
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
            }

            public final AnAction getBaseAction() {
                return this.baseAction;
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabledAndVisible(!this.this$0.isToolbarVisible());
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.baseAction.actionPerformed(new AnActionEvent(e.getInputEvent(), DataManager.getInstance().getDataContext((Component)((Object)this.this$0)), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers()));
            }
        };
        AnAction scrollFromEditorAction = ActionManager.getInstance().getAction("DatabaseView.ScrollFromEditor");
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        Object[] objectArray = new AnAction[]{refreshTitleAction2, consoleTitleAction2, scrollFromEditorAction, actionsManager.createExpandAllHeaderAction((JTree)((Object)this.myTree)), actionsManager.createCollapseAllHeaderAction((JTree)((Object)this.myTree))};
        toolWindow.setTitleActions(CollectionsKt.listOf((Object[])objectArray));
    }

    private final void setupGearMenu(ToolWindowEx toolWindow) {
        AnAction anAction = ActionManager.getInstance().getAction("DatabaseView.MoreOptions");
        ActionGroup group = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
        toolWindow.setAdditionalGearActions(group);
    }

    /*
     * Unable to fully structure code
     */
    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        if (this.project.isDisposed()) {
            return;
        }
        v0 = this.myTree.getSelectionPaths();
        if (v0 != null) {
            $this$map$iv = v0;
            $i$f$map = false;
            var7_7 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>($this$map$iv.length);
            $i$f$mapTo = false;
            var11_19 = ((void)$this$mapTo$iv$iv).length;
            for (var10_15 = 0; var10_15 < var11_19; ++var10_15) {
                var13_23 = item$iv$iv = $this$mapTo$iv$iv[var10_15];
                var15_25 = destination$iv$iv;
                $i$a$-map-DatabaseViewPanel$uiDataSnapshot$lpc$1 = false;
                var15_25.add(it.getLastPathComponent());
            }
            v1 = (List)destination$iv$iv;
        } else {
            v1 = CollectionsKt.emptyList();
        }
        lpc = v1;
        $this$filterIsInstance$iv = lpc;
        $i$f$filterIsInstance = false;
        $i$f$map = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BasicNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        nodes = (List)destination$iv$iv;
        selectedNodes = SequencesKt.toList(this.getSelectedNodes());
        selectedElements = SequencesKt.toList(this.getSelectedElements());
        nodeRanks = this.getNodeRanks();
        singleNode = (BasicNode)CollectionsKt.singleOrNull((List)nodes);
        v2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"PROJECT");
        sink.set(v2, (Object)this.project);
        v3 = DatabaseView.DATABASE_TREE_IS_ORIGIN;
        Intrinsics.checkNotNullExpressionValue(v3, (String)"DATABASE_TREE_IS_ORIGIN");
        sink.set(v3, (Object)true);
        v4 = DatabaseView.DATABASE_VIEW_KEY;
        Intrinsics.checkNotNullExpressionValue(v4, (String)"DATABASE_VIEW_KEY");
        sink.set(v4, (Object)DatabaseView.getDatabaseView(this.project));
        v5 = DatabaseView.DATABASE_NODES;
        Intrinsics.checkNotNullExpressionValue(v5, (String)"DATABASE_NODES");
        $this$toTypedArray$iv = selectedNodes;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        sink.set(v5, (Object)thisCollection$iv.toArray(new BasicNode[0]));
        v6 = DatabaseView.DATABASE_ELEMENTS;
        Intrinsics.checkNotNullExpressionValue(v6, (String)"DATABASE_ELEMENTS");
        $this$toTypedArray$iv = selectedElements;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        sink.set(v6, (Object)thisCollection$iv.toArray(new BasicElement[0]));
        v7 = DatabaseView.DATABASE_NODE_RANKS;
        Intrinsics.checkNotNullExpressionValue(v7, (String)"DATABASE_NODE_RANKS");
        sink.set(v7, nodeRanks);
        v8 = DatabaseView.DATABASE_RELATED_SINGLE_DATA_SOURCE;
        Intrinsics.checkNotNullExpressionValue(v8, (String)"DATABASE_RELATED_SINGLE_DATA_SOURCE");
        sink.set(v8, this.getRelatedDataSourceNodes().single());
        v9 = DatabaseView.DATABASE_RELATED_DATA_SOURCES;
        Intrinsics.checkNotNullExpressionValue(v9, (String)"DATABASE_RELATED_DATA_SOURCES");
        sink.set(v9, (Object)this.getRelatedDataSource());
        v10 = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"HELP_ID");
        sink.set(v10, (Object)"reference.tools.datasource");
        $i$f$toTypedArray = this;
        var16_29 = ActionsKt.DOCUMENTATION_TARGETS;
        var15_25 = sink;
        $i$a$-run-DatabaseViewPanel$uiDataSnapshot$1 = false;
        v11 = (BasicNode)CollectionsKt.singleOrNull((List)selectedNodes);
        if (v11 == null) ** GOTO lbl-1000
        it = v11;
        $i$a$-let-DatabaseViewPanel$uiDataSnapshot$1$1 = false;
        v12 = super.getMyDocService().prepareQuickDoc(it);
        v11 = v12;
        if (v12 != null) {
            it = v11;
            $i$a$-let-DatabaseViewPanel$uiDataSnapshot$1$2 = false;
            v13 = CollectionsKt.listOf((Object)it);
        } else lbl-1000:
        // 2 sources

        {
            v13 = null;
        }
        var17_30 = v13;
        var15_25.set(var16_29, var17_30);
        v14 = DatabaseView.DROP_ELEMENT_PROVIDER;
        Intrinsics.checkNotNullExpressionValue(v14, (String)"DROP_ELEMENT_PROVIDER");
        sink.set(v14, (Object)this.getDropElementProvider(nodeRanks));
        v15 = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"COPY_PROVIDER");
        sink.set(v15, (Object)this.copyPasteProvider);
        v16 = PlatformDataKeys.CUT_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"CUT_PROVIDER");
        sink.set(v16, (Object)this.copyPasteProvider);
        v17 = PlatformDataKeys.PASTE_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"PASTE_PROVIDER");
        sink.set(v17, (Object)this.copyPasteProvider);
        sink.set(DatabaseViewPanel.AUTO_SCROLL_HANDLER, (Object)this.myAutoScrollHandler);
        v18 = VcsDataKeys.VIRTUAL_FILES;
        Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"VIRTUAL_FILES");
        sink.lazy(v18, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, uiDataSnapshot$lambda$2(com.intellij.database.view.DatabaseViewPanel java.util.List ), ()Ljava/lang/Iterable;)((DatabaseViewPanel)this, (List)nodes));
        v19 = CommonDataKeys.NAVIGATABLE;
        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"NAVIGATABLE");
        sink.lazy(v19, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, uiDataSnapshot$lambda$3(com.intellij.database.model.basic.BasicNode com.intellij.database.view.DatabaseViewPanel ), ()Lcom/intellij/pom/Navigatable;)((BasicNode)singleNode, (DatabaseViewPanel)this));
        v20 = CommonDataKeys.PSI_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"PSI_ELEMENT");
        sink.lazy(v20, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, uiDataSnapshot$lambda$4(com.intellij.database.model.basic.BasicNode com.intellij.database.view.DatabaseViewPanel ), ()Lcom/intellij/psi/PsiElement;)((BasicNode)singleNode, (DatabaseViewPanel)this));
        v21 = PlatformCoreDataKeys.PSI_ELEMENT_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"PSI_ELEMENT_ARRAY");
        sink.lazy(v21, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, uiDataSnapshot$lambda$5(java.util.List com.intellij.database.view.DatabaseViewPanel ), ()[Lcom/intellij/psi/PsiElement;)((List)nodes, (DatabaseViewPanel)this));
        v22 = CommonDataKeys.NAVIGATABLE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"NAVIGATABLE_ARRAY");
        sink.lazy(v22, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, uiDataSnapshot$lambda$6(java.util.List com.intellij.database.view.DatabaseViewPanel ), ()[Lcom/intellij/pom/Navigatable;)((List)nodes, (DatabaseViewPanel)this));
    }

    private final DeleteProvider getDropElementProvider(EnumSet<DvTreeNodeRank> ranks) {
        if (ranks.isEmpty()) {
            return null;
        }
        if (ranks.contains(DvTreeNodeRank.TL_FOLDER)) {
            return new DvFolderDeleteProvider(this.project);
        }
        if (ranks.contains(DvTreeNodeRank.TL_UNKNOWN)) {
            return null;
        }
        return ranks.contains(DvTreeNodeRank.TL_ROOT) || ranks.contains(DvTreeNodeRank.TL_FAMILY) || ranks.contains(DvTreeNodeRank.TL_NAMESPACE) || ranks.contains(DvTreeNodeRank.TL_ELEMENT) ? (DeleteProvider)new DbDeleteProvider.DbTreeDeleteProvider() : null;
    }

    private final EnumSet<DvTreeNodeRank> getNodeRanks() {
        EnumSet<DvTreeNodeRank> ranks = EnumSet.noneOf(DvTreeNodeRank.class);
        Sequence<BasicNode> selectedNodes = this.getSelectedNodes();
        for (BasicNode node : selectedNodes) {
            ranks.add(DvTreeNodeRankFun.getTreeNodeRank((BasicNode)node));
        }
        Intrinsics.checkNotNull(ranks);
        return ranks;
    }

    private final DataSourceNode[] getRelatedDataSource() {
        DataSourceNode[] dataSourceNodeArray;
        JBIterable<DataSourceNode> relatedDSNs = this.getRelatedDataSourceNodes();
        if (relatedDSNs.isEmpty()) {
            dataSourceNodeArray = EMPTY_DSN_ARRAY;
        } else {
            Object[] objectArray = relatedDSNs.toArray((Object[])EMPTY_DSN_ARRAY);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
            dataSourceNodeArray = (DataSourceNode[])objectArray;
        }
        return dataSourceNodeArray;
    }

    private final DnDTarget findDndTargetAt(Point point, boolean strict) {
        DasObject o;
        TreePath path;
        TreePath treePath = path = strict ? this.myTree.getPathForLocation(point.x, point.y) : this.myTree.getClosestPathForLocation(point.x, point.y);
        if (path == null) {
            return null;
        }
        Object smth = path.getLastPathComponent();
        if (smth == null) {
            return null;
        }
        if (smth instanceof BasicNode) {
            DvTreeContext context = this.getMyStructureService().getContext();
            return this.getDnDTarget1((BasicNode)smth, context);
        }
        DataSourceNode dataSourceNode = DatabaseViewPanel.Companion.findDsnInPath(path);
        if (dataSourceNode == null) {
            return null;
        }
        DataSourceNode dsn = dataSourceNode;
        DbDataSource dbDataSource = this.getMyDbModelRegistry().findDbDataSource(dsn);
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dbDataSource2 = dbDataSource;
        DasObject dasObject = o = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class);
        Object object = dasObject == null ? smth : DbImplUtilCore.findElement((DbDataSource)dbDataSource2, (DasObject)dasObject);
        Intrinsics.checkNotNull((Object)object);
        Object element = object;
        return DatabaseViewPanel.Companion.getDnDTarget2(element);
    }

    private final DnDTarget getDnDTarget1(BasicNode node, DvTreeContext context) {
        DnDTarget dnDTarget;
        BasicNode basicNode = node;
        if (basicNode instanceof DvFolder) {
            dnDTarget = new DvFolderDropTarget(this.project, (DvFolder)node, (JTree)((Object)this.myTree), (AbstractTree<BasicNode>)this.getMyStructureService().getAbstractTree());
        } else if (basicNode instanceof DvDsGroup) {
            String string;
            DvDsGroup dvDsGroup = (DvDsGroup)node;
            if (dvDsGroup instanceof DvSimpleDsGroup) {
                string = ((DvSimpleDsGroup)node).path;
            } else if (dvDsGroup instanceof DvRootDsGroup) {
                string = "";
            } else {
                return null;
            }
            String groupName = string;
            dnDTarget = new DataSourceUiUtil.DbGroupDropTarget(groupName, this.project);
        } else if (basicNode instanceof DataSourceNode) {
            DbDataSource dbDataSource = this.getMyDbModelRegistry().findDbDataSource((DataSourceNode)node);
            if (dbDataSource == null) {
                return null;
            }
            DbDataSource dbDataSource2 = dbDataSource;
            DnDTarget target = DatabaseViewPanel.Companion.getDataSourceManagerUi(dbDataSource2).createDnDTarget(dbDataSource2.getDelegate());
            if (target == null) {
                target = new DbElementDnDTarget.DataSourceDnDTarget(dbDataSource2);
            }
            dnDTarget = target;
        } else if (basicNode instanceof BasicElement) {
            DbModelRegistry r = (DbModelRegistry)context.project.getService(DbModelRegistry.class);
            DbElement dbElement = r.findDbElement((BasicElement)node);
            dnDTarget = DatabaseViewPanel.Companion.getDnDTarget2(dbElement);
        } else if (basicNode instanceof HostFamily) {
            DbModelRegistry registry;
            BasicElement basicElement = ((HostFamily)node).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
            BasicElement host = basicElement;
            DbModelRegistry dbModelRegistry = registry = (DbModelRegistry)context.project.getService(DbModelRegistry.class);
            DbElement dbHost = dbModelRegistry != null ? dbModelRegistry.findDbElement(host) : null;
            dnDTarget = dbHost instanceof DbNamespaceImpl ? new DbElementDnDTarget.FamilyGroupDnDTarget((DbNamespaceImpl)dbHost, ((HostFamily)node).getChildrenKind()) : null;
        } else {
            dnDTarget = null;
        }
        return dnDTarget;
    }

    @NotNull
    public final Promise<Void> selectNodes(@NotNull Collection<? extends BasicNode> nodes, boolean requestFocus, boolean forceShowToolWindow) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        ToolWindow window = Companion.getDatabaseToolWindow(this.project);
        if (!requestFocus && !forceShowToolWindow) {
            return this.selectNodes(nodes);
        }
        AsyncPromise res2 = new AsyncPromise();
        Runnable continuation = () -> DatabaseViewPanel.selectNodes$lambda$6(this, nodes, res2);
        if (requestFocus) {
            window.activate(continuation);
        } else {
            window.show(continuation);
        }
        return (Promise)res2;
    }

    @NotNull
    public final Element getState() {
        Element element = new Element("TreeState");
        TreeState.createOn((JTree)((JTree)((Object)this.myTree))).writeExternal(element);
        return element;
    }

    public final void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializer.deserializeInto((Object)this.myViewOptions, (Element)state);
        TreeState treeState = TreeState.createFrom((Element)state);
        Intrinsics.checkNotNullExpressionValue((Object)treeState, (String)"createFrom(...)");
        TreeState treeState2 = treeState;
        treeState2.applyTo((JTree)((Object)this.myTree), (Object)this.myStructure.getRoot());
    }

    private final String getTreePathPresentationText(TreePath o) {
        TreePath treePath = o;
        Object node = treePath != null ? treePath.getLastPathComponent() : null;
        return this.getNodePresentationText(node);
    }

    private final String getNodePresentationText(Object o) {
        if (o instanceof BasicNode) {
            ItemPresentation presentation;
            ItemPresentation itemPresentation = presentation = (ItemPresentation)ReadAction.compute(() -> DatabaseViewPanel.getNodePresentationText$lambda$0(this, o));
            return itemPresentation != null ? itemPresentation.getPresentableText() : null;
        }
        return null;
    }

    public final void showSchemaManagerGotIt(@Nullable DasDataSource ds) {
        DasDataSource dasDataSource;
        if (ds == null) {
            return;
        }
        DasDataSource dasDataSource2 = ds;
        Object object = dasDataSource2 instanceof RawDataSource ? (RawDataSource)dasDataSource2 : null;
        if (object == null) {
            dasDataSource = ds;
            DbDataSource dbDataSource = dasDataSource instanceof DbDataSource ? (DbDataSource)dasDataSource : null;
            object = dbDataSource != null ? dbDataSource.getDelegateDataSource() : null;
            if (object == null) {
                return;
            }
        }
        RawDataSource rds = object;
        String string = DatabaseBundle.message((String)"click.here.to.display.other.schemas.got.it", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GotItTooltip tip = new GotItTooltip("database.schema.control.got.it", string, (Disposable)this);
        if (!tip.canShow()) {
            return;
        }
        AsyncTreeModel model = this.asyncModel;
        DataSourceNode dsn = this.getMyModelRegistry().getDataSourceNode(rds);
        dasDataSource = new Function1(this, tip){
            final /* synthetic */ DatabaseViewPanel this$0;
            final /* synthetic */ GotItTooltip $tip;
            {
                this.this$0 = $receiver;
                this.$tip = $tip;
            }

            public final Void invoke(TreePath path) {
                Tree tree = this.this$0.getTree();
                Intrinsics.checkNotNull((Object)path);
                Point pt = com.intellij.database.view.DatabaseViewPanel$Companion.access$getSchemaControlLocation(DatabaseViewPanel.Companion, path, tree);
                if (pt != null) {
                    tree.scrollRectToVisible(new Rectangle(pt));
                }
                this.$tip.show((JComponent)tree, (arg_0, arg_1) -> showSchemaManagerGotIt.2.invoke$lambda$0(path, tree, arg_0, arg_1));
                return null;
            }

            private static final Point invoke$lambda$0(TreePath $path, Tree $tree, Component c2, Balloon b) {
                Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNull((Object)$path);
                Point loc = com.intellij.database.view.DatabaseViewPanel$Companion.access$getSchemaControlLocation(DatabaseViewPanel.Companion, $path, $tree);
                Point point = loc;
                if (point == null) {
                    point = new Point();
                }
                return point;
            }
        };
        model.getTreePath((Object)dsn).thenAsync(arg_0 -> DatabaseViewPanel.showSchemaManagerGotIt$lambda$1(arg_0 -> DatabaseViewPanel.showSchemaManagerGotIt$lambda$0(model, arg_0), arg_0)).then(new Function((Function1)dasDataSource){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object fun(Object p0) {
                return this.function.invoke(p0);
            }
        });
    }

    private static final DvTreeStructureService myStructureService_delegate$lambda$0(DatabaseViewPanel this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DvTreeStructureService)object;
    }

    private static final DatabaseNodeWrappingService myWrappingService_delegate$lambda$0(DatabaseViewPanel this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<DatabaseNodeWrappingService> serviceClass$iv = DatabaseNodeWrappingService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DatabaseNodeWrappingService)object;
    }

    private static final BasicModelRegistry myModelRegistry_delegate$lambda$0() {
        return BasicModelRegistry.Companion.instance();
    }

    private static final DbModelRegistry myDbModelRegistry_delegate$lambda$0(DatabaseViewPanel this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<DbModelRegistry> serviceClass$iv = DbModelRegistry.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DbModelRegistry)object;
    }

    private static final DatabaseDocumentationService myDocService_delegate$lambda$0(DatabaseViewPanel this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<DatabaseDocumentationService> serviceClass$iv = DatabaseDocumentationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DatabaseDocumentationService)object;
    }

    private static final Object getSelectedNodes$lambda$0(TreePath it) {
        return it.getLastPathComponent();
    }

    private static final Sequence refineAndExpandNodesAsElements$lambda$0(DatabaseViewPanel this$0, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.refineNodeAsElements(it);
    }

    private static final DataSourceNode getRelatedDataSourceNodes$lambda$0(TreePath it) {
        Intrinsics.checkNotNull((Object)it);
        return DatabaseViewPanel.Companion.getPathDSN(it);
    }

    private static final DataSourceNode getRelatedDataSourceNodes$lambda$1(Function1 $tmp0, Object p0) {
        return (DataSourceNode)$tmp0.invoke(p0);
    }

    private static final String initComponents$lambda$0(DatabaseViewPanel this$0, TreePath it) {
        return this$0.getTreePathPresentationText(it);
    }

    private static final String initComponents$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void updateEmptyText$lambda$0(DatabaseViewPanel this$0, AnAction $action, ActionEvent it) {
        DataContext dataContext = SimpleDataContext.getSimpleContext((DataKey)PlatformDataKeys.CONTEXT_MENU_POINT, (Object)this$0.myTree.getEmptyText().getPointBelow(), (DataContext)DataManager.getInstance().getDataContext((Component)((Object)this$0.myTree)));
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getSimpleContext(...)");
        DataContext context = dataContext;
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"DatabaseViewPopup", null, (DataContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent event = anActionEvent;
        Intrinsics.checkNotNull((Object)$action);
        ActionUtil.performAction((AnAction)$action, (AnActionEvent)event);
    }

    private static final void invokeRefresh$lambda$0(DatabaseViewPanel this$0) {
        this$0.myStructure.refreshAll();
    }

    private static final void selectNode$lambda$0(DatabaseViewPanel this$0, BasicNode $node, AsyncPromise $res) {
        this$0.selectNode($node).processed((Promise)$res);
    }

    private static final Promise expandNodes$lambda$0(AsyncTreeModel $treeModel, BasicNode it) {
        return $treeModel.getTreePath((Object)it);
    }

    private static final Promise expandNodes$lambda$1(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Unit expandNodes$lambda$2(DatabaseViewPanel this$0, List paths) {
        if (paths != null) {
            TreeUtil.expandPaths((JTree)((JTree)((Object)this$0.myTree)), (Iterable)paths);
        }
        return Unit.INSTANCE;
    }

    private static final void expandNodes$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Promise selectNodes$lambda$0(AsyncTreeModel $treeModel, BasicNode it) {
        return $treeModel.getTreePath((Object)it);
    }

    private static final Promise selectNodes$lambda$1(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Unit selectNodes$lambda$2(DatabaseViewPanel this$0, List paths) {
        if (paths != null) {
            TreeUtil.selectPaths((JTree)((JTree)((Object)this$0.myTree)), (Collection)paths);
        }
        return Unit.INSTANCE;
    }

    private static final void selectNodes$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void selectNodes$lambda$4(List it) {
        return null;
    }

    private static final Void selectNodes$lambda$5(Function1 $tmp0, Object p0) {
        return (Void)$tmp0.invoke(p0);
    }

    private static final Unit collapseNodes$lambda$0(DatabaseViewPanel this$0, TreePath it) {
        this$0.myTree.collapsePath(it);
        return Unit.INSTANCE;
    }

    private static final void collapseNodes$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final BasicNode unwrap$lambda$0(DatabaseViewPanel this$0, Object o) {
        return this$0.unwrap(o);
    }

    private static final Iterable uiDataSnapshot$lambda$2(DatabaseViewPanel this$0, List $nodes) {
        return DbNodeDescriptor.getVirtualFiles(this$0.project, () -> DatabaseViewPanel.uiDataSnapshot$lambda$2$0($nodes));
    }

    private static final Collection uiDataSnapshot$lambda$2$0(List $nodes) {
        return $nodes;
    }

    private static final Navigatable uiDataSnapshot$lambda$3(BasicNode $singleNode, DatabaseViewPanel this$0) {
        Navigatable navigatable;
        BasicNode basicNode = $singleNode;
        if (basicNode != null) {
            BasicNode it = basicNode;
            boolean bl = false;
            navigatable = DbNodeDescriptor.getNavigatable(this$0.project, it);
        } else {
            navigatable = null;
        }
        return navigatable;
    }

    private static final PsiElement uiDataSnapshot$lambda$4(BasicNode $singleNode, DatabaseViewPanel this$0) {
        PsiElement psiElement;
        BasicNode basicNode = $singleNode;
        if (basicNode != null) {
            BasicNode it = basicNode;
            boolean bl = false;
            psiElement = DbNodeDescriptor.getPsiElement(this$0.project, it);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    private static final PsiElement[] uiDataSnapshot$lambda$5(List $nodes, DatabaseViewPanel this$0) {
        PsiElement[] psiElementArray;
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)$nodes), arg_0 -> DatabaseViewPanel.uiDataSnapshot$lambda$5$0(this$0, arg_0))));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiElement[] it = psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
        boolean bl = false;
        return !(it.length == 0) ? psiElementArray : null;
    }

    private static final PsiElement uiDataSnapshot$lambda$5$0(DatabaseViewPanel this$0, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DbNodeDescriptor.getPsiElement(this$0.project, it);
    }

    private static final Navigatable[] uiDataSnapshot$lambda$6(List $nodes, DatabaseViewPanel this$0) {
        Navigatable[] navigatableArray;
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)$nodes), arg_0 -> DatabaseViewPanel.uiDataSnapshot$lambda$6$0(this$0, arg_0))));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Navigatable[] it = navigatableArray = thisCollection$iv.toArray(new Navigatable[0]);
        boolean bl = false;
        return !(it.length == 0) ? navigatableArray : null;
    }

    private static final Navigatable uiDataSnapshot$lambda$6$0(DatabaseViewPanel this$0, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DbNodeDescriptor.getNavigatable(this$0.project, it);
    }

    private static final void selectNodes$lambda$6(DatabaseViewPanel this$0, Collection $nodes, AsyncPromise $res) {
        this$0.selectNodes($nodes).processed((Promise)$res);
    }

    private static final ItemPresentation getNodePresentationText$lambda$0(DatabaseViewPanel this$0, Object $o) {
        return this$0.myTree.getCellPresentation((BasicNode)$o);
    }

    private static final Promise showSchemaManagerGotIt$lambda$0(AsyncTreeModel $model, TreePath it) {
        return $model.resolve(it);
    }

    private static final Promise showSchemaManagerGotIt$lambda$1(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$0(DatabaseViewPanel this$0) {
        this$0.invokeRefresh();
    }

    private static final void _init_$lambda$1(DatabaseViewPanel this$0, DbDataSource it) {
        this$0.refreshView();
    }

    private static final void _init_$lambda$2(DatabaseViewPanel this$0, JdbcDriverManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.refreshView();
    }

    private static final void _init_$lambda$3(DatabaseViewPanel this$0) {
        this$0.invokeRefresh();
    }

    private static final void _init_$lambda$4(DatabaseViewPanel this$0, DatabaseConnection databaseConnection, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)databaseConnection, (String)"<unused var>");
        this$0.refreshView();
    }

    private static final boolean ourFilterIsStickyCheck$lambda$0(DatabaseSettings s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return s.treeFilterIsSticky;
    }

    @NotNull
    public static final DataKey<MyAutoScrollFromSourceHandler> getAUTO_SCROLL_HANDLER() {
        return Companion.getAUTO_SCROLL_HANDLER();
    }

    public static final /* synthetic */ String access$getNodePresentationText(DatabaseViewPanel $this, Object o) {
        return $this.getNodePresentationText(o);
    }

    static {
        Logger logger = Logger.getInstance(DatabaseViewPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ourLogger = logger;
        EMPTY_NODES_ARRAY = new BasicNode[0];
        EMPTY_ELEMENTS_ARRAY = new BasicElement[0];
        EMPTY_DSN_ARRAY = new DataSourceNode[0];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0017\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\"\u0010\"\u001a\u0004\u0018\u0001H#\"\u0004\b\u0000\u0010#2\u000b\u0010$\u001a\u00070%\u00a2\u0006\u0002\b&H\u0003\u00a2\u0006\u0002\u0010'J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H\u0002R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b/\u00100R\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002030-X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00104R\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u00110-X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00106\u00a8\u00067"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$Companion;", "", "<init>", "()V", "AUTO_SCROLL_HANDLER", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/database/view/DatabaseViewPanel$MyAutoScrollFromSourceHandler;", "getAUTO_SCROLL_HANDLER$annotations", "getAUTO_SCROLL_HANDLER", "()Lcom/intellij/openapi/actionSystem/DataKey;", "ourFilterIsEnabledCheck", "Lcom/intellij/database/util/common/BooleanVal;", "ourFilterIsStickyCheck", "ourLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getPathDSN", "Lcom/intellij/database/view/DataSourceNode;", "path", "Ljavax/swing/tree/TreePath;", "findDsnInPath", "createDnDTarget", "Lcom/intellij/ide/dnd/DnDTarget;", "element", "Lcom/intellij/database/psi/DbElement;", "getDnDTarget2", "getDataSourceManagerUi", "Lcom/intellij/database/psi/DataSourceManagerUi;", "Lcom/intellij/database/model/RawDataSource;", "Lcom/intellij/database/psi/DbDataSource;", "getDatabaseToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "traceAndNull", "Z", "message", "", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/String;)Ljava/lang/Object;", "getSchemaControlLocation", "Ljava/awt/Point;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "EMPTY_NODES_ARRAY", "", "Lcom/intellij/database/model/basic/BasicNode;", "getEMPTY_NODES_ARRAY", "()[Lcom/intellij/database/model/basic/BasicNode;", "[Lcom/intellij/database/model/basic/BasicNode;", "EMPTY_ELEMENTS_ARRAY", "Lcom/intellij/database/model/basic/BasicElement;", "[Lcom/intellij/database/model/basic/BasicElement;", "EMPTY_DSN_ARRAY", "[Lcom/intellij/database/view/DataSourceNode;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<MyAutoScrollFromSourceHandler> getAUTO_SCROLL_HANDLER() {
            return AUTO_SCROLL_HANDLER;
        }

        @JvmStatic
        public static /* synthetic */ void getAUTO_SCROLL_HANDLER$annotations() {
        }

        private final DataSourceNode getPathDSN(TreePath path) {
            Object[] pathNodes = path.getPath();
            Intrinsics.checkNotNull((Object)pathNodes);
            for (Object node : pathNodes) {
                if (!(node instanceof DataSourceNode)) continue;
                return (DataSourceNode)node;
            }
            return null;
        }

        private final DataSourceNode findDsnInPath(TreePath path) {
            DataSourceNode dsn = (DataSourceNode)TreeUtil.findObjectInPath((TreePath)path, DataSourceNode.class);
            return dsn;
        }

        @TestOnly
        @Nullable
        public final DnDTarget createDnDTarget(@Nullable DbElement element) {
            return this.getDnDTarget2(element);
        }

        private final DnDTarget getDnDTarget2(Object element) {
            DnDTarget dnDTarget;
            Object object = element;
            if (object instanceof DbDataSource) {
                DnDTarget target = this.getDataSourceManagerUi((DbDataSource)element).createDnDTarget(((DbDataSource)element).getDelegate());
                dnDTarget = target;
                if (dnDTarget == null) {
                    dnDTarget = new DbElementDnDTarget.DataSourceDnDTarget((DbDataSource)element);
                }
            } else {
                dnDTarget = object instanceof DbNamespaceImpl ? (DnDTarget)new DbElementDnDTarget.NamespaceDnDTarget((DbNamespace)element) : (object instanceof DbTableImpl ? (DnDTarget)new DbElementDnDTarget.DbTableDnDTarget((DbTable)element) : null);
            }
            return dnDTarget;
        }

        private final DataSourceManagerUi<RawDataSource> getDataSourceManagerUi(DbDataSource element) {
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.intellij.database.psi.DbDataSourceImpl");
            DataSourceManager dataSourceManager = ((DbDataSourceImpl)element).getDbManager();
            Intrinsics.checkNotNull((Object)dataSourceManager, (String)"null cannot be cast to non-null type com.intellij.database.psi.DataSourceManagerUi<com.intellij.database.model.RawDataSource>");
            return (DataSourceManagerUi)dataSourceManager;
        }

        @NotNull
        public final ToolWindow getDatabaseToolWindow(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Database");
            Intrinsics.checkNotNull((Object)toolWindow);
            return toolWindow;
        }

        @Contract(value="_ -> null")
        private final <Z> Z traceAndNull(String message) {
            ourLogger.trace(message);
            return null;
        }

        private final Point getSchemaControlLocation(TreePath path, Tree tree) {
            Rectangle b = tree.getPathBounds(path);
            if (b == null) {
                return null;
            }
            double x = b.getMaxX() - b.getHeight() / (double)2;
            return new Point((int)x, (int)b.getMaxY());
        }

        @NotNull
        public final BasicNode[] getEMPTY_NODES_ARRAY() {
            return EMPTY_NODES_ARRAY;
        }

        public static final /* synthetic */ Point access$getSchemaControlLocation(Companion $this, TreePath path, Tree tree) {
            return $this.getSchemaControlLocation(path, tree);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0019H\u0014J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$MyAutoScrollFromSourceHandler;", "Lcom/intellij/ui/AutoScrollFromSourceHandler;", "project", "Lcom/intellij/openapi/project/Project;", "myView", "Lcom/intellij/database/view/DatabaseViewPanel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/view/DatabaseViewPanel;)V", "getMyView", "()Lcom/intellij/database/view/DatabaseViewPanel;", "value", "", "isAutoScrollEnabledSynthetic", "()Z", "setAutoScrollEnabledSynthetic", "(Z)V", "enabled", "install", "", "updateEnabledState", "selectInView", "editor", "Lcom/intellij/openapi/editor/Editor;", "selectForEditorInAlarm", "selectedEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "isAutoScrollEnabled", "setAutoScrollEnabled", "selectElementFromEditor", "selectElementFromEditorInner", "force", "intellij.database.impl"})
    public static final class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        @NotNull
        private final DatabaseViewPanel myView;
        private boolean enabled;

        public MyAutoScrollFromSourceHandler(@NotNull Project project, @NotNull DatabaseViewPanel myView) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)myView), (String)"myView");
            super(project, (JComponent)((Object)myView), (Disposable)myView);
            this.myView = myView;
        }

        @NotNull
        public final DatabaseViewPanel getMyView() {
            return this.myView;
        }

        public final boolean isAutoScrollEnabledSynthetic() {
            return this.isAutoScrollEnabled();
        }

        public final void setAutoScrollEnabledSynthetic(boolean value) {
            this.setAutoScrollEnabled(value);
        }

        public void install() {
            super.install();
            EditorFactory.getInstance().getEventMulticaster().addCaretListener(new CaretListener(this){
                final /* synthetic */ MyAutoScrollFromSourceHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void caretPositionChanged(CaretEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Editor editor2 = event.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                    MyAutoScrollFromSourceHandler.access$selectInView(this.this$0, editor2);
                }
            }, (Disposable)this.myView);
            MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myView);
            Topic topic = DataGridListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new DataGridListener(this){
                final /* synthetic */ MyAutoScrollFromSourceHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSelectionChanged(DataGrid dataGrid) {
                    Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
                    MyAutoScrollFromSourceHandler.access$selectInView(this.this$0, dataGrid);
                }
            });
            this.myProject.getMessageBus().connect((Disposable)this.myView).subscribe(DatabaseViewOptions.TOPIC, () -> MyAutoScrollFromSourceHandler.install$lambda$0(this));
            this.updateEnabledState();
        }

        private final void updateEnabledState() {
            boolean willEnable = this.isAutoScrollEnabled();
            if (this.enabled == willEnable) {
                return;
            }
            this.enabled = willEnable;
            if (this.enabled) {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
                FileEditor[] fileEditorArray = fileEditorManager.getSelectedEditors();
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getSelectedEditors(...)");
                FileEditor[] editors2 = fileEditorArray;
                if (!(editors2.length == 0)) {
                    FileEditor fileEditor = editors2[0];
                    Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"get(...)");
                    this.selectElementFromEditor(fileEditor);
                }
            }
        }

        private final void selectInView(Editor editor2) {
            VirtualFile file1;
            FileEditor selectedEditor;
            if (!this.myView.isShowing() || !this.isAutoScrollEnabled()) {
                return;
            }
            FileEditor fileEditor = selectedEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor();
            Object object = file1 = fileEditor != null ? fileEditor.getFile() : null;
            if (file1 == null) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
            if (!Intrinsics.areEqual((Object)file1, (Object)file2)) {
                return;
            }
            this.selectForEditorInAlarm(selectedEditor);
        }

        private final void selectForEditorInAlarm(FileEditor selectedEditor) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> MyAutoScrollFromSourceHandler.selectForEditorInAlarm$lambda$0(this, selectedEditor), this.getAlarmDelay(), this.getModalityState());
        }

        private final void selectInView(DataGrid grid) {
            DataGrid grid1;
            DatabaseTableFileEditor selectedEditor;
            if (!this.myView.isShowing() || !this.isAutoScrollEnabled()) {
                return;
            }
            FileEditor fileEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor();
            DatabaseTableFileEditor databaseTableFileEditor = selectedEditor = fileEditor instanceof DatabaseTableFileEditor ? (DatabaseTableFileEditor)fileEditor : null;
            Object object = grid1 = databaseTableFileEditor != null ? databaseTableFileEditor.getDataGrid() : null;
            if (!Intrinsics.areEqual((Object)grid, (Object)grid1)) {
                return;
            }
            this.selectForEditorInAlarm((FileEditor)selectedEditor);
        }

        public boolean isAutoScrollEnabled() {
            return this.myView.myViewOptions.getAutoScrollingFromSources();
        }

        public void setAutoScrollEnabled(boolean enabled) {
            this.myView.myViewOptions.setAutoScrollingFromSources(enabled);
            this.myView.myViewOptions.fireChanged();
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.selectElementFromEditorInner(editor2, false);
        }

        public final void selectElementFromEditorInner(@NotNull FileEditor editor2, boolean force) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext dataContext2 = dataContext;
            DbElement element = DatabaseContextFun.getSelectedDbElementFromEditor(dataContext2);
            DataContext dataContext3 = DataManager.getInstance().getDataContext((Component)((Object)this.myView));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
            PsiElement selection = (PsiElement)DatabaseContextFun.getSelectedPsiElements(dataContext3).first();
            if (element != null && (force || selection == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)element), (PsiElement)selection, (boolean)false))) {
                BasicNode node = this.myView.unwrap(element);
                this.myView.selectNode(node);
            }
        }

        private static final void install$lambda$0(MyAutoScrollFromSourceHandler this$0) {
            this$0.updateEnabledState();
        }

        private static final void selectForEditorInAlarm$lambda$0(MyAutoScrollFromSourceHandler this$0, FileEditor $selectedEditor) {
            FileEditor fileEditor = $selectedEditor;
            Intrinsics.checkNotNull((Object)fileEditor);
            this$0.selectElementFromEditor(fileEditor);
        }

        public static final /* synthetic */ void access$selectInView(MyAutoScrollFromSourceHandler $this, Editor editor2) {
            $this.selectInView(editor2);
        }

        public static final /* synthetic */ void access$selectInView(MyAutoScrollFromSourceHandler $this, DataGrid grid) {
            $this.selectInView(grid);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$MyDnDSource;", "Lcom/intellij/ide/dnd/DnDSource;", "<init>", "(Lcom/intellij/database/view/DatabaseViewPanel;)V", "canStartDragging", "", "action", "Lcom/intellij/ide/dnd/DnDAction;", "dragOrigin", "Ljava/awt/Point;", "startDragging", "Lcom/intellij/ide/dnd/DnDDragStartBean;", "createDraggedImage", "Lcom/intellij/openapi/util/Pair;", "Ljava/awt/Image;", "bean", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseViewPanel.kt\ncom/intellij/database/view/DatabaseViewPanel$MyDnDSource\n+ 2 SequenceFun.kt\ncom/intellij/database/util/sequences/SequenceFun\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,932:1\n10#2:933\n37#3,2:934\n*S KotlinDebug\n*F\n+ 1 DatabaseViewPanel.kt\ncom/intellij/database/view/DatabaseViewPanel$MyDnDSource\n*L\n658#1:933\n658#1:934,2\n*E\n"})
    private final class MyDnDSource
    implements DnDSource {
        public boolean canStartDragging(@NotNull DnDAction action, @NotNull Point dragOrigin) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)dragOrigin, (String)"dragOrigin");
            TreePath[] treePathArray = DatabaseViewPanel.this.getMyTree().getSelectionPaths();
            return treePathArray != null ? !(treePathArray.length == 0) : false;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public DnDDragStartBean startDragging(@NotNull DnDAction action, @NotNull Point dragOrigin) {
            void $this$toArray$iv;
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)dragOrigin, (String)"dragOrigin");
            Object[] paths = DatabaseViewPanel.this.getMyTree().getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return new DnDDragStartBean(null, dragOrigin);
            }
            Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])paths), arg_0 -> MyDnDSource.startDragging$lambda$0(DatabaseViewPanel.this, arg_0)));
            boolean $i$f$toArray = false;
            Collection $this$toTypedArray$iv$iv = SequencesKt.toList((Sequence)$this$toArray$iv);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            Object[] selection = thisCollection$iv$iv.toArray(new Object[0]);
            return new DnDDragStartBean((Object)(!(selection.length == 0) ? new MyTransferable(selection) : null), dragOrigin);
        }

        @Nullable
        public Pair<Image, Point> createDraggedImage(@NotNull DnDAction action, @NotNull Point dragOrigin, @NotNull DnDDragStartBean bean) {
            DatabaseViewTreeComponent.CellRenderer cellRenderer;
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)dragOrigin, (String)"dragOrigin");
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            Object object = bean.getAttachedObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.view.DatabaseViewPanel.MyTransferable");
            Object[] attachedObjects = ((MyTransferable)object).getObjects();
            if (attachedObjects.length == 0) {
                return (Pair)Companion.traceAndNull("Cannot drag: no attached objects");
            }
            Object attachedObject = attachedObjects[0];
            TreeCellRenderer treeCellRenderer = DatabaseViewPanel.this.getMyTree().getCellRenderer();
            DatabaseViewTreeComponent.CellRenderer cellRenderer2 = cellRenderer = treeCellRenderer instanceof DatabaseViewTreeComponent.CellRenderer ? (DatabaseViewTreeComponent.CellRenderer)treeCellRenderer : null;
            if (cellRenderer == null) {
                return (Pair)Companion.traceAndNull("Cannot drag: no cell renderer");
            }
            ThrowableComputable innerPresentationSupplier = () -> MyDnDSource.createDraggedImage$lambda$0(cellRenderer, attachedObject);
            ItemPresentation presentation = (ItemPresentation)ReadAction.compute((ThrowableComputable)innerPresentationSupplier);
            if (presentation == null) {
                return (Pair)Companion.traceAndNull("Cannot drag: no presentation");
            }
            SimpleColoredComponent c2 = new SimpleColoredComponent();
            c2.setForeground(RenderingUtil.getForeground((JTree)((JTree)((Object)DatabaseViewPanel.this.getMyTree()))));
            c2.setBackground(RenderingUtil.getBackground((JTree)((JTree)((Object)DatabaseViewPanel.this.getMyTree()))));
            c2.setIcon(presentation.getIcon(false));
            if (presentation instanceof PresentationData) {
                for (PresentableNodeDescriptor.ColoredFragment fragment : ((PresentationData)presentation).getColoredText()) {
                    c2.append(fragment.getText(), fragment.getAttributes());
                }
            }
            if (attachedObjects.length > 1) {
                c2.append(" +" + (attachedObjects.length - 1), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
            Dimension dimension = c2.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            Dimension size = dimension;
            c2.setSize(size);
            BufferedImage bufferedImage = UIUtil.createImage((Component)((Component)c2), (int)size.width, (int)size.height, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage image = bufferedImage;
            c2.setOpaque(false);
            Graphics2D g = image.createGraphics();
            c2.paint((Graphics)g);
            g.dispose();
            return Pair.create((Object)image, (Object)new Point(0, 0));
        }

        private static final Object startDragging$lambda$0(DatabaseViewPanel this$0, TreePath path) {
            DasObject o;
            DataSourceNode dsn = Companion.findDsnInPath(path);
            DbDataSource dataSource = dsn != null ? this$0.getMyDbModelRegistry().findDbDataSource(dsn) : null;
            DbElement e = DbImplUtilCore.findElement((DbDataSource)dataSource, (DasObject)(o = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class)));
            Object object = e;
            if (object == null) {
                object = path.getLastPathComponent();
            }
            return object;
        }

        private static final ItemPresentation createDraggedImage$lambda$0(DatabaseViewTreeComponent.CellRenderer $cellRenderer, Object $attachedObject) {
            Object object = $attachedObject;
            Intrinsics.checkNotNull((Object)object);
            return $cellRenderer.getCopyPresentationInner(object);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$MyDnDTarget;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "<init>", "(Lcom/intellij/database/view/DatabaseViewPanel;)V", "myHelper", "Lcom/intellij/database/dbimport/DbElementDnDTarget$ExpandHelper;", "update", "", "aEvent", "Lcom/intellij/ide/dnd/DnDEvent;", "cleanUpOnLeave", "", "drop", "hasDdlDataSourceFiles", "intellij.database.impl"})
    private final class MyDnDTarget
    implements DnDNativeTarget {
        @NotNull
        private final DbElementDnDTarget.ExpandHelper myHelper;

        public MyDnDTarget() {
            this.myHelper = new DbElementDnDTarget.ExpandHelper((JTree)((Object)DatabaseViewPanel.this.getMyTree()), DatabaseViewPanel.this);
        }

        public boolean update(@NotNull DnDEvent aEvent) {
            Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
            this.myHelper.update(aEvent);
            Point point = aEvent.getPointOn((Component)((Object)DatabaseViewPanel.this.getMyTree()));
            boolean canCreateDataSource = this.hasDdlDataSourceFiles(aEvent);
            Intrinsics.checkNotNull((Object)point);
            DnDTarget target = DatabaseViewPanel.this.findDndTargetAt(point, canCreateDataSource);
            boolean targetOk = target != null && aEvent.delegateUpdateTo(target);
            boolean ok2 = targetOk || canCreateDataSource;
            aEvent.setDropPossible(ok2);
            if (ok2) {
                Rectangle bounds;
                RelativeRectangle rectangle = null;
                rectangle = targetOk ? ((bounds = DatabaseViewPanel.this.getMyTree().getPathBounds(DatabaseViewPanel.this.getMyTree().getClosestPathForLocation(point.x, point.y))) != null ? new RelativeRectangle((Component)((Object)DatabaseViewPanel.this.getMyTree()), bounds) : null) : null;
                if (rectangle != null) {
                    aEvent.setHighlighting(rectangle, 1);
                }
            } else {
                this.myHelper.notHandled(aEvent);
            }
            return ok2;
        }

        public void cleanUpOnLeave() {
            super.cleanUpOnLeave();
            this.myHelper.leave();
        }

        public void drop(@NotNull DnDEvent aEvent) {
            Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
            boolean canCreateDataSource = this.hasDdlDataSourceFiles(aEvent);
            Point point = aEvent.getPointOn((Component)((Object)DatabaseViewPanel.this.getMyTree()));
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPointOn(...)");
            DnDTarget target = DatabaseViewPanel.this.findDndTargetAt(point, canCreateDataSource);
            if (target != null && aEvent.delegateUpdateTo(target)) {
                aEvent.delegateDropTo(target);
            } else if (!(target instanceof DbElementDnDTarget.DataSourceDnDTarget)) {
                DataSourceUiUtil.createDataSourceFromFiles(DatabaseViewPanel.this.getProject(), FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject()));
            }
        }

        private final boolean hasDdlDataSourceFiles(DnDEvent aEvent) {
            List list = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVirtualFileListFromAttachedObject(...)");
            Collection files2 = list;
            for (DataSourceManager manager : DataSourceManager.getManagers((Project)DatabaseViewPanel.this.getProject())) {
                if (!(manager instanceof BasicDataSourceManager) || !((BasicDataSourceManager)manager).canCreateDataSourceByFiles(files2)) continue;
                return true;
            }
            return SystemInfo.isMac && files2.isEmpty();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u001b\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$MyTransferable;", "Ljava/awt/datatransfer/Transferable;", "objects", "", "", "<init>", "([Ljava/lang/Object;)V", "getObjects", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getTransferDataFlavors", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "flavor", "getTransferData", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseViewPanel.kt\ncom/intellij/database/view/DatabaseViewPanel$MyTransferable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,932:1\n1#2:933\n*E\n"})
    private static final class MyTransferable
    implements Transferable {
        @NotNull
        private final Object[] objects;

        public MyTransferable(@NotNull Object[] objects) {
            Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
            this.objects = objects;
        }

        @NotNull
        public final Object[] getObjects() {
            return this.objects;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[2];
            Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.stringFlavor, (String)"stringFlavor");
            Intrinsics.checkNotNullExpressionValue((Object)DnDEventImpl.ourDataFlavor, (String)"ourDataFlavor");
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            return true;
        }

        @Override
        @NotNull
        public Object getTransferData(@NotNull DataFlavor flavor) throws UnsupportedFlavorException {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            if (DataFlavor.stringFlavor.equals(flavor)) {
                StringBuilder sb = new StringBuilder();
                List dataSources = new ArrayList();
                for (Object object : this.objects) {
                    LocalDataSource it;
                    if (object instanceof PsiNamedElement) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(((PsiNamedElement)object).getName());
                    }
                    if (!(object instanceof DataSourceNode)) continue;
                    RawDataSource rawDataSource = ((DataSourceNode)object).dataSource;
                    if ((rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null) == null) continue;
                    it = it;
                    boolean bl = false;
                    dataSources.add(it);
                }
                if (!((Collection)dataSources).isEmpty()) {
                    sb.append(DataSourceExportImportHelperKt.exportDataSourcesSettings((Collection)dataSources));
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            if (DnDEventImpl.ourDataFlavor.equals(flavor)) {
                return this.objects;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

