/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteRun.terminal.backend.split;

import com.intellij.idea.AppMode;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remoteRun.terminal.backend.split.BackendSshTerminalCachingRunner;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import com.jetbrains.plugins.remotesdk.console.SshTerminalCachingRunner;
import com.jetbrains.plugins.remotesdk.console.SshTerminalRunnerFactory;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/remoteRun/terminal/backend/split/BackendSshTerminalRunnerFactory;", "Lcom/jetbrains/plugins/remotesdk/console/SshTerminalRunnerFactory;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createRunner", "Lcom/jetbrains/plugins/remotesdk/console/SshTerminalCachingRunner;", "optionsProvider", "Lcom/jetbrains/plugins/remotesdk/console/SshConsoleOptionsProvider;", "data", "Lcom/intellij/remote/RemoteCredentials;", "intellij.remoteRun.terminal.backend.split"})
public final class BackendSshTerminalRunnerFactory
extends SshTerminalRunnerFactory {
    public BackendSshTerminalRunnerFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    public SshTerminalCachingRunner createRunner(@NotNull SshConsoleOptionsProvider optionsProvider, @NotNull RemoteCredentials data) {
        Intrinsics.checkNotNullParameter((Object)optionsProvider, (String)"optionsProvider");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (AppMode.isRemoteDevHost()) {
            Project project = this.getProject();
            Charset charset = optionsProvider.getCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
            return new BackendSshTerminalCachingRunner(project, data, charset);
        }
        return super.createRunner(optionsProvider, data);
    }
}

