/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.execution.update;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.appServers.serverInstances.DefaultServerInstance;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ModuleResourcesBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReloadResourcesUpdatingPolicy
extends UpdatingPolicy {
    private static final Logger LOG = Logger.getInstance(ReloadResourcesUpdatingPolicy.class);
    @NonNls
    private static final String ID = "update-resources";

    public static UpdatingPolicy getInstance() {
        return UpdatingRunningApplicationUtil.findPolicy(ID);
    }

    public ReloadResourcesUpdatingPolicy() {
        super(ID);
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = AppServersIntegrationBundle.message((String)"updating.policy.update.resources", (Object[])new Object[0]);
        if (string == null) {
            ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailableOnFrameDeactivation() {
        return true;
    }

    @Override
    public boolean isAvailableForConfiguration(@NotNull CommonModel commonModel) {
        if (commonModel == null) {
            ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(1);
        }
        return UpdatingRunningApplicationUtil.isResourcesReloadingSupported(commonModel);
    }

    @Override
    public void runUpdate(@NotNull Project project, @Nullable Executor executor, @NotNull J2EEServerInstance serverInstance, @NotNull ProcessHandler processHandler, boolean onFrameDeactivation) {
        if (project == null) {
            ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(2);
        }
        if (serverInstance == null) {
            ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(4);
        }
        CommonModel model = serverInstance.getCommonModel();
        ProjectTask compileTask = ReloadResourcesUpdatingPolicy.createCompileTask(project, model);
        Runnable compileAction = () -> UpdatingRunningApplicationUtil.startCompilation(project, compileTask, onFrameDeactivation).onSuccess((Consumer)new UpdateResourceOnServerListener(serverInstance, false));
        UpdatingRunningApplicationUtil.updateOpenedFilesAndStartCompilation(project, model.getArtifactsToBuild(), compileAction);
    }

    public static ProjectTask createCompileTask(Project project, CommonModel commonModel) {
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts((Collection)commonModel.getDeployedArtifacts(), (Project)project);
        return new ProjectTaskList((Collection)ContainerUtil.map((Collection)modules, ModuleResourcesBuildTaskImpl::new));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/appServers/run/execution/update/ReloadResourcesUpdatingPolicy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverInstance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/appServers/run/execution/update/ReloadResourcesUpdatingPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runUpdate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public static class UpdateResourceOnServerListener
    implements Consumer<ProjectTaskManager.Result> {
        private final J2EEServerInstance myServerInstance;
        private final boolean myUpdateClassFiles;

        public UpdateResourceOnServerListener(J2EEServerInstance serverInstance, boolean updateClassFiles) {
            this.myServerInstance = serverInstance;
            this.myUpdateClassFiles = updateClassFiles;
        }

        @Override
        public void accept(ProjectTaskManager.Result result) {
            HashSet<String> writtenPaths;
            if (!result.isAborted() && !result.hasErrors() && (writtenPaths = ArtifactsCompiler.getWrittenPaths((ProjectTaskContext)result.getContext())) != null && this.myServerInstance instanceof DefaultServerInstance) {
                HashSet<String> toUpdate;
                if (this.myUpdateClassFiles) {
                    toUpdate = writtenPaths;
                } else {
                    HashSet<String> withoutClassFiles = new HashSet<String>();
                    for (String path : writtenPaths) {
                        if (path.endsWith(".class")) continue;
                        withoutClassFiles.add(path);
                    }
                    toUpdate = withoutClassFiles;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating changed files on server '" + this.myServerInstance.getName() + "' (" + toUpdate.size() + "): ");
                    for (String path : toUpdate) {
                        LOG.debug(path);
                    }
                }
                ((DefaultServerInstance)this.myServerInstance).updateChangedFiles((Set)toUpdate);
            }
        }
    }
}

