/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.descriptor;

import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.facet.DescriptorMetaDataRegistry;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptor;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.util.descriptors.ConfigFileVersion;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeTemplatesBase
implements FileTemplateGroupDescriptorFactory {
    @NotNull
    public abstract JavaeeIntegration getIntegration();

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        DescriptorMetaDataRegistry.getInstance().getProvider(JavaeeApplicationFacet.ID);
        String name = this.getIntegration().getPresentableName();
        Icon icon = this.getIntegration().getIcon();
        FileTemplateGroupDescriptor root = new FileTemplateGroupDescriptor(name, icon);
        for (JavaeeDescriptor descriptor : this.getIntegration().getDescriptorsManager().getItems()) {
            JavaeeTemplatesBase.addFileTemplates(root, descriptor);
        }
        return root;
    }

    private static void addFileTemplates(FileTemplateGroupDescriptor root, JavaeeDescriptor descriptor) {
        Icon icon = descriptor.getIcon();
        ConfigFileVersion[] versions = descriptor.getMetaData().getVersions();
        if (versions.length == 1) {
            root.addTemplate(new FileTemplateDescriptor(versions[0].getTemplateName(), icon));
        } else {
            FileTemplateGroupDescriptor group = new FileTemplateGroupDescriptor(descriptor.getMetaData().getTitle(), icon);
            for (ConfigFileVersion version : versions) {
                group.addTemplate(new FileTemplateDescriptor(version.getTemplateName(), icon));
            }
            root.addTemplate((FileTemplateDescriptor)group);
        }
    }
}

