/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class JavaeePortConfig
extends CachedConfig<JavaeeServerModel> {
    public static final int INVALID_PORT = Integer.MAX_VALUE;
    private static final Map<CachedConfig.Key, JavaeePortConfig> cache = new HashMap<CachedConfig.Key, JavaeePortConfig>();
    private int port = Integer.MAX_VALUE;

    protected static <M extends JavaeeServerModel> int get(Factory<M> factory, M model, int dflt) {
        int port;
        JavaeePortConfig config = JavaeePortConfig.get(factory, model);
        if (config != null && (port = config.port) != Integer.MAX_VALUE) {
            return port;
        }
        return dflt;
    }

    protected static <M extends JavaeeServerModel> JavaeePortConfig get(Factory<M> factory, M model) {
        return JavaeePortConfig.get(cache, factory, model);
    }

    @Override
    protected void update(JavaeeServerModel data) {
        this.port = this.getPort(data);
    }

    protected abstract int getPort(JavaeeServerModel var1);

    public static Integer safeParseInt(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected static interface Factory<T extends JavaeeServerModel>
    extends CachedConfig.Factory<T, JavaeePortConfig> {
    }
}

