/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.features;

import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereSpellCheckResult;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsagesCollector;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProviderKt;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereFileFeaturesProviderKt;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywherePsiElementFeaturesProviderUtils;
import com.intellij.textMatching.PrefixMatchingUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0016JD\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010 \u00a8\u0006\""}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereFileFeaturesProvider;", "Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereElementFeaturesProvider;", "<init>", "()V", "getFeaturesDeclarations", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getElementFeatures", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "element", "", "currentTime", "", "searchQuery", "", "elementPriority", "", "cache", "Lcom/intellij/searchEverywhereMl/ranking/core/features/FeaturesProviderCache;", "correction", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereSpellCheckResult;", "isBookmark", "", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "isExactMatch", "isExactRelativePath", "getRelativePathNameMatchingFeatures", "", "isTopLevel", "(Lcom/intellij/psi/PsiFileSystemItem;)Ljava/lang/Boolean;", "matchesFileTypeInQuery", "(Lcom/intellij/psi/PsiFileSystemItem;Ljava/lang/String;)Ljava/lang/Boolean;", "Fields", "intellij.searchEverywhereMl.ranking.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSearchEverywhereFileFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereFileFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereFileFeaturesProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n216#2,2:203\n1#3:205\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereFileFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereFileFeaturesProvider\n*L\n163#1:203,2\n*E\n"})
public final class SearchEverywhereFileFeaturesProvider
extends SearchEverywhereElementFeaturesProvider {
    public SearchEverywhereFileFeaturesProvider() {
        Class[] classArray = new Class[]{FileSearchEverywhereContributor.class, RecentFilesSEContributor.class};
        super(classArray);
    }

    @Override
    @NotNull
    public List<EventField<?>> getFeaturesDeclarations() {
        Object[] objectArray = new PrimitiveEventField[]{Fields.INSTANCE.getIS_DIRECTORY_DATA_KEY(), Fields.INSTANCE.getFILETYPE_DATA_KEY(), Fields.INSTANCE.getIS_BOOKMARK_DATA_KEY(), Fields.INSTANCE.getIS_EXACT_MATCH_DATA_KEY(), Fields.INSTANCE.getFILETYPE_MATCHES_QUERY_DATA_KEY(), Fields.INSTANCE.getIS_TOP_LEVEL_DATA_KEY(), Fields.INSTANCE.getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY()};
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        Collection<EventField<?>> collection2 = Fields.INSTANCE.getREL_PATH_NAME_FEATURE_TO_FIELD().values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)collection2);
    }

    @Override
    @NotNull
    public List<EventPair<?>> getElementFeatures(@NotNull Object element, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable FeaturesProviderCache cache, @NotNull SearchEverywhereSpellCheckResult correction) {
        List list;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Intrinsics.checkNotNullParameter((Object)correction, (String)"correction");
        PsiElement psiElement = SearchEverywherePsiElementFeaturesProviderUtils.INSTANCE.getPsiElementOrNull(element);
        PsiFileSystemItem psiFileSystemItem = psiElement instanceof PsiFileSystemItem ? (PsiFileSystemItem)psiElement : null;
        if (psiFileSystemItem == null) {
            return CollectionsKt.emptyList();
        }
        PsiFileSystemItem item = psiFileSystemItem;
        List $this$getElementFeatures_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getElementFeatures_u24lambda_u240.add(Fields.INSTANCE.getIS_BOOKMARK_DATA_KEY().with((Object)this.isBookmark(item)));
        $this$getElementFeatures_u24lambda_u240.add(Fields.INSTANCE.getIS_DIRECTORY_DATA_KEY().with((Object)item.isDirectory()));
        $this$getElementFeatures_u24lambda_u240.add(Fields.INSTANCE.getIS_EXACT_MATCH_DATA_KEY().with((Object)this.isExactMatch(item, searchQuery, elementPriority)));
        $this$getElementFeatures_u24lambda_u240.add(Fields.INSTANCE.getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY().with((Object)this.isExactRelativePath(item, searchQuery)));
        $this$getElementFeatures_u24lambda_u240.addAll(this.getRelativePathNameMatchingFeatures(item, searchQuery));
        SearchEverywhereElementFeaturesProviderKt.putIfValueNotNull($this$getElementFeatures_u24lambda_u240, (EventField)Fields.INSTANCE.getIS_TOP_LEVEL_DATA_KEY(), this.isTopLevel(item));
        if (!item.isDirectory()) {
            $this$getElementFeatures_u24lambda_u240.add(Fields.INSTANCE.getFILETYPE_DATA_KEY().with((Object)item.getVirtualFile().getFileType().getName()));
            SearchEverywhereElementFeaturesProviderKt.putIfValueNotNull($this$getElementFeatures_u24lambda_u240, (EventField)Fields.INSTANCE.getFILETYPE_MATCHES_QUERY_DATA_KEY(), this.matchesFileTypeInQuery(item, searchQuery));
        }
        return CollectionsKt.build((List)list);
    }

    private final boolean isBookmark(PsiFileSystemItem item) {
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)item.getProject());
        Boolean bkm = (Boolean)ReadAction.compute(() -> SearchEverywhereFileFeaturesProvider.isBookmark$lambda$0(item, bookmarksManager));
        Intrinsics.checkNotNull((Object)bkm);
        return bkm;
    }

    private final boolean isExactMatch(PsiFileSystemItem item, String searchQuery, int elementPriority) {
        if (elementPriority == 5000) {
            return true;
        }
        String string = item.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        String string2 = item.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String fileName = string2;
        return SequencesKt.none((Sequence)SequencesKt.filterIndexed((Sequence)SequencesKt.map((Sequence)StringsKt.asSequence((CharSequence)searchQuery), SearchEverywhereFileFeaturesProvider::isExactMatch$lambda$0), (arg_0, arg_1) -> SearchEverywhereFileFeaturesProvider.isExactMatch$lambda$1(searchQuery, fileName, filePath, arg_0, arg_1)));
    }

    private final boolean isExactRelativePath(PsiFileSystemItem item, String searchQuery) {
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Path path = SearchEverywhereFileFeaturesProviderKt.access$toNioPathOrNull(virtualFile);
        if (path == null) {
            return false;
        }
        Path filePath = path;
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = SearchEverywhereFileFeaturesProviderKt.access$toNioPathOrNull((VirtualFile)object)) == null) {
            return false;
        }
        Object basePath = object;
        Path path2 = NioPathUtil.toNioPathOrNull((String)searchQuery);
        if (path2 == null) {
            return false;
        }
        Path queryPath = path2;
        try {
            Path relativePath = basePath.relativize(filePath);
            return Intrinsics.areEqual((Object)queryPath, (Object)relativePath);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private final Collection<EventPair<?>> getRelativePathNameMatchingFeatures(PsiFileSystemItem item, String searchQuery) {
        Map map;
        Iterable<Path> iterable;
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Path path = SearchEverywhereFileFeaturesProviderKt.access$toNioPathOrNull(virtualFile);
        if (path == null) {
            return CollectionsKt.emptyList();
        }
        Path filePath = path;
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = SearchEverywhereFileFeaturesProviderKt.access$toNioPathOrNull((VirtualFile)object)) == null) {
            return CollectionsKt.emptyList();
        }
        Object basePath = object;
        try {
            iterable = basePath.relativize(filePath);
        }
        catch (IllegalArgumentException e) {
            return CollectionsKt.emptyList();
        }
        Path relativePath = iterable;
        Iterable<Path> $this$getRelativePathNameMatchingFeatures_u24lambda_u240 = iterable = CollectionsKt.createListBuilder();
        boolean bl = false;
        Map $this$getRelativePathNameMatchingFeatures_u24lambda_u240_u240 = map = MapsKt.createMapBuilder();
        boolean bl2 = false;
        PrefixMatchingUtil.INSTANCE.calculateFeatures(((Object)relativePath).toString(), searchQuery, $this$getRelativePathNameMatchingFeatures_u24lambda_u240_u240);
        Map prefixMatchingFeatures = MapsKt.build((Map)map);
        Map $this$forEach$iv = Fields.INSTANCE.getREL_PATH_NAME_FEATURE_TO_FIELD();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            EventPair<?> it;
            Object matchValue;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl3 = false;
            String key = (String)entry.getKey();
            EventField field = (EventField)entry.getValue();
            if (prefixMatchingFeatures.get(key) == null) continue;
            if (this.setMatchValueToField$intellij_searchEverywhereMl_ranking_core(matchValue, field) == null) continue;
            boolean bl4 = false;
            $this$getRelativePathNameMatchingFeatures_u24lambda_u240.add(it);
        }
        return CollectionsKt.build((List)iterable);
    }

    private final Boolean isTopLevel(PsiFileSystemItem item) {
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object basePath = object;
        Object object2 = item.getVirtualFile().getParent();
        if (object2 == null || (object2 = object2.getPath()) == null) {
            return null;
        }
        Object fileDirectoryPath = object2;
        return Intrinsics.areEqual((Object)fileDirectoryPath, (Object)basePath);
    }

    private final Boolean matchesFileTypeInQuery(PsiFileSystemItem item, String searchQuery) {
        String fileExtension = item.getVirtualFile().getExtension();
        String extensionInQuery = StringsKt.substringAfterLast((String)searchQuery, (char)'.', (String)"");
        if (((CharSequence)extensionInQuery).length() == 0 || fileExtension == null) {
            return null;
        }
        String string = extensionInQuery.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = fileExtension.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return Intrinsics.areEqual((Object)string, (Object)string2);
    }

    private static final Boolean isBookmark$lambda$0(PsiFileSystemItem $item, BookmarksManager $bookmarksManager) {
        Bookmark bookmark;
        VirtualFile virtualFile = $item.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile vFile = virtualFile;
            boolean bl = false;
            Object object = $bookmarksManager;
            if (object != null && (object = object.getBookmarks()) != null) {
                Object v2;
                block5: {
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        Bookmark it = (Bookmark)t;
                        boolean bl2 = false;
                        if (!(it instanceof FileBookmark && Intrinsics.areEqual((Object)((FileBookmark)it).getFile(), (Object)vFile))) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                bookmark = v2;
            } else {
                bookmark = null;
            }
        } else {
            bookmark = null;
        }
        return bookmark != null;
    }

    private static final char isExactMatch$lambda$0(char it) {
        return it == '\\' ? (char)'/' : (char)it;
    }

    private static final boolean isExactMatch$lambda$1(String $searchQuery, String $fileName, String $filePath, int searchQueryCharIndex, char c) {
        if (searchQueryCharIndex == 0 && c == '/' && $searchQuery.length() - 1 == $fileName.length()) {
            return true;
        }
        Integer n = $filePath.length() - $searchQuery.length() + searchQueryCharIndex;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        if (n2 == null) {
            return true;
        }
        int index = n2;
        return $filePath.charAt(index) != c;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR5\u0010\u0016\u001a&\u0012\u0004\u0012\u00020\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0017j\u0012\u0012\u0004\u0012\u00020\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereFileFeaturesProvider$Fields;", "", "<init>", "()V", "FILETYPE_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getFILETYPE_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "IS_BOOKMARK_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getIS_BOOKMARK_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_DIRECTORY_DATA_KEY", "getIS_DIRECTORY_DATA_KEY", "IS_EXACT_MATCH_DATA_KEY", "getIS_EXACT_MATCH_DATA_KEY", "FILETYPE_MATCHES_QUERY_DATA_KEY", "getFILETYPE_MATCHES_QUERY_DATA_KEY", "IS_TOP_LEVEL_DATA_KEY", "getIS_TOP_LEVEL_DATA_KEY", "IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY", "getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY", "REL_PATH_NAME_FEATURE_TO_FIELD", "Ljava/util/HashMap;", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "Lkotlin/collections/HashMap;", "getREL_PATH_NAME_FEATURE_TO_FIELD", "()Ljava/util/HashMap;", "intellij.searchEverywhereMl.ranking.core"})
    public static final class Fields {
        @NotNull
        public static final Fields INSTANCE = new Fields();
        @NotNull
        private static final StringEventField FILETYPE_DATA_KEY = EventFields.StringValidatedByCustomRule((String)"fileType", FileTypeUsagesCollector.ValidationRule.class);
        @NotNull
        private static final BooleanEventField IS_BOOKMARK_DATA_KEY = EventFields.Boolean((String)"isBookmark");
        @NotNull
        private static final BooleanEventField IS_DIRECTORY_DATA_KEY = EventFields.Boolean((String)"isDirectory");
        @NotNull
        private static final BooleanEventField IS_EXACT_MATCH_DATA_KEY = EventFields.Boolean((String)"isExactMatch");
        @NotNull
        private static final BooleanEventField FILETYPE_MATCHES_QUERY_DATA_KEY = EventFields.Boolean((String)"fileTypeMatchesQuery");
        @NotNull
        private static final BooleanEventField IS_TOP_LEVEL_DATA_KEY = EventFields.Boolean((String)"isTopLevel");
        @NotNull
        private static final BooleanEventField IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY = EventFields.Boolean((String)"isExactRelativePath");
        @NotNull
        private static final HashMap<String, EventField<?>> REL_PATH_NAME_FEATURE_TO_FIELD;

        private Fields() {
        }

        @NotNull
        public final StringEventField getFILETYPE_DATA_KEY() {
            return FILETYPE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_BOOKMARK_DATA_KEY() {
            return IS_BOOKMARK_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_DIRECTORY_DATA_KEY() {
            return IS_DIRECTORY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EXACT_MATCH_DATA_KEY() {
            return IS_EXACT_MATCH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getFILETYPE_MATCHES_QUERY_DATA_KEY() {
            return FILETYPE_MATCHES_QUERY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_TOP_LEVEL_DATA_KEY() {
            return IS_TOP_LEVEL_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY() {
            return IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY;
        }

        @NotNull
        public final HashMap<String, EventField<?>> getREL_PATH_NAME_FEATURE_TO_FIELD() {
            return REL_PATH_NAME_FEATURE_TO_FIELD;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"prefix_same_start_count", (Object)EventFields.Int((String)"relPathPrefixSameStartCount")), TuplesKt.to((Object)"prefix_greedy_score", (Object)EventFields.Double((String)"relPathPrefixGreedyScore")), TuplesKt.to((Object)"prefix_matched_words_score", (Object)EventFields.Double((String)"relPathPrefixMatchedWordsScore")), TuplesKt.to((Object)"prefix_matched_words_relative", (Object)EventFields.Double((String)"relPathPrefixMatchedWordsRelative"))};
            REL_PATH_NAME_FEATURE_TO_FIELD = MapsKt.hashMapOf((Pair[])pairArray);
        }
    }
}

