/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database.config.impl;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.RecognizedDataSourceConfigProvider;
import com.intellij.persistence.database.config.impl.RecognizedDataSourceConfigProviderImplKt;
import com.intellij.persistence.database.config.impl.urlParser.CommonDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseType;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.DatabasesKt;
import com.intellij.persistence.database.config.impl.urlParser.DerbyUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.H2UrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.HsqldbUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.OracleUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.SqlServerUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.SqliteUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.SybaseUrlParserKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0004J#\u0010\n\u001a\u0004\u0018\u00010\t2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\f\"\u00020\tH\u0004\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\tH\u0004J9\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0004\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/persistence/database/config/impl/RecognizedDataSourceConfigProviderImpl;", "I", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "Lcom/intellij/persistence/database/RecognizedDataSourceConfigProvider;", "<init>", "()V", "findFirstApplicableDbTypeOrDefault", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseType;", "value", "", "guessSampleUrl", "values", "", "([Ljava/lang/String;)Ljava/lang/String;", "guessDefaultDatasourceName", "url", "host", "guessDriverClass", "tryToParse", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "databaseNamePropValue", "port", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nRecognizedDataSourceConfigProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecognizedDataSourceConfigProviderImpl.kt\ncom/intellij/persistence/database/config/impl/RecognizedDataSourceConfigProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,71:1\n295#2,2:72\n1#3:74\n52#4:75\n52#4:76\n*S KotlinDebug\n*F\n+ 1 RecognizedDataSourceConfigProviderImpl.kt\ncom/intellij/persistence/database/config/impl/RecognizedDataSourceConfigProviderImpl\n*L\n12#1:72,2\n22#1:75\n48#1:76\n*E\n"})
public abstract class RecognizedDataSourceConfigProviderImpl<I extends ConfigDataSourcePropertyInfo>
implements RecognizedDataSourceConfigProvider<I> {
    @NotNull
    protected final DatabaseType findFirstApplicableDbTypeOrDefault(@NotNull String value) {
        DatabaseType databaseType;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Iterable $this$firstOrNull$iv = (Iterable)DatabaseType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DatabaseType type = (DatabaseType)((Object)element$iv);
                boolean bl = false;
                if (!StringsKt.contains((CharSequence)value, (CharSequence)type.name(), (boolean)true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((databaseType = (DatabaseType)v0) == null) {
            databaseType = DatabaseType.MYSQL;
        }
        return databaseType;
    }

    @Nullable
    protected final String guessSampleUrl(String ... values) {
        DatabaseType databaseType;
        block2: {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            for (String it : (Iterable)ArraysKt.toList((Object[])values)) {
                boolean bl = false;
                DatabaseType databaseType2 = this.findFirstApplicableDbTypeOrDefault(it);
                if (databaseType2 == null) continue;
                databaseType = databaseType2;
                break block2;
            }
            databaseType = null;
        }
        if (databaseType == null) {
            return null;
        }
        DatabaseType databaseType3 = databaseType;
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver(databaseType3);
        return databaseDriver != null ? databaseDriver.getSampleUrl() : null;
    }

    @NotNull
    protected final String guessDefaultDatasourceName(@NotNull String url, @Nullable String host) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        DatabaseType databaseType = this.findFirstApplicableDbTypeOrDefault(url);
        String string2 = databaseType.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        boolean condition$iv = host != null;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$guessDefaultDatasourceName_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            string = (String)$this$guessDefaultDatasourceName_u24lambda_u240 + "@" + host;
        } else {
            string = $this$applyIf$iv;
        }
        return string;
    }

    public static /* synthetic */ String guessDefaultDatasourceName$default(RecognizedDataSourceConfigProviderImpl recognizedDataSourceConfigProviderImpl, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: guessDefaultDatasourceName");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return recognizedDataSourceConfigProviderImpl.guessDefaultDatasourceName(string, string2);
    }

    @Nullable
    protected final String guessDriverClass(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        DatabaseType dbType = this.findFirstApplicableDbTypeOrDefault(url);
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver(dbType);
        return databaseDriver != null ? databaseDriver.getDriverClass() : null;
    }

    @Nullable
    protected final DatabaseUrl tryToParse(@NotNull String url, @Nullable String databaseNamePropValue, @Nullable String host, @Nullable Integer port) {
        CommonDatabaseUrl commonDatabaseUrl;
        DatabaseUrl databaseUrl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = url;
        if (RecognizedDataSourceConfigProviderImplKt.access$getH2PrefixRegex$p().containsMatchIn(charSequence)) {
            v0 = H2UrlParserKt.parseH2Url(url, databaseNamePropValue, host, port);
        } else {
            charSequence = url;
            v0 = RecognizedDataSourceConfigProviderImplKt.access$getSqlitePrefixRegex$p().containsMatchIn(charSequence) ? SqliteUrlParserKt.parseSqliteUrl(url, databaseNamePropValue) : (StringsKt.contains$default((CharSequence)url, (CharSequence)"sybase", (boolean)false, (int)2, null) ? SybaseUrlParserKt.parseSybaseUrl(url, databaseNamePropValue, host, port) : (StringsKt.contains$default((CharSequence)url, (CharSequence)"hsqldb", (boolean)false, (int)2, null) ? HsqldbUrlParserKt.parseHsqldbUrl(url, databaseNamePropValue) : (StringsKt.contains$default((CharSequence)url, (CharSequence)"derby", (boolean)false, (int)2, null) ? DerbyUrlParserKt.parseDerbyUrl(url, databaseNamePropValue, host, port) : (StringsKt.contains$default((CharSequence)url, (CharSequence)"oracle", (boolean)false, (int)2, null) ? OracleUrlParserKt.parseOracleUrl(url, databaseNamePropValue, host, port) : (databaseUrl = StringsKt.contains$default((CharSequence)url, (CharSequence)"mssql", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)url, (CharSequence)"sqlserver", (boolean)false, (int)2, null) ? SqlServerUrlParserKt.parseSqlServerUrl(url, databaseNamePropValue, host, port) : null)))));
        }
        if (databaseUrl != null) {
            DatabaseUrl it = databaseUrl;
            boolean bl = false;
            return it;
        }
        CommonDatabaseUrl commonDatabaseUrl2 = DatabaseUrlParserKt.parseToCommonDatabaseUrl(url, databaseNamePropValue, host, port);
        if (commonDatabaseUrl2 != null) {
            CommonDatabaseUrl parsedUrl = commonDatabaseUrl2;
            boolean bl = false;
            CommonDatabaseUrl commonDatabaseUrl3 = parsedUrl;
            boolean condition$iv = parsedUrl.getDatabaseName() == null;
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void $this$tryToParse_u24lambda_u241_u240 = $this$applyIf$iv;
                boolean bl2 = false;
                commonDatabaseUrl = CommonDatabaseUrl.copy$default((CommonDatabaseUrl)$this$tryToParse_u24lambda_u241_u240, null, null, databaseNamePropValue, null, null, null, null, null, 251, null);
            } else {
                commonDatabaseUrl = $this$applyIf$iv;
            }
        } else {
            commonDatabaseUrl = null;
        }
        return commonDatabaseUrl;
    }

    public static /* synthetic */ DatabaseUrl tryToParse$default(RecognizedDataSourceConfigProviderImpl recognizedDataSourceConfigProviderImpl, String string, String string2, String string3, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tryToParse");
        }
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return recognizedDataSourceConfigProviderImpl.tryToParse(string, string2, string3, n);
    }
}

