/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StandardExceptionProcessor
extends AbstractClassProcessor {
    public StandardExceptionProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.StandardException");
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (nameHint == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(2);
        }
        return nameHint.equals(psiClass.getName());
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(4);
        }
        return Collections.singleton(StandardExceptionProcessor.getConstructorName(psiClass));
    }

    private static String getConstructorName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(5);
        }
        return Strings.notNullize((String)psiClass.getName());
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(8);
        }
        if (StandardExceptionProcessor.checkWrongType(psiClass)) {
            builder.addErrorMessage("inspection.message.standardexception.class.only.supported.on.class", new Object[0]);
            return false;
        }
        if (StandardExceptionProcessor.checkWrongInheritorOfThrowable(psiClass)) {
            builder.addErrorMessage("inspection.message.standardexception.should.extend.throwable", new Object[0]);
            return false;
        }
        if (StandardExceptionProcessor.checkWrongAccessVisibility(psiAnnotation)) {
            builder.addErrorMessage("inspection.message.standardexception.accesslevel.none.not.valid", new Object[0]);
        }
        return true;
    }

    private static boolean checkWrongType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(9);
        }
        return psiClass.isInterface() || psiClass.isAnnotationType() || psiClass.isEnum() || psiClass.isRecord();
    }

    private static boolean checkWrongInheritorOfThrowable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(10);
        }
        return !InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Throwable");
    }

    private static boolean checkWrongAccessVisibility(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(11);
        }
        return null == LombokProcessorUtil.getAccessVisibility(psiAnnotation);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        if (psiClass == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(13);
        }
        if (target == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(14);
        }
        PsiManager psiManager = psiClass.getManager();
        Collection<PsiMethod> existedConstructors = PsiClassUtil.collectClassConstructorIntern(psiClass);
        String accessVisibility = StandardExceptionProcessor.getAccessVisibility(psiAnnotation);
        if (StandardExceptionProcessor.noConstructorWithParamsOfTypesDefined(existedConstructors, new PsiClassType[0])) {
            target.add((PsiElement)StandardExceptionProcessor.createConstructor(psiClass, psiAnnotation, psiManager, accessVisibility).withBodyText("this(null, null);"));
        }
        GlobalSearchScope psiClassResolveScope = psiClass.getResolveScope();
        PsiClassType javaLangStringType = PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)psiClassResolveScope);
        PsiClassType javaLangThrowableType = PsiType.getJavaLangThrowable((PsiManager)psiManager, (GlobalSearchScope)psiClassResolveScope);
        boolean addConstructorProperties = ConfigDiscovery.getInstance().getBooleanLombokConfigProperty(ConfigKey.ANYCONSTRUCTOR_ADD_CONSTRUCTOR_PROPERTIES, psiClass);
        if (StandardExceptionProcessor.noConstructorWithParamsOfTypesDefined(existedConstructors, javaLangStringType)) {
            LombokLightMethodBuilder messageConstructor = StandardExceptionProcessor.createConstructor(psiClass, psiAnnotation, psiManager, accessVisibility).withFinalParameter("message", (PsiType)javaLangStringType).withBodyText("this(message, null);");
            if (addConstructorProperties) {
                messageConstructor.withAnnotation("java.beans.ConstructorProperties(\"message\")");
            }
            target.add((PsiElement)messageConstructor);
        }
        if (StandardExceptionProcessor.noConstructorWithParamsOfTypesDefined(existedConstructors, javaLangThrowableType)) {
            LombokLightMethodBuilder causeConstructor = StandardExceptionProcessor.createConstructor(psiClass, psiAnnotation, psiManager, accessVisibility).withFinalParameter("cause", (PsiType)javaLangThrowableType).withBodyText("this(cause != null ? cause.getMessage() : null, cause);");
            if (addConstructorProperties) {
                causeConstructor.withAnnotation("java.beans.ConstructorProperties(\"cause\")");
            }
            target.add((PsiElement)causeConstructor);
        }
        if (StandardExceptionProcessor.noConstructorWithParamsOfTypesDefined(existedConstructors, javaLangStringType, javaLangThrowableType)) {
            LombokLightMethodBuilder messageCauseConstructor = StandardExceptionProcessor.createConstructor(psiClass, psiAnnotation, psiManager, accessVisibility).withFinalParameter("message", (PsiType)javaLangStringType).withFinalParameter("cause", (PsiType)javaLangThrowableType).withBodyText("super(message);\nif (cause != null) super.initCause(cause);");
            if (addConstructorProperties) {
                messageCauseConstructor.withAnnotation("java.beans.ConstructorProperties({\"message\",\"cause\"})");
            }
            target.add((PsiElement)messageCauseConstructor);
        }
    }

    @PsiModifier.ModifierConstant
    private static String getAccessVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String accessVisibility;
        if (psiAnnotation == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(15);
        }
        if (null == (accessVisibility = LombokProcessorUtil.getAccessVisibility(psiAnnotation))) {
            accessVisibility = "public";
        }
        return accessVisibility;
    }

    private static boolean noConstructorWithParamsOfTypesDefined(Collection<PsiMethod> existedConstructors, PsiClassType ... classTypes) {
        return !ContainerUtil.exists(existedConstructors, method -> {
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != classTypes.length) {
                return false;
            }
            int paramIndex = 0;
            for (PsiClassType classType : classTypes) {
                if (!PsiTypesUtil.compareTypes((PsiType)parameterList.getParameter(paramIndex).getType(), (PsiType)classType, (boolean)true)) {
                    return false;
                }
                ++paramIndex;
            }
            return true;
        });
    }

    private static LombokLightMethodBuilder createConstructor(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiManager psiManager, @PsiModifier.ModifierConstant String accessVisibility) {
        if (psiClass == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(16);
        }
        if (psiAnnotation == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(17);
        }
        if (psiManager == null) {
            StandardExceptionProcessor.$$$reportNull$$$0(18);
        }
        return new LombokLightMethodBuilder(psiManager, StandardExceptionProcessor.getConstructorName(psiClass)).withConstructor(true).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withModifier(accessVisibility);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/StandardExceptionProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getConstructorName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWrongType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWrongInheritorOfThrowable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWrongAccessVisibility";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessVisibility";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "createConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

