/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import de.plushnikov.intellij.plugin.Version;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LombokLibraryUtil {
    private static final String LOMBOK_PACKAGE = "lombok.experimental";

    public static boolean hasLombokLibrary(@NotNull Project project) {
        if (project == null) {
            LombokLibraryUtil.$$$reportNull$$$0(0);
        }
        if (project.isDefault() || !project.isInitialized()) {
            return false;
        }
        ThreadingAssertions.assertReadAccess();
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)"org.projectlombok:lombok") || !DumbService.isDumb((Project)project) && LombokLibraryUtil.detectLombokJarsSlow(project);
    }

    public static boolean hasLombokClasses(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"lombok.Getter");
    }

    private static boolean detectLombokJarsSlow(Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            OrderEnumerator orderEnumerator = OrderEnumerator.orderEntries((Project)project);
            Ref exists = new Ref((Object)false);
            orderEnumerator.recursively().forEachLibrary(library -> {
                ProgressManager.checkCanceled();
                VirtualFile[] libraryFiles = library.getFiles(OrderRootType.CLASSES);
                JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                for (VirtualFile libraryFile : libraryFiles) {
                    if (libraryFile.getFileSystem() != jarFileSystem || libraryFile.findChild("lombok") == null) continue;
                    exists.set((Object)true);
                    return false;
                }
                return true;
            });
            return CachedValueProvider.Result.create((Object)((Boolean)exists.get()), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
    }

    @NotNull
    public static String getLombokVersionCached(@NotNull Project project) {
        if (project == null) {
            LombokLibraryUtil.$$$reportNull$$$0(1);
        }
        String string = (String)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            String lombokVersion = null;
            try {
                lombokVersion = (String)ReadAction.nonBlocking(() -> LombokLibraryUtil.getLombokVersionInternal(project)).executeSynchronously();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                Logger.getInstance(LombokLibraryUtil.class).error(e);
            }
            return new CachedValueProvider.Result((Object)StringUtil.notNullize((String)lombokVersion), new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
        if (string == null) {
            LombokLibraryUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static String getLombokVersionInternal(@NotNull Project project) {
        List entries;
        PsiDirectory[] directories;
        PsiPackage aPackage;
        if (project == null) {
            LombokLibraryUtil.$$$reportNull$$$0(3);
        }
        if ((aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(LOMBOK_PACKAGE)) != null && (directories = aPackage.getDirectories()).length > 0 && !(entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(directories[0].getVirtualFile())).isEmpty()) {
            return Version.parseLombokVersion((OrderEntry)entries.get(0));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/util/LombokLibraryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/util/LombokLibraryUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLombokVersionCached";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasLombokLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLombokVersionCached";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLombokVersionInternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

