/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.mdc.customobjects;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import liquibase.changelog.ChangeSet;
import liquibase.logging.mdc.CustomMdcObject;

public class ChangesetsUpdated
implements CustomMdcObject {
    private int changesetCount;
    private List<Changeset> changeset;

    public ChangesetsUpdated() {
    }

    public ChangesetsUpdated(List<ChangeSet> deployedChangeSets) {
        this.changesetCount = deployedChangeSets.size();
        this.changeset = new ArrayList<Changeset>(this.changesetCount);
        for (ChangeSet deployedChangeSet : deployedChangeSets) {
            this.changeset.add(new Changeset(deployedChangeSet.getId(), deployedChangeSet.getAuthor(), deployedChangeSet.getFilePath(), Objects.toString(deployedChangeSet.getAttribute("deploymentId")), Objects.toString(deployedChangeSet.getAttribute("updateExecType"))));
        }
    }

    public int getChangesetCount() {
        return this.changesetCount;
    }

    public void setChangesetCount(int changesetCount) {
        this.changesetCount = changesetCount;
    }

    public List<Changeset> getChangeset() {
        return this.changeset;
    }

    public void setChangeset(List<Changeset> changeset) {
        this.changeset = changeset;
    }

    public static class Changeset {
        private String changesetId;
        private String changesetAuthor;
        private String changesetFilepath;
        private String deploymentId;
        private String changesetOutcome;

        public Changeset(String changesetId, String changesetAuthor, String changesetFilepath, String deploymentId, String changesetOutcome) {
            this.changesetId = changesetId;
            this.changesetAuthor = changesetAuthor;
            this.changesetFilepath = changesetFilepath;
            this.deploymentId = deploymentId;
            this.changesetOutcome = changesetOutcome;
        }

        public String getChangesetId() {
            return this.changesetId;
        }

        public void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        public String getChangesetAuthor() {
            return this.changesetAuthor;
        }

        public void setChangesetAuthor(String changesetAuthor) {
            this.changesetAuthor = changesetAuthor;
        }

        public String getChangesetFilepath() {
            return this.changesetFilepath;
        }

        public void setChangesetFilepath(String changesetFilepath) {
            this.changesetFilepath = changesetFilepath;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public String getChangesetOutcome() {
            return this.changesetOutcome;
        }

        public void setChangesetOutcome(String changesetOutcome) {
            this.changesetOutcome = changesetOutcome;
        }
    }
}

