/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartLocator;
import com.intellij.kubernetes.helm.tgz.TgzFileSystem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/KubernetesTreeStructureProvider;", "Lcom/intellij/ide/projectView/TreeStructureProvider;", "<init>", "()V", "modify", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "parent", "children", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "TgzDirectoryNode", "intellij.clouds.kubernetes.backend"})
public final class KubernetesTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, @Nullable ViewSettings settings) {
        block18: {
            block17: {
                VirtualFile parentFile;
                block16: {
                    block15: {
                        Intrinsics.checkNotNullParameter(parent, (String)"parent");
                        Intrinsics.checkNotNullParameter(children, (String)"children");
                        if (!(parent instanceof ProjectViewNode)) {
                            return children;
                        }
                        if (((ProjectViewNode)parent).getProject() == null) {
                            return children;
                        }
                        VirtualFile virtualFile = parentFile = ((ProjectViewNode)parent).getVirtualFile();
                        if (virtualFile != null ? !virtualFile.isDirectory() : false) break block15;
                        VirtualFile virtualFile2 = parentFile;
                        if (Chart.Companion.isChartsDirName(virtualFile2 != null ? virtualFile2.getNameSequence() : null)) break block16;
                    }
                    return children;
                }
                VirtualFile virtualFile = parentFile;
                if ((virtualFile != null ? virtualFile.getParent() : null) == null) break block17;
                ChartLocator chartLocator = ChartLocator.Companion.instance();
                VirtualFile virtualFile3 = parentFile.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getParent(...)");
                if (chartLocator.locateChartByChartDir(virtualFile3) != null) break block18;
            }
            return children;
        }
        ArrayList<TgzDirectoryNode> result2 = new ArrayList<TgzDirectoryNode>();
        for (AbstractTreeNode<?> it : children) {
            boolean bl;
            if (it instanceof PsiFileNode && Chart.Companion.isHelmDependency(((PsiFileNode)it).getVirtualFile())) {
                PsiDirectory root;
                VirtualFile virtualFile = ((PsiFileNode)it).getVirtualFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                if (TgzFileSystem.Companion.findRootByLocalArchive(virtualFile) != null) {
                    VirtualFile it2;
                    boolean bl2 = false;
                    Project project = ((ProjectViewNode)parent).getProject();
                    Intrinsics.checkNotNull((Object)project);
                    v7 = PsiManager.getInstance((Project)project).findDirectory(it2);
                } else {
                    v7 = root = null;
                }
                if (root != null) {
                    Project project = ((ProjectViewNode)parent).getProject();
                    Intrinsics.checkNotNull((Object)project);
                    bl = result2.add(new TgzDirectoryNode(project, root, settings));
                    continue;
                }
                bl = result2.add((TgzDirectoryNode)it);
                continue;
            }
            bl = result2.add((TgzDirectoryNode)it);
        }
        return result2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/KubernetesTreeStructureProvider$TgzDirectoryNode;", "Lcom/intellij/ide/projectView/impl/nodes/PsiDirectoryNode;", "project", "Lcom/intellij/openapi/project/Project;", "dir", "Lcom/intellij/psi/PsiDirectory;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiDirectory;Lcom/intellij/ide/projectView/ViewSettings;)V", "getChildrenImpl", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "intellij.clouds.kubernetes.backend"})
    @SourceDebugExtension(value={"SMAP\nKubernetesTreeStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesTreeStructureProvider.kt\ncom/intellij/kubernetes/KubernetesTreeStructureProvider$TgzDirectoryNode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,69:1\n11561#2:70\n11896#2,3:71\n*S KotlinDebug\n*F\n+ 1 KubernetesTreeStructureProvider.kt\ncom/intellij/kubernetes/KubernetesTreeStructureProvider$TgzDirectoryNode\n*L\n65#1:70\n65#1:71,3\n*E\n"})
    public static final class TgzDirectoryNode
    extends PsiDirectoryNode {
        @NotNull
        private final PsiDirectory dir;

        public TgzDirectoryNode(@NotNull Project project, @NotNull PsiDirectory dir, @Nullable ViewSettings settings) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            super(project, dir, settings);
            this.dir = dir;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Collection<AbstractTreeNode<?>> getChildrenImpl() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PsiDirectory[] psiDirectoryArray = this.dir.getSubdirectories();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getSubdirectories(...)");
            Sequence sequence = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])psiDirectoryArray), arg_0 -> TgzDirectoryNode.getChildrenImpl$lambda$0(this, arg_0));
            PsiFile[] psiFileArray = this.dir.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
            Object[] objectArray = psiFileArray;
            Sequence sequence2 = sequence;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiFile psiFile = (PsiFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((AbstractTreeNode)new PsiFileNode(this.getProject(), (PsiFile)it, this.getSettings()));
            }
            return SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)sequence2, (Iterable)((List)destination$iv$iv)));
        }

        private static final TgzDirectoryNode getChildrenImpl$lambda$0(TgzDirectoryNode this$0, PsiDirectory it) {
            Project project = this$0.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNull((Object)it);
            return new TgzDirectoryNode(project, it, this$0.getSettings());
        }
    }
}

