/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.factories.CustomFactoryMethodTypeHandler;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockitoEasyMockCustomFactoryMethodTypeHandler
extends CustomFactoryMethodTypeHandler {
    private static final Map<String, String> METHOD_TO_CLASS_MAP = Map.of("mock", "org.mockito.Mockito", "createStrictMock", "org.easymock.EasyMock");

    @Nullable
    public PsiType getFactoryMethodType(@NotNull PsiMethod psiMethod, @Nullable CommonSpringBean contextBean) {
        if (psiMethod == null) {
            MockitoEasyMockCustomFactoryMethodTypeHandler.$$$reportNull$$$0(0);
        }
        if (!(contextBean instanceof SpringBean)) {
            return null;
        }
        String methodName = psiMethod.getName();
        if (!METHOD_TO_CLASS_MAP.containsKey(methodName)) {
            return null;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : METHOD_TO_CLASS_MAP.entrySet()) {
            JavaPsiFacade facade;
            PsiClass psiClass;
            String classFqn;
            List constructorArgs;
            if (!entry.getKey().equals(methodName) || !entry.getValue().equals(containingClass.getQualifiedName()) || (constructorArgs = ((SpringBean)contextBean).getConstructorArgs()).size() != 1 || (classFqn = ((ConstructorArg)constructorArgs.get(0)).getValueAsString()) == null || (psiClass = (facade = JavaPsiFacade.getInstance((Project)psiMethod.getProject())).findClass(classFqn, psiMethod.getResolveScope())) == null) continue;
            return facade.getElementFactory().createType(psiClass);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/factories/resolvers/MockitoEasyMockCustomFactoryMethodTypeHandler", "getFactoryMethodType"));
    }
}

