/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public final class SpringUastConstructorAutowiringChecker {
    public static void checkClass(@NotNull UClass aClass, @NotNull ProblemsHolder holder, @NotNull Map<PsiClass, SpringJavaClassInfo.MappedBeanInfo> mappedBeanInfos) {
        if (aClass == null) {
            SpringUastConstructorAutowiringChecker.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringUastConstructorAutowiringChecker.$$$reportNull$$$0(1);
        }
        if (mappedBeanInfos == null) {
            SpringUastConstructorAutowiringChecker.$$$reportNull$$$0(2);
        }
        PsiClass psiClass = aClass.getJavaPsi();
        PsiElement sourcePsi = aClass.getSourcePsi();
        if (sourcePsi == null) {
            return;
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("abstract") || !SpringAutowireUtil.isAutowiringRelevantClass(psiClass)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return;
        }
        SpringJavaClassInfo.MappedBeanInfo info = mappedBeanInfos.get(psiClass);
        if (info != null && info.isStereotypeJavaBean()) {
            Set<PsiMethod> requiredConstructors;
            PsiElement identifier;
            Collection<String> annotations = SpringAutowireUtil.getAutowiredAnnotations(module);
            HashMap<PsiMethod, PsiAnnotation> autowiredConstructors = new HashMap<PsiMethod, PsiAnnotation>();
            PsiMethod[] constructors = psiClass.getConstructors();
            boolean hasNoArgConstructor = constructors.length == 0;
            for (PsiMethod method : constructors) {
                if (!hasNoArgConstructor && method.getParameterList().getParametersCount() == 0) {
                    hasNoArgConstructor = true;
                }
                for (String annotation : annotations) {
                    PsiAnnotation autowiredAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{annotation});
                    if (autowiredAnno == null) continue;
                    autowiredConstructors.put(method, autowiredAnno);
                }
            }
            if (SpringCommonUtils.isStereotypeComponentOrMeta((PsiClass)psiClass) && !hasNoArgConstructor && autowiredConstructors.isEmpty() && constructors.length > 1 && (identifier = UElementKt.getSourcePsiElement((UElement)aClass.getUastAnchor())) != null) {
                holder.registerProblem(identifier, SpringBundle.message("class.without.matching.constructor.for.autowiring", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
            if ((requiredConstructors = SpringUastConstructorAutowiringChecker.getRequiredConstructors(autowiredConstructors)).size() > 1) {
                for (PsiMethod constructor : requiredConstructors) {
                    PsiElement identifier2;
                    UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)constructor, UMethod.class);
                    if (uMethod == null || (identifier2 = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) continue;
                    holder.registerProblem(identifier2, SpringBundle.message("multiple.autowiring.constructor", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        }
    }

    @NotNull
    private static Set<PsiMethod> getRequiredConstructors(@NotNull Map<PsiMethod, PsiAnnotation> constructors) {
        if (constructors == null) {
            SpringUastConstructorAutowiringChecker.$$$reportNull$$$0(3);
        }
        HashSet<PsiMethod> requiredConstructors = new HashSet<PsiMethod>();
        for (Map.Entry<PsiMethod, PsiAnnotation> constructor : constructors.entrySet()) {
            PsiAnnotation annotation = constructor.getValue();
            PsiMethod method = constructor.getKey();
            if ("org.springframework.beans.factory.annotation.Autowired".equals(annotation.getQualifiedName())) {
                Boolean required = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"required");
                if (required != null && !required.booleanValue()) continue;
                requiredConstructors.add(method);
                continue;
            }
            requiredConstructors.add(method);
        }
        HashSet<PsiMethod> hashSet = requiredConstructors;
        if (hashSet == null) {
            SpringUastConstructorAutowiringChecker.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedBeanInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastConstructorAutowiringChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastConstructorAutowiringChecker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredConstructors";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

