/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.microservices.url.MultiPathBestMatcher;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolverManager;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.SpringMvcUrlTargetInfo;
import com.intellij.spring.mvc.model.jam.SpringMvcUrlPathSpecification;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.spring.mvc.views.SpringMvcViewTargetResolver;
import com.intellij.spring.mvc.views.SpringMvcViewTargetResolverKt;
import com.intellij.spring.mvc.views.ViewMultiResolverReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMVCReference
extends PsiReferenceBase.Poly<PsiElement>
implements EmptyResolveMessageProvider,
HighlightedReference,
ViewMultiResolverReference {
    private final String myText;
    private final NotNullLazyValue<List<String>> myAllValues;
    private static final ResolveCache.AbstractResolver<SpringMVCReference, Set<PsiElement>> MY_RESOLVER = (reference, incompleteCode) -> reference.innerResolve(incompleteCode);

    public SpringMVCReference(PsiElement element, TextRange range, String fullText, boolean soft) {
        super(element, range, soft);
        this.myText = fullText;
        this.myAllValues = NotNullLazyValue.lazy(() -> SpringMVCReference.firRanges(this.myText, "/", true).flatMap(slashRange -> SpringMVCReference.firRanges(slashRange.subSequence((CharSequence)this.myText), ".", false).map(textRange -> textRange.shiftRight(slashRange.getStartOffset()))).map(it -> it.substring(this.myText)).toList());
    }

    private static StreamEx<TextRange> firRanges(CharSequence text, String delimiter, boolean forward) {
        List split = SequencesKt.toList((Sequence)TextRangeUtils.splitToTextRanges((CharSequence)text, (String)delimiter, (boolean)false));
        if (split.isEmpty()) {
            return StreamEx.empty();
        }
        TextRange anchor = forward ? (TextRange)split.get(split.size() - 1) : (TextRange)split.get(0);
        return StreamEx.of((Collection)split).map(range -> forward ? TextRange.create((int)range.getStartOffset(), (int)anchor.getEndOffset()) : TextRange.create((int)anchor.getStartOffset(), (int)range.getEndOffset()));
    }

    @NotNull
    private StreamEx<ServletMappingInfo> getServletMappingInfos() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                SpringMVCReference.$$$reportNull$$$0(0);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.of(SpringMvcUtils.getServletMappingInfos(module));
        if (streamEx == null) {
            SpringMVCReference.$$$reportNull$$$0(1);
        }
        return streamEx;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ServletMappingInfo myMappingInfo;
        if (newElementName == null) {
            SpringMVCReference.$$$reportNull$$$0(2);
        }
        if ((myMappingInfo = (ServletMappingInfo)this.selectServletMapping().nonNull().findAny().orElse(null)) == null) {
            return super.handleElementRename(newElementName);
        }
        String s = myMappingInfo.stripMapping(newElementName);
        return super.handleElementRename(s);
    }

    private StreamEx<ServletMappingInfo> selectServletMapping() {
        return (StreamEx)this.getServletMappingInfos().filter(info -> ContainerUtil.or((Iterable)((Iterable)this.myAllValues.getValue()), value -> info.matches(value)));
    }

    @Override
    public boolean hasResolvers() {
        return this.selectServletMapping().findAny().isPresent();
    }

    public boolean isReferenceTo(@NotNull PsiElement target) {
        if (target == null) {
            SpringMVCReference.$$$reportNull$$$0(3);
        }
        if (!(target instanceof PomTargetPsiElement)) {
            return false;
        }
        return super.isReferenceTo(target);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        Set collection = (Set)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, MY_RESOLVER, false, incompleteCode);
        if (collection == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringMVCReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array((Collection)collection, PsiElementResolveResult.class, PsiElementResolveResult::new);
        if (resolveResultArray == null) {
            SpringMVCReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    private Set<PsiElement> innerResolve(boolean incompleteCode) {
        PsiElement element = this.getElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Module> allModules = new LinkedHashSet<Module>();
        ModuleUtilCore.getDependencies((Module)module, allModules);
        allModules.add(module);
        Set allResolvedTargets = ((MultiPathBestMatcher)StreamEx.of((Collection)((Collection)this.myAllValues.getValue())).map(value -> SpringMvcUrlPathSpecification.INSTANCE.getParser().parseUrlPath(new PartiallyKnownString(value)).getUrlPath()).foldLeft((Object)new MultiPathBestMatcher(), (matcher, urlPath) -> {
            Iterable resolved = UrlResolverManager.getInstance((Project)element.getProject()).resolve(new UrlResolveRequest(null, null, urlPath, "GET"), (resolver, request) -> {
                if (resolver instanceof SpringMvcViewTargetResolver) {
                    return SpringMvcViewTargetResolverKt.resolveMvcViewTargets(allModules, (SpringMvcViewTargetResolver)resolver, request);
                }
                return Collections.emptyList();
            });
            return matcher.addBestMatching(resolved, urlPath);
        })).getResult();
        return StreamEx.of((Collection)allResolvedTargets).map(this::extractPsiElement).nonNull().toSet();
    }

    @Nullable
    private PsiElement extractPsiElement(UrlTargetInfo it) {
        if (it instanceof SpringMvcUrlTargetInfo) {
            UrlMappingElement urlMapping = ((SpringMvcUrlTargetInfo)it).getUrlMapping();
            PomNamedTarget pomTarget = urlMapping.getPomTarget();
            if (pomTarget == null) {
                return null;
            }
            return PomService.convertToPsi((Project)this.getElement().getProject(), (PomTarget)pomTarget);
        }
        return it.resolveToPsiElement();
    }

    public Object @NotNull [] getVariants() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            if (EMPTY_ARRAY == null) {
                SpringMVCReference.$$$reportNull$$$0(6);
            }
            return EMPTY_ARRAY;
        }
        Object[] objectArray = ContainerUtil.map2Array(SpringMvcUtils.getUrlMappings(module), LookupElement.class, variant -> {
            String lookupString = ((StreamEx)StreamEx.of((Collection)variant.getUrlPath().getSegments()).map(e -> e.getValueIfExact()).takeWhileInclusive(Objects::nonNull)).map(StringUtil::notNullize).joining((CharSequence)"/");
            PsiElement resolveElement = variant.getNavigationTarget();
            LookupElementBuilder builder = resolveElement != null ? LookupElementBuilder.create((Object)resolveElement, (String)lookupString).withTypeText(FileUtilRt.getNameWithoutExtension((String)resolveElement.getContainingFile().getName())) : LookupElementBuilder.create((String)lookupString);
            builder = builder.withIcon(SpringApiIcons.RequestMapping);
            if (variant.getMethod().length > 0) {
                builder = builder.withTailText(" " + RequestMethod.getDisplay(variant.getMethod()), true);
            }
            return builder.withPresentableText("/" + variant.getPresentation());
        });
        if (objectArray == null) {
            SpringMVCReference.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = SpringMvcBundle.message("cannot.resolve.controller.url", new Object[0]);
        if (string == null) {
            SpringMVCReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String toString() {
        return "SpringMVCReference{myElement=" + this.myElement.getText() + "range=" + String.valueOf(this.getRangeInElement()) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/SpringMVCReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServletMappingInfos";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/SpringMVCReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

