/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.pathVariables;

import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.microservices.jvm.pathvars.usages.AnnotationParamSearcherUtils;
import com.intellij.microservices.url.parameters.PathVariableDeclaringReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMember;
import com.intellij.semantic.SemKey;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.webClient.exchange.HttpExchange;
import com.intellij.spring.mvc.webClient.exchange.SpringExchangeMapping;
import com.intellij.util.Plow;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

public final class SpringMvcPathVariableDeclarationSearcher {
    private SpringMvcPathVariableDeclarationSearcher() {
    }

    @Nullable
    public static PathVariableDeclaringReference findPathVariableDeclaration(String pathVariableName, PsiElement context) {
        return (PathVariableDeclaringReference)SpringMvcPathVariableDeclarationSearcher.collectDeclarations(context).find(reference -> reference.getValue().equals(pathVariableName));
    }

    public static Plow<PathVariableDeclaringReference> collectDeclarations(@Nullable PsiElement context) {
        return SpringMvcPathVariableDeclarationSearcher.collectDeclarations((UMethod)UastUtils.findContaining((PsiElement)context, UMethod.class));
    }

    public static Plow<PathVariableDeclaringReference> collectDeclarations(@Nullable UMethod method) {
        return Plow.of(processor -> {
            if (!SpringMvcPathVariableDeclarationSearcher.processRequestMapping((Processor<PathVariableDeclaringReference>)processor, (UDeclaration)method, RequestMapping.METHOD_JAM_KEY)) {
                return false;
            }
            UClass clazz = UastUtils.getContainingUClass((UElement)method);
            if (!SpringMvcPathVariableDeclarationSearcher.processRequestMapping((Processor<PathVariableDeclaringReference>)processor, (UDeclaration)clazz, RequestMapping.CLASS_JAM_KEY)) {
                return false;
            }
            if (!SpringMvcPathVariableDeclarationSearcher.processExchangeMappings((Processor<PathVariableDeclaringReference>)processor, (UDeclaration)method, SpringExchangeMapping.MAPPING_JAM_KEY)) {
                return false;
            }
            return SpringMvcPathVariableDeclarationSearcher.processExchangeMappings((Processor<PathVariableDeclaringReference>)processor, (UDeclaration)clazz, HttpExchange.CLASS_JAM_KEY);
        });
    }

    private static <T extends PsiMember> boolean processRequestMapping(Processor<PathVariableDeclaringReference> processor, @Nullable UDeclaration modifierListOwner, SemKey<? extends RequestMapping<T>> jamKey) {
        if (modifierListOwner == null) {
            return false;
        }
        PsiElement jvmDeclaration = modifierListOwner.getJavaPsi();
        if (jvmDeclaration == null) {
            return false;
        }
        RequestMapping requestMapping = (RequestMapping)JamService.getJamService((Project)jvmDeclaration.getProject()).getJamElement(jamKey, jvmDeclaration);
        if (requestMapping == null) {
            return true;
        }
        return SpringMvcPathVariableDeclarationSearcher.walkUrlAttributes(requestMapping.getMappingUrls(), processor);
    }

    @NotNull
    private static StreamEx<PathVariableDeclaringReference> getReferencesForUrlPsiElement(UExpression expression) {
        if (expression == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(0);
            }
            return streamEx;
        }
        if (expression instanceof UInjectionHost) {
            UInjectionHost uInjectionHost = (UInjectionHost)expression;
            PsiLanguageInjectionHost injectionHost = uInjectionHost.getPsiLanguageInjectionHost();
            StreamEx streamEx = StreamEx.of((Object[])injectionHost.getReferences()).select(PathVariableDeclaringReference.class);
            if (streamEx == null) {
                SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(1);
            }
            return streamEx;
        }
        if (expression instanceof UReferenceExpression) {
            StreamEx streamEx = StreamEx.of((Object)AnnotationParamSearcherUtils.deepReferencesSearch((UExpression)expression)).select(PathVariableDeclaringReference.class);
            if (streamEx == null) {
                SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(2);
            }
            return streamEx;
        }
        if (expression instanceof UPolyadicExpression) {
            StreamEx streamEx = StreamEx.of((Collection)((UPolyadicExpression)expression).getOperands()).flatMap(operand -> SpringMvcPathVariableDeclarationSearcher.getReferencesForUrlPsiElement(operand));
            if (streamEx == null) {
                SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(3);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.empty();
        if (streamEx == null) {
            SpringMvcPathVariableDeclarationSearcher.$$$reportNull$$$0(4);
        }
        return streamEx;
    }

    private static boolean processExchangeMappings(Processor<PathVariableDeclaringReference> processor, @Nullable UDeclaration modifierListOwner, SemKey<? extends SpringExchangeMapping<?>> jamKey) {
        if (modifierListOwner == null) {
            return false;
        }
        PsiElement jvmDeclaration = modifierListOwner.getJavaPsi();
        if (jvmDeclaration == null) {
            return false;
        }
        SpringExchangeMapping exchangeMapping = (SpringExchangeMapping)JamService.getJamService((Project)jvmDeclaration.getProject()).getJamElement(jamKey, jvmDeclaration);
        if (exchangeMapping == null) {
            return true;
        }
        return SpringMvcPathVariableDeclarationSearcher.walkUrlAttributes(exchangeMapping.getUrls(), processor);
    }

    private static boolean walkUrlAttributes(List<JamStringAttributeElement<String>> requestMappingAttributes, Processor<PathVariableDeclaringReference> processor) {
        return StreamEx.of(requestMappingAttributes).map(urlAttribute -> (UExpression)UastContextKt.toUElement((PsiElement)urlAttribute.getPsiElement(), UExpression.class)).nonNull().flatMap(SpringMvcPathVariableDeclarationSearcher::getReferencesForUrlPsiElement).allMatch(arg_0 -> processor.process(arg_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/mvc/pathVariables/SpringMvcPathVariableDeclarationSearcher", "getReferencesForUrlPsiElement"));
    }
}

