/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.java;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.Direction;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.ModelTraverse;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringConstructorArgUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class SpringJavaClassInfo {
    private static final Key<CachedValue<MappedBeanInfo>> SPRING_JAVA_CLASS_INFO_KEY = Key.create((String)"SPRING_JAVA_CLASS_INFO");
    private final CachedValue<MappedBeanInfo> myMappedInfo;

    @NotNull
    public static SpringJavaClassInfo getSpringJavaClassInfo(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(0);
        }
        CachedValue info = (CachedValue)ConcurrencyUtil.computeIfAbsent((UserDataHolder)psiClass, SPRING_JAVA_CLASS_INFO_KEY, () -> SpringJavaClassInfo.createCachedValue(psiClass, psiClass.getProject()));
        return new SpringJavaClassInfo((CachedValue<MappedBeanInfo>)info);
    }

    private SpringJavaClassInfo(@NotNull CachedValue<MappedBeanInfo> mappedInfo) {
        if (mappedInfo == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(1);
        }
        this.myMappedInfo = mappedInfo;
    }

    @NotNull
    private static CachedValue<MappedBeanInfo> createCachedValue(@NotNull PsiClass psiClass, @NotNull Project project) {
        if (psiClass == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(3);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue((UserDataHolder)psiClass, () -> {
            CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
            SpringModelSearchParameters.BeanClass parameters = SpringModelSearchParameters.byClass(psiClass).withInheritors().effectiveBeanTypes();
            boolean isMapped = SpringModelSearchers.doesBeanExist(model, parameters);
            return CachedValueProvider.Result.create((Object)new MappedBeanInfo(psiClass, isMapped), SpringJavaClassInfo.getMappedDependencies(project));
        }, false);
        if (cachedValue == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(4);
        }
        return cachedValue;
    }

    private static void addStereotypeBeanMethod(@NotNull MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> map, @NotNull JamStringAttributeElement<PsiMethod> attributeElement, @NotNull SpringMethodType type) {
        PsiAnnotationMemberValue identifyingElement;
        PsiMethod psiMethod;
        if (map == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(5);
        }
        if (attributeElement == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(6);
        }
        if (type == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(7);
        }
        if ((psiMethod = (PsiMethod)attributeElement.getValue()) != null && (identifyingElement = attributeElement.getPsiElement()) != null) {
            map.putValue((Object)psiMethod, (Object)Pair.create((Object)identifyingElement.getParent(), (Object)((Object)type)));
        }
    }

    private static Collection<Object> getMappedDependencies(@NotNull Project project) {
        if (project == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(8);
        }
        ArrayList<Object> dependencies = new ArrayList<Object>(Arrays.asList(SpringModificationTrackersManager.getInstance(project).getOuterModelsDependencies()));
        dependencies.add(PsiModificationTracker.getInstance((Project)project).forLanguage((Language)XMLLanguage.INSTANCE));
        return dependencies;
    }

    private static void addSpringBeanMethod(@NotNull MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> map, @NotNull List<PsiMethod> psiMethods, @NotNull SpringMethodType type, @NotNull GenericAttributeValue<PsiMethod> genericAttributeValue) {
        if (map == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(9);
        }
        if (psiMethods == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(10);
        }
        if (type == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(11);
        }
        if (genericAttributeValue == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(12);
        }
        if (!DomUtil.hasXml(genericAttributeValue)) {
            return;
        }
        PsiMethod psiMethod = (PsiMethod)genericAttributeValue.getValue();
        if (psiMethod != null && psiMethods.contains(psiMethod)) {
            map.putValue((Object)psiMethod, (Object)Pair.create((Object)genericAttributeValue.getXmlAttribute(), (Object)((Object)type)));
        }
    }

    private static void addSpringBeanMethods(@NotNull MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> map, @NotNull List<PsiMethod> psiMethods, @NotNull SpringMethodType type, @NotNull GenericAttributeValue<Set<PsiMethod>> genericAttributeValue) {
        if (map == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(13);
        }
        if (psiMethods == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(14);
        }
        if (type == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(15);
        }
        if (genericAttributeValue == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(16);
        }
        if (!DomUtil.hasXml(genericAttributeValue)) {
            return;
        }
        Set methods = (Set)genericAttributeValue.getValue();
        if (methods != null) {
            for (PsiMethod psiMethod : methods) {
                if (!psiMethods.contains(psiMethod)) continue;
                map.putValue((Object)psiMethod, (Object)Pair.create((Object)genericAttributeValue.getXmlAttribute(), (Object)((Object)type)));
            }
        }
    }

    public boolean isCalculatedMapped() {
        Getter getter = this.myMappedInfo.getUpToDateOrNull();
        return getter != null && ((MappedBeanInfo)getter.get()).isMapped();
    }

    public boolean isResolved() {
        return this.myMappedInfo.hasUpToDateValue();
    }

    public MappedBeanInfo resolve() {
        return (MappedBeanInfo)this.myMappedInfo.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedInfo";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/java/SpringJavaClassInfo";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeElement";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethods";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericAttributeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/java/SpringJavaClassInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpringJavaClassInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addStereotypeBeanMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMappedDependencies";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addSpringBeanMethod";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSpringBeanMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    public static final class MappedBeanInfo {
        private final PsiClass myPsiClass;
        private final boolean myMapped;
        private final CachedValue<Set<SpringBeanPointer<?>>> myBeans;
        private final CachedValue<MappedMembersInfo> myMembersInfo;

        public MappedBeanInfo(PsiClass aClass, boolean isMapped) {
            this.myPsiClass = aClass;
            this.myMapped = isMapped;
            this.myMembersInfo = CachedValuesManager.getManager((Project)aClass.getProject()).createCachedValue(() -> {
                MappedMembersInfo info = new MappedMembersInfo(this.findMappedProperties(), this.findMappedConstructors(), this.findMappedMethods());
                Project project = this.myPsiClass.getProject();
                ArrayList<Object> dependencies = new ArrayList<Object>();
                ContainerUtil.addAll(dependencies, (Object[])SpringModificationTrackersManager.getInstance(project).getOuterModelsDependencies());
                dependencies.add(this.myPsiClass);
                dependencies.add(DomManager.getDomManager((Project)project));
                return CachedValueProvider.Result.create((Object)info, dependencies);
            });
            this.myBeans = CachedValuesManager.getManager((Project)aClass.getProject()).createCachedValue(() -> {
                SpringModelSearchParameters.BeanClass parameters;
                CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(aClass);
                List<SpringBeanPointer<?>> byInheritance = SpringModelSearchers.findBeans(model, parameters = SpringModelSearchParameters.byClass(aClass).withInheritors().effectiveBeanTypes());
                LinkedHashSet beans2 = byInheritance.size() <= 1 ? Set.copyOf(byInheritance) : new LinkedHashSet(byInheritance);
                return CachedValueProvider.Result.create(beans2, MappedBeanInfo.getBeanDependencies(aClass.getProject(), model));
            });
        }

        public boolean isMapped() {
            return this.myMapped;
        }

        public Set<SpringBeanPointer<?>> getBeans() {
            if (!this.myMapped) {
                return Collections.emptySet();
            }
            return (Set)this.myBeans.getValue();
        }

        public boolean isMappedProperty(PsiMethod method) {
            if (!this.myMapped) {
                return false;
            }
            String propertyName = StringUtil.getPropertyName((String)method.getName());
            if (propertyName == null) {
                return false;
            }
            return !this.getMappedProperties(propertyName).isEmpty();
        }

        public boolean isMappedConstructor(@NotNull PsiMethod method) {
            if (method == null) {
                MappedBeanInfo.$$$reportNull$$$0(0);
            }
            if (!this.myMapped) {
                return false;
            }
            if (!method.isConstructor()) {
                return false;
            }
            return this.getMappedConstructors().containsKey((Object)method);
        }

        public boolean isMappedDomBean() {
            if (!this.myMapped) {
                return false;
            }
            return ContainerUtil.findInstance((Iterable)((Iterable)this.myBeans.getValue()), DomSpringBeanPointer.class) != null;
        }

        public @Unmodifiable @NotNull List<DomSpringBeanPointer> getMappedDomBeans() {
            if (!this.myMapped) {
                List<DomSpringBeanPointer> list = Collections.emptyList();
                if (list == null) {
                    MappedBeanInfo.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = ContainerUtil.findAll((Collection)((Collection)this.myBeans.getValue()), DomSpringBeanPointer.class);
            if (list == null) {
                MappedBeanInfo.$$$reportNull$$$0(2);
            }
            return list;
        }

        public boolean isStereotypeJavaBean() {
            if (!this.myMapped) {
                return false;
            }
            return ContainerUtil.exists((Iterable)((Iterable)this.myBeans.getValue()), bean -> bean.isDefinedByCode());
        }

        @NotNull
        public List<JamSpringBeanPointer> getStereotypeMappedBeans() {
            if (!this.myMapped) {
                List<JamSpringBeanPointer> list = Collections.emptyList();
                if (list == null) {
                    MappedBeanInfo.$$$reportNull$$$0(3);
                }
                return list;
            }
            List list = ContainerUtil.findAll((Collection)((Collection)this.myBeans.getValue()), JamSpringBeanPointer.class);
            if (list == null) {
                MappedBeanInfo.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public List<SpringBeanPointer<?>> getAllBeans() {
            if (!this.myMapped) {
                List<SpringBeanPointer<?>> list = Collections.emptyList();
                if (list == null) {
                    MappedBeanInfo.$$$reportNull$$$0(5);
                }
                return list;
            }
            return new ArrayList((Collection)this.myBeans.getValue());
        }

        private static Collection<Object> getBeanDependencies(@NotNull Project project, @NotNull CommonSpringModel model) {
            if (project == null) {
                MappedBeanInfo.$$$reportNull$$$0(6);
            }
            if (model == null) {
                MappedBeanInfo.$$$reportNull$$$0(7);
            }
            LinkedHashSet<Object> dependencies = new LinkedHashSet<Object>();
            ContainerUtil.addAll(dependencies, (Object[])SpringModificationTrackersManager.getInstance(project).getOuterModelsDependencies());
            CommonProcessors.CollectProcessor configFilesProcessor = new CommonProcessors.CollectProcessor();
            ModelTraverse.traverseModelPreventingRecursion(model, true, m -> {
                if (m instanceof LocalModel) {
                    return ((LocalModel)m).traverseConfigDependencies((Processor<PsiFile>)configFilesProcessor);
                }
                return Direction.TRAVERSE;
            });
            ContainerUtil.addAll(dependencies, (Iterable)configFilesProcessor.getResults());
            return dependencies;
        }

        public boolean isAutowired() {
            if (!this.myMapped) {
                return false;
            }
            List<DomSpringBeanPointer> pointers = this.getMappedDomBeans();
            for (DomSpringBeanPointer pointer : pointers) {
                Autowire autowire;
                DomSpringBean springBean = (DomSpringBean)pointer.getSpringBean();
                if (!(springBean instanceof SpringBean) || !(autowire = ((SpringBean)springBean).getBeanAutowire()).isAutowired()) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public Set<Autowire> getAutowires() {
            if (!this.myMapped) {
                Set<Autowire> set = Collections.emptySet();
                if (set == null) {
                    MappedBeanInfo.$$$reportNull$$$0(8);
                }
                return set;
            }
            EnumSet<Autowire> autowires = EnumSet.noneOf(Autowire.class);
            for (DomSpringBeanPointer pointer : this.getMappedDomBeans()) {
                Autowire autowire;
                DomSpringBean springBean = (DomSpringBean)pointer.getSpringBean();
                if (!(springBean instanceof SpringBean) || !(autowire = ((SpringBean)springBean).getBeanAutowire()).isAutowired()) continue;
                autowires.add(autowire);
            }
            EnumSet<Autowire> enumSet = autowires;
            if (enumSet == null) {
                MappedBeanInfo.$$$reportNull$$$0(9);
            }
            return enumSet;
        }

        @NotNull
        public Collection<SpringPropertyDefinition> getMappedProperties(String propertyName) {
            if (!this.myMapped) {
                Set<SpringPropertyDefinition> set = Collections.emptySet();
                if (set == null) {
                    MappedBeanInfo.$$$reportNull$$$0(10);
                }
                return set;
            }
            MultiMap<String, SpringPropertyDefinition> value = this.getMappedProperties();
            if (value == null) {
                List<SpringPropertyDefinition> list = Collections.emptyList();
                if (list == null) {
                    MappedBeanInfo.$$$reportNull$$$0(11);
                }
                return list;
            }
            Collection collection = value.get((Object)propertyName);
            if (collection == null) {
                MappedBeanInfo.$$$reportNull$$$0(12);
            }
            return collection;
        }

        @NotNull
        public Collection<SpringBeanPointer<?>> getMappedConstructorDefinitions(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                MappedBeanInfo.$$$reportNull$$$0(13);
            }
            if (!this.myMapped) {
                List<SpringBeanPointer<?>> list = Collections.emptyList();
                if (list == null) {
                    MappedBeanInfo.$$$reportNull$$$0(14);
                }
                return list;
            }
            MultiMap<PsiMethod, SpringBeanPointer<?>> value = this.getMappedConstructors();
            if (value == null) {
                List<SpringBeanPointer<?>> list = Collections.emptyList();
                if (list == null) {
                    MappedBeanInfo.$$$reportNull$$$0(15);
                }
                return list;
            }
            Collection collection = value.get((Object)psiMethod);
            if (collection == null) {
                MappedBeanInfo.$$$reportNull$$$0(16);
            }
            return collection;
        }

        @NotNull
        public Collection<Pair<PsiElement, SpringMethodType>> getMethodTypes(@NotNull PsiMethod psiMethod) {
            MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> value;
            if (psiMethod == null) {
                MappedBeanInfo.$$$reportNull$$$0(17);
            }
            if ((value = this.getMappedMethods()) == null) {
                List<Pair<PsiElement, SpringMethodType>> list = Collections.emptyList();
                if (list == null) {
                    MappedBeanInfo.$$$reportNull$$$0(18);
                }
                return list;
            }
            Collection collection = value.get((Object)psiMethod);
            if (collection == null) {
                MappedBeanInfo.$$$reportNull$$$0(19);
            }
            return collection;
        }

        public MultiMap<String, SpringPropertyDefinition> getMappedProperties() {
            if (!this.myMapped) {
                return MultiMap.empty();
            }
            return ((MappedMembersInfo)this.myMembersInfo.getValue()).properties;
        }

        private MultiMap<String, SpringPropertyDefinition> findMappedProperties() {
            List<DomSpringBeanPointer> list = this.getMappedDomBeans();
            MultiMap map = MultiMap.create();
            for (DomSpringBeanPointer beanPointer : list) {
                DomSpringBean bean;
                if (!beanPointer.isValid() || !((bean = (DomSpringBean)beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                List<SpringPropertyDefinition> properties = ((SpringBean)bean).getAllProperties();
                for (SpringPropertyDefinition property : properties) {
                    String propertyName = property.getPropertyName();
                    if (propertyName == null) continue;
                    map.putValue((Object)propertyName, (Object)property);
                }
            }
            return map;
        }

        private MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> getMappedMethods() {
            return ((MappedMembersInfo)this.myMembersInfo.getValue()).methods;
        }

        private MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> findMappedMethods() {
            List<PsiMethod> psiMethods = Arrays.asList(this.myPsiClass.getMethods());
            MultiMap map = MultiMap.create();
            for (JamSpringBeanPointer jamSpringBeanPointer : this.getStereotypeMappedBeans()) {
                JamPsiMemberSpringBean bean = (JamPsiMemberSpringBean)jamSpringBeanPointer.getSpringBean();
                if (!(bean instanceof ContextJavaBean)) continue;
                SpringJavaClassInfo.addStereotypeBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, ((ContextJavaBean)bean).getInitMethodAttributeElement(), SpringMethodType.INIT);
                SpringJavaClassInfo.addStereotypeBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, ((ContextJavaBean)bean).getDestroyMethodAttributeElement(), SpringMethodType.DESTROY);
            }
            List<DomSpringBeanPointer> list = this.getMappedDomBeans();
            for (DomSpringBeanPointer beanPointer : list) {
                DomSpringBean bean;
                if (!beanPointer.isValid() || !((bean = (DomSpringBean)beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                SpringBean springBean = (SpringBean)bean;
                Beans beans2 = (Beans)DomUtil.getParentOfType((DomElement)bean, Beans.class, (boolean)false);
                if (beans2 != null) {
                    SpringJavaClassInfo.addSpringBeanMethods((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.INIT, beans2.getDefaultInitMethod());
                    SpringJavaClassInfo.addSpringBeanMethods((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.DESTROY, beans2.getDefaultDestroyMethod());
                }
                SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.INIT, (GenericAttributeValue<PsiMethod>)springBean.getInitMethod());
                SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.DESTROY, (GenericAttributeValue<PsiMethod>)springBean.getDestroyMethod());
                for (LookupMethod lookupMethod : springBean.getLookupMethods()) {
                    SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.LOOKUP, lookupMethod.getName());
                }
            }
            CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
            SpringBeanUtils.getInstance().processXmlFactoryBeans(this.myPsiClass.getProject(), this.myPsiClass.getResolveScope(), (Processor<SpringBeanPointer<?>>)collectProcessor);
            for (SpringBeanPointer pointer : collectProcessor.getResults()) {
                PsiMethod factoryMethod;
                GenericAttributeValue<PsiMethod> domFactoryMethod;
                Object commonSpringBean;
                if (!pointer.isValid() || !((commonSpringBean = pointer.getSpringBean()) instanceof SpringBean)) continue;
                SpringBean springBean = (SpringBean)commonSpringBean;
                if (!commonSpringBean.isValid() || !DomUtil.hasXml(domFactoryMethod = springBean.getFactoryMethod()) || (factoryMethod = (PsiMethod)domFactoryMethod.getValue()) == null || !psiMethods.contains(factoryMethod)) continue;
                SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.FACTORY, domFactoryMethod);
            }
            return map;
        }

        public MultiMap<PsiMethod, SpringBeanPointer<?>> getMappedConstructors() {
            if (!this.myMapped) {
                return MultiMap.empty();
            }
            return ((MappedMembersInfo)this.myMembersInfo.getValue()).constructors;
        }

        private MultiMap<PsiMethod, SpringBeanPointer<?>> findMappedConstructors() {
            List<DomSpringBeanPointer> list = this.getMappedDomBeans();
            MultiMap map = MultiMap.create();
            for (DomSpringBeanPointer beanPointer : list) {
                DomSpringBean bean;
                if (!beanPointer.isValid() || !((bean = (DomSpringBean)beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(this.myPsiClass);
                PsiMethod constructor = SpringConstructorArgUtils.getInstance().getSpringBeanConstructor((SpringBean)bean, model);
                if (constructor == null) continue;
                map.putValue((Object)constructor, (Object)beanPointer);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 14, 15, 16, 18, 19 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/java/SpringJavaClassInfo$MappedBeanInfo";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/java/SpringJavaClassInfo$MappedBeanInfo";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedDomBeans";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStereotypeMappedBeans";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllBeans";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAutowires";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedProperties";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedConstructorDefinitions";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isMappedConstructor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getBeanDependencies";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getMappedConstructorDefinitions";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getMethodTypes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 14, 15, 16, 18, 19 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MappedMembersInfo {
        final MultiMap<String, SpringPropertyDefinition> properties;
        final MultiMap<PsiMethod, SpringBeanPointer<?>> constructors;
        final MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> methods;

        MappedMembersInfo(MultiMap<String, SpringPropertyDefinition> properties, MultiMap<PsiMethod, SpringBeanPointer<?>> constructors, MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> methods) {
            this.properties = properties;
            this.constructors = constructors;
            this.methods = methods;
        }
    }

    public static enum SpringMethodType {
        INIT("init"),
        DESTROY("destroy"),
        FACTORY("factory"),
        LOOKUP("lookup");

        private final String myName;

        private SpringMethodType(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }
    }
}

