/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.util;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.values.converters.FieldRetrievingFactoryBeanConverter;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.util.SpringUtilElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Spring Constant")
@BeanType(provider=SpringConstantBeanTypeProvider.class)
public interface SpringConstant
extends SpringUtilElement,
DomSpringBean {
    @Required
    @Referencing(value=FieldRetrievingFactoryBeanConverter.FieldReferenceRequired.class)
    @NotNull
    public GenericAttributeValue<String> getStaticField();

    public static class SpringConstantBeanTypeProvider
    implements BeanTypeProvider<SpringConstant> {
        @Override
        public String @NotNull [] getBeanTypeCandidates() {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                SpringConstantBeanTypeProvider.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }

        @Override
        @Nullable
        public String getBeanType(SpringConstant constant) {
            PsiClass psiClass = SpringConstantBeanTypeProvider.getStaticFieldType(constant);
            return psiClass != null ? StringUtil.notNullize((String)psiClass.getQualifiedName()) : "";
        }

        @Nullable
        private static PsiClass getStaticFieldType(SpringConstant constant) {
            String staticField = constant.getStaticField().getRawText();
            if (StringUtil.isEmptyOrSpaces((String)staticField) || PlaceholderUtils.getInstance().isDefaultPlaceholder(staticField)) {
                return null;
            }
            int lastPoint = staticField.indexOf("$");
            if (lastPoint == -1) {
                lastPoint = staticField.indexOf(".");
            }
            if (lastPoint >= 0) {
                String className = staticField.substring(0, lastPoint);
                if (StringUtil.isEmptyOrSpaces((String)className)) {
                    return null;
                }
                String fieldName = staticField.substring(lastPoint + 1);
                if (StringUtil.isEmptyOrSpaces((String)fieldName)) {
                    return null;
                }
                Project project = constant.getPsiManager().getProject();
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
                if (aClass != null) {
                    PsiField fieldByName = aClass.findFieldByName(fieldName, true);
                    if (fieldByName != null) {
                        PsiType type = fieldByName.getType();
                        if (type instanceof PsiClassType) {
                            return ((PsiClassType)type).resolve();
                        }
                    } else {
                        for (PsiMethod method : aClass.findMethodsByName(fieldName, true)) {
                            PsiType returnType = method.getReturnType();
                            if (!(returnType instanceof PsiClassType)) continue;
                            return ((PsiClassType)returnType).resolve();
                        }
                    }
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/util/SpringConstant$SpringConstantBeanTypeProvider", "getBeanTypeCandidates"));
        }
    }
}

