/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;

public class AnnotationArgConverter {
    private static final Logger LOG = Logger.getInstance(AnnotationArgConverter.class);

    @Nullable
    public GrAnnotationMemberValue convert(PsiAnnotationMemberValue value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("@A(");
        this.generateText(value, buffer);
        buffer.append(")");
        String text = buffer.toString();
        try {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(value.getProject());
            return factory.createAnnotationFromText(text).getParameterList().getAttributes()[0].getValue();
        }
        catch (IncorrectOperationException | ArrayIndexOutOfBoundsException e) {
            LOG.error("Text: \"" + text + "\"", e);
            return null;
        }
    }

    private void generateText(PsiAnnotationMemberValue value, final @NlsSafe StringBuilder buffer) {
        value.accept((PsiElementVisitor)new JavaElementVisitor(this){

            public void visitAnnotation(@NotNull PsiAnnotation annotation) {
                if (annotation == null) {
                    1.$$$reportNull$$$0(0);
                }
                buffer.append("@");
                PsiJavaCodeReferenceElement ref2 = annotation.getNameReferenceElement();
                if (ref2 == null) {
                    return;
                }
                PsiElement resolved = ref2.resolve();
                if (resolved instanceof PsiClass && ((PsiClass)resolved).getQualifiedName() != null) {
                    buffer.append(((PsiClass)resolved).getQualifiedName());
                } else {
                    buffer.append(ref2.getText());
                }
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                parameterList.accept((PsiElementVisitor)this);
            }

            public void visitAnnotationParameterList(@NotNull PsiAnnotationParameterList list) {
                PsiNameValuePair[] attributes;
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((attributes = list.getAttributes()).length > 0) {
                    buffer.append('(');
                    for (PsiNameValuePair attribute : attributes) {
                        attribute.accept((PsiElementVisitor)this);
                        buffer.append(',');
                    }
                    buffer.replace(buffer.length() - 1, buffer.length(), ")");
                }
            }

            public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
                if (pair == null) {
                    1.$$$reportNull$$$0(2);
                }
                String name = pair.getName();
                PsiAnnotationMemberValue value = pair.getValue();
                if (name != null) {
                    buffer.append(name);
                    buffer.append('=');
                }
                if (value != null) {
                    value.accept((PsiElementVisitor)this);
                }
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
                buffer.append(expression.getText());
            }

            public void visitAnnotationArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
                if (initializer == null) {
                    1.$$$reportNull$$$0(4);
                }
                PsiAnnotationMemberValue[] initializers = initializer.getInitializers();
                this.processInitializers(initializers);
            }

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                PsiArrayInitializerExpression arrayInitializer;
                if (expression == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((arrayInitializer = expression.getArrayInitializer()) == null) {
                    super.visitNewExpression(expression);
                } else {
                    PsiType type = expression.getType();
                    if (type == null) {
                        type = PsiType.getJavaLangObject((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope()).createArrayType();
                    }
                    buffer.append('(');
                    arrayInitializer.accept((PsiElementVisitor)this);
                    buffer.append(" as ");
                    buffer.append(type.getCanonicalText());
                    buffer.append(")");
                }
            }

            public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression arrayInitializer) {
                if (arrayInitializer == null) {
                    1.$$$reportNull$$$0(6);
                }
                this.processInitializers((PsiAnnotationMemberValue[])arrayInitializer.getInitializers());
            }

            private void processInitializers(PsiAnnotationMemberValue[] initializers) {
                buffer.append('[');
                for (PsiAnnotationMemberValue initializer : initializers) {
                    initializer.accept((PsiElementVisitor)this);
                    buffer.append(',');
                }
                if (initializers.length > 0) {
                    buffer.delete(buffer.length() - 1, buffer.length());
                }
                buffer.append(']');
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "annotation";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pair";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayInitializer";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/AnnotationArgConverter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnnotation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnnotationParameterList";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNameValuePair";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnnotationArrayInitializer";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayInitializerExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

