/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.core.utils;

import com.intellij.charts.core.utils.GroupingResult;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.DataFrameImpl;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.dataframe.columns.StringColumn;
import com.intellij.charts.settings.data.ColumnModifier;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0007\u001a\u00020\b*\u00020\bJ\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u001e\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\bJ\u001c\u0010\u0010\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\bJ:\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/charts/core/utils/GroupingUtils;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "copy", "Lcom/intellij/charts/dataframe/DataFrame;", "getGroupedDataFrame", "column", "Lcom/intellij/charts/settings/data/ColumnSettings;", "dataFrame", "getSortedIfNecessary", "columns", "", "getJoinedColumn", "Lcom/intellij/charts/dataframe/columns/StringColumn;", "get", "Lcom/intellij/charts/core/utils/GroupingResult;", "x", "groups", "y", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nGroupingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupingUtils.kt\ncom/intellij/charts/core/utils/GroupingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,171:1\n1869#2,2:172\n1563#2:175\n1634#2,3:176\n774#2:179\n865#2,2:180\n774#2:182\n865#2,2:183\n1869#2,2:185\n1#3:174\n382#4,7:187\n216#5,2:194\n*S KotlinDebug\n*F\n+ 1 GroupingUtils.kt\ncom/intellij/charts/core/utils/GroupingUtils\n*L\n29#1:172,2\n64#1:175\n64#1:176,3\n71#1:179\n71#1:180,2\n90#1:182\n90#1:183,2\n111#1:185,2\n130#1:187,7\n142#1:194,2\n*E\n"})
public final class GroupingUtils {
    @NotNull
    public static final GroupingUtils INSTANCE = new GroupingUtils();
    @NotNull
    private static final Logger logger;

    private GroupingUtils() {
    }

    @NotNull
    public final DataFrame copy(@NotNull DataFrame $this$copy) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        ArrayList columns = new ArrayList($this$copy.getColumnsCount());
        Iterable $this$forEach$iv = $this$copy.getColumns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Column it = (Column)element$iv;
            boolean bl = false;
            columns.add(it.getType().createDataColumn(it.getName(), CollectionsKt.toMutableList((Collection)it.toList())));
        }
        return new DataFrameImpl(columns);
    }

    @NotNull
    public final DataFrame getGroupedDataFrame(@NotNull ColumnSettings column, @NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return switch (WhenMappings.$EnumSwitchMapping$0[column.getModifier().ordinal()]) {
            case 1 -> dataFrame.groupBy(column.getColumnId());
            case 2 -> {
                DataFrame df = this.copy(dataFrame);
                DataFrame.sortBy$default(df, column.getColumnId(), false, 2, null);
                yield df.groupBy(column.getColumnId());
            }
            default -> dataFrame;
        };
    }

    private final DataFrame getSortedIfNecessary(List<ColumnSettings> columns, DataFrame dataFrame) {
        DataFrame dataFrame2;
        Object v0;
        block3: {
            Iterable iterable = columns;
            for (Object t : iterable) {
                ColumnSettings it = (ColumnSettings)t;
                boolean bl = false;
                if (!(it.getModifier() == ColumnModifier.GroupAndSort)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ColumnSettings sortColumn = v0;
        if (sortColumn == null) {
            dataFrame2 = dataFrame;
        } else {
            DataFrame df = this.copy(dataFrame);
            DataFrame.sortBy$default(df, sortColumn.getColumnId(), false, 2, null);
            dataFrame2 = df;
        }
        return dataFrame2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame getGroupedDataFrame(@NotNull List<ColumnSettings> columns, @NotNull DataFrame dataFrame) {
        DataFrame dataFrame2;
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (columns.size() == 1 && ((ColumnSettings)CollectionsKt.first(columns)).getModifier() == ColumnModifier.None) {
            dataFrame2 = dataFrame;
        } else if (columns.size() == 1) {
            dataFrame2 = this.getSortedIfNecessary(columns, dataFrame).groupBy(((ColumnSettings)CollectionsKt.first(columns)).getColumnId());
        } else if (columns.size() > 1) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = columns;
            DataFrame dataFrame3 = this.getSortedIfNecessary(columns, dataFrame);
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColumnSettings columnSettings = (ColumnSettings)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getColumnId().getName());
            }
            dataFrame2 = dataFrame3.groupBy((List)destination$iv$iv);
        } else {
            dataFrame2 = dataFrame;
        }
        return dataFrame2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StringColumn getJoinedColumn(@NotNull List<ColumnSettings> columns, @NotNull DataFrame dataFrame) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        Iterable $this$filter$iv = dataFrame.getColumns();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object v0;
            block3: {
                Column column = (Column)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = columns;
                for (Object t : iterable2) {
                    ColumnSettings it = (ColumnSettings)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getColumnId().getName(), (Object)column.getName())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if (!(v0 != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List dfColumns = (List)destination$iv$iv;
        ArrayList<String> data = new ArrayList<String>(dataFrame.getRowsCount());
        int n = dataFrame.getRowsCount();
        for (int i = 0; i < n; ++i) {
            data.add(CollectionsKt.joinToString$default((Iterable)dfColumns, (CharSequence)".", null, null, (int)0, null, arg_0 -> GroupingUtils.getJoinedColumn$lambda$1(i, arg_0), (int)30, null));
        }
        return new StringColumn(CollectionsKt.joinToString$default((Iterable)dfColumns, (CharSequence)".", null, null, (int)0, null, GroupingUtils::getJoinedColumn$lambda$2, (int)30, null), (List<String>)data);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GroupingResult get(@NotNull DataFrame dataFrame, @NotNull List<ColumnSettings> x2, @NotNull List<ColumnSettings> groups2, @NotNull List<ColumnSettings> y2) {
        Object object;
        Column column;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(x2, (String)"x");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter(y2, (String)"y");
        DataFrame df = this.getGroupedDataFrame(CollectionsKt.plus((Collection)x2, (Iterable)groups2), dataFrame);
        ArrayList<Integer> dfIndexToXIndex = new ArrayList<Integer>(df.getRowsCount());
        if (x2.size() == 1 && groups2.isEmpty()) {
            column = df.get(((ColumnSettings)CollectionsKt.first(x2)).getColumnId());
        } else {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = df.getColumns();
            int $i$f$filter = 0;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Object v1;
                block20: {
                    Column column2 = (Column)element$iv$iv;
                    boolean bl = false;
                    object = x2;
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        ColumnSettings it = (ColumnSettings)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getColumnId().getName(), (Object)column2.getName())) continue;
                        v1 = t;
                        break block20;
                    }
                    v1 = null;
                }
                if (!(v1 != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List xColumns = (List)destination$iv$iv;
            if (xColumns.size() == 1) {
                $i$f$filter = df.getRowsCount();
                for (int i = 0; i < $i$f$filter; ++i) {
                    dfIndexToXIndex.add(i);
                }
                column = (Column)CollectionsKt.first((List)xColumns);
            } else {
                LinkedHashSet<String> xValuesSet = new LinkedHashSet<String>();
                int $this$filterTo$iv$iv2 = df.getRowsCount();
                for (int i = 0; i < $this$filterTo$iv$iv2; ++i) {
                    String xValue = CollectionsKt.joinToString$default((Iterable)xColumns, (CharSequence)".", null, null, (int)0, null, arg_0 -> GroupingUtils.get$lambda$1(i, arg_0), (int)30, null);
                    xValuesSet.add(xValue);
                    dfIndexToXIndex.add(CollectionsKt.indexOf((Iterable)xValuesSet, (Object)xValue));
                }
                column = new StringColumn(CollectionsKt.joinToString$default((Iterable)xColumns, (CharSequence)".", null, null, (int)0, null, GroupingUtils::get$lambda$2, (int)30, null), CollectionsKt.toMutableList((Collection)xValuesSet));
            }
        }
        Column xColumn = column;
        Iterable $this$forEach$iv = y2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColumnSettings it = (ColumnSettings)element$iv;
            boolean bl = false;
            if (SeriesSettings.Companion.columnAggregationSupported(it, df)) continue;
            logger.warn("Selected aggregation is not supported for " + it.getColumnId().getName() + " column.");
            return null;
        }
        List yColumns = new ArrayList();
        List yColumnsSettings = new ArrayList();
        if (!((Collection)groups2).isEmpty()) {
            for (ColumnSettings yCol : y2) {
                yColumn = SeriesSettings.Companion.getAggregatedColumn(yCol, df);
                HashMap seriesToData = new HashMap();
                int element$iv$iv = df.getRowsCount();
                for (int i = 0; i < element$iv$iv; ++i) {
                    Object object2;
                    void $this$getOrPut$iv;
                    String seriesName = CollectionsKt.joinToString$default((Iterable)groups2, (CharSequence)".", null, null, (int)0, null, arg_0 -> GroupingUtils.get$lambda$4(df, i, arg_0), (int)30, null) + "." + yColumn.getName();
                    object = seriesToData;
                    String key$iv = seriesName;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        ArrayList<?> arrayList = yColumn.getType().createDataArray();
                        Intrinsics.checkNotNull(arrayList, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any?>");
                        List arr = TypeIntrinsics.asMutableList(arrayList);
                        int n = xColumn.getSize();
                        int n2 = 0;
                        while (n2 < n) {
                            int it = n2++;
                            boolean bl3 = false;
                            arr.add(null);
                        }
                        List answer$iv = arr;
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    List data = (List)object2;
                    Object e = dfIndexToXIndex.get(i);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    data.set(((Number)e).intValue(), yColumn.get(i));
                }
                Map $this$forEach$iv2 = seriesToData;
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator3.next();
                    boolean bl = false;
                    Column<Object> yCol1 = yColumn.getType().createColumn((String)it.getKey(), (List)it.getValue());
                    if (xColumn.getSize() != yCol1.getSize()) {
                        logger.warn("Different column sizes x: " + xColumn.getSize() + " y: " + yCol1.getSize());
                        return null;
                    }
                    yColumns.add(yCol1);
                    yColumnsSettings.add(yCol);
                }
            }
        } else {
            for (ColumnSettings yCol : y2) {
                yColumn = SeriesSettings.Companion.getAggregatedColumn(yCol, df);
                if (xColumn.getSize() != yColumn.getSize()) {
                    logger.warn("Different column sizes x: " + xColumn.getSize() + " y: " + yColumn.getSize());
                    return null;
                }
                yColumns.add(yColumn);
                yColumnsSettings.add(yCol);
            }
        }
        return new GroupingResult(df, xColumn, new ColumnSettings(new ColumnId(xColumn.getName(), -1), ColumnModifier.None), yColumns, yColumnsSettings);
    }

    private static final CharSequence getJoinedColumn$lambda$1(int $i, Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.get($i));
    }

    private static final CharSequence getJoinedColumn$lambda$2(Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence get$lambda$1(int $i, Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.get($i));
    }

    private static final CharSequence get$lambda$2(Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence get$lambda$4(DataFrame $df, int $i, ColumnSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf($df.get(it.getColumnId()).get($i));
    }

    static {
        Logger logger2 = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColumnModifier.values().length];
            try {
                nArray[ColumnModifier.Group.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnModifier.GroupAndSort.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

