/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0002\u0010\u000eJ;\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\nH\u0016J\u0012\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u000bH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/SummaryBinStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "binCount", "", "binWidth", "", "xPosKind", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;", "xPos", "yAggFunction", "Lkotlin/Function1;", "", "yMinAggFunction", "yMaxAggFunction", "(ILjava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;DLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "binOptions", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinOptions;", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nSummaryBinStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryBinStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/SummaryBinStat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class SummaryBinStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BinStat.XPosKind xPosKind;
    private final double xPos;
    @NotNull
    private final Function1<List<Double>, Double> yAggFunction;
    @NotNull
    private final Function1<List<Double>, Double> yMinAggFunction;
    @NotNull
    private final Function1<List<Double>, Double> yMaxAggFunction;
    @NotNull
    private final BinStatUtil.BinOptions binOptions;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public SummaryBinStat(int binCount, @Nullable Double binWidth, @NotNull BinStat.XPosKind xPosKind, double xPos, @NotNull Function1<? super List<Double>, Double> yAggFunction, @NotNull Function1<? super List<Double>, Double> yMinAggFunction, @NotNull Function1<? super List<Double>, Double> yMaxAggFunction) {
        Intrinsics.checkNotNullParameter((Object)((Object)xPosKind), (String)"xPosKind");
        Intrinsics.checkNotNullParameter(yAggFunction, (String)"yAggFunction");
        Intrinsics.checkNotNullParameter(yMinAggFunction, (String)"yMinAggFunction");
        Intrinsics.checkNotNullParameter(yMaxAggFunction, (String)"yMaxAggFunction");
        super(DEF_MAPPING);
        this.xPosKind = xPosKind;
        this.xPos = xPos;
        this.yAggFunction = yAggFunction;
        this.yMinAggFunction = yMinAggFunction;
        this.yMaxAggFunction = yMaxAggFunction;
        this.binOptions = new BinStatUtil.BinOptions(binCount, binWidth);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Pair[] pairArray;
        List list2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getY()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        List<Double> ys = data.getNumeric(TransformVar.INSTANCE.getY());
        if (data.has(TransformVar.INSTANCE.getX())) {
            list2 = data.getNumeric(TransformVar.INSTANCE.getX());
        } else {
            int n = ys.size();
            pairArray = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                Pair[] pairArray2 = pairArray;
                boolean bl = false;
                pairArray2.add(0.0);
            }
            list2 = (List)pairArray;
        }
        List xs = list2;
        pairArray = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getY(), this.yAggFunction), TuplesKt.to((Object)Stats.INSTANCE.getY_MIN(), this.yMinAggFunction), TuplesKt.to((Object)Stats.INSTANCE.getY_MAX(), this.yMaxAggFunction)};
        Map aggFunctions = MapsKt.mapOf((Pair[])pairArray);
        DoubleSpan doubleSpan = statCtx.overallXRange();
        if (doubleSpan == null) {
            return this.withEmptyStatValues();
        }
        DoubleSpan rangeX = doubleSpan;
        Map<DataFrame.Variable, List<Double>> statData = BinStatUtil.INSTANCE.computeSummaryStatSeries(xs, ys, aggFunctions, rangeX, this.xPosKind, this.xPos, this.binOptions);
        DataFrame.Builder builder = new DataFrame.Builder();
        for (Map.Entry<DataFrame.Variable, List<Double>> entry : statData.entrySet()) {
            DataFrame.Variable variable = entry.getKey();
            List<Double> series = entry.getValue();
            builder.putNumeric(variable, series);
        }
        return builder.build();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getYMIN(), (Object)Stats.INSTANCE.getY_MIN()), TuplesKt.to(Aes.Companion.getYMAX(), (Object)Stats.INSTANCE.getY_MAX())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/SummaryBinStat$Companion;", "", "()V", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

