/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.MouseEventPeer;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.gcommon.base.Throwables;
import org.jetbrains.letsPlot.commons.logging.Logger;
import org.jetbrains.letsPlot.commons.logging.PortableLogging;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.SomeFig;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Label;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReferenceProvider;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.MarginSide;
import org.jetbrains.letsPlot.core.plot.builder.PlotInteractor;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgComponent;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgComponentHelper;
import org.jetbrains.letsPlot.core.plot.builder.PlotTile;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBox;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxesLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendsBlockInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.plot.PlotFigureLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.presentation.Defaults;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.HorizontalAxisTooltipPosition;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.VerticalAxisTooltipPosition;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 Q2\u00020\u0001:\u0001QB\u0093\u0001\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019JP\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020J2\u0006\u0010L\u001a\u00020\u0003H\u0002J\b\u0010M\u001a\u00020>H\u0014J\b\u0010N\u001a\u00020>H\u0002J\b\u0010O\u001a\u00020>H\u0002J\b\u0010P\u001a\u00020>H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001cR(\u0010'\u001a\u0004\u0018\u00010&2\b\u0010%\u001a\u0004\u0018\u00010&@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010/\u001a\b\u0012\u0004\u0012\u00020.0\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgComponent;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "title", "", "subtitle", "caption", "coreLayersByTile", "", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "marginalLayersByTile", "figureLayoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/plot/PlotFigureLayoutInfo;", "frameProviderByTile", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReferenceProvider;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "interactionsEnabled", "", "plotSpecId", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "styleSheet", "Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/plot/PlotFigureLayoutInfo;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;ZLjava/lang/String;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;)V", "containsLiveMap", "getContainsLiveMap", "()Z", "figureSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getFigureSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "flippedAxis", "getFlippedAxis", "hAxisTitle", "getInteractionsEnabled", "value", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;", "interactor", "getInteractor$plot_builder", "()Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;", "setInteractor$plot_builder", "(Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;)V", "isDisposed", "<set-?>", "Lorg/jetbrains/letsPlot/commons/values/SomeFig;", "liveMapFigures", "getLiveMapFigures$plot_builder", "()Ljava/util/List;", "mouseEventPeer", "Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;", "getMouseEventPeer", "()Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;", "getPlotContext", "()Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "getStyleSheet", "()Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "vAxisTitle", "addAxisTitle", "", "text", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "overallTileBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "overallGeomBounds", "labelSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "justification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "margins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "plotInset", "className", "buildComponent", "buildPlot", "buildPlotComponents", "clear", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotSvgComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotSvgComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/PlotSvgComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,517:1\n1747#2,3:518\n1855#2,2:522\n1#3:521\n*S KotlinDebug\n*F\n+ 1 PlotSvgComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/PlotSvgComponent\n*L\n82#1:518,3\n250#1:522,2\n*E\n"})
public final class PlotSvgComponent
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String title;
    @Nullable
    private final String subtitle;
    @Nullable
    private final String caption;
    @NotNull
    private final List<List<GeomLayer>> coreLayersByTile;
    @NotNull
    private final List<List<GeomLayer>> marginalLayersByTile;
    @NotNull
    private final PlotFigureLayoutInfo figureLayoutInfo;
    @NotNull
    private final List<FrameOfReferenceProvider> frameProviderByTile;
    @NotNull
    private final CoordProvider coordProvider;
    private final boolean interactionsEnabled;
    @Nullable
    private final String plotSpecId;
    @NotNull
    private final Theme theme;
    @NotNull
    private final StyleSheet styleSheet;
    @NotNull
    private final PlotContext plotContext;
    @NotNull
    private final DoubleVector figureSize;
    private final boolean flippedAxis;
    @NotNull
    private final MouseEventPeer mouseEventPeer;
    @Nullable
    private PlotInteractor interactor;
    @NotNull
    private List<? extends SomeFig> liveMapFigures;
    private final boolean containsLiveMap;
    @Nullable
    private final String hAxisTitle;
    @Nullable
    private final String vAxisTitle;
    private boolean isDisposed;
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(PlotSvgComponent.class));
    private static final boolean DEBUG_DRAWING = false;

    /*
     * WARNING - void declaration
     */
    public PlotSvgComponent(@Nullable String title, @Nullable String subtitle, @Nullable String caption, @NotNull List<? extends List<? extends GeomLayer>> coreLayersByTile, @NotNull List<? extends List<? extends GeomLayer>> marginalLayersByTile, @NotNull PlotFigureLayoutInfo figureLayoutInfo, @NotNull List<? extends FrameOfReferenceProvider> frameProviderByTile, @NotNull CoordProvider coordProvider, boolean interactionsEnabled, @Nullable String plotSpecId, @NotNull Theme theme2, @NotNull StyleSheet styleSheet, @NotNull PlotContext plotContext) {
        boolean bl;
        boolean bl2;
        block3: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(coreLayersByTile, (String)"coreLayersByTile");
            Intrinsics.checkNotNullParameter(marginalLayersByTile, (String)"marginalLayersByTile");
            Intrinsics.checkNotNullParameter((Object)figureLayoutInfo, (String)"figureLayoutInfo");
            Intrinsics.checkNotNullParameter(frameProviderByTile, (String)"frameProviderByTile");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
            Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
            this.title = title;
            this.subtitle = subtitle;
            this.caption = caption;
            this.coreLayersByTile = coreLayersByTile;
            this.marginalLayersByTile = marginalLayersByTile;
            this.figureLayoutInfo = figureLayoutInfo;
            this.frameProviderByTile = frameProviderByTile;
            this.coordProvider = coordProvider;
            this.interactionsEnabled = interactionsEnabled;
            this.plotSpecId = plotSpecId;
            this.theme = theme2;
            this.styleSheet = styleSheet;
            this.plotContext = plotContext;
            this.figureSize = this.figureLayoutInfo.getFigureSize();
            this.flippedAxis = this.frameProviderByTile.get(0).getFlipAxis();
            this.mouseEventPeer = new MouseEventPeer();
            this.liveMapFigures = CollectionsKt.emptyList();
            Iterable iterable = CollectionsKt.flatten((Iterable)this.coreLayersByTile);
            PlotSvgComponent plotSvgComponent = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GeomLayer p0 = (GeomLayer)element$iv;
                    boolean bl3 = false;
                    if (!p0.isLiveMap()) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        plotSvgComponent.containsLiveMap = bl = bl2;
        this.hAxisTitle = this.frameProviderByTile.get(0).getHAxisLabel();
        this.vAxisTitle = this.frameProviderByTile.get(0).getVAxisLabel();
    }

    public final boolean getInteractionsEnabled() {
        return this.interactionsEnabled;
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    @NotNull
    public final StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    @NotNull
    public final PlotContext getPlotContext() {
        return this.plotContext;
    }

    @NotNull
    public final DoubleVector getFigureSize() {
        return this.figureSize;
    }

    public final boolean getFlippedAxis() {
        return this.flippedAxis;
    }

    @NotNull
    public final MouseEventPeer getMouseEventPeer() {
        return this.mouseEventPeer;
    }

    @Nullable
    public final PlotInteractor getInteractor$plot_builder() {
        return this.interactor;
    }

    public final void setInteractor$plot_builder(@Nullable PlotInteractor value) {
        if (!(this.interactor == null)) {
            boolean $i$a$-check-PlotSvgComponent$interactor$32 = false;
            String $i$a$-check-PlotSvgComponent$interactor$32 = "interactor can be initialize only once.";
            throw new IllegalStateException($i$a$-check-PlotSvgComponent$interactor$32.toString());
        }
        if (!(!this.isBuilt())) {
            boolean bl = false;
            String string = "Can't change interactor after plot has already been built.";
            throw new IllegalStateException(string.toString());
        }
        this.interactor = value;
    }

    @NotNull
    public final List<SomeFig> getLiveMapFigures$plot_builder() {
        return this.liveMapFigures;
    }

    public final boolean getContainsLiveMap() {
        return this.containsLiveMap;
    }

    @Override
    public void clear() {
        this.isDisposed = true;
        super.clear();
    }

    @Override
    protected void buildComponent() {
        if (!(!this.isDisposed)) {
            boolean $i$a$-check-PlotSvgComponent$buildComponent$22 = false;
            String $i$a$-check-PlotSvgComponent$buildComponent$22 = "Plot can't be rebuild after it was disposed.";
            throw new IllegalStateException($i$a$-check-PlotSvgComponent$buildComponent$22.toString());
        }
        try {
            this.buildPlot();
        }
        catch (RuntimeException e) {
            LOG.error(e, (Function0<String>)((Function0)buildComponent.2.INSTANCE));
            Throwable rootCause = Throwables.INSTANCE.getRootCause(e);
            String causeMessage = rootCause.getMessage() != null ? '\'' + rootCause.getMessage() + '\'' : "<no message>";
            String message = "Error building plot: " + Reflection.getOrCreateKotlinClass(rootCause.getClass()).getSimpleName() + '\n' + causeMessage;
            double y2 = this.figureSize.getY() / (double)2;
            Label errorLabel = new Label(message, 0, false, 6, null);
            Color textColor2 = this.theme.plot().showBackground() ? this.theme.plot().textColor() : Defaults.INSTANCE.getTEXT_COLOR();
            errorLabel.textColor().set(textColor2);
            errorLabel.setFontSize(12.0);
            errorLabel.setLineHeight(16.0);
            errorLabel.setFontWeight("normal");
            errorLabel.setFontStyle("normal");
            errorLabel.setHorizontalAnchor(Text.HorizontalAnchor.MIDDLE);
            errorLabel.setVerticalAnchor(Text.VerticalAnchor.CENTER);
            errorLabel.moveTo(this.figureSize.getX() / (double)2, y2);
            this.getRootGroup().children().add(errorLabel.getRootGroup());
        }
    }

    private final void buildPlot() {
        this.buildPlotComponents();
        this.reg(new Registration(this){
            final /* synthetic */ PlotSvgComponent this$0;
            {
                this.this$0 = $receiver;
            }

            protected void doRemove() {
                PlotInteractor plotInteractor = this.this$0.getInteractor$plot_builder();
                if (plotInteractor != null) {
                    plotInteractor.dispose();
                }
                PlotSvgComponent.access$setLiveMapFigures$p(this.this$0, CollectionsKt.emptyList());
            }
        });
    }

    private final void buildPlotComponents() {
        DoubleRectangle it;
        Object marginalFrameByMargin;
        SvgPathElement backgroundArea = new SvgPathElement();
        SvgPathElement backgroundBorder = new SvgPathElement();
        List backgroundLiveMapWindows = new ArrayList();
        this.add(backgroundArea);
        boolean axisEnabled = !this.containsLiveMap;
        PlotLayoutInfo layoutInfo = this.figureLayoutInfo.getPlotLayoutInfo();
        DoubleRectangle plotOuterBounds = this.figureLayoutInfo.getFigureLayoutedBounds();
        DoubleRectangle plotOuterBoundsWithoutTitleAndCaption = this.figureLayoutInfo.getFigureBoundsWithoutTitleAndCaption();
        DoubleVector plotAreaOrigin = this.figureLayoutInfo.getPlotAreaOrigin();
        PlotTheme plotTheme = this.theme.plot();
        DoubleVector tilesOrigin = plotAreaOrigin;
        for (TileLayoutInfo tileLayoutInfo : layoutInfo.getTiles()) {
            int tileIndex = tileLayoutInfo.getTrueIndex();
            FrameOfReferenceProvider tileFrameProvider = this.frameProviderByTile.get(tileIndex);
            FrameOfReference tileFrame = tileFrameProvider.createTileFrame(tileLayoutInfo, this.coordProvider, false);
            marginalFrameByMargin = tileFrameProvider.createMarginalFrames(tileLayoutInfo, this.coordProvider, plotTheme.backgroundFill(), false);
            PlotTile tile2 = new PlotTile(this.coreLayersByTile.get(tileIndex), this.marginalLayersByTile.get(tileIndex), tilesOrigin, tileLayoutInfo, this.plotSpecId, this.theme, tileFrame, (Map<MarginSide, ? extends FrameOfReference>)marginalFrameByMargin);
            DoubleVector plotOriginAbsolute = tilesOrigin.add(tileLayoutInfo.getOffset());
            tile2.moveTo(plotOriginAbsolute);
            this.add(tile2);
            if (tile2.getLiveMapFigure() != null) {
                SomeFig $this$buildPlotComponents_u24lambda_u244;
                boolean bl = false;
                this.liveMapFigures = CollectionsKt.plus((Collection)this.liveMapFigures, (Iterable)CollectionsKt.listOf((Object)$this$buildPlotComponents_u24lambda_u244));
            }
            DoubleRectangle geomOuterBoundsAbsolute = tileLayoutInfo.getGeomOuterBounds().add(plotOriginAbsolute);
            DoubleRectangle geomInnerBoundsAbsolute = tileLayoutInfo.getGeomInnerBounds().add(plotOriginAbsolute);
            DoubleRectangle geomContentBoundsAbsolute = tileLayoutInfo.getGeomContentBounds().add(plotOriginAbsolute);
            DoubleVector axisOrigin = new DoubleVector(layoutInfo.getHasLeftAxis() ? geomOuterBoundsAbsolute.getLeft() : geomOuterBoundsAbsolute.getRight(), layoutInfo.getHasBottomAxis() ? geomOuterBoundsAbsolute.getBottom() : geomOuterBoundsAbsolute.getTop());
            PlotInteractor plotInteractor = this.interactor;
            if (plotInteractor != null) {
                plotInteractor.onTileAdded(tile2, geomContentBoundsAbsolute, tile2.getTargetLocators(), tile2.getLayerYOrientations(), axisOrigin, layoutInfo.getHasBottomAxis() ? HorizontalAxisTooltipPosition.BOTTOM : HorizontalAxisTooltipPosition.TOP, layoutInfo.getHasLeftAxis() ? VerticalAxisTooltipPosition.LEFT : VerticalAxisTooltipPosition.RIGHT);
            }
            if (!this.containsLiveMap) continue;
            backgroundLiveMapWindows.add(geomInnerBoundsAbsolute);
        }
        if (plotTheme.showBackground()) {
            Thickness plotInset = plotTheme.plotMargins().plus(Thickness.Companion.uniform(plotTheme.backgroundStrokeWidth() / (double)2));
            DoubleRectangle backgroundRect = plotInset.inflateRect(this.figureLayoutInfo.getFigureLayoutedBounds());
            SvgPathDataBuilder backgroundAreaPath = PlotSvgComponent.buildPlotComponents$rect(new SvgPathDataBuilder(false, 1, null), backgroundRect);
            Object $this$forEach$iv = backgroundLiveMapWindows;
            boolean $i$f$forEach = false;
            marginalFrameByMargin = $this$forEach$iv.iterator();
            while (marginalFrameByMargin.hasNext()) {
                Object element$iv = marginalFrameByMargin.next();
                DoubleRectangle p0 = (DoubleRectangle)element$iv;
                boolean bl = false;
                PlotSvgComponent.buildPlotComponents$rect(backgroundAreaPath, p0);
            }
            Object $this$buildPlotComponents_u24lambda_u246 = $this$forEach$iv = backgroundArea;
            boolean bl = false;
            ((SvgPathElement)$this$buildPlotComponents_u24lambda_u246).fillRule().set(SvgPathElement.FillRule.EVEN_ODD);
            ((SvgPathElement)$this$buildPlotComponents_u24lambda_u246).fillColor().set(plotTheme.backgroundFill());
            ((SvgPathElement)$this$buildPlotComponents_u24lambda_u246).d().set(backgroundAreaPath.build());
            Object $this$buildPlotComponents_u24lambda_u247 = $this$forEach$iv = backgroundBorder;
            boolean bl2 = false;
            ((SvgPathElement)$this$buildPlotComponents_u24lambda_u247).fillColor().set(Color.Companion.getTRANSPARENT());
            ((SvgPathElement)$this$buildPlotComponents_u24lambda_u247).strokeColor().set(plotTheme.backgroundColor());
            ((SvgPathElement)$this$buildPlotComponents_u24lambda_u247).strokeWidth().set(plotTheme.backgroundStrokeWidth());
            StrokeDashArraySupport.INSTANCE.apply((SvgShape)$this$buildPlotComponents_u24lambda_u247, plotTheme.backgroundStrokeWidth(), plotTheme.backgroundLineType());
            ((SvgPathElement)$this$buildPlotComponents_u24lambda_u247).d().set(PlotSvgComponent.buildPlotComponents$rect(new SvgPathDataBuilder(false, 1, null), backgroundRect).build());
            ((SvgGraphicsElement)$this$buildPlotComponents_u24lambda_u247).pointerEvents().set(SvgGraphicsElement.PointerEvents.NONE);
        }
        DoubleRectangle geomAreaBounds = this.figureLayoutInfo.getGeomAreaBounds();
        Pair<DoubleRectangle, DoubleRectangle> pair2 = PlotSvgComponentHelper.INSTANCE.titleElementAndTextBounds(this.title, plotOuterBounds, geomAreaBounds, plotTheme);
        DoubleRectangle plotTitleElementRect = (DoubleRectangle)pair2.component1();
        DoubleRectangle plotTitleTextRect = (DoubleRectangle)pair2.component2();
        Pair<DoubleRectangle, DoubleRectangle> pair3 = PlotSvgComponentHelper.INSTANCE.subtitleElementAndTextBounds(this.subtitle, plotOuterBounds, geomAreaBounds, plotTitleElementRect, plotTheme);
        DoubleRectangle subtitleElementRect = (DoubleRectangle)pair3.component1();
        DoubleRectangle subtitleTextRect = (DoubleRectangle)pair3.component2();
        Pair<DoubleRectangle, DoubleRectangle> pair4 = PlotSvgComponentHelper.INSTANCE.captionElementAndTextBounds(this.caption, plotOuterBounds, geomAreaBounds, plotTheme);
        DoubleRectangle captionElementRect = (DoubleRectangle)pair4.component1();
        DoubleRectangle captionTextRect = (DoubleRectangle)pair4.component2();
        DoubleRectangle doubleRectangle = plotTitleTextRect;
        if (doubleRectangle != null) {
            it = doubleRectangle;
            boolean bl = false;
            PlotSvgComponentHelper.addTitle$default(PlotSvgComponentHelper.INSTANCE, this, this.title, PlotLabelSpecFactory.INSTANCE.plotTitle(plotTheme), plotTheme.titleJustification(), it, null, "plot-title", 32, null);
        }
        DoubleRectangle doubleRectangle2 = subtitleTextRect;
        if (doubleRectangle2 != null) {
            it = doubleRectangle2;
            boolean bl = false;
            PlotSvgComponentHelper.addTitle$default(PlotSvgComponentHelper.INSTANCE, this, this.subtitle, PlotLabelSpecFactory.INSTANCE.plotSubtitle(plotTheme), plotTheme.subtitleJustification(), it, null, "plot-subtitle", 32, null);
        }
        DoubleRectangle overallTileBounds = PlotLayoutUtil.INSTANCE.overallTileBounds$plot_builder(layoutInfo).add(plotAreaOrigin);
        if (axisEnabled) {
            Orientation titleOrientation;
            if (this.vAxisTitle != null) {
                titleOrientation = ((TileLayoutInfo)CollectionsKt.first(layoutInfo.getTiles())).getAxisInfos().getVAxisTitleOrientation();
                this.addAxisTitle(this.vAxisTitle, titleOrientation, overallTileBounds, geomAreaBounds, PlotLabelSpecFactory.INSTANCE.axisTitle(this.theme.verticalAxis(this.flippedAxis)), this.theme.verticalAxis(this.flippedAxis).titleJustification(), this.theme.verticalAxis(this.flippedAxis).titleMargins(), plotTheme.plotInset(), "axis-title-" + this.theme.verticalAxis(this.flippedAxis).getAxis());
            }
            if (this.hAxisTitle != null) {
                titleOrientation = ((TileLayoutInfo)CollectionsKt.first(layoutInfo.getTiles())).getAxisInfos().getHAxisTitleOrientation();
                this.addAxisTitle(this.hAxisTitle, titleOrientation, overallTileBounds, geomAreaBounds, PlotLabelSpecFactory.INSTANCE.axisTitle(this.theme.horizontalAxis(this.flippedAxis)), this.theme.horizontalAxis(this.flippedAxis).titleJustification(), this.theme.horizontalAxis(this.flippedAxis).titleMargins(), plotTheme.plotInset(), "axis-title-" + this.theme.horizontalAxis(this.flippedAxis).getAxis());
            }
        }
        LegendTheme legendTheme = this.theme.legend();
        LegendsBlockInfo legendsBlockInfo = this.figureLayoutInfo.getLegendsBlockInfo();
        if (!legendTheme.position().isHidden()) {
            LegendsBlockInfo legendsBlockInfoLayouted = new LegendBoxesLayout(plotOuterBoundsWithoutTitleAndCaption, geomAreaBounds, legendTheme).doLayout(legendsBlockInfo);
            for (LegendBoxesLayout.BoxWithLocation boxWithLocation : legendsBlockInfoLayouted.getBoxWithLocationList()) {
                LegendBox legendBox = boxWithLocation.getLegendBox().createLegendBox();
                legendBox.moveTo(boxWithLocation.getLocation());
                this.add(legendBox);
            }
        }
        DoubleRectangle doubleRectangle3 = captionTextRect;
        if (doubleRectangle3 != null) {
            DoubleRectangle it2 = doubleRectangle3;
            boolean bl = false;
            PlotSvgComponentHelper.addTitle$default(PlotSvgComponentHelper.INSTANCE, this, this.caption, PlotLabelSpecFactory.INSTANCE.plotCaption(plotTheme), plotTheme.captionJustification(), it2, null, "plot-caption", 32, null);
        }
        this.add(backgroundBorder);
    }

    private final void addAxisTitle(String text2, Orientation orientation, DoubleRectangle overallTileBounds, DoubleRectangle overallGeomBounds, LabelSpec labelSpec, TextJustification justification, Thickness margins, Thickness plotInset, String className) {
        DoubleRectangle doubleRectangle;
        TextJustification.Companion.TextRotation textRotation;
        DoubleRectangle doubleRectangle2;
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: 
            case 2: {
                doubleRectangle2 = new DoubleRectangle(overallTileBounds.getLeft(), overallGeomBounds.getTop(), overallTileBounds.getWidth(), overallGeomBounds.getHeight());
                break;
            }
            case 3: 
            case 4: {
                doubleRectangle2 = new DoubleRectangle(overallGeomBounds.getLeft(), overallTileBounds.getTop(), overallGeomBounds.getWidth(), overallTileBounds.getHeight());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleRectangle referenceRect = doubleRectangle2;
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                textRotation = TextJustification.Companion.TextRotation.ANTICLOCKWISE;
                break;
            }
            case 2: {
                textRotation = TextJustification.Companion.TextRotation.ANTICLOCKWISE;
                break;
            }
            default: {
                textRotation = null;
            }
        }
        TextJustification.Companion.TextRotation rotation = textRotation;
        double textHeight = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(text2, labelSpec).getY();
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                doubleRectangle = new DoubleRectangle(referenceRect.getLeft() - textHeight - margins.getWidth() - plotInset.getLeft(), referenceRect.getTop(), textHeight + margins.getWidth(), referenceRect.getHeight());
                break;
            }
            case 2: {
                doubleRectangle = new DoubleRectangle(referenceRect.getRight() + plotInset.getRight(), referenceRect.getTop(), textHeight + margins.getWidth(), referenceRect.getHeight());
                break;
            }
            case 3: {
                doubleRectangle = new DoubleRectangle(referenceRect.getLeft(), referenceRect.getTop() - textHeight - margins.getHeight() - plotInset.getTop(), referenceRect.getWidth(), textHeight + margins.getHeight());
                break;
            }
            case 4: {
                doubleRectangle = new DoubleRectangle(referenceRect.getLeft(), referenceRect.getBottom() + plotInset.getBottom(), referenceRect.getWidth(), textHeight + margins.getHeight());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleRectangle axisTitleElementRect = doubleRectangle;
        DoubleRectangle axisTitleTextRect = orientation.isHorizontal() ? PlotSvgComponentHelper.createTextRectangle$plot_builder$default(PlotSvgComponentHelper.INSTANCE, axisTitleElementRect, margins.getTop(), 0.0, margins.getBottom(), 0.0, 20, null) : PlotSvgComponentHelper.createTextRectangle$plot_builder$default(PlotSvgComponentHelper.INSTANCE, axisTitleElementRect, 0.0, margins.getRight(), 0.0, margins.getLeft(), 10, null);
        PlotSvgComponentHelper.INSTANCE.addTitle(this, text2, labelSpec, justification, axisTitleTextRect, rotation, className);
    }

    private static final SvgPathDataBuilder buildPlotComponents$rect(SvgPathDataBuilder $this$buildPlotComponents_u24rect, DoubleRectangle rect2) {
        SvgPathDataBuilder svgPathDataBuilder;
        SvgPathDataBuilder $this$buildPlotComponents_u24rect_u24lambda_u243 = svgPathDataBuilder = $this$buildPlotComponents_u24rect;
        boolean bl = false;
        SvgPathDataBuilder.moveTo$default($this$buildPlotComponents_u24rect_u24lambda_u243, rect2.getLeft(), rect2.getTop(), false, 4, null);
        SvgPathDataBuilder.lineTo$default($this$buildPlotComponents_u24rect_u24lambda_u243, rect2.getLeft(), rect2.getBottom(), false, 4, null);
        SvgPathDataBuilder.lineTo$default($this$buildPlotComponents_u24rect_u24lambda_u243, rect2.getRight(), rect2.getBottom(), false, 4, null);
        SvgPathDataBuilder.lineTo$default($this$buildPlotComponents_u24rect_u24lambda_u243, rect2.getRight(), rect2.getTop(), false, 4, null);
        $this$buildPlotComponents_u24rect_u24lambda_u243.closePath();
        return svgPathDataBuilder;
    }

    public static final /* synthetic */ void access$setLiveMapFigures$p(PlotSvgComponent $this, List list2) {
        $this.liveMapFigures = list2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgComponent$Companion;", "", "()V", "DEBUG_DRAWING", "", "LOG", "Lorg/jetbrains/letsPlot/commons/logging/Logger;", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

