/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlAlterInnerElementBlock;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlColumnBlock;
import com.intellij.sql.formatter.model.SqlColumnDefaultBlock;
import com.intellij.sql.formatter.model.SqlColumnNullabilityBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterTableBlock;", "Lcom/intellij/sql/formatter/model/SqlDdlStatementBlock;", "<init>", "()V", "countOfElements", "", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "countRole", "", "role", "countRole$intellij_database_sql_core_impl", "configureFormattingAttributes", "userRequiresExpand", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlAlterTableBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlAlterTableBlock.kt\ncom/intellij/sql/formatter/model/SqlAlterTableBlock\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n+ 3 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n14#2:148\n468#3,3:149\n468#3,3:157\n456#3:161\n468#3,3:167\n468#3,3:170\n468#3,3:173\n1869#4:152\n1869#4:160\n1869#4,2:163\n1870#4:165\n1870#4:166\n1869#4,2:176\n112#5,4:153\n1#6:162\n*S KotlinDebug\n*F\n+ 1 SqlAlterTableBlock.kt\ncom/intellij/sql/formatter/model/SqlAlterTableBlock\n*L\n38#1:148\n46#1:149,3\n49#1:157,3\n50#1:161\n67#1:167,3\n69#1:170,3\n71#1:173,3\n46#1:152\n49#1:160\n52#1:163,2\n49#1:165\n46#1:166\n74#1:176,2\n47#1:153,4\n50#1:162\n*E\n"})
public final class SqlAlterTableBlock
extends SqlDdlStatementBlock {
    private int countOfElements;

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)SqlCompositeElementTypes.SQL_ALTER_INSTRUCTION)) ? BlockRole.ELEMENT : super.determineRole(node);
    }

    @Override
    public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        super.countRole$intellij_database_sql_core_impl(role);
        if (role == BlockRole.ELEMENT) {
            int n = this.countOfElements;
            this.countOfElements = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        Object alterInstructionBlock;
        void $this$forEach$iv;
        void _true_$iv;
        void $this$choose$iv;
        SqlCodeStyleSettings s = this.getContext().getSql();
        boolean toWrap = s.TABLE_ALTER_INSTRUCTION_WRAP == 1;
        boolean toIndent = s.TABLE_ALTER_INSTRUCTION_INDENT;
        boolean toAlign = s.TABLE_ALTER_INSTRUCTION_ALIGN && this.countOfElements >= 2;
        boolean toAlignTypes = s.TABLE_TYPES_ALIGN && this.countOfElements >= 2;
        boolean toAlignNullabilities = s.TABLE_NULLABILITIES_ALIGN && this.countOfElements >= 2;
        boolean toAlignDefaults = s.TABLE_DEFAULTS_ALIGN && this.countOfElements >= 2;
        boolean bl = toIndent;
        Indent indent = SqlFormattingFunKt.getNORMAL_INDENT();
        Indent _false_$iv = SqlFormattingFunKt.getNONE_INDENT();
        boolean $i$f$choose = false;
        Indent i = $this$choose$iv != false ? _true_$iv : _false_$iv;
        Wrap w = toWrap ? SqlFlowBlock.makeWrap$default(this, WrapType.ALWAYS, false, 2, null) : null;
        Alignment a = toAlign ? SqlFormattingModelFun.makeLeftAlignment() : null;
        Alignment aT = toAlignTypes ? SqlFormattingModelFun.makeLeftAlignmentBS() : null;
        Alignment aN = toAlignNullabilities ? SqlFormattingModelFun.makeLeftAlignmentBS() : null;
        Alignment aD1 = toAlignDefaults ? SqlFormattingModelFun.makeLeftAlignmentBS() : null;
        Alignment aD2 = toAlignDefaults ? SqlFormattingModelFun.makeLeftAlignmentBS() : null;
        Iterable $this$filter$iv = this.getNestedBlocks();
        boolean $i$f$filter = false;
        Object $this$jbi$iv$iv = $this$filter$iv;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(SqlAlterInstructionBlock.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        $this$filter$iv = (Iterable)jBIterable2;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void indent$iv;
            void wrap$iv;
            void this_$iv;
            alterInstructionBlock = (SqlAlterInstructionBlock)element$iv;
            boolean bl2 = false;
            SqlBlock sqlBlock = (SqlBlock)alterInstructionBlock;
            Wrap wrap = w;
            Indent indent2 = i;
            Alignment align$iv = a;
            boolean $i$f$setAttributes = false;
            this_$iv.setMyWrap((Wrap)wrap$iv);
            this_$iv.setMyIndent((Indent)indent$iv);
            this_$iv.setMyAlign(align$iv);
            if (!toAlignTypes && !toAlignNullabilities && !toAlignDefaults) continue;
            Iterable $this$filter$iv2 = ((SqlFlowBlock)alterInstructionBlock).getNestedBlocks();
            boolean $i$f$filter2 = false;
            Iterable $this$jbi$iv$iv2 = $this$filter$iv2;
            boolean $i$f$getJbi2 = false;
            JBIterable jBIterable3 = JBIterable.from((Iterable)$this$jbi$iv$iv2);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"from(...)");
            JBIterable jBIterable4 = jBIterable3.filter(SqlAlterInnerElementBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
            $this$filter$iv2 = (Iterable)jBIterable4;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SqlColumnBlock sqlColumnBlock;
                Object v5;
                Object v4;
                block9: {
                    SqlAlterInnerElementBlock innerBlock = (SqlAlterInnerElementBlock)element$iv2;
                    boolean bl3 = false;
                    Iterable $this$find$iv = innerBlock.getNestedBlocks();
                    boolean $i$f$find = false;
                    Iterable iterable = $this$find$iv;
                    for (Object t : iterable) {
                        Block it$iv = (Block)t;
                        boolean bl4 = false;
                        if (!(it$iv instanceof SqlColumnBlock)) continue;
                        v4 = t;
                        break block9;
                    }
                    v4 = v5 = null;
                }
                if (!(v4 instanceof SqlColumnBlock)) {
                    v5 = null;
                }
                if ((SqlColumnBlock)((Block)v5) == null) continue;
                SqlColumnBlock columnBlock = sqlColumnBlock;
                boolean bl5 = false;
                boolean nullabilityWas = false;
                Iterable $this$forEach$iv3 = columnBlock.getNestedBlocks();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    SqlBlock it = (SqlBlock)element$iv3;
                    boolean bl6 = false;
                    if (it.getRole() == BlockRole.TYPE) {
                        it.setMyAlign(aT);
                        continue;
                    }
                    if (it instanceof SqlColumnNullabilityBlock) {
                        nullabilityWas = true;
                        it.setMyAlign(aN);
                        continue;
                    }
                    if (!(it instanceof SqlColumnDefaultBlock)) continue;
                    it.setMyAlign(nullabilityWas ? aD2 : aD1);
                }
            }
        }
        if (s.TABLE_TYPES_ALIGN) {
            void $this$forEach$iv4;
            void $this$filter$iv3;
            void $this$filter$iv4;
            void $this$filter$iv5;
            Alignment columnTypeAlignment = SqlFormattingModelFun.makeLeftAlignmentBS();
            alterInstructionBlock = this.getNestedBlocks();
            boolean $i$f$filter3 = false;
            void $this$jbi$iv$iv3 = $this$filter$iv5;
            boolean $i$f$getJbi3 = false;
            JBIterable jBIterable5 = JBIterable.from((Iterable)$this$jbi$iv$iv3);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"from(...)");
            JBIterable jBIterable6 = jBIterable5.filter(SqlAlterInstructionBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable6, (String)"filter(...)");
            JBIterable jBIterable7 = jBIterable6.flatten(arg_0 -> SqlAlterTableBlock.configureFormattingAttributes$lambda$2(SqlAlterTableBlock::configureFormattingAttributes$lambda$1, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable7, (String)"flatten(...)");
            Iterable element$iv = (Iterable)jBIterable7;
            boolean $i$f$filter4 = false;
            void $this$jbi$iv$iv4 = $this$filter$iv4;
            boolean $i$f$getJbi4 = false;
            JBIterable jBIterable8 = JBIterable.from((Iterable)$this$jbi$iv$iv4);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable8, (String)"from(...)");
            JBIterable jBIterable9 = jBIterable8.filter(SqlAlterInnerElementBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable9, (String)"filter(...)");
            JBIterable jBIterable10 = jBIterable9.flatten(arg_0 -> SqlAlterTableBlock.configureFormattingAttributes$lambda$4(SqlAlterTableBlock::configureFormattingAttributes$lambda$3, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable10, (String)"flatten(...)");
            $this$jbi$iv$iv = (Iterable)jBIterable10;
            boolean $i$f$filter5 = false;
            void $this$jbi$iv$iv5 = $this$filter$iv3;
            boolean $i$f$getJbi5 = false;
            JBIterable jBIterable11 = JBIterable.from((Iterable)$this$jbi$iv$iv5);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable11, (String)"from(...)");
            JBIterable jBIterable12 = jBIterable11.filter(SqlColumnBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable12, (String)"filter(...)");
            JBIterable jBIterable13 = jBIterable12.flatten(arg_0 -> SqlAlterTableBlock.configureFormattingAttributes$lambda$6(SqlAlterTableBlock::configureFormattingAttributes$lambda$5, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable13, (String)"flatten(...)");
            Iterable $i$f$forEach4 = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable13), BlockRole.BODY);
            boolean $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv4) {
                SqlBlock it = (SqlBlock)element$iv4;
                boolean bl7 = false;
                it.setMyAlign(columnTypeAlignment);
            }
        }
    }

    @Override
    protected boolean userRequiresExpand() {
        return this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 1 || this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 0;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        return block2 instanceof SqlComma ? this.getContext().makeNoSpace(false) : (block2 instanceof SqlAlterInstructionBlock && this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 0 ? this.getContext().makeAutoSpacing(true) : super.decideSpacing(block1, block2));
    }

    private static final Iterable configureFormattingAttributes$lambda$1(SqlAlterInstructionBlock it) {
        return it.getNestedBlocks();
    }

    private static final Iterable configureFormattingAttributes$lambda$2(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable configureFormattingAttributes$lambda$3(SqlAlterInnerElementBlock it) {
        return it.getNestedBlocks();
    }

    private static final Iterable configureFormattingAttributes$lambda$4(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable configureFormattingAttributes$lambda$5(SqlColumnBlock it) {
        return it.getNestedBlocks();
    }

    private static final Iterable configureFormattingAttributes$lambda$6(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }
}

