/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.kotlin;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.inheritance.ImplicitSubclassProvider;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.kotlin.AbstractAllOpenCompilerPluginInspection;
import com.intellij.spring.kotlin.SpringKotlinBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.quickfix.ChangeObjectToClassFix;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFixBase;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/spring/kotlin/IncompatibleSpringClassModifiersInspection;", "Lcom/intellij/spring/kotlin/AbstractAllOpenCompilerPluginInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.spring.kotlin"})
public final class IncompatibleSpringClassModifiersInspection
extends AbstractAllOpenCompilerPluginInspection {
    public IncompatibleSpringClassModifiersInspection() {
        super(true);
    }

    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(this, holder){
            final /* synthetic */ IncompatibleSpringClassModifiersInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitClassOrObject(KtClassOrObject classOrObject) {
                Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
                super.visitClassOrObject(classOrObject);
                ImplicitSubclassProvider implicitSubclassProvider = this.this$0.implicitSubclassProvider();
                if (implicitSubclassProvider == null) {
                    return;
                }
                ImplicitSubclassProvider subclassProvider = implicitSubclassProvider;
                KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)classOrObject);
                if (ktLightClass == null) {
                    return;
                }
                KtLightClass lightClass = ktLightClass;
                if (subclassProvider.getSubclassingInfo((PsiClass)lightClass) == null) {
                    return;
                }
                if (classOrObject instanceof KtObjectDeclaration) {
                    LocalQuickFix localQuickFix = LocalQuickFix.from((ModCommandAction)((ModCommandAction)new ChangeObjectToClassFix((KtObjectDeclaration)classOrObject)));
                    if (localQuickFix != null) {
                        LocalQuickFix localQuickFix2 = localQuickFix;
                        ProblemsHolder problemsHolder = this.$holder;
                        LocalQuickFix it = localQuickFix2;
                        boolean bl = false;
                        PsiElement psiElement = ((KtObjectDeclaration)classOrObject).getObjectKeyword();
                        Intrinsics.checkNotNull((Object)psiElement);
                        Object[] objectArray = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)KtTokens.OBJECT_KEYWORD.getValue(), (String)"getValue(...)");
                        String string = SpringKotlinBundle.message("spring.kotlin.no.kotlin.change.incompatible.with.spring.modifier.descriptor.0", objectArray);
                        objectArray = new LocalQuickFix[]{it};
                        problemsHolder.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
                    }
                } else if (classOrObject.hasModifier(KtTokens.FINAL_KEYWORD)) {
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.FINAL_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"FINAL_KEYWORD");
                    this.registerRemoveModifier(classOrObject, ktModifierKeywordToken);
                } else if (classOrObject.hasModifier(KtTokens.ENUM_KEYWORD)) {
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ENUM_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"ENUM_KEYWORD");
                    this.registerRemoveModifier(classOrObject, ktModifierKeywordToken);
                } else if (classOrObject.hasModifier(KtTokens.DATA_KEYWORD)) {
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.DATA_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"DATA_KEYWORD");
                    this.registerRemoveModifier(classOrObject, ktModifierKeywordToken);
                }
            }

            private final void registerRemoveModifier(KtClassOrObject classOrObject, KtModifierKeywordToken modifier) {
                block0: {
                    LocalQuickFix localQuickFix = LocalQuickFix.from((ModCommandAction)((ModCommandAction)new RemoveModifierFixBase((KtModifierListOwner)classOrObject, modifier, false)));
                    if (localQuickFix == null) break block0;
                    LocalQuickFix localQuickFix2 = localQuickFix;
                    ProblemsHolder problemsHolder = this.$holder;
                    LocalQuickFix it = localQuickFix2;
                    boolean bl = false;
                    KtModifierList ktModifierList = classOrObject.getModifierList();
                    Object object = ktModifierList != null ? ktModifierList.getModifier(modifier) : null;
                    Intrinsics.checkNotNull((Object)object);
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)modifier.getValue(), (String)"getValue(...)");
                    String string = SpringKotlinBundle.message("spring.kotlin.no.kotlin.remove.incompatible.with.spring.modifier.descriptor.0", objectArray);
                    objectArray = new LocalQuickFix[]{it};
                    problemsHolder.registerProblem(object, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
                }
            }
        };
    }
}

