/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.starter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.local.StarterModuleBuilder;
import com.intellij.ide.starters.remote.WebStarterContext;
import com.intellij.ide.starters.remote.WebStarterContextProvider;
import com.intellij.ide.starters.remote.WebStarterDependency;
import com.intellij.ide.starters.remote.WebStarterDependencyCategory;
import com.intellij.ide.starters.remote.WebStarterFrameworkVersion;
import com.intellij.ide.starters.remote.WebStarterModuleBuilder;
import com.intellij.ide.starters.remote.WebStarterServerOptions;
import com.intellij.ide.starters.remote.WebStarterSettings;
import com.intellij.ide.starters.remote.wizard.WebStarterLibrariesStep;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.LibraryLink;
import com.intellij.ide.starters.shared.LibraryLinkType;
import com.intellij.ide.starters.shared.StarterAppType;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterLanguageLevel;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.ide.starters.shared.StarterTestRunner;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.starter.MicronautModuleBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002CDB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0014J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0014J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0014J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0014J \u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0018\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u0007H\u0002J\u0010\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0002J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0014J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0014J\b\u0010=\u001a\u00020>H\u0003J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/intellij/micronaut/starter/MicronautModuleBuilder;", "Lcom/intellij/ide/starters/remote/WebStarterModuleBuilder;", "<init>", "()V", "INVALID_ARTIFACT_SYMBOL_PATTERN", "Lkotlin/text/Regex;", "getDefaultServerUrl", "", "getBuilderId", "getNodeIcon", "Ljavax/swing/Icon;", "getPresentableName", "getDescription", "getHelpId", "getProjectTypes", "", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getTestFrameworks", "Lcom/intellij/ide/starters/shared/StarterTestRunner;", "getApplicationTypes", "Lcom/intellij/ide/starters/shared/StarterAppType;", "getDefaultLanguageLevel", "Lcom/intellij/ide/starters/shared/StarterLanguageLevel;", "getLanguageLevels", "getFilePathsToOpen", "getCustomizedMessages", "Lcom/intellij/ide/starters/shared/CustomizedMessages;", "loadServerOptions", "Lcom/intellij/ide/starters/remote/WebStarterServerOptions;", "serverUrl", "handleOptionsJson", "optionsJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "loadFeatures", "", "Lcom/intellij/ide/starters/remote/WebStarterDependencyCategory;", "appTypeId", "descriptionLinkPattern", "Ljava/util/regex/Pattern;", "composeGeneratorUrl", "Lcom/intellij/util/Url;", "starterContext", "Lcom/intellij/ide/starters/remote/WebStarterContext;", "composeEndpointUrl", "endpoint", "suggestBasePackage", "group", "artifact", "sanitizeArtifact", "input", "extractGeneratorResult", "", "tempZipFile", "Ljava/io/File;", "contentEntryDir", "createLibrariesStep", "Lcom/intellij/ide/starters/remote/wizard/WebStarterLibrariesStep;", "contextProvider", "Lcom/intellij/ide/starters/remote/WebStarterContextProvider;", "validateOptions", "Lcom/intellij/micronaut/starter/MicronautModuleBuilder$ValidationResult;", "getCategoryPriority", "", "category", "Lcom/intellij/micronaut/starter/MicronautModuleBuilder$MicronautFeatureCategory;", "ValidationResult", "MicronautFeatureCategory", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMicronautModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicronautModuleBuilder.kt\ncom/intellij/micronaut/starter/MicronautModuleBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,322:1\n1563#2:323\n1634#2,3:324\n1374#2:327\n1460#2,5:328\n1563#2:333\n1634#2,3:334\n1056#2:345\n1617#2,9:346\n1869#2:355\n1870#2:357\n1626#2:358\n1#3:337\n1#3:356\n382#4,7:338\n*S KotlinDebug\n*F\n+ 1 MicronautModuleBuilder.kt\ncom/intellij/micronaut/starter/MicronautModuleBuilder\n*L\n111#1:323\n111#1:324,3\n119#1:327\n119#1:328,5\n133#1:333\n133#1:334,3\n178#1:345\n279#1:346,9\n279#1:355\n279#1:357\n279#1:358\n279#1:356\n158#1:338,7\n*E\n"})
public final class MicronautModuleBuilder
extends WebStarterModuleBuilder {
    @NotNull
    private final Regex INVALID_ARTIFACT_SYMBOL_PATTERN = new Regex("[^a-zA-Z0-9_.-]");

    @NotNull
    public String getDefaultServerUrl() {
        return "https://launch.micronaut.io";
    }

    @NotNull
    public String getBuilderId() {
        return "micronaut";
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = MicronautIcons.MicronautLogo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MicronautLogo");
        return icon;
    }

    @NotNull
    public String getPresentableName() {
        return "Micronaut";
    }

    @NotNull
    public String getDescription() {
        return MicronautBundle.message("micronaut.starter.description.for.micronaut.project.starter", new Object[0]);
    }

    @NotNull
    public String getHelpId() {
        return "micronaut.project";
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        Object[] objectArray = new StarterProjectType[]{new StarterProjectType("GRADLE", "Gradle - Groovy", null, 4, null), new StarterProjectType("GRADLE_KOTLIN", "Gradle - Kotlin", null, 4, null), new StarterProjectType("MAVEN", "Maven", null, 4, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        Object[] objectArray = new StarterLanguage[]{new StarterLanguage("JAVA", "Java", "JAVA", false, null, 24, null), new StarterLanguage("KOTLIN", "Kotlin", "kotlin", false, null, 24, null), new StarterLanguage("GROOVY", "Groovy", "Groovy", false, null, 24, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<StarterTestRunner> getTestFrameworks() {
        Object[] objectArray = new StarterTestRunner[]{new StarterTestRunner("JUNIT", "JUnit"), new StarterTestRunner("KOTLINTEST", "Kotest"), new StarterTestRunner("SPOCK", "Spock")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<StarterAppType> getApplicationTypes() {
        Object[] objectArray = new StarterAppType[]{new StarterAppType("DEFAULT", "Application"), new StarterAppType("CLI", "CLI Application"), new StarterAppType("FUNCTION", "Serverless Function"), new StarterAppType("GRPC", "gRPC Application"), new StarterAppType("MESSAGING", "Messaging Application")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected StarterLanguageLevel getDefaultLanguageLevel() {
        return new StarterLanguageLevel("JDK_21", "21", "21");
    }

    @NotNull
    protected List<StarterLanguageLevel> getLanguageLevels() {
        Object[] objectArray = new StarterLanguageLevel[]{new StarterLanguageLevel("JDK_21", "21", "21"), new StarterLanguageLevel("JDK_17", "17", "17"), new StarterLanguageLevel("JDK_11", "11", "11"), new StarterLanguageLevel("JDK_8", "8", "8")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        return CollectionsKt.listOf((Object)"README.md");
    }

    @NotNull
    protected CustomizedMessages getCustomizedMessages() {
        CustomizedMessages customizedMessages;
        CustomizedMessages $this$getCustomizedMessages_u24lambda_u240 = customizedMessages = new CustomizedMessages();
        boolean bl = false;
        $this$getCustomizedMessages_u24lambda_u240.setProjectTypeLabel(JavaStartersBundle.message((String)"title.project.build.system.label", (Object[])new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setDependenciesLabel(MicronautBundle.message("micronaut.starter.features.label", new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setSelectedDependenciesLabel(MicronautBundle.message("micronaut.starter.selected.features.label", new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setNoDependenciesSelectedLabel(MicronautBundle.message("micronaut.starter.select.features.hint", new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setServerUrlDialogTitle(MicronautBundle.message("micronaut.starter.server.url.label", new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setFrameworkVersionLabel(MicronautBundle.message("micronaut.starter.version.label", new Object[0]));
        return customizedMessages;
    }

    @NotNull
    protected WebStarterServerOptions loadServerOptions(@NotNull String serverUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        JsonNode json = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/select-options"), null, (int)2, null);
        return this.handleOptionsJson(serverUrl, json);
    }

    /*
     * WARNING - void declaration
     */
    private final WebStarterServerOptions handleOptionsJson(String serverUrl, JsonNode optionsJson) {
        JsonNode jdkNodes;
        JsonNode jdkConfigObject;
        void $this$flatMapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        JsonNode jsonNode = optionsJson.get("type");
        if (jsonNode == null || (jsonNode = jsonNode.get("options")) == null) {
            throw new IOException("Unable to read application types");
        }
        JsonNode typesNode = jsonNode;
        Iterable $this$map$iv = (Iterable)typesNode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void typeObject = it;
            String id = typeObject.get("name").asText();
            String string = typeObject.get("title").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
            String title = StringsKt.removePrefix((String)string, (CharSequence)"Micronaut ");
            Intrinsics.checkNotNull((Object)id);
            collection.add(new StarterAppType(id, title));
        }
        List types = (List)destination$iv$iv;
        Pattern descriptionLinkPattern = Pattern.compile(" \\((http[s]?://[^\\s]+)\\)");
        Iterable $this$flatMap$iv = types;
        boolean $i$f$flatMap = false;
        Iterable $i$f$mapTo22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            StarterAppType it = (StarterAppType)element$iv$iv;
            boolean bl = false;
            String string = it.getId();
            Intrinsics.checkNotNull((Object)descriptionLinkPattern);
            Iterable list$iv$iv = this.loadFeatures(serverUrl, string, descriptionLinkPattern);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List dependencyCategories = (List)destination$iv$iv2;
        JsonNode versionsJson = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/versions"), null, (int)2, null);
        Object object = versionsJson.get("versions");
        if (object == null || (object = object.get("micronaut.version")) == null || (object = object.asText()) == null) {
            throw new IOException("Unable to read Micronaut version");
        }
        Object version = object;
        WebStarterServerOptions options = new WebStarterServerOptions(CollectionsKt.listOf((Object)new WebStarterFrameworkVersion((String)version, (String)version, true)), dependencyCategories);
        options.putUserData(WebStarterSettings.getSERVER_APPLICATION_TYPES(), (Object)types);
        JsonNode jsonNode3 = jdkConfigObject = optionsJson.get("jdkVersion");
        Object object2 = jdkNodes = jsonNode3 != null ? jsonNode3.get("options") : null;
        if (jdkNodes != null) {
            String defaultOptionName;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = (Iterable)jdkNodes;
            boolean $i$f$map2 = false;
            Iterable bl = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void jdkObject;
                JsonNode jsonNode4 = (JsonNode)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                String id = jdkObject.get("name").asText();
                String title = jdkObject.get("label").asText();
                Intrinsics.checkNotNull((Object)id);
                Intrinsics.checkNotNull((Object)title);
                collection.add(new StarterLanguageLevel(id, title, StringsKt.removePrefix((String)id, (CharSequence)"JDK_")));
            }
            List languageLevels = (List)destination$iv$iv3;
            options.putUserData(WebStarterSettings.getSERVER_LANGUAGE_LEVELS_KEY(), (Object)languageLevels);
            JsonNode jsonNode5 = jdkConfigObject.get("defaultOption");
            String string = jsonNode5 != null && (jsonNode5 = jsonNode5.get("name")) != null ? jsonNode5.asText() : (defaultOptionName = null);
            if (defaultOptionName != null) {
                Iterator iterator;
                block8: {
                    Iterable iterable2 = languageLevels;
                    for (Iterator iterator2 : iterable2) {
                        StarterLanguageLevel it = (StarterLanguageLevel)iterator2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)defaultOptionName)) continue;
                        iterator = iterator2;
                        break block8;
                    }
                    iterator = null;
                }
                StarterLanguageLevel defaultLanguageLevel = (StarterLanguageLevel)iterator;
                options.putUserData(WebStarterSettings.getSERVER_LANGUAGE_LEVEL_KEY(), (Object)defaultLanguageLevel);
            }
        }
        return options;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<WebStarterDependencyCategory> loadFeatures(String serverUrl, String appTypeId, Pattern descriptionLinkPattern) {
        JsonNode featuresRoot = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/application-types/" + appTypeId + "/features"), null, (int)2, null);
        Map categories = new LinkedHashMap();
        Iterator iterator = featuresRoot.get("features").iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            List list;
            Object object;
            void $this$getOrPut$iv;
            JsonNode featureElement = (JsonNode)iterator2.next();
            String categoryName = featureElement.get("category").asText();
            Map map = categories;
            String key$iv = categoryName;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Intrinsics.checkNotNull((Object)categoryName);
                MicronautFeatureCategory answer$iv = new MicronautFeatureCategory(appTypeId, categoryName, null, 4, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            MicronautFeatureCategory category = (MicronautFeatureCategory)((Object)object);
            String id = featureElement.get("name").asText();
            String title = featureElement.get("title").asText();
            Object description = featureElement.get("description").asText();
            Matcher matcher = descriptionLinkPattern.matcher((CharSequence)description);
            if (matcher.find()) {
                String string = description;
                Intrinsics.checkNotNull((Object)string);
                int n = 0;
                int n2 = matcher.start();
                String string2 = string.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = description;
                Intrinsics.checkNotNull((Object)string);
                n = matcher.end();
                String string3 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                description = string2 + string3;
                String string4 = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
                list = CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.WEBSITE, string4, null, 4, null));
            } else {
                list = CollectionsKt.emptyList();
            }
            List links = list;
            List<WebStarterDependency> list2 = category.getFeatures();
            Intrinsics.checkNotNull((Object)id);
            Intrinsics.checkNotNull((Object)title);
            list2.add(new WebStarterDependency(id, title, (String)description, links, false, false, 48, null));
        }
        Iterable $this$sortedBy$iv = categories.values();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
            final /* synthetic */ MicronautModuleBuilder this$0;
            {
                this.this$0 = micronautModuleBuilder;
            }

            public final int compare(T a, T b) {
                MicronautFeatureCategory it = (MicronautFeatureCategory)((Object)a);
                boolean bl = false;
                Comparable comparable = Integer.valueOf(MicronautModuleBuilder.access$getCategoryPriority(this.this$0, it));
                it = (MicronautFeatureCategory)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(MicronautModuleBuilder.access$getCategoryPriority(this.this$0, it)));
            }
        });
    }

    @NotNull
    protected Url composeGeneratorUrl(@NotNull String serverUrl, @NotNull WebStarterContext starterContext) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)starterContext, (String)"starterContext");
        return this.composeEndpointUrl(starterContext, serverUrl, "create");
    }

    private final Url composeEndpointUrl(WebStarterContext starterContext, String serverUrl, String endpoint) {
        String basePackage = this.suggestBasePackage(starterContext.getGroup(), starterContext.getArtifact());
        String string = StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/");
        StarterAppType starterAppType = starterContext.getApplicationType();
        Intrinsics.checkNotNull((Object)starterAppType);
        Url url = Urls.newFromEncoded((String)(string + "/" + endpoint + "/" + starterAppType.getId() + "/" + basePackage));
        String lang = starterContext.getLanguage().getId();
        StarterProjectType starterProjectType = starterContext.getProjectType();
        Intrinsics.checkNotNull((Object)starterProjectType);
        String projectType = starterProjectType.getId();
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"build", (Object)projectType);
        StarterTestRunner starterTestRunner = starterContext.getTestFramework();
        Intrinsics.checkNotNull((Object)starterTestRunner);
        pairArray[1] = TuplesKt.to((Object)"test", (Object)starterTestRunner.getId());
        pairArray[2] = TuplesKt.to((Object)"lang", (Object)lang);
        StarterLanguageLevel starterLanguageLevel = starterContext.getLanguageLevel();
        Intrinsics.checkNotNull((Object)starterLanguageLevel);
        pairArray[3] = TuplesKt.to((Object)"javaVersion", (Object)starterLanguageLevel.getId());
        Url url2 = url.addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"addParameters(...)");
        url = url2;
        if (!((Collection)starterContext.getDependencies()).isEmpty()) {
            String features = CollectionsKt.joinToString$default((Iterable)starterContext.getDependencies(), (CharSequence)",", null, null, (int)0, null, MicronautModuleBuilder::composeEndpointUrl$lambda$0, (int)30, null);
            Url url3 = url.addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"features", (Object)features)));
            Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"addParameters(...)");
            url = url3;
        }
        return url;
    }

    private final String suggestBasePackage(String group, String artifact) {
        String string = group.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String[] stringArray = new String[]{"."};
        String groupPrefix = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, MicronautModuleBuilder::suggestBasePackage$lambda$0, (int)30, null);
        return groupPrefix + "." + this.sanitizeArtifact(artifact);
    }

    private final String sanitizeArtifact(String input) {
        String string = FileUtil.sanitizeFileName((String)input, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(...)");
        String fileName = string;
        CharSequence charSequence = fileName;
        Regex regex = this.INVALID_ARTIFACT_SYMBOL_PATTERN;
        String string2 = "_";
        String string3 = regex.replace(charSequence, string2).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return string3;
    }

    protected void extractGeneratorResult(@NotNull File tempZipFile, @NotNull File contentEntryDir) {
        Intrinsics.checkNotNullParameter((Object)tempZipFile, (String)"tempZipFile");
        Intrinsics.checkNotNullParameter((Object)contentEntryDir, (String)"contentEntryDir");
        WebStarterSettings.unzipSubfolder((File)tempZipFile, (File)contentEntryDir);
    }

    @NotNull
    protected WebStarterLibrariesStep createLibrariesStep(@NotNull WebStarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        return new WebStarterLibrariesStep(contextProvider, this){
            final /* synthetic */ MicronautModuleBuilder this$0;
            {
                this.this$0 = $receiver;
                super($contextProvider);
            }

            protected boolean validateWithServer(ProgressIndicator progressIndicator) {
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                progressIndicator.setText(MicronautBundle.message("micronaut.starter.message.validating.dependencies", new Object[0]));
                try {
                    ValidationResult result = MicronautModuleBuilder.access$validateOptions(this.this$0);
                    if (result.getMessage() != null) {
                        progressIndicator.checkCanceled();
                        this.showError(result.getMessage());
                        return false;
                    }
                }
                catch (IOException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(MicronautModuleBuilder.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info((Throwable)e);
                    Object[] objectArray = new Object[]{e.getMessage()};
                    String string = JavaStartersBundle.message((String)"error.text.with.error.content", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.showError(string);
                }
                return true;
            }

            private final void showError(String error) {
                ApplicationManager.getApplication().invokeLater(() -> createLibrariesStep.1.showError$lambda$0(error), this.getModalityState(), this.getDisposed());
            }

            private static final void showError$lambda$0(String $error) {
                Object[] objectArray = new Object[]{$error};
                Messages.showErrorDialog((String)JavaStartersBundle.message((String)"error.text.with.error.content", (Object[])objectArray), (String)MicronautBundle.message("micronaut.starter.message.validation.title", new Object[0]));
            }
        };
    }

    @RequiresBackgroundThread
    private final ValidationResult validateOptions() {
        Url url = this.composeEndpointUrl(this.getStarterContext(), this.getStarterContext().getServerUrl(), "preview");
        Object object = HttpRequests.request((String)url.toExternalForm()).userAgent(this.getUserAgent()).connectTimeout(10000).throwStatusCodeException(false).isReadResponseOnError(true).connect(arg_0 -> MicronautModuleBuilder.validateOptions$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (ValidationResult)object;
    }

    private final int getCategoryPriority(MicronautFeatureCategory category) {
        return switch (category.getTitle()) {
            case "Server" -> 0;
            case "Client" -> 1;
            case "Database" -> 2;
            case "Validation" -> 3;
            case "Logging" -> 4;
            case "Security" -> 5;
            case "Management" -> 6;
            case "Messaging" -> 7;
            case "Reactive" -> 8;
            case "View Rendering" -> 9;
            default -> 100;
        };
    }

    private static final CharSequence composeEndpointUrl$lambda$0(WebStarterDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }

    private static final CharSequence suggestBasePackage$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StarterModuleBuilder.Companion.sanitizePackage(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final ValidationResult validateOptions$lambda$0(MicronautModuleBuilder this$0, HttpRequests.Request request) {
        int statusCode;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        URLConnection uRLConnection = request.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"getConnection(...)");
        URLConnection connection = uRLConnection;
        if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 200) {
            return new ValidationResult(null);
        }
        int n = statusCode = connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : -1;
        if (statusCode == 400) {
            String string = request.readError();
            if (string == null) {
                string = "";
            }
            String error = string;
            try {
                Object object;
                List list;
                JsonNode jsonRootElement = this$0.getObjectMapper().readTree((Reader)new StringReader(error));
                JsonNode jsonNode = jsonRootElement.get("_embedded");
                JsonNode jsonNode2 = jsonNode != null ? jsonNode.get("errors") : null;
                ArrayNode arrayNode = jsonNode2 instanceof ArrayNode ? (ArrayNode)jsonNode2 : null;
                if (arrayNode != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)arrayNode;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        JsonNode it = (JsonNode)element$iv$iv;
                        boolean bl2 = false;
                        JsonNode jsonNode3 = it.get("message");
                        if ((jsonNode3 != null ? jsonNode3.asText() : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = null;
                }
                if ((object = UtilKt.nullize(list)) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null)) == null) {
                    JsonNode jsonNode4 = jsonRootElement.get("message");
                    object = jsonNode4 != null ? jsonNode4.asText() : null;
                    if (object == null) {
                        object = MicronautBundle.message("micronaut.starter.message.validation.error", new Object[0]);
                    }
                }
                Object errorMessage = object;
                return new ValidationResult((String)errorMessage);
            }
            catch (Throwable e) {
                throw new IOException("Error parsing JSON response", e);
            }
        }
        throw new IOException(MicronautBundle.message("micronaut.starter.message.validation.error", new Object[0]));
    }

    public static final /* synthetic */ ValidationResult access$validateOptions(MicronautModuleBuilder $this) {
        return $this.validateOptions();
    }

    public static final /* synthetic */ int access$getCategoryPriority(MicronautModuleBuilder $this, MicronautFeatureCategory category) {
        return $this.getCategoryPriority(category);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/micronaut/starter/MicronautModuleBuilder$MicronautFeatureCategory;", "Lcom/intellij/ide/starters/remote/WebStarterDependencyCategory;", "appTypeId", "", "title", "features", "", "Lcom/intellij/ide/starters/remote/WebStarterDependency;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getFeatures", "()Ljava/util/List;", "isAvailable", "", "starterContext", "Lcom/intellij/ide/starters/remote/WebStarterContext;", "intellij.micronaut"})
    private static final class MicronautFeatureCategory
    extends WebStarterDependencyCategory {
        @NotNull
        private final String appTypeId;
        @NotNull
        private final List<WebStarterDependency> features;

        public MicronautFeatureCategory(@NotNull String appTypeId, @NotNull String title, @NotNull List<WebStarterDependency> features) {
            Intrinsics.checkNotNullParameter((Object)appTypeId, (String)"appTypeId");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(features, (String)"features");
            super(title, features);
            this.appTypeId = appTypeId;
            this.features = features;
        }

        public /* synthetic */ MicronautFeatureCategory(String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = new ArrayList();
            }
            this(string, string2, list);
        }

        @NotNull
        public final List<WebStarterDependency> getFeatures() {
            return this.features;
        }

        public boolean isAvailable(@NotNull WebStarterContext starterContext) {
            Intrinsics.checkNotNullParameter((Object)starterContext, (String)"starterContext");
            StarterAppType starterAppType = starterContext.getApplicationType();
            return Intrinsics.areEqual((Object)(starterAppType != null ? starterAppType.getId() : null), (Object)this.appTypeId);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/micronaut/starter/MicronautModuleBuilder$ValidationResult;", "", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "intellij.micronaut"})
    public static final class ValidationResult {
        @Nullable
        private final String message;

        public ValidationResult(@Nullable String message) {
            this.message = message;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }
    }
}

