/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 22120691621493L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1610063880 - -((char)-26095), 1610063880 - 23984, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1610063880 - -((char)-26096), 1610063880 - (char)-29991, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 26674912150031L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.d();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1129692330 + (char)-22073, 1129692330 + 20412, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1129692330 + (char)-22074, -1129692330 + -25180, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1129692330 + (char)-22067, -1129692330 + -((char)-30165), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 55365934890913L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.d();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(488497890 + 14582, 488497890 + 14424, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(488497890 + 14585, 488497890 + 23813, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(488497890 + 14584, -488497890 + -15603, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(488497890 + 14579, 488497890 + 13835, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(488497890 + 14578, -488497890 + -29239, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(488497890 + 14581, 488497890 + (char)-32263, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(488497890 + 14579, 488497890 + 13835, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(488497890 + 14580, 488497890 + 20693, (int)l2));
            if (ActionTimestamp.d() != null) {
                SshAgentIpcService.d(new int[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 85578528763397L;
                    nArray = SshAgentIpcService.d();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 140212051478269L;
                int[] nArray2 = SshAgentIpcService.d();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1450813830 + 30983, 1450813830 + (char)-14441, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1450813830 + 30979, 1450813830 + 30763, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1450813830 + 30982, -1450813830 + -24678, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1450813830 + 30979, 1450813830 + 30763, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1450813830 + 30985, -1450813830 + -22932, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1450813830 + 30983, 1450813830 + (char)-14441, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1450813830 + 30979, 1450813830 + 30763, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1450813830 + 30984, -1450813830 + -((char)-25606), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1450813830 + 30983, 1450813830 + (char)-14441, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1450813830 + 30979, 1450813830 + 30763, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1450813830 + 30987, 1450813830 + (char)-28833, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1450813830 + 30979, 1450813830 + 30763, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1450813830 + 30986, -1450813830 + -((char)-13929), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1450813830 + 30979, 1450813830 + 30763, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1450813830 + 30985, -1450813830 + -22932, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1450813830 + 30983, 1450813830 + (char)-14441, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1450813830 + 30979, 1450813830 + 30763, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1450813830 + 30989, -1450813830 + -31310, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 136135340300763L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(2056881510 + 9064, 2056881510 - 320, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 117229326318436L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1806013530 + -24886, -1806013530 + -6174, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00fbo\u009e\u00a9*\u0080\u00f8^\u00c9p\u00b6\u009f.<\u00e47\u00aa\u00e7\u0099\u0014\u00b6^7\u0089\u0004F@\u0003\\\u00dd\u00c1\u00fe\u0002\u00e9\u00a0\u0006\u00cf\u00072\u0087";
                        var4_3 = "\u00fbo\u009e\u00a9*\u0080\u00f8^\u00c9p\u00b6\u009f.<\u00e47\u00aa\u00e7\u0099\u0014\u00b6^7\u0089\u0004F@\u0003\\\u00dd\u00c1\u00fe\u0002\u00e9\u00a0\u0006\u00cf\u00072\u0087".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 114;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 26;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 101;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 74;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 84;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 123;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 19;
                                        break;
                                    }
                                    default: {
                                        v11 = 56;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x3115) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 122;
                            case 1 -> 183;
                            case 2 -> 223;
                            case 3 -> 222;
                            case 4 -> 195;
                            case 5 -> 161;
                            case 6 -> 50;
                            case 7 -> 198;
                            case 8 -> 112;
                            case 9 -> 25;
                            case 10 -> 146;
                            case 11 -> 242;
                            case 12 -> 135;
                            case 13 -> 85;
                            case 14 -> 209;
                            case 15 -> 193;
                            case 16 -> 7;
                            case 17 -> 201;
                            case 18 -> 151;
                            case 19 -> 218;
                            case 20 -> 87;
                            case 21 -> 177;
                            case 22 -> 211;
                            case 23 -> 159;
                            case 24 -> 101;
                            case 25 -> 232;
                            case 26 -> 109;
                            case 27 -> 131;
                            case 28 -> 186;
                            case 29 -> 111;
                            case 30 -> 63;
                            case 31 -> 150;
                            case 32 -> 207;
                            case 33 -> 214;
                            case 34 -> 73;
                            case 35 -> 114;
                            case 36 -> 247;
                            case 37 -> 74;
                            case 38 -> 162;
                            case 39 -> 178;
                            case 40 -> 167;
                            case 41 -> 238;
                            case 42 -> 194;
                            case 43 -> 190;
                            case 44 -> 203;
                            case 45 -> 86;
                            case 46 -> 200;
                            case 47 -> 99;
                            case 48 -> 34;
                            case 49 -> 91;
                            case 50 -> 95;
                            case 51 -> 43;
                            case 52 -> 67;
                            case 53 -> 234;
                            case 54 -> 12;
                            case 55 -> 125;
                            case 56 -> 197;
                            case 57 -> 142;
                            case 58 -> 35;
                            case 59 -> 47;
                            case 60 -> 179;
                            case 61 -> 39;
                            case 62 -> 77;
                            case 63 -> 217;
                            case 64 -> 11;
                            case 65 -> 137;
                            case 66 -> 103;
                            case 67 -> 19;
                            case 68 -> 31;
                            case 69 -> 69;
                            case 70 -> 244;
                            case 71 -> 168;
                            case 72 -> 97;
                            case 73 -> 13;
                            case 74 -> 115;
                            case 75 -> 15;
                            case 76 -> 118;
                            case 77 -> 180;
                            case 78 -> 53;
                            case 79 -> 81;
                            case 80 -> 72;
                            case 81 -> 165;
                            case 82 -> 248;
                            case 83 -> 70;
                            case 84 -> 236;
                            case 85 -> 208;
                            case 86 -> 104;
                            case 87 -> 65;
                            case 88 -> 10;
                            case 89 -> 206;
                            case 90 -> 14;
                            case 91 -> 120;
                            case 92 -> 66;
                            case 93 -> 215;
                            case 94 -> 3;
                            case 95 -> 239;
                            case 96 -> 41;
                            case 97 -> 152;
                            case 98 -> 169;
                            case 99 -> 24;
                            case 100 -> 80;
                            case 101 -> 202;
                            case 102 -> 107;
                            case 103 -> 33;
                            case 104 -> 144;
                            case 105 -> 230;
                            case 106 -> 75;
                            case 107 -> 185;
                            case 108 -> 82;
                            case 109 -> 127;
                            case 110 -> 154;
                            case 111 -> 235;
                            case 112 -> 147;
                            case 113 -> 172;
                            case 114 -> 219;
                            case 115 -> 191;
                            case 116 -> 166;
                            case 117 -> 46;
                            case 118 -> 252;
                            case 119 -> 149;
                            case 120 -> 79;
                            case 121 -> 246;
                            case 122 -> 130;
                            case 123 -> 163;
                            case 124 -> 176;
                            case 125 -> 37;
                            case 126 -> 56;
                            case 127 -> 40;
                            case 128 -> 18;
                            case 129 -> 20;
                            case 130 -> 59;
                            case 131 -> 68;
                            case 132 -> 188;
                            case 133 -> 145;
                            case 134 -> 62;
                            case 135 -> 55;
                            case 136 -> 26;
                            case 137 -> 133;
                            case 138 -> 90;
                            case 139 -> 184;
                            case 140 -> 156;
                            case 141 -> 23;
                            case 142 -> 192;
                            case 143 -> 153;
                            case 144 -> 225;
                            case 145 -> 27;
                            case 146 -> 2;
                            case 147 -> 0;
                            case 148 -> 124;
                            case 149 -> 110;
                            case 150 -> 22;
                            case 151 -> 6;
                            case 152 -> 121;
                            case 153 -> 212;
                            case 154 -> 140;
                            case 155 -> 93;
                            case 156 -> 216;
                            case 157 -> 204;
                            case 158 -> 76;
                            case 159 -> 102;
                            case 160 -> 220;
                            case 161 -> 71;
                            case 162 -> 174;
                            case 163 -> 213;
                            case 164 -> 233;
                            case 165 -> 241;
                            case 166 -> 129;
                            case 167 -> 48;
                            case 168 -> 105;
                            case 169 -> 141;
                            case 170 -> 155;
                            case 171 -> 38;
                            case 172 -> 143;
                            case 173 -> 88;
                            case 174 -> 45;
                            case 175 -> 148;
                            case 176 -> 32;
                            case 177 -> 100;
                            case 178 -> 224;
                            case 179 -> 8;
                            case 180 -> 4;
                            case 181 -> 116;
                            case 182 -> 84;
                            case 183 -> 61;
                            case 184 -> 113;
                            case 185 -> 221;
                            case 186 -> 251;
                            case 187 -> 240;
                            case 188 -> 128;
                            case 189 -> 42;
                            case 190 -> 227;
                            case 191 -> 254;
                            case 192 -> 171;
                            case 193 -> 237;
                            case 194 -> 78;
                            case 195 -> 138;
                            case 196 -> 181;
                            case 197 -> 182;
                            case 198 -> 58;
                            case 199 -> 30;
                            case 200 -> 126;
                            case 201 -> 164;
                            case 202 -> 170;
                            case 203 -> 226;
                            case 204 -> 157;
                            case 205 -> 123;
                            case 206 -> 205;
                            case 207 -> 21;
                            case 208 -> 173;
                            case 209 -> 119;
                            case 210 -> 57;
                            case 211 -> 52;
                            case 212 -> 64;
                            case 213 -> 134;
                            case 214 -> 5;
                            case 215 -> 49;
                            case 216 -> 196;
                            case 217 -> 136;
                            case 218 -> 243;
                            case 219 -> 16;
                            case 220 -> 139;
                            case 221 -> 250;
                            case 222 -> 60;
                            case 223 -> 199;
                            case 224 -> 44;
                            case 225 -> 249;
                            case 226 -> 92;
                            case 227 -> 132;
                            case 228 -> 158;
                            case 229 -> 51;
                            case 230 -> 160;
                            case 231 -> 253;
                            case 232 -> 98;
                            case 233 -> 1;
                            case 234 -> 117;
                            case 235 -> 255;
                            case 236 -> 36;
                            case 237 -> 29;
                            case 238 -> 210;
                            case 239 -> 175;
                            case 240 -> 229;
                            case 241 -> 89;
                            case 242 -> 189;
                            case 243 -> 96;
                            case 244 -> 231;
                            case 245 -> 106;
                            case 246 -> 187;
                            case 247 -> 228;
                            case 248 -> 83;
                            case 249 -> 17;
                            case 250 -> 54;
                            case 251 -> 245;
                            case 252 -> 28;
                            case 253 -> 94;
                            case 254 -> 9;
                            default -> 108;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray != null) {
                ActionTimestamp.d(new ActionTimestamp[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 94234469908309L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.d();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1407560730 - (char)-28427, 1407560730 - 25445, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1407560730 - (char)-28423, 1407560730 - (char)-27647, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1407560730 - (char)-28448, 1407560730 - 22096, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1407560730 - (char)-28427, 1407560730 - 25445, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1407560730 - (char)-28423, 1407560730 - (char)-27647, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1407560730 - (char)-28451, -1407560730 - -20288, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 103866652950431L;
                        int[] nArray2 = SshAgentIpcService.d();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1458809100 - -1282, 1458809100 + 6011, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1458809100 - -1281, 1458809100 + 7180, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 95982103066775L;
                int[] nArray2 = SshAgentIpcService.d();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1826067240 + 18879, 1826067240 - 945, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1826067240 + 18875, 1826067240 + 19635, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1826067240 + 18900, -1826067240 + -10055, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1826067240 + 18875, 1826067240 + 19635, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1826067240 + 18877, -1826067240 + -27212, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1826067240 + 18879, 1826067240 - 945, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1826067240 + 18875, 1826067240 + 19635, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1826067240 + 18891, 1826067240 + 15565, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1826067240 + 18879, 1826067240 - 945, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1826067240 + 18875, 1826067240 + 19635, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1826067240 + 18890, -1826067240 + -16739, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1826067240 + 18879, 1826067240 - 945, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1826067240 + 18875, 1826067240 + 19635, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1826067240 + 18889, -1826067240 - -3574, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 42179517321283L;
                    Object object = this.lock;
                    nArray = SshAgentIpcService.d();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31475, 1356443430 + (char)-18307, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31471, 1356443430 + (char)-30743, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31490, 1356443430 + (char)-21500, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31491, 1356443430 + (char)-20680, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31475, 1356443430 + (char)-18307, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31471, 1356443430 + (char)-30743, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31492, -1356443430 + -26589, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31475, 1356443430 + (char)-18307, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31471, 1356443430 + (char)-30743, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31493, -1356443430 + -30936, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31475, 1356443430 + (char)-18307, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31471, 1356443430 + (char)-30743, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31494, -1356443430 + -((char)-24020), (int)l2));
                    if (nArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31475, 1356443430 + (char)-18307, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31471, 1356443430 + (char)-30743, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31495, 1356443430 + (char)-18385, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1356443430 + (char)-31496, -1356443430 + -((char)-26323), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00f6\u00f6o\u0017la\u0001T\u0014:\u0004\u00ce\u00ae\u00a6\u00de\u00f7\u00b9\u0003}\u0087-\u0010\u008e\u00c5\u0013\u00f2Z\u00cd\u00e0\u0006\u001f\u00abR\u00bc\u00a1U\u0018~\u0012&\\9E\u0006\n\u00f5vV<LS\u001c*`\u0014\u00b1\u00b4)\u00a1\u00c2\u007f\t?`\u0090\u00a3\u0084%\u00a9N<\u0005\u0093\u008b\u00c3\u00b8\u0089\bh\u00bc\u00bc/D@\u0002\u0092\u0014gi\u001d\u0098\u00b1\u0010 \u00f7\u0097i\u00be\u001b}\u00eb\u00d3R\"\u00a1.\u00dd\u0005{\r\u00deh*\u001eh+\u00a9\u00c8Y\u0013\u00a8\u00ba\u0085t\u0013\u00fb\u00a8\u008b\"UFj\u00a7\u008fG\u00e9\u0003\u00bb\u00d0P\u00ae\u00fb\u00c6\u00b9\u0010N\u00e5\u0089\u00d4\n\u00a24uk?Co\u00a4L\f2\tb\u00fe\u00edaxZ\u0010>\u00e5\u00107$\u00a6\u00ec\u00ef\u00a5\u0088\u0095\u00fc#\u00b1\u00ec\u00fa<\u00c7<?\u00ffjS\u00e0\u000b\u001fgW\r\u0018G\u008d\u009d\u00b3\u00b9k\u00f0\u00c8\f\u001e\u00bc\u0089\u0007\u00d1@\u00f5\u00b1\u00fb\u0012\u00efzCB\u001c\u00a2\u00be\u00bf\u0083l\u00fc)\u0096\u00b2\u00ee\u0088\u0016r>N\u0001\u00f7\u00b1|\u00e6\u0019.\u00a4${\u0010N\u0001\u00ac\b*Y\u00f4\u0093M\u00d7#`\f\u008b^\u00d0h\u00d4\u00ca\u00fe\u00c4\u001bA\u001f\u00a4F\u00bd\u0005\u0016\u0003\f\u00a7\u00e5ix\u00f8yW\u00cc\u00e0\u008c'\u00aa&Gl\u00c7\u0095k`\u00fb\u00e85S=\u00d3\u00a5\u00f8\u0085\u00dd\u0098\u00a7\"\u00edt\u00f5\u00b9\u00a2+\u0093e<\u009b\u0006\u0094\u00fe\u00ca\u00e44\u00da\u0006\u00b2\u00d8\u00c3bP^`\u00f2\u00bb\u000fl\u0090\u00a3\u0013\u00f7\u001f\u00ef\u0091Y\u009fG\u00f9k\u00e7\u00fd\u00df\u001c\u008eI8\u0015\u0092\u00dbziGUp\u0096#\u0003\u0093\u00c3Ov\u00de\u00ce\u000b\u00caS\u00f8\u00c9\u00d1\u00fe^B\u000f\u009d\u0097\u0015N\u0091h\u0092\u00c4\u00fd\u0010_\u00f8\u00de\u00a1e@\u00e9)\u00fe\u00a7c;\u001d))\u00f6\u00bfzZ#A\u00e7\u00f0l=.\u00d2\u000b\u00b9\u00c3\u00a7^T\u0002%\u00c8D\u00e3\u00bd\u00c2\t,d\u00a4O\u0016U\r\u00cd\u00ef(\u00d2\u0001\u00e1\u00c1\u00a8\u0007\u00b4\u00978EO\u00ff\u00f1\u0007\u00a2\u0019\u009e\u00f8|\u00a7\u0081(\u00dbQ\u0093\u00a6\u00ae\u00b4\u00a0i\u00f4\u00d9\u0017x\u000fm\u0001\u00be\u0001\u00daG\u00b7\u0001(\u00b5\u00fb\u0098}\u00d1\u0091,\u0091\u00dc\u0097\u00af\u00fe%\u00e31\u0005\u000e\u00b2\u000f\u00b2\u00cf\u00f0\\*\u0087\u0095\u00cc'\u00e0\u00cc\u000e\u00d4\u00f7\u00e4\"\u00b412\u008b*{\u00c6\u00b7H\u00d5\u00aa\u00cf\u0098\u0016\u00d5\u009cw\u001a\u00ad\u00ae\u00d75\u00a0\u00c39\u0092\u009e\u00c9\u00d6\u00c8\u00fa\u00a2\u00be\u00c0\u000e\u0015\u00de\u0004~\u00b4\u00c3FD]\u00f1\u0083,1\u00b9\u001b\u009d)\u0012\u0085\u008d\t\u00f4A\\\u00d6.\u00c9\u00d43z.*\u00e6\u00bb\u00ad.a\u00ec\u00ef\u00fbz\u0093\n\u00a7r\u0091\u00e9\u00e9`\u00abF\u001cT\u00188\u00ec\u00a60\u001a\u0003'^8\u00fc`\u0013\u00a4;\u0088\u000e\u0003\u00e3It\b\u0011s\u00b2)v]j\u0006!\u00ca\u00a7\u0081d\u0013/\u0017/\b\u00d8\u00eaC\u0088~{}\u009f\u001c\u00caHu\u00e0\u0007n\u007f\u00f4\u00c2t\u00e1\u00159S\u0007\u00d1\u0001\u00ae\tO\u008cH1\u00c6\u009f\u0091\u00ddh";
                var4_3 = "\u00f6\u00f6o\u0017la\u0001T\u0014:\u0004\u00ce\u00ae\u00a6\u00de\u00f7\u00b9\u0003}\u0087-\u0010\u008e\u00c5\u0013\u00f2Z\u00cd\u00e0\u0006\u001f\u00abR\u00bc\u00a1U\u0018~\u0012&\\9E\u0006\n\u00f5vV<LS\u001c*`\u0014\u00b1\u00b4)\u00a1\u00c2\u007f\t?`\u0090\u00a3\u0084%\u00a9N<\u0005\u0093\u008b\u00c3\u00b8\u0089\bh\u00bc\u00bc/D@\u0002\u0092\u0014gi\u001d\u0098\u00b1\u0010 \u00f7\u0097i\u00be\u001b}\u00eb\u00d3R\"\u00a1.\u00dd\u0005{\r\u00deh*\u001eh+\u00a9\u00c8Y\u0013\u00a8\u00ba\u0085t\u0013\u00fb\u00a8\u008b\"UFj\u00a7\u008fG\u00e9\u0003\u00bb\u00d0P\u00ae\u00fb\u00c6\u00b9\u0010N\u00e5\u0089\u00d4\n\u00a24uk?Co\u00a4L\f2\tb\u00fe\u00edaxZ\u0010>\u00e5\u00107$\u00a6\u00ec\u00ef\u00a5\u0088\u0095\u00fc#\u00b1\u00ec\u00fa<\u00c7<?\u00ffjS\u00e0\u000b\u001fgW\r\u0018G\u008d\u009d\u00b3\u00b9k\u00f0\u00c8\f\u001e\u00bc\u0089\u0007\u00d1@\u00f5\u00b1\u00fb\u0012\u00efzCB\u001c\u00a2\u00be\u00bf\u0083l\u00fc)\u0096\u00b2\u00ee\u0088\u0016r>N\u0001\u00f7\u00b1|\u00e6\u0019.\u00a4${\u0010N\u0001\u00ac\b*Y\u00f4\u0093M\u00d7#`\f\u008b^\u00d0h\u00d4\u00ca\u00fe\u00c4\u001bA\u001f\u00a4F\u00bd\u0005\u0016\u0003\f\u00a7\u00e5ix\u00f8yW\u00cc\u00e0\u008c'\u00aa&Gl\u00c7\u0095k`\u00fb\u00e85S=\u00d3\u00a5\u00f8\u0085\u00dd\u0098\u00a7\"\u00edt\u00f5\u00b9\u00a2+\u0093e<\u009b\u0006\u0094\u00fe\u00ca\u00e44\u00da\u0006\u00b2\u00d8\u00c3bP^`\u00f2\u00bb\u000fl\u0090\u00a3\u0013\u00f7\u001f\u00ef\u0091Y\u009fG\u00f9k\u00e7\u00fd\u00df\u001c\u008eI8\u0015\u0092\u00dbziGUp\u0096#\u0003\u0093\u00c3Ov\u00de\u00ce\u000b\u00caS\u00f8\u00c9\u00d1\u00fe^B\u000f\u009d\u0097\u0015N\u0091h\u0092\u00c4\u00fd\u0010_\u00f8\u00de\u00a1e@\u00e9)\u00fe\u00a7c;\u001d))\u00f6\u00bfzZ#A\u00e7\u00f0l=.\u00d2\u000b\u00b9\u00c3\u00a7^T\u0002%\u00c8D\u00e3\u00bd\u00c2\t,d\u00a4O\u0016U\r\u00cd\u00ef(\u00d2\u0001\u00e1\u00c1\u00a8\u0007\u00b4\u00978EO\u00ff\u00f1\u0007\u00a2\u0019\u009e\u00f8|\u00a7\u0081(\u00dbQ\u0093\u00a6\u00ae\u00b4\u00a0i\u00f4\u00d9\u0017x\u000fm\u0001\u00be\u0001\u00daG\u00b7\u0001(\u00b5\u00fb\u0098}\u00d1\u0091,\u0091\u00dc\u0097\u00af\u00fe%\u00e31\u0005\u000e\u00b2\u000f\u00b2\u00cf\u00f0\\*\u0087\u0095\u00cc'\u00e0\u00cc\u000e\u00d4\u00f7\u00e4\"\u00b412\u008b*{\u00c6\u00b7H\u00d5\u00aa\u00cf\u0098\u0016\u00d5\u009cw\u001a\u00ad\u00ae\u00d75\u00a0\u00c39\u0092\u009e\u00c9\u00d6\u00c8\u00fa\u00a2\u00be\u00c0\u000e\u0015\u00de\u0004~\u00b4\u00c3FD]\u00f1\u0083,1\u00b9\u001b\u009d)\u0012\u0085\u008d\t\u00f4A\\\u00d6.\u00c9\u00d43z.*\u00e6\u00bb\u00ad.a\u00ec\u00ef\u00fbz\u0093\n\u00a7r\u0091\u00e9\u00e9`\u00abF\u001cT\u00188\u00ec\u00a60\u001a\u0003'^8\u00fc`\u0013\u00a4;\u0088\u000e\u0003\u00e3It\b\u0011s\u00b2)v]j\u0006!\u00ca\u00a7\u0081d\u0013/\u0017/\b\u00d8\u00eaC\u0088~{}\u009f\u001c\u00caHu\u00e0\u0007n\u007f\u00f4\u00c2t\u00e1\u00159S\u0007\u00d1\u0001\u00ae\tO\u008cH1\u00c6\u009f\u0091\u00ddh".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 54;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0096\u009b\u00f8P\u00fd\u008e\u00b2\u0087H]$P\u00c0n\u00ab\u00a8\u00a3B\u00bc(\u00feD\u0011\u00e1\u00cc\u0082o2\u0081\u0014\u0091\u00d15\u009aW\u00d6G6\u009b\u0002\u001aL-,\u00ec\u00c9Y\u008f6\u00d4";
                    var4_3 = "\u0096\u009b\u00f8P\u00fd\u008e\u00b2\u0087H]$P\u00c0n\u00ab\u00a8\u00a3B\u00bc(\u00feD\u0011\u00e1\u00cc\u0082o2\u0081\u0014\u0091\u00d15\u009aW\u00d6G6\u009b\u0002\u001aL-,\u00ec\u00c9Y\u008f6\u00d4".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 112;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 35;
                            break;
                        }
                        case 1: {
                            v15 = 43;
                            break;
                        }
                        case 2: {
                            v15 = 43;
                            break;
                        }
                        case 3: {
                            v15 = 125;
                            break;
                        }
                        case 4: {
                            v15 = 58;
                            break;
                        }
                        case 5: {
                            v15 = 116;
                            break;
                        }
                        default: {
                            v15 = 21;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFA47C) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 31;
                case 1 -> 49;
                case 2 -> 186;
                case 3 -> 202;
                case 4 -> 140;
                case 5 -> 38;
                case 6 -> 230;
                case 7 -> 48;
                case 8 -> 135;
                case 9 -> 76;
                case 10 -> 239;
                case 11 -> 188;
                case 12 -> 61;
                case 13 -> 173;
                case 14 -> 34;
                case 15 -> 216;
                case 16 -> 2;
                case 17 -> 8;
                case 18 -> 101;
                case 19 -> 149;
                case 20 -> 33;
                case 21 -> 51;
                case 22 -> 146;
                case 23 -> 245;
                case 24 -> 87;
                case 25 -> 118;
                case 26 -> 132;
                case 27 -> 241;
                case 28 -> 213;
                case 29 -> 6;
                case 30 -> 102;
                case 31 -> 116;
                case 32 -> 194;
                case 33 -> 220;
                case 34 -> 155;
                case 35 -> 235;
                case 36 -> 184;
                case 37 -> 90;
                case 38 -> 249;
                case 39 -> 36;
                case 40 -> 196;
                case 41 -> 231;
                case 42 -> 30;
                case 43 -> 144;
                case 44 -> 43;
                case 45 -> 167;
                case 46 -> 180;
                case 47 -> 244;
                case 48 -> 225;
                case 49 -> 32;
                case 50 -> 153;
                case 51 -> 252;
                case 52 -> 106;
                case 53 -> 191;
                case 54 -> 218;
                case 55 -> 234;
                case 56 -> 199;
                case 57 -> 10;
                case 58 -> 17;
                case 59 -> 237;
                case 60 -> 27;
                case 61 -> 150;
                case 62 -> 21;
                case 63 -> 22;
                case 64 -> 1;
                case 65 -> 179;
                case 66 -> 139;
                case 67 -> 86;
                case 68 -> 52;
                case 69 -> 198;
                case 70 -> 161;
                case 71 -> 70;
                case 72 -> 212;
                case 73 -> 13;
                case 74 -> 73;
                case 75 -> 58;
                case 76 -> 190;
                case 77 -> 3;
                case 78 -> 114;
                case 79 -> 40;
                case 80 -> 133;
                case 81 -> 233;
                case 82 -> 53;
                case 83 -> 19;
                case 84 -> 207;
                case 85 -> 47;
                case 86 -> 104;
                case 87 -> 50;
                case 88 -> 129;
                case 89 -> 16;
                case 90 -> 141;
                case 91 -> 62;
                case 92 -> 45;
                case 93 -> 115;
                case 94 -> 68;
                case 95 -> 238;
                case 96 -> 152;
                case 97 -> 148;
                case 98 -> 138;
                case 99 -> 232;
                case 100 -> 44;
                case 101 -> 181;
                case 102 -> 103;
                case 103 -> 41;
                case 104 -> 204;
                case 105 -> 147;
                case 106 -> 117;
                case 107 -> 170;
                case 108 -> 254;
                case 109 -> 185;
                case 110 -> 46;
                case 111 -> 226;
                case 112 -> 109;
                case 113 -> 222;
                case 114 -> 89;
                case 115 -> 42;
                case 116 -> 88;
                case 117 -> 248;
                case 118 -> 176;
                case 119 -> 201;
                case 120 -> 174;
                case 121 -> 211;
                case 122 -> 100;
                case 123 -> 178;
                case 124 -> 67;
                case 125 -> 255;
                case 126 -> 105;
                case 127 -> 77;
                case 128 -> 78;
                case 129 -> 123;
                case 130 -> 200;
                case 131 -> 64;
                case 132 -> 4;
                case 133 -> 26;
                case 134 -> 165;
                case 135 -> 205;
                case 136 -> 183;
                case 137 -> 214;
                case 138 -> 166;
                case 139 -> 107;
                case 140 -> 187;
                case 141 -> 79;
                case 142 -> 92;
                case 143 -> 168;
                case 144 -> 60;
                case 145 -> 9;
                case 146 -> 171;
                case 147 -> 5;
                case 148 -> 251;
                case 149 -> 136;
                case 150 -> 203;
                case 151 -> 157;
                case 152 -> 156;
                case 153 -> 74;
                case 154 -> 66;
                case 155 -> 177;
                case 156 -> 81;
                case 157 -> 75;
                case 158 -> 217;
                case 159 -> 95;
                case 160 -> 209;
                case 161 -> 71;
                case 162 -> 151;
                case 163 -> 12;
                case 164 -> 229;
                case 165 -> 69;
                case 166 -> 82;
                case 167 -> 197;
                case 168 -> 134;
                case 169 -> 242;
                case 170 -> 247;
                case 171 -> 172;
                case 172 -> 160;
                case 173 -> 113;
                case 174 -> 189;
                case 175 -> 145;
                case 176 -> 130;
                case 177 -> 143;
                case 178 -> 127;
                case 179 -> 122;
                case 180 -> 159;
                case 181 -> 126;
                case 182 -> 80;
                case 183 -> 195;
                case 184 -> 253;
                case 185 -> 84;
                case 186 -> 28;
                case 187 -> 162;
                case 188 -> 240;
                case 189 -> 121;
                case 190 -> 72;
                case 191 -> 96;
                case 192 -> 208;
                case 193 -> 158;
                case 194 -> 99;
                case 195 -> 131;
                case 196 -> 224;
                case 197 -> 23;
                case 198 -> 192;
                case 199 -> 35;
                case 200 -> 55;
                case 201 -> 228;
                case 202 -> 128;
                case 203 -> 7;
                case 204 -> 124;
                case 205 -> 56;
                case 206 -> 24;
                case 207 -> 18;
                case 208 -> 14;
                case 209 -> 97;
                case 210 -> 142;
                case 211 -> 91;
                case 212 -> 63;
                case 213 -> 65;
                case 214 -> 54;
                case 215 -> 29;
                case 216 -> 193;
                case 217 -> 83;
                case 218 -> 250;
                case 219 -> 164;
                case 220 -> 227;
                case 221 -> 206;
                case 222 -> 59;
                case 223 -> 236;
                case 224 -> 221;
                case 225 -> 108;
                case 226 -> 39;
                case 227 -> 154;
                case 228 -> 175;
                case 229 -> 163;
                case 230 -> 223;
                case 231 -> 215;
                case 232 -> 98;
                case 233 -> 37;
                case 234 -> 25;
                case 235 -> 20;
                case 236 -> 110;
                case 237 -> 85;
                case 238 -> 243;
                case 239 -> 120;
                case 240 -> 57;
                case 241 -> 0;
                case 242 -> 169;
                case 243 -> 125;
                case 244 -> 11;
                case 245 -> 112;
                case 246 -> 182;
                case 247 -> 246;
                case 248 -> 93;
                case 249 -> 15;
                case 250 -> 94;
                case 251 -> 111;
                case 252 -> 119;
                case 253 -> 219;
                case 254 -> 210;
                default -> 137;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 20406533504637L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1143847890 + (char)-18330, -1143847890 + -((char)-17131), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 94255370715562L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.d();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1981516260 + -((char)-5586), -1981516260 + -((char)-23197), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1981516260 + -((char)-5585), 1981516260 + (char)-27095, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1981516260 + -((char)-5584), -1981516260 + -((char)-26509), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "tD\u00d5#\u0002\u00c9-8\u0010\u00c5\u0083\u0012z@Y\u009cs@\u0015D\u0013j\"\u00ac\u00c1";
                    var4_3 = "tD\u00d5#\u0002\u00c9-8\u0010\u00c5\u0083\u0012z@Y\u009cs@\u0015D\u0013j\"\u00ac\u00c1".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 8;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00e3v\u009a\u00d8&5\u00f1\u0096\u00cf\u00a8^\u0087\u00fa\u00beF\u00aa\u00ab\u0099\u00dd$\u00e26\u00d2u[\u00ab\u0016~},\u00b1a\u0003\u001f\u0010\u00c0\u00bc>\u00e2\u009c\u00ee+pL\u000e\u00eaF'\f\u00b3]\u0089\u00be\u00cc?mIN1";
                        var4_3 = "\u00e3v\u009a\u00d8&5\u00f1\u0096\u00cf\u00a8^\u0087\u00fa\u00beF\u00aa\u00ab\u0099\u00dd$\u00e26\u00d2u[\u00ab\u0016~},\u00b1a\u0003\u001f\u0010\u00c0\u00bc>\u00e2\u009c\u00ee+pL\u000e\u00eaF'\f\u00b3]\u0089\u00be\u00cc?mIN1".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 95;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 1;
                                break;
                            }
                            case 1: {
                                v15 = 71;
                                break;
                            }
                            case 2: {
                                v15 = 124;
                                break;
                            }
                            case 3: {
                                v15 = 107;
                                break;
                            }
                            case 4: {
                                v15 = 16;
                                break;
                            }
                            case 5: {
                                v15 = 97;
                                break;
                            }
                            default: {
                                v15 = 72;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4A45) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 151;
                    case 1 -> 31;
                    case 2 -> 26;
                    case 3 -> 105;
                    case 4 -> 48;
                    case 5 -> 25;
                    case 6 -> 112;
                    case 7 -> 129;
                    case 8 -> 29;
                    case 9 -> 50;
                    case 10 -> 102;
                    case 11 -> 71;
                    case 12 -> 123;
                    case 13 -> 251;
                    case 14 -> 219;
                    case 15 -> 133;
                    case 16 -> 90;
                    case 17 -> 181;
                    case 18 -> 85;
                    case 19 -> 114;
                    case 20 -> 225;
                    case 21 -> 120;
                    case 22 -> 121;
                    case 23 -> 237;
                    case 24 -> 108;
                    case 25 -> 179;
                    case 26 -> 167;
                    case 27 -> 224;
                    case 28 -> 223;
                    case 29 -> 226;
                    case 30 -> 185;
                    case 31 -> 16;
                    case 32 -> 191;
                    case 33 -> 47;
                    case 34 -> 158;
                    case 35 -> 170;
                    case 36 -> 119;
                    case 37 -> 131;
                    case 38 -> 198;
                    case 39 -> 197;
                    case 40 -> 246;
                    case 41 -> 64;
                    case 42 -> 96;
                    case 43 -> 184;
                    case 44 -> 139;
                    case 45 -> 163;
                    case 46 -> 210;
                    case 47 -> 115;
                    case 48 -> 203;
                    case 49 -> 182;
                    case 50 -> 34;
                    case 51 -> 165;
                    case 52 -> 35;
                    case 53 -> 241;
                    case 54 -> 153;
                    case 55 -> 14;
                    case 56 -> 244;
                    case 57 -> 211;
                    case 58 -> 22;
                    case 59 -> 201;
                    case 60 -> 206;
                    case 61 -> 54;
                    case 62 -> 95;
                    case 63 -> 44;
                    case 64 -> 192;
                    case 65 -> 168;
                    case 66 -> 59;
                    case 67 -> 252;
                    case 68 -> 142;
                    case 69 -> 162;
                    case 70 -> 193;
                    case 71 -> 140;
                    case 72 -> 200;
                    case 73 -> 77;
                    case 74 -> 12;
                    case 75 -> 178;
                    case 76 -> 30;
                    case 77 -> 238;
                    case 78 -> 243;
                    case 79 -> 134;
                    case 80 -> 117;
                    case 81 -> 73;
                    case 82 -> 245;
                    case 83 -> 97;
                    case 84 -> 164;
                    case 85 -> 23;
                    case 86 -> 159;
                    case 87 -> 74;
                    case 88 -> 11;
                    case 89 -> 143;
                    case 90 -> 180;
                    case 91 -> 236;
                    case 92 -> 45;
                    case 93 -> 254;
                    case 94 -> 62;
                    case 95 -> 4;
                    case 96 -> 189;
                    case 97 -> 91;
                    case 98 -> 21;
                    case 99 -> 235;
                    case 100 -> 130;
                    case 101 -> 144;
                    case 102 -> 111;
                    case 103 -> 7;
                    case 104 -> 6;
                    case 105 -> 147;
                    case 106 -> 109;
                    case 107 -> 101;
                    case 108 -> 39;
                    case 109 -> 166;
                    case 110 -> 231;
                    case 111 -> 234;
                    case 112 -> 81;
                    case 113 -> 116;
                    case 114 -> 127;
                    case 115 -> 217;
                    case 116 -> 19;
                    case 117 -> 152;
                    case 118 -> 248;
                    case 119 -> 222;
                    case 120 -> 79;
                    case 121 -> 86;
                    case 122 -> 135;
                    case 123 -> 98;
                    case 124 -> 156;
                    case 125 -> 87;
                    case 126 -> 83;
                    case 127 -> 36;
                    case 128 -> 84;
                    case 129 -> 137;
                    case 130 -> 118;
                    case 131 -> 253;
                    case 132 -> 20;
                    case 133 -> 124;
                    case 134 -> 212;
                    case 135 -> 56;
                    case 136 -> 65;
                    case 137 -> 92;
                    case 138 -> 132;
                    case 139 -> 106;
                    case 140 -> 66;
                    case 141 -> 146;
                    case 142 -> 93;
                    case 143 -> 199;
                    case 144 -> 52;
                    case 145 -> 209;
                    case 146 -> 186;
                    case 147 -> 2;
                    case 148 -> 24;
                    case 149 -> 215;
                    case 150 -> 202;
                    case 151 -> 15;
                    case 152 -> 41;
                    case 153 -> 10;
                    case 154 -> 221;
                    case 155 -> 76;
                    case 156 -> 155;
                    case 157 -> 38;
                    case 158 -> 136;
                    case 159 -> 18;
                    case 160 -> 213;
                    case 161 -> 69;
                    case 162 -> 107;
                    case 163 -> 176;
                    case 164 -> 250;
                    case 165 -> 249;
                    case 166 -> 196;
                    case 167 -> 17;
                    case 168 -> 1;
                    case 169 -> 154;
                    case 170 -> 82;
                    case 171 -> 229;
                    case 172 -> 55;
                    case 173 -> 126;
                    case 174 -> 177;
                    case 175 -> 110;
                    case 176 -> 28;
                    case 177 -> 72;
                    case 178 -> 161;
                    case 179 -> 3;
                    case 180 -> 80;
                    case 181 -> 46;
                    case 182 -> 145;
                    case 183 -> 88;
                    case 184 -> 27;
                    case 185 -> 160;
                    case 186 -> 138;
                    case 187 -> 57;
                    case 188 -> 67;
                    case 189 -> 218;
                    case 190 -> 113;
                    case 191 -> 232;
                    case 192 -> 220;
                    case 193 -> 172;
                    case 194 -> 100;
                    case 195 -> 70;
                    case 196 -> 75;
                    case 197 -> 242;
                    case 198 -> 128;
                    case 199 -> 173;
                    case 200 -> 216;
                    case 201 -> 40;
                    case 202 -> 125;
                    case 203 -> 230;
                    case 204 -> 104;
                    case 205 -> 171;
                    case 206 -> 33;
                    case 207 -> 53;
                    case 208 -> 187;
                    case 209 -> 9;
                    case 210 -> 240;
                    case 211 -> 204;
                    case 212 -> 49;
                    case 213 -> 5;
                    case 214 -> 175;
                    case 215 -> 42;
                    case 216 -> 0;
                    case 217 -> 13;
                    case 218 -> 51;
                    case 219 -> 141;
                    case 220 -> 61;
                    case 221 -> 8;
                    case 222 -> 255;
                    case 223 -> 247;
                    case 224 -> 227;
                    case 225 -> 208;
                    case 226 -> 37;
                    case 227 -> 205;
                    case 228 -> 174;
                    case 229 -> 188;
                    case 230 -> 183;
                    case 231 -> 169;
                    case 232 -> 194;
                    case 233 -> 43;
                    case 234 -> 122;
                    case 235 -> 63;
                    case 236 -> 214;
                    case 237 -> 157;
                    case 238 -> 239;
                    case 239 -> 207;
                    case 240 -> 58;
                    case 241 -> 149;
                    case 242 -> 94;
                    case 243 -> 150;
                    case 244 -> 190;
                    case 245 -> 99;
                    case 246 -> 233;
                    case 247 -> 195;
                    case 248 -> 60;
                    case 249 -> 32;
                    case 250 -> 148;
                    case 251 -> 89;
                    case 252 -> 78;
                    case 253 -> 228;
                    case 254 -> 103;
                    default -> 68;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 104119788671752L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "vV\u001d\u001dofJ/\tq\\\u000e\u0017\"$W3\u001a";
                    var5_4 = "vV\u001d\u001dofJ/\tq\\\u000e\u0017\"$W3\u001a".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 64;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 93;
                                    break;
                                }
                                case 1: {
                                    v11 = 115;
                                    break;
                                }
                                case 2: {
                                    v11 = 47;
                                    break;
                                }
                                case 3: {
                                    v11 = 51;
                                    break;
                                }
                                case 4: {
                                    v11 = 74;
                                    break;
                                }
                                case 5: {
                                    v11 = 74;
                                    break;
                                }
                                default: {
                                    v11 = 57;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 134257788390008L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "J|K\u000e;x\n\u0004LbG\u0014\n@}L\u00147z\u0012j|E\t@}L\u00147z\u0012fv\rG{Q\u0019=w\bfqV\u0013<~";
                    var5_4 = "J|K\u000e;x\n\u0004LbG\u0014\n@}L\u00147z\u0012j|E\t@}L\u00147z\u0012fv\rG{Q\u0019=w\bfqV\u0013<~".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "Pn]\u0019+g\u0011\u0006Pn]\u0019'm";
                        var5_4 = "Pn]\u0019+g\u0011\u0006Pn]\u0019'm".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 82;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 65;
                                break;
                            }
                            case 1: {
                                v15 = 80;
                                break;
                            }
                            case 2: {
                                v15 = 96;
                                break;
                            }
                            case 3: {
                                v15 = 56;
                                break;
                            }
                            case 4: {
                                v15 = 16;
                                break;
                            }
                            case 5: {
                                v15 = 91;
                                break;
                            }
                            default: {
                                v15 = 36;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 86655662346844L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-402122760 + -((char)-17374), 402122760 + (char)-25661, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 19570581540244L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00cb\u0094h\u0086E\u0003b3\u00e9\u00055i\u0091\u00fd\u0099\r \u0000\u0005\u009a\u00feT\t\u00e7\u0003o\u00b4r\u0016\u0010\u0016\u00d4\u0004\u00eb\u00e1\u00ef\u00c1\u00ad\u00d3\u00a2M\u0086\u00cf\u00f9\u0010\u0082\u0005\u00a0\u009a#\u0083\u00cf3\u00ce\u00a2\u00ff\u00f3K\u00a8\u00a4Q\u0002\u00c0\u00fc\u00e3?\u0004\"\"+*\u00cdy\u00b7\u0097\u00aaHF\u00ac-$\u00de\u0096\u008bo\u001b)\u00e5Cn\u00d2\u00bb\u00edTI\u00ea\u00c9!r\u0081\u00a0\u0085ek";
                    var4_3 = "\u00cb\u0094h\u0086E\u0003b3\u00e9\u00055i\u0091\u00fd\u0099\r \u0000\u0005\u009a\u00feT\t\u00e7\u0003o\u00b4r\u0016\u0010\u0016\u00d4\u0004\u00eb\u00e1\u00ef\u00c1\u00ad\u00d3\u00a2M\u0086\u00cf\u00f9\u0010\u0082\u0005\u00a0\u009a#\u0083\u00cf3\u00ce\u00a2\u00ff\u00f3K\u00a8\u00a4Q\u0002\u00c0\u00fc\u00e3?\u0004\"\"+*\u00cdy\u00b7\u0097\u00aaHF\u00ac-$\u00de\u0096\u008bo\u001b)\u00e5Cn\u00d2\u00bb\u00edTI\u00ea\u00c9!r\u0081\u00a0\u0085ek".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 56;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u008d;\fm\u009bD\u00f5\u00a3.\u0018\u0089\u00aa,\u0007\u0017&L~\u0092\u0085\u0092\u0080s\u00f8+\u0006\u009a C\u0017\u00b4\u00e3)m\u00e1\u0081\u008d-\u0016\u00a8\u00a1^\u0001p,\u00f4\u00a5Z\u001dJ\u00f2\u00c5_#\u00f4S4\u0004\u00f4Tx\u0098\u00e1\u0006\u0091\u00fc\f\u00d7\\5\u00a3\u001e\u0087J\u00b8\u0094\u00d8\u00a6\u00b1\u00ea\u00fe\u00049iIT\u000e\u00dd\u00aeE.\u0089\u00e3";
                        var4_3 = "\u008d;\fm\u009bD\u00f5\u00a3.\u0018\u0089\u00aa,\u0007\u0017&L~\u0092\u0085\u0092\u0080s\u00f8+\u0006\u009a C\u0017\u00b4\u00e3)m\u00e1\u0081\u008d-\u0016\u00a8\u00a1^\u0001p,\u00f4\u00a5Z\u001dJ\u00f2\u00c5_#\u00f4S4\u0004\u00f4Tx\u0098\u00e1\u0006\u0091\u00fc\f\u00d7\\5\u00a3\u001e\u0087J\u00b8\u0094\u00d8\u00a6\u00b1\u00ea\u00fe\u00049iIT\u000e\u00dd\u00aeE.\u0089\u00e3".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 105;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 88;
                                break;
                            }
                            case 1: {
                                v15 = 79;
                                break;
                            }
                            case 2: {
                                v15 = 13;
                                break;
                            }
                            case 3: {
                                v15 = 39;
                                break;
                            }
                            case 4: {
                                v15 = 107;
                                break;
                            }
                            case 5: {
                                v15 = 90;
                                break;
                            }
                            default: {
                                v15 = 120;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF898A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 140;
                    case 1 -> 21;
                    case 2 -> 215;
                    case 3 -> 231;
                    case 4 -> 252;
                    case 5 -> 150;
                    case 6 -> 42;
                    case 7 -> 28;
                    case 8 -> 103;
                    case 9 -> 78;
                    case 10 -> 218;
                    case 11 -> 175;
                    case 12 -> 195;
                    case 13 -> 126;
                    case 14 -> 235;
                    case 15 -> 243;
                    case 16 -> 129;
                    case 17 -> 93;
                    case 18 -> 158;
                    case 19 -> 251;
                    case 20 -> 27;
                    case 21 -> 210;
                    case 22 -> 207;
                    case 23 -> 95;
                    case 24 -> 130;
                    case 25 -> 23;
                    case 26 -> 119;
                    case 27 -> 248;
                    case 28 -> 113;
                    case 29 -> 31;
                    case 30 -> 168;
                    case 31 -> 67;
                    case 32 -> 45;
                    case 33 -> 181;
                    case 34 -> 94;
                    case 35 -> 142;
                    case 36 -> 237;
                    case 37 -> 72;
                    case 38 -> 146;
                    case 39 -> 3;
                    case 40 -> 190;
                    case 41 -> 53;
                    case 42 -> 73;
                    case 43 -> 33;
                    case 44 -> 108;
                    case 45 -> 114;
                    case 46 -> 120;
                    case 47 -> 81;
                    case 48 -> 68;
                    case 49 -> 9;
                    case 50 -> 193;
                    case 51 -> 5;
                    case 52 -> 128;
                    case 53 -> 6;
                    case 54 -> 56;
                    case 55 -> 224;
                    case 56 -> 186;
                    case 57 -> 24;
                    case 58 -> 239;
                    case 59 -> 65;
                    case 60 -> 255;
                    case 61 -> 197;
                    case 62 -> 174;
                    case 63 -> 246;
                    case 64 -> 115;
                    case 65 -> 212;
                    case 66 -> 144;
                    case 67 -> 155;
                    case 68 -> 91;
                    case 69 -> 145;
                    case 70 -> 17;
                    case 71 -> 188;
                    case 72 -> 39;
                    case 73 -> 47;
                    case 74 -> 102;
                    case 75 -> 184;
                    case 76 -> 26;
                    case 77 -> 167;
                    case 78 -> 176;
                    case 79 -> 84;
                    case 80 -> 157;
                    case 81 -> 228;
                    case 82 -> 162;
                    case 83 -> 138;
                    case 84 -> 43;
                    case 85 -> 208;
                    case 86 -> 225;
                    case 87 -> 40;
                    case 88 -> 83;
                    case 89 -> 7;
                    case 90 -> 226;
                    case 91 -> 141;
                    case 92 -> 55;
                    case 93 -> 180;
                    case 94 -> 131;
                    case 95 -> 63;
                    case 96 -> 242;
                    case 97 -> 79;
                    case 98 -> 58;
                    case 99 -> 132;
                    case 100 -> 46;
                    case 101 -> 100;
                    case 102 -> 98;
                    case 103 -> 230;
                    case 104 -> 90;
                    case 105 -> 117;
                    case 106 -> 134;
                    case 107 -> 250;
                    case 108 -> 159;
                    case 109 -> 164;
                    case 110 -> 223;
                    case 111 -> 179;
                    case 112 -> 125;
                    case 113 -> 137;
                    case 114 -> 69;
                    case 115 -> 86;
                    case 116 -> 178;
                    case 117 -> 154;
                    case 118 -> 1;
                    case 119 -> 74;
                    case 120 -> 198;
                    case 121 -> 62;
                    case 122 -> 152;
                    case 123 -> 70;
                    case 124 -> 221;
                    case 125 -> 234;
                    case 126 -> 64;
                    case 127 -> 12;
                    case 128 -> 127;
                    case 129 -> 161;
                    case 130 -> 171;
                    case 131 -> 76;
                    case 132 -> 110;
                    case 133 -> 16;
                    case 134 -> 116;
                    case 135 -> 177;
                    case 136 -> 10;
                    case 137 -> 32;
                    case 138 -> 185;
                    case 139 -> 22;
                    case 140 -> 49;
                    case 141 -> 87;
                    case 142 -> 170;
                    case 143 -> 236;
                    case 144 -> 41;
                    case 145 -> 19;
                    case 146 -> 233;
                    case 147 -> 88;
                    case 148 -> 34;
                    case 149 -> 201;
                    case 150 -> 156;
                    case 151 -> 227;
                    case 152 -> 35;
                    case 153 -> 123;
                    case 154 -> 60;
                    case 155 -> 254;
                    case 156 -> 220;
                    case 157 -> 52;
                    case 158 -> 101;
                    case 159 -> 77;
                    case 160 -> 8;
                    case 161 -> 51;
                    case 162 -> 143;
                    case 163 -> 136;
                    case 164 -> 54;
                    case 165 -> 222;
                    case 166 -> 118;
                    case 167 -> 104;
                    case 168 -> 111;
                    case 169 -> 192;
                    case 170 -> 172;
                    case 171 -> 205;
                    case 172 -> 183;
                    case 173 -> 214;
                    case 174 -> 75;
                    case 175 -> 163;
                    case 176 -> 25;
                    case 177 -> 187;
                    case 178 -> 89;
                    case 179 -> 173;
                    case 180 -> 249;
                    case 181 -> 80;
                    case 182 -> 240;
                    case 183 -> 245;
                    case 184 -> 29;
                    case 185 -> 20;
                    case 186 -> 199;
                    case 187 -> 59;
                    case 188 -> 213;
                    case 189 -> 219;
                    case 190 -> 147;
                    case 191 -> 92;
                    case 192 -> 82;
                    case 193 -> 194;
                    case 194 -> 196;
                    case 195 -> 37;
                    case 196 -> 124;
                    case 197 -> 30;
                    case 198 -> 71;
                    case 199 -> 189;
                    case 200 -> 112;
                    case 201 -> 203;
                    case 202 -> 165;
                    case 203 -> 209;
                    case 204 -> 121;
                    case 205 -> 11;
                    case 206 -> 206;
                    case 207 -> 36;
                    case 208 -> 99;
                    case 209 -> 217;
                    case 210 -> 109;
                    case 211 -> 153;
                    case 212 -> 122;
                    case 213 -> 105;
                    case 214 -> 169;
                    case 215 -> 85;
                    case 216 -> 232;
                    case 217 -> 211;
                    case 218 -> 182;
                    case 219 -> 14;
                    case 220 -> 107;
                    case 221 -> 66;
                    case 222 -> 241;
                    case 223 -> 229;
                    case 224 -> 96;
                    case 225 -> 151;
                    case 226 -> 160;
                    case 227 -> 48;
                    case 228 -> 50;
                    case 229 -> 106;
                    case 230 -> 133;
                    case 231 -> 204;
                    case 232 -> 238;
                    case 233 -> 97;
                    case 234 -> 253;
                    case 235 -> 135;
                    case 236 -> 44;
                    case 237 -> 13;
                    case 238 -> 57;
                    case 239 -> 139;
                    case 240 -> 61;
                    case 241 -> 244;
                    case 242 -> 15;
                    case 243 -> 149;
                    case 244 -> 4;
                    case 245 -> 0;
                    case 246 -> 216;
                    case 247 -> 2;
                    case 248 -> 38;
                    case 249 -> 148;
                    case 250 -> 247;
                    case 251 -> 166;
                    case 252 -> 18;
                    case 253 -> 191;
                    case 254 -> 202;
                    default -> 200;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 83494817078983L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-652859670 - -14195, 652859670 + 4130, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 90542741037255L;
                    int[] nArray = SshAgentIpcService.d();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-535420950 + -((char)-16498), -535420950 + -((char)-9784), (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 120489263591325L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u009d6\u00d9\u00cc\u00d3\u0003\u00fe\u00e9\u00e3";
                var4_3 = "\u009d6\u00d9\u00cc\u00d3\u0003\u00fe\u00e9\u00e3".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 115;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 43;
                                break;
                            }
                            case 1: {
                                v11 = 62;
                                break;
                            }
                            case 2: {
                                v11 = 58;
                                break;
                            }
                            case 3: {
                                v11 = 53;
                                break;
                            }
                            case 4: {
                                v11 = 15;
                                break;
                            }
                            case 5: {
                                v11 = 74;
                                break;
                            }
                            default: {
                                v11 = 20;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFC09A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 4;
                    case 1 -> 178;
                    case 2 -> 59;
                    case 3 -> 41;
                    case 4 -> 223;
                    case 5 -> 250;
                    case 6 -> 37;
                    case 7 -> 65;
                    case 8 -> 40;
                    case 9 -> 38;
                    case 10 -> 167;
                    case 11 -> 98;
                    case 12 -> 202;
                    case 13 -> 163;
                    case 14 -> 191;
                    case 15 -> 135;
                    case 16 -> 92;
                    case 17 -> 183;
                    case 18 -> 20;
                    case 19 -> 0;
                    case 20 -> 36;
                    case 21 -> 149;
                    case 22 -> 18;
                    case 23 -> 180;
                    case 24 -> 143;
                    case 25 -> 124;
                    case 26 -> 23;
                    case 27 -> 138;
                    case 28 -> 195;
                    case 29 -> 208;
                    case 30 -> 25;
                    case 31 -> 10;
                    case 32 -> 66;
                    case 33 -> 129;
                    case 34 -> 31;
                    case 35 -> 244;
                    case 36 -> 188;
                    case 37 -> 247;
                    case 38 -> 83;
                    case 39 -> 132;
                    case 40 -> 64;
                    case 41 -> 29;
                    case 42 -> 231;
                    case 43 -> 70;
                    case 44 -> 200;
                    case 45 -> 58;
                    case 46 -> 165;
                    case 47 -> 72;
                    case 48 -> 112;
                    case 49 -> 115;
                    case 50 -> 150;
                    case 51 -> 90;
                    case 52 -> 61;
                    case 53 -> 254;
                    case 54 -> 111;
                    case 55 -> 211;
                    case 56 -> 126;
                    case 57 -> 213;
                    case 58 -> 77;
                    case 59 -> 224;
                    case 60 -> 131;
                    case 61 -> 95;
                    case 62 -> 80;
                    case 63 -> 237;
                    case 64 -> 93;
                    case 65 -> 241;
                    case 66 -> 5;
                    case 67 -> 161;
                    case 68 -> 19;
                    case 69 -> 226;
                    case 70 -> 55;
                    case 71 -> 151;
                    case 72 -> 139;
                    case 73 -> 17;
                    case 74 -> 89;
                    case 75 -> 164;
                    case 76 -> 197;
                    case 77 -> 162;
                    case 78 -> 125;
                    case 79 -> 107;
                    case 80 -> 46;
                    case 81 -> 57;
                    case 82 -> 74;
                    case 83 -> 255;
                    case 84 -> 32;
                    case 85 -> 104;
                    case 86 -> 6;
                    case 87 -> 210;
                    case 88 -> 142;
                    case 89 -> 168;
                    case 90 -> 69;
                    case 91 -> 119;
                    case 92 -> 11;
                    case 93 -> 234;
                    case 94 -> 170;
                    case 95 -> 176;
                    case 96 -> 175;
                    case 97 -> 109;
                    case 98 -> 145;
                    case 99 -> 130;
                    case 100 -> 229;
                    case 101 -> 39;
                    case 102 -> 172;
                    case 103 -> 242;
                    case 104 -> 13;
                    case 105 -> 21;
                    case 106 -> 240;
                    case 107 -> 117;
                    case 108 -> 43;
                    case 109 -> 1;
                    case 110 -> 177;
                    case 111 -> 246;
                    case 112 -> 110;
                    case 113 -> 133;
                    case 114 -> 225;
                    case 115 -> 199;
                    case 116 -> 184;
                    case 117 -> 251;
                    case 118 -> 50;
                    case 119 -> 102;
                    case 120 -> 3;
                    case 121 -> 155;
                    case 122 -> 147;
                    case 123 -> 120;
                    case 124 -> 35;
                    case 125 -> 52;
                    case 126 -> 215;
                    case 127 -> 206;
                    case 128 -> 248;
                    case 129 -> 166;
                    case 130 -> 116;
                    case 131 -> 34;
                    case 132 -> 153;
                    case 133 -> 103;
                    case 134 -> 189;
                    case 135 -> 22;
                    case 136 -> 26;
                    case 137 -> 207;
                    case 138 -> 97;
                    case 139 -> 171;
                    case 140 -> 121;
                    case 141 -> 15;
                    case 142 -> 190;
                    case 143 -> 75;
                    case 144 -> 24;
                    case 145 -> 181;
                    case 146 -> 182;
                    case 147 -> 220;
                    case 148 -> 233;
                    case 149 -> 84;
                    case 150 -> 137;
                    case 151 -> 209;
                    case 152 -> 128;
                    case 153 -> 42;
                    case 154 -> 44;
                    case 155 -> 76;
                    case 156 -> 193;
                    case 157 -> 185;
                    case 158 -> 198;
                    case 159 -> 194;
                    case 160 -> 48;
                    case 161 -> 252;
                    case 162 -> 204;
                    case 163 -> 30;
                    case 164 -> 174;
                    case 165 -> 253;
                    case 166 -> 16;
                    case 167 -> 68;
                    case 168 -> 114;
                    case 169 -> 45;
                    case 170 -> 101;
                    case 171 -> 154;
                    case 172 -> 236;
                    case 173 -> 196;
                    case 174 -> 85;
                    case 175 -> 49;
                    case 176 -> 173;
                    case 177 -> 54;
                    case 178 -> 159;
                    case 179 -> 28;
                    case 180 -> 81;
                    case 181 -> 118;
                    case 182 -> 214;
                    case 183 -> 219;
                    case 184 -> 2;
                    case 185 -> 245;
                    case 186 -> 99;
                    case 187 -> 12;
                    case 188 -> 217;
                    case 189 -> 179;
                    case 190 -> 136;
                    case 191 -> 108;
                    case 192 -> 88;
                    case 193 -> 201;
                    case 194 -> 227;
                    case 195 -> 192;
                    case 196 -> 235;
                    case 197 -> 91;
                    case 198 -> 47;
                    case 199 -> 86;
                    case 200 -> 53;
                    case 201 -> 82;
                    case 202 -> 218;
                    case 203 -> 94;
                    case 204 -> 62;
                    case 205 -> 9;
                    case 206 -> 7;
                    case 207 -> 71;
                    case 208 -> 203;
                    case 209 -> 33;
                    case 210 -> 100;
                    case 211 -> 212;
                    case 212 -> 140;
                    case 213 -> 157;
                    case 214 -> 221;
                    case 215 -> 160;
                    case 216 -> 144;
                    case 217 -> 243;
                    case 218 -> 87;
                    case 219 -> 67;
                    case 220 -> 232;
                    case 221 -> 216;
                    case 222 -> 239;
                    case 223 -> 122;
                    case 224 -> 230;
                    case 225 -> 141;
                    case 226 -> 63;
                    case 227 -> 186;
                    case 228 -> 222;
                    case 229 -> 134;
                    case 230 -> 169;
                    case 231 -> 56;
                    case 232 -> 8;
                    case 233 -> 14;
                    case 234 -> 113;
                    case 235 -> 156;
                    case 236 -> 73;
                    case 237 -> 127;
                    case 238 -> 146;
                    case 239 -> 105;
                    case 240 -> 158;
                    case 241 -> 78;
                    case 242 -> 205;
                    case 243 -> 106;
                    case 244 -> 228;
                    case 245 -> 27;
                    case 246 -> 238;
                    case 247 -> 249;
                    case 248 -> 79;
                    case 249 -> 51;
                    case 250 -> 148;
                    case 251 -> 187;
                    case 252 -> 152;
                    case 253 -> 123;
                    case 254 -> 96;
                    default -> 60;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

