/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.sequence.BasedOptionsHolder;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import com.vladsch.flexmark.util.sequence.IRichSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import com.vladsch.flexmark.util.sequence.builder.tree.SegmentTree;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasedSequence
extends IRichSequence<BasedSequence>,
BasedOptionsHolder {
    public static final BasedSequence NULL = new EmptyBasedSequence();
    public static final BasedSequence EMPTY = new EmptyBasedSequence();
    public static final BasedSequence EOL = CharSubSequence.of("\n");
    public static final BasedSequence SPACE = CharSubSequence.of(" ");
    public static final List<BasedSequence> EMPTY_LIST = new ArrayList<BasedSequence>();
    public static final BasedSequence[] EMPTY_ARRAY = new BasedSequence[0];
    public static final BasedSequence[] EMPTY_SEGMENTS = new BasedSequence[0];
    public static final BasedSequence LINE_SEP = CharSubSequence.of(SequenceUtils.LINE_SEP);

    @NotNull
    public static BasedSequence of(@Nullable CharSequence charSequence) {
        return BasedSequenceImpl.create(charSequence);
    }

    @NotNull
    public static BasedSequence ofSpaces(int count) {
        return BasedSequence.of(RepeatedSequence.ofSpaces(count));
    }

    @NotNull
    public static BasedSequence repeatOf(char c, int count) {
        return BasedSequence.of(RepeatedSequence.repeatOf(String.valueOf(c), 0, count));
    }

    @NotNull
    public static BasedSequence repeatOf(@NotNull CharSequence chars, int count) {
        return BasedSequence.of(RepeatedSequence.repeatOf(chars, 0, chars.length() * count));
    }

    @NotNull
    public static BasedSequence repeatOf(@NotNull CharSequence chars, int startIndex, int endIndex) {
        return BasedSequence.of(RepeatedSequence.repeatOf(chars, startIndex, endIndex));
    }

    @Override
    @NotNull
    public SequenceBuilder getBuilder();

    @NotNull
    public Object getBase();

    @NotNull
    public BasedSequence getBaseSequence();

    public int getStartOffset();

    public int getEndOffset();

    public int getIndexOffset(int var1);

    public void addSegments(@NotNull IBasedSegmentBuilder<?> var1);

    @NotNull
    public SegmentTree getSegmentTree();

    @NotNull
    public Range getSourceRange();

    @Override
    @NotNull
    public BasedSequence subSequence(int var1, int var2);

    @NotNull
    public BasedSequence baseSubSequence(int var1, int var2);

    @NotNull
    public BasedSequence baseSubSequence(int var1);

    public char safeBaseCharAt(int var1);

    public boolean isBaseCharAt(int var1, @NotNull CharPredicate var2);

    @NotNull
    public BasedSequence getEmptyPrefix();

    @NotNull
    public BasedSequence getEmptySuffix();

    @NotNull
    public String unescape();

    @NotNull
    public String unescapeNoEntities();

    @NotNull
    public BasedSequence unescape(@NotNull ReplacedTextMapper var1);

    @NotNull
    public BasedSequence normalizeEOL(@NotNull ReplacedTextMapper var1);

    @NotNull
    public BasedSequence normalizeEndWithEOL(@NotNull ReplacedTextMapper var1);

    public boolean isContinuedBy(@NotNull BasedSequence var1);

    public boolean isContinuationOf(@NotNull BasedSequence var1);

    @NotNull
    public BasedSequence spliceAtEnd(@NotNull BasedSequence var1);

    public boolean containsAllOf(@NotNull BasedSequence var1);

    public boolean containsSomeOf(@NotNull BasedSequence var1);

    @NotNull
    public BasedSequence prefixOf(@NotNull BasedSequence var1);

    @NotNull
    public BasedSequence suffixOf(@NotNull BasedSequence var1);

    @NotNull
    public BasedSequence intersect(@NotNull BasedSequence var1);

    @NotNull
    public BasedSequence extendByAny(@NotNull CharPredicate var1, int var2);

    @NotNull
    public BasedSequence extendByAny(@NotNull CharPredicate var1);

    @NotNull
    public BasedSequence extendByOneOfAny(@NotNull CharPredicate var1);

    public boolean containsSomeIn(@NotNull CharPredicate var1);

    public boolean containsSomeNotIn(@NotNull CharPredicate var1);

    public boolean containsOnlyIn(@NotNull CharPredicate var1);

    public boolean containsOnlyNotIn(@NotNull CharPredicate var1);

    @NotNull
    public BasedSequence extendByAnyNot(@NotNull CharPredicate var1, int var2);

    @NotNull
    public BasedSequence extendByAnyNot(@NotNull CharPredicate var1);

    @NotNull
    public BasedSequence extendByOneOfAnyNot(@NotNull CharPredicate var1);

    @Deprecated
    @NotNull
    default public BasedSequence extendToAny(@NotNull CharPredicate charSet, int maxCount) {
        return this.extendByAnyNot(charSet, maxCount);
    }

    @Deprecated
    @NotNull
    default public BasedSequence extendToAny(@NotNull CharPredicate charSet) {
        return this.extendByAnyNot(charSet);
    }

    @NotNull
    public BasedSequence extendToEndOfLine(@NotNull CharPredicate var1, boolean var2);

    @NotNull
    public BasedSequence extendToEndOfLine(@NotNull CharPredicate var1);

    @NotNull
    public BasedSequence extendToEndOfLine(boolean var1);

    @NotNull
    public BasedSequence extendToEndOfLine();

    @NotNull
    public BasedSequence extendToStartOfLine(@NotNull CharPredicate var1, boolean var2);

    @NotNull
    public BasedSequence extendToStartOfLine(@NotNull CharPredicate var1);

    @NotNull
    public BasedSequence extendToStartOfLine(boolean var1);

    @NotNull
    public BasedSequence extendToStartOfLine();

    @NotNull
    public BasedSequence prefixWithIndent(int var1);

    @NotNull
    public BasedSequence prefixWithIndent();

    @NotNull
    public Pair<Integer, Integer> baseLineColumnAtIndex(int var1);

    @NotNull
    public Range baseLineRangeAtIndex(int var1);

    public int baseEndOfLine(int var1);

    public int baseEndOfLineAnyEOL(int var1);

    public int baseStartOfLine(int var1);

    public int baseStartOfLineAnyEOL(int var1);

    public int baseColumnAtIndex(int var1);

    @NotNull
    public Pair<Integer, Integer> baseLineColumnAtStart();

    @NotNull
    public Pair<Integer, Integer> baseLineColumnAtEnd();

    public int baseEndOfLine();

    public int baseEndOfLineAnyEOL();

    public int baseStartOfLine();

    public int baseStartOfLineAnyEOL();

    @NotNull
    public Range baseLineRangeAtStart();

    @NotNull
    public Range baseLineRangeAtEnd();

    public int baseColumnAtEnd();

    public int baseColumnAtStart();

    public static class EmptyBasedSequence
    extends BasedSequenceImpl {
        public EmptyBasedSequence() {
            super(0);
        }

        @Override
        public int getOptionFlags() {
            return 0;
        }

        @Override
        public boolean allOptions(int options) {
            return false;
        }

        @Override
        public boolean anyOptions(int options) {
            return false;
        }

        @Override
        public <T> T getOption(DataKeyBase<T> dataKey) {
            return dataKey.get(null);
        }

        @Override
        @Nullable
        public DataHolder getOptions() {
            return null;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            throw new StringIndexOutOfBoundsException("EMPTY sequence has no characters");
        }

        @Override
        public int getIndexOffset(int index) {
            SequenceUtils.validateIndexInclusiveEnd(index, this.length());
            return 0;
        }

        @Override
        @NotNull
        public BasedSequence subSequence(int i, int i1) {
            SequenceUtils.validateStartEnd(i, i1, this.length());
            return this;
        }

        @Override
        @NotNull
        public BasedSequence baseSubSequence(int startIndex, int endIndex) {
            return this.subSequence(startIndex, endIndex);
        }

        @Override
        @NotNull
        public BasedSequence getBaseSequence() {
            return this;
        }

        @Override
        @NotNull
        public BasedSequence getBase() {
            return this;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return 0;
        }

        @Override
        @NotNull
        public Range getSourceRange() {
            return Range.NULL;
        }
    }
}

