/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DColor;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;

public class PdfBoxGraphics2DColor
extends Color
implements IPdfBoxGraphics2DColor {
    private final PDColor color;
    private final int alpha;
    private final boolean overprint;

    public PdfBoxGraphics2DColor(PDColor color) {
        this(color, 255);
    }

    public PdfBoxGraphics2DColor(PDColor color, int alpha) {
        this(color, alpha, false);
    }

    public PdfBoxGraphics2DColor(PDColor color, int alpha, boolean overprint) {
        super(PdfBoxGraphics2DColor.toRGBValue(color, alpha));
        this.color = color;
        this.alpha = alpha;
        this.overprint = overprint;
    }

    private static int toRGBValue(PDColor color, int alpha) {
        try {
            return color.toRGB() & 0xFFFFFF | alpha << 24;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public boolean isOverprint() {
        return this.overprint;
    }

    @Override
    public PDColor toPDColor() {
        return this.color;
    }
}

