/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.util.estimators;

import com.jetbrains.rd.platform.util.estimators.P2QuantileEstimator;
import com.jetbrains.rd.platform.util.estimators.ValueEstimator;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.Property;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rd/platform/util/estimators/MovingP2QuantileEstimator;", "Lcom/jetbrains/rd/platform/util/estimators/ValueEstimator;", "", "probability", "windowSize", "", "<init>", "(DI)V", "currentWindowEstimator", "Lcom/jetbrains/rd/platform/util/estimators/P2QuantileEstimator;", "n", "previousWindowEstimation", "estimationProperty", "Lcom/jetbrains/rd/util/reactive/IProperty;", "estimation", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getEstimation", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "addValue", "", "value", "clear", "intellij.rd.platform"})
public final class MovingP2QuantileEstimator
implements ValueEstimator<Double> {
    private final int windowSize;
    @NotNull
    private final P2QuantileEstimator currentWindowEstimator;
    private int n;
    private double previousWindowEstimation;
    @NotNull
    private final IProperty<Double> estimationProperty;
    @NotNull
    private final IPropertyView<Double> estimation;

    public MovingP2QuantileEstimator(double probability, int windowSize) {
        this.windowSize = windowSize;
        this.currentWindowEstimator = new P2QuantileEstimator(probability);
        this.estimationProperty = (IProperty)new Property(null);
        this.estimation = (IPropertyView)this.estimationProperty;
    }

    @Override
    @NotNull
    public IPropertyView<Double> getEstimation() {
        return this.estimation;
    }

    @Override
    public void addValue(double value) {
        if (this.n == this.windowSize) {
            this.previousWindowEstimation = this.currentWindowEstimator.getQuantile();
            this.currentWindowEstimator.clear();
        }
        this.n = this.n % this.windowSize + 1;
        this.currentWindowEstimator.addValue(value);
        this.estimationProperty.set((Object)this.getEstimation());
    }

    @Override
    public void clear() {
        this.n = 0;
        this.previousWindowEstimation = 0.0;
        this.currentWindowEstimator.clear();
        this.estimationProperty.set(null);
    }

    private final double getEstimation() {
        double currentWindowEstimation = this.currentWindowEstimator.getQuantile();
        double currentWindowWeight = (double)this.n * 1.0 / (double)this.windowSize;
        double previousWindowWeight = 1.0 - currentWindowWeight;
        return previousWindowWeight * this.previousWindowEstimation + currentWindowWeight * currentWindowEstimation;
    }
}

