/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.run.task.state;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.ResolvedPortBindingKt;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentExtKt;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ktor.run.KtorRunConfiguration;
import com.intellij.ktor.run.task.state.KtorServerConfiguration;
import com.intellij.ktor.run.task.state.KtorServerConfigurationKt;
import com.intellij.ktor.run.task.state.KtorTaskState;
import com.intellij.microservices.http.request.NavigatorHttpRequest;
import com.intellij.microservices.jvm.util.PortBindingNotificationPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.ui.IdeBorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/intellij/ktor/run/task/state/KtorTaskState;", "Lcom/intellij/task/RunConfigurationTaskState;", "configuration", "Lcom/intellij/ktor/run/KtorRunConfiguration;", "isDelegatedToGradle", "", "javaParams", "Lkotlin/Function0;", "Lcom/intellij/execution/configurations/JavaParameters;", "<init>", "(Lcom/intellij/ktor/run/KtorRunConfiguration;ZLkotlin/jvm/functions/Function0;)V", "ktorServerConfiguration", "Lcom/intellij/ktor/run/task/state/KtorServerConfiguration;", "getKtorServerConfiguration", "()Lcom/intellij/ktor/run/task/state/KtorServerConfiguration;", "setKtorServerConfiguration", "(Lcom/intellij/ktor/run/task/state/KtorServerConfiguration;)V", "prepareTargetEnvironmentRequest", "", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "handleCreatedTargetEnvironment", "", "environment", "Lcom/intellij/execution/target/TargetEnvironment;", "processExecutionResult", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "console", "Lcom/intellij/execution/ui/ExecutionConsole;", "addPortBindingPanel", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "processHandler", "serverConfiguration", "intellij.ktor"})
public final class KtorTaskState
implements RunConfigurationTaskState {
    @NotNull
    private final KtorRunConfiguration configuration;
    private final boolean isDelegatedToGradle;
    @NotNull
    private final Function0<JavaParameters> javaParams;
    @Nullable
    private KtorServerConfiguration ktorServerConfiguration;

    public KtorTaskState(@NotNull KtorRunConfiguration configuration, boolean isDelegatedToGradle, @NotNull Function0<? extends JavaParameters> javaParams) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter(javaParams, (String)"javaParams");
        this.configuration = configuration;
        this.isDelegatedToGradle = isDelegatedToGradle;
        this.javaParams = javaParams;
    }

    @Nullable
    public final KtorServerConfiguration getKtorServerConfiguration() {
        return this.ktorServerConfiguration;
    }

    public final void setKtorServerConfiguration(@Nullable KtorServerConfiguration ktorServerConfiguration) {
        this.ktorServerConfiguration = ktorServerConfiguration;
    }

    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        Module module = ((JavaRunConfigurationModule)this.configuration.getConfigurationModule()).getModule();
        if (module == null) {
            return;
        }
        Module module2 = module;
        KtorServerConfiguration ktorServerConfiguration = (KtorServerConfiguration)com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super KtorServerConfiguration>, Object>(module2, this, null){
            int label;
            final /* synthetic */ Module $module;
            final /* synthetic */ KtorTaskState this$0;
            {
                this.$module = $module;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.readAction(() -> prepareTargetEnvironmentRequest.serverConfiguration.1.invokeSuspend$lambda$0(this.$module, this.this$0), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super KtorServerConfiguration> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final KtorServerConfiguration invokeSuspend$lambda$0(Module $module, KtorTaskState this$0) {
                return KtorServerConfigurationKt.getServerConfiguration($module, (JavaParameters)KtorTaskState.access$getJavaParams$p(this$0).invoke());
            }
        }));
        if (ktorServerConfiguration == null) {
            return;
        }
        KtorServerConfiguration serverConfiguration2 = ktorServerConfiguration;
        if (!(request instanceof LocalTargetEnvironmentRequest)) {
            request.getTargetPortBindings().add(new TargetEnvironment.TargetPortBinding(null, serverConfiguration2.getServerPort()));
        }
        this.ktorServerConfiguration = serverConfiguration2;
    }

    @Nullable
    public String handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        KtorServerConfiguration ktorServerConfiguration = this.ktorServerConfiguration;
        if (ktorServerConfiguration == null) {
            return null;
        }
        KtorServerConfiguration configuration = ktorServerConfiguration;
        ResolvedPortBinding resolvedPortBinding = TargetEnvironmentExtKt.findTargetPortBinding((TargetEnvironment)environment, (int)configuration.getServerPort());
        if (resolvedPortBinding == null) {
            return null;
        }
        int localServerPort = ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)resolvedPortBinding);
        configuration.setServerPort(localServerPort);
        return null;
    }

    public void processExecutionResult(@NotNull ProcessHandler handler, @NotNull ExecutionConsole console) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        KtorServerConfiguration ktorServerConfiguration = this.ktorServerConfiguration;
        if (ktorServerConfiguration == null) {
            return;
        }
        KtorServerConfiguration serverConfiguration2 = ktorServerConfiguration;
        handler.putUserData(KtorServerConfigurationKt.getSERVER_CONFIGURATION_KEY(), (Object)serverConfiguration2);
        if (serverConfiguration2.getServerPort() != serverConfiguration2.getOriginPort() && console instanceof ConsoleViewImpl) {
            this.addPortBindingPanel((ConsoleViewImpl)console, handler, serverConfiguration2);
        }
        RunDashboardManager.getInstance((Project)this.configuration.getProject()).updateDashboard(false);
    }

    private final void addPortBindingPanel(ConsoleViewImpl console, ProcessHandler processHandler, KtorServerConfiguration serverConfiguration2) {
        ApplicationManager.getApplication().invokeLater(() -> KtorTaskState.addPortBindingPanel$lambda$0(serverConfiguration2, this, processHandler, console), arg_0 -> KtorTaskState.addPortBindingPanel$lambda$1(console, arg_0));
    }

    private static final void addPortBindingPanel$lambda$0(KtorServerConfiguration $serverConfiguration, KtorTaskState this$0, ProcessHandler $processHandler, ConsoleViewImpl $console) {
        NavigatorHttpRequest request = new NavigatorHttpRequest($serverConfiguration.getApplicationUrl(), "GET", CollectionsKt.emptyList(), CollectionsKt.emptyList());
        Project project = this$0.configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = this$0.configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        PortBindingNotificationPanel panel = new PortBindingNotificationPanel(project, request, string, $serverConfiguration.getOriginPort(), $serverConfiguration.getServerPort());
        panel.registerProcessListener($processHandler, (Disposable)$console);
        JPanel jPanel = ServiceViewUIUtils.getServicesAlignedPanelWrapper((JComponent)((JComponent)panel));
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getServicesAlignedPanelWrapper(...)");
        JPanel wrapper = jPanel;
        wrapper.setBorder(this$0.isDelegatedToGradle ? IdeBorderFactory.createBorder((int)12) : IdeBorderFactory.createBorder((int)8));
        $console.addNotificationComponent((JComponent)wrapper);
    }

    private static final boolean addPortBindingPanel$lambda$1(ConsoleViewImpl $console, Object it) {
        return Disposer.isDisposed((Disposable)((Disposable)$console));
    }

    public static final /* synthetic */ Function0 access$getJavaParams$p(KtorTaskState $this) {
        return $this.javaParams;
    }
}

