/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.php;

import com.intellij.openapi.project.Project;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.projectDescription.QodanaProjectDescriber;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/qodana/php/PhpInterpreterProjectDescriber;", "Lorg/jetbrains/qodana/staticAnalysis/projectDescription/QodanaProjectDescriber;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "description", "Lorg/jetbrains/qodana/php/PhpInterpreterProjectDescriber$InterpreterDescription;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "InterpreterDescription", "intellij.qodana.php"})
public final class PhpInterpreterProjectDescriber
implements QodanaProjectDescriber {
    @NotNull
    private final String id;

    public PhpInterpreterProjectDescriber() {
        String string = PhpBundle.message((String)"PhpInterpreter.php.sdk.type", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.id = string;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public Object description(@NotNull Project project, @NotNull Continuation<? super InterpreterDescription> $completion) {
        PhpProjectConfigurationFacade instance = PhpProjectConfigurationFacade.getInstance((Project)project);
        PhpInterpreter phpInterpreter = instance.getInterpreter();
        PhpLanguageLevel phpLanguageLevel = instance.getLanguageLevel();
        Intrinsics.checkNotNullExpressionValue((Object)phpLanguageLevel, (String)"getLanguageLevel(...)");
        return new InterpreterDescription(phpInterpreter, phpLanguageLevel);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\b\u0010\nR\u0015\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\f\u0010\nR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/qodana/php/PhpInterpreterProjectDescriber$InterpreterDescription;", "", "interpreter", "Lcom/jetbrains/php/config/interpreters/PhpInterpreter;", "level", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "<init>", "(Lcom/jetbrains/php/config/interpreters/PhpInterpreter;Lcom/jetbrains/php/config/PhpLanguageLevel;)V", "isRemote", "", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "isProjectLevel", "pathToPhpExecutable", "", "getPathToPhpExecutable", "()Ljava/lang/String;", "homePath", "getHomePath", "getLevel", "intellij.qodana.php"})
    public static final class InterpreterDescription {
        @Nullable
        private final Boolean isRemote;
        @Nullable
        private final Boolean isProjectLevel;
        @Nullable
        private final String pathToPhpExecutable;
        @Nullable
        private final String homePath;
        @NotNull
        private final String level;

        public InterpreterDescription(@Nullable PhpInterpreter interpreter, @NotNull PhpLanguageLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            PhpInterpreter phpInterpreter = interpreter;
            this.isRemote = phpInterpreter != null ? Boolean.valueOf(phpInterpreter.isRemote()) : null;
            PhpInterpreter phpInterpreter2 = interpreter;
            this.isProjectLevel = phpInterpreter2 != null ? Boolean.valueOf(phpInterpreter2.isProjectLevel()) : null;
            PhpInterpreter phpInterpreter3 = interpreter;
            this.pathToPhpExecutable = phpInterpreter3 != null ? phpInterpreter3.getPathToPhpExecutable() : null;
            PhpInterpreter phpInterpreter4 = interpreter;
            this.homePath = phpInterpreter4 != null ? phpInterpreter4.getHomePath() : null;
            String string = level.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            this.level = string;
        }

        @Nullable
        public final Boolean isRemote() {
            return this.isRemote;
        }

        @Nullable
        public final Boolean isProjectLevel() {
            return this.isProjectLevel;
        }

        @Nullable
        public final String getPathToPhpExecutable() {
            return this.pathToPhpExecutable;
        }

        @Nullable
        public final String getHomePath() {
            return this.homePath;
        }

        @NotNull
        public final String getLevel() {
            return this.level;
        }
    }
}

