/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseAffectAnalyzer;
import com.intellij.database.introspection.AffectedObjectScriptedMention;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.ObjectEffectType;
import com.intellij.database.introspection.ScriptedName;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.SearchPath;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlDefinitionHolderStatementImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\b\u001a\u00060\tR\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/mysqlbase/MysqlBaseAffectAnalyzer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "<init>", "()V", "determineBelongingKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "prepareDeterminer", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "dbms", "Lcom/intellij/database/Dbms;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "MysqlBaseDeterminer", "intellij.database.dialects.mysqlbase"})
final class MysqlBaseAffectAnalyzer
extends BaseAffectAnalyzer {
    @Nullable
    protected BelongingAreaKind determineBelongingKind(@NotNull ObjectKind objectKind) {
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        ObjectKind objectKind2 = objectKind;
        return Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.NONE) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.UNKNOWN_OBJECT) || Intrinsics.areEqual((Object)objectKind2, (Object)SqlDbElementType.ANY) ? null : (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.SCHEMA) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.COLLATION) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.USER) ? BelongingAreaKind.A_ROOT : BelongingAreaKind.A_SCHEMA);
    }

    @NotNull
    protected BaseAffectAnalyzer.Determiner prepareDeterminer(@NotNull Dbms dbms, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return (BaseAffectAnalyzer.Determiner)new MysqlBaseDeterminer(searchPath);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J$\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0002J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/mysqlbase/MysqlBaseAffectAnalyzer$MysqlBaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Lcom/intellij/database/dialects/mysqlbase/MysqlBaseAffectAnalyzer;Lcom/intellij/database/util/SearchPath;)V", "analyzeStatement", "", "statement", "Lcom/intellij/sql/psi/SqlStatement;", "analyzeDdlStatement", "Lcom/intellij/sql/psi/SqlDdlStatement;", "analyzeCreateStatement", "Lcom/intellij/sql/psi/SqlCreateStatement;", "analyzeAlterStatement", "Lcom/intellij/sql/psi/SqlAlterStatement;", "analyzeDropStatement", "Lcom/intellij/sql/psi/impl/SqlDropStatementImpl;", "isCreateUser", "", "isAlterUser", "isRenameUser", "handleUserOrRole", "nameElement", "Lcom/intellij/sql/psi/SqlNameElement;", "effectType", "Lcom/intellij/database/introspection/ObjectEffectType;", "userName", "Lcom/intellij/database/introspection/ScriptedName;", "newUserName", "parseUserName", "spec", "", "intellij.database.dialects.mysqlbase"})
    @SourceDebugExtension(value={"SMAP\nMysqlBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseAffectAnalyzer.kt\ncom/intellij/database/dialects/mysqlbase/MysqlBaseAffectAnalyzer$MysqlBaseDeterminer\n+ 2 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n234#2:173\n234#2:174\n234#2:178\n234#2:179\n455#3:175\n455#3:180\n1869#4,2:176\n1869#4,2:181\n1#5:183\n*S KotlinDebug\n*F\n+ 1 MysqlBaseAffectAnalyzer.kt\ncom/intellij/database/dialects/mysqlbase/MysqlBaseAffectAnalyzer$MysqlBaseDeterminer\n*L\n47#1:173\n61#1:174\n84#1:178\n102#1:179\n70#1:175\n110#1:180\n70#1:176,2\n110#1:181,2\n*E\n"})
    private final class MysqlBaseDeterminer
    extends BaseAffectAnalyzer.SingleDatabaseDeterminer {
        public MysqlBaseDeterminer(SearchPath searchPath) {
            super((BaseAffectAnalyzer)MysqlBaseAffectAnalyzer.this, searchPath);
        }

        protected void analyzeStatement(@NotNull SqlStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            if (this.isRenameUser(statement)) {
                BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
                PsiElement $this$child$iv = (PsiElement)statement;
                boolean $i$f$child = false;
                SqlRenameToClause sqlRenameToClause = (SqlRenameToClause)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlRenameToClause.class, (boolean)false);
                if (sqlRenameToClause == null) {
                    return;
                }
                SqlRenameToClause renameClause = sqlRenameToClause;
                Object object = renameClause.getTargetReference();
                if (object == null || (object = object.getName()) == null) {
                    return;
                }
                Object oldUserSpec = object;
                Object object2 = renameClause.getNameElement();
                if (object2 == null || (object2 = object2.getName()) == null) {
                    return;
                }
                Object newUserSpec = object2;
                this.handleUserOrRole(ObjectEffectType.WAS_RENAMED, this.parseUserName((String)oldUserSpec), this.parseUserName((String)newUserSpec));
            } else {
                super.analyzeStatement(statement);
            }
        }

        protected void analyzeDdlStatement(@NotNull SqlDdlStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            if (this.isCreateUser(statement)) {
                BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
                PsiElement $this$child$iv = (PsiElement)statement;
                boolean $i$f$child = false;
                SqlDefinition sqlDefinition = (SqlDefinition)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlDefinition.class, (boolean)false);
                if (sqlDefinition == null || (sqlDefinition = sqlDefinition.getNameElement()) == null) {
                    return;
                }
                SqlDefinition userNameElement = sqlDefinition;
                this.handleUserOrRole((SqlNameElement)userNameElement, ObjectEffectType.WAS_CREATED);
            } else {
                super.analyzeDdlStatement(statement);
            }
        }

        protected void analyzeCreateStatement(@NotNull SqlCreateStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            if (Intrinsics.areEqual((Object)statement.getKind(), (Object)ObjectKind.ROLE)) {
                PsiElement $this$childrenOfType$iv = (PsiElement)statement;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlReferenceExpression.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlReferenceExpression r = (SqlReferenceExpression)element$iv;
                    boolean bl = false;
                    this.handleUserOrRole((SqlNameElement)r, ObjectEffectType.WAS_CREATED);
                }
            } else {
                super.analyzeCreateStatement(statement);
            }
        }

        protected void analyzeAlterStatement(@NotNull SqlAlterStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            if (this.isAlterUser(statement)) {
                this.handleUserOrRole((SqlNameElement)statement.getAlterTargetReference(), ObjectEffectType.WAS_ALTERED);
                return;
            }
            BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
            PsiElement $this$child$iv = (PsiElement)statement;
            boolean $i$f$child = false;
            SqlRenameToClause renameClause = (SqlRenameToClause)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlRenameToClause.class, (boolean)false);
            if (renameClause == null) {
                super.analyzeAlterStatement(statement);
                return;
            }
            SqlReferenceExpression sqlReferenceExpression = statement.getAlterTargetReference();
            if (sqlReferenceExpression == null && (sqlReferenceExpression = renameClause.getTargetReference()) == null) {
                return;
            }
            SqlReferenceExpression objectRef = sqlReferenceExpression;
            SqlNameElement newNameElement = renameClause.getNameElement();
            this.handleRename(BelongingAreaKind.A_SCHEMA, objectRef, (SqlElement)newNameElement);
        }

        protected void analyzeDropStatement(@NotNull SqlDropStatementImpl statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            ObjectKind objectKind = statement.getTargetType();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.INDEX)) {
                SqlOnTargetClauseImpl targetClause;
                BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
                PsiElement $this$child$iv = (PsiElement)statement;
                boolean $i$f$child = false;
                SqlOnTargetClauseImpl sqlOnTargetClauseImpl = targetClause = (SqlOnTargetClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlOnTargetClauseImpl.class, (boolean)false);
                SqlExpression sqlExpression = sqlOnTargetClauseImpl != null ? sqlOnTargetClauseImpl.getTargetExpression() : null;
                SqlReferenceExpression tableRefExpr = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                BaseAffectAnalyzer.Determiner.handleIdentifier$default((BaseAffectAnalyzer.Determiner)((BaseAffectAnalyzer.Determiner)this), (ObjectEffectType)ObjectEffectType.WAS_ALTERED, (BelongingAreaKind)BelongingAreaKind.A_SCHEMA, (ObjectKind)ObjectKind.TABLE, (SqlNameElement)((SqlNameElement)tableRefExpr), (int)0, (int)16, null);
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.USER)) {
                this.handleUserOrRole((SqlNameElement)statement.getTargetExpression(), ObjectEffectType.WAS_DROPPED);
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE)) {
                PsiElement $this$childrenOfType$iv = (PsiElement)statement;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlReferenceExpression.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlReferenceExpression r = (SqlReferenceExpression)element$iv;
                    boolean bl = false;
                    this.handleUserOrRole((SqlNameElement)r, ObjectEffectType.WAS_DROPPED);
                }
            } else {
                super.analyzeDropStatement(statement);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCreateUser(SqlDdlStatement statement) {
            if (!(statement instanceof SqlDefinitionHolderStatementImpl)) return false;
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)((SqlDefinitionHolderStatementImpl)statement).getFirstChild()), (Object)SqlCommonKeywords.SQL_CREATE)) return false;
            PsiElement psiElement = ((SqlDefinitionHolderStatementImpl)statement).getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)PsiTreeUtilKt.nextLeaf((PsiElement)psiElement, MysqlBaseDeterminer::isCreateUser$lambda$0)), (Object)SqlCommonKeywords.SQL_USER)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAlterUser(SqlAlterStatement statement) {
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)statement.getFirstChild()), (Object)SqlCommonKeywords.SQL_ALTER)) return false;
            PsiElement psiElement = statement.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)PsiTreeUtilKt.nextLeaf((PsiElement)psiElement, MysqlBaseDeterminer::isAlterUser$lambda$0)), (Object)SqlCommonKeywords.SQL_USER)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isRenameUser(SqlStatement statement) {
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)statement.getFirstChild()), (Object)SqlCommonKeywords.SQL_RENAME)) return false;
            PsiElement psiElement = statement.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)PsiTreeUtilKt.nextLeaf((PsiElement)psiElement, MysqlBaseDeterminer::isRenameUser$lambda$0)), (Object)SqlCommonKeywords.SQL_USER)) return false;
            return true;
        }

        private final void handleUserOrRole(SqlNameElement nameElement, ObjectEffectType effectType) {
            if (nameElement == null) {
                return;
            }
            String userSpec = nameElement.getText();
            Intrinsics.checkNotNull((Object)userSpec);
            ScriptedName userName = this.parseUserName(userSpec);
            MysqlBaseDeterminer.handleUserOrRole$default(this, effectType, userName, null, 4, null);
        }

        private final void handleUserOrRole(ObjectEffectType effectType, ScriptedName userName, ScriptedName newUserName) {
            AffectedObjectScriptedMention mention = switch (WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
                case 1 -> {
                    ScriptedName v0 = ScriptedName.Companion.getCurrent();
                    ScriptedName v1 = ScriptedName.Companion.getCurrent();
                    ObjectKind v2 = ObjectKind.USER;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"USER");
                    yield AffectedObjectScriptedMention.Companion.wasCreated(v0, v1, userName, v2, BelongingAreaKind.A_ROOT);
                }
                case 2 -> {
                    ScriptedName v4 = ScriptedName.Companion.getCurrent();
                    ScriptedName v5 = ScriptedName.Companion.getCurrent();
                    ObjectKind v6 = ObjectKind.USER;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"USER");
                    yield AffectedObjectScriptedMention.Companion.wasAltered(v4, v5, userName, v6, BelongingAreaKind.A_ROOT);
                }
                case 3 -> {
                    ScriptedName v7 = ScriptedName.Companion.getCurrent();
                    ScriptedName v8 = ScriptedName.Companion.getCurrent();
                    ObjectKind v9 = ObjectKind.USER;
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"USER");
                    yield AffectedObjectScriptedMention.Companion.wasDropped(v7, v8, userName, v9, BelongingAreaKind.A_ROOT);
                }
                case 4 -> {
                    ScriptedName v10 = newUserName;
                    if (v10 != null) {
                        ScriptedName it = v10;
                        boolean $i$a$-let-MysqlBaseAffectAnalyzer$MysqlBaseDeterminer$handleUserOrRole$mention$1 = false;
                        ScriptedName v11 = ScriptedName.Companion.getCurrent();
                        ScriptedName v12 = ScriptedName.Companion.getCurrent();
                        ObjectKind v13 = ObjectKind.USER;
                        Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"USER");
                        yield AffectedObjectScriptedMention.Companion.wasRenamed(v11, v12, userName, it, v13, BelongingAreaKind.A_ROOT);
                    }
                    yield null;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            this.acceptObject(mention);
        }

        static /* synthetic */ void handleUserOrRole$default(MysqlBaseDeterminer mysqlBaseDeterminer, ObjectEffectType objectEffectType, ScriptedName scriptedName, ScriptedName scriptedName2, int n, Object object) {
            if ((n & 4) != 0) {
                scriptedName2 = null;
            }
            mysqlBaseDeterminer.handleUserOrRole(objectEffectType, scriptedName, scriptedName2);
        }

        @NotNull
        public final ScriptedName parseUserName(@NotNull String spec) {
            String string;
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            int at = StringsKt.lastIndexOf$default((CharSequence)spec, (char)'@', (int)0, (boolean)false, (int)6, null);
            String it = spec;
            boolean bl = false;
            if (at == -1) {
                string = it;
            } else {
                String string2 = it.substring(0, at);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            String userName = string;
            boolean quoted = false;
            if (MysqlBaseDeterminer.parseUserName$quoted(userName)) {
                quoted = true;
                userName = MysqlBaseDeterminer.parseUserName$unquote(userName);
            }
            return ScriptedName.Companion.of(userName, quoted);
        }

        private static final boolean isCreateUser$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)TokenType.WHITE_SPACE);
        }

        private static final boolean isAlterUser$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)TokenType.WHITE_SPACE);
        }

        private static final boolean isRenameUser$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)TokenType.WHITE_SPACE);
        }

        private static final boolean parseUserName$quoted(String $this$parseUserName_u24quoted) {
            return StringsKt.startsWith$default((CharSequence)$this$parseUserName_u24quoted, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$parseUserName_u24quoted, (char)'\'', (boolean)false, (int)2, null) && $this$parseUserName_u24quoted.length() > 2;
        }

        private static final String parseUserName$unquote(String $this$parseUserName_u24unquote) {
            String string;
            if (MysqlBaseDeterminer.parseUserName$quoted($this$parseUserName_u24unquote)) {
                String string2 = $this$parseUserName_u24unquote.substring(1, $this$parseUserName_u24unquote.length() - 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = $this$parseUserName_u24unquote;
            }
            return string;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ObjectEffectType.values().length];
                try {
                    nArray[ObjectEffectType.WAS_CREATED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ObjectEffectType.WAS_ALTERED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ObjectEffectType.WAS_DROPPED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ObjectEffectType.WAS_RENAMED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

