/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.toolkit;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.toolkit.JbrApiHandler;
import com.intellij.database.remote.toolkit.RemoteDesktopActions;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandler;
import com.intellij.database.remote.toolkit.ToolkitHandler;
import com.intellij.desktop.DesktopActionsHandler;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.openapi.util.Setter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDesktopActionsHandlerImpl
extends RemoteObject
implements RemoteDesktopActionsHandler {
    private static Setter<RemoteDesktopActionsHandler> ourSupport = null;
    private final RemoteDesktopActions myHandler;

    public RemoteDesktopActionsHandlerImpl(@NotNull RemoteDesktopActions handler) {
        if (handler == null) {
            RemoteDesktopActionsHandlerImpl.$$$reportNull$$$0(0);
        }
        this.myHandler = handler;
    }

    public String getCastToClassName() throws RemoteException {
        return DesktopActionsHandler.class.getName();
    }

    @Override
    public void open(File file) throws IOException {
        this.myHandler.open(file);
    }

    @Override
    public void edit(File file) throws IOException {
        this.myHandler.edit(file);
    }

    @Override
    public void print(File file) throws IOException {
        this.myHandler.print(file);
    }

    @Override
    public void mail(URI mailtoURL) throws IOException {
        this.myHandler.mail(mailtoURL);
    }

    @Override
    public void browse(URI uri) throws IOException {
        this.myHandler.browse(uri);
    }

    @NotNull
    public static RemoteDesktopActionsHandler wrap(@NotNull RemoteDesktopActions handler) {
        if (handler == null) {
            RemoteDesktopActionsHandlerImpl.$$$reportNull$$$0(1);
        }
        return new RemoteDesktopActionsHandlerImpl(handler);
    }

    public static void setHandler(RemoteDesktopActionsHandler handler) {
        if (ourSupport != null) {
            ourSupport.set((Object)handler);
        }
    }

    public static void prepareHandler() {
        String actions = System.getProperty(RemoteDesktopActionsHandlerImpl.getActionsProperty());
        State state = State.getState(actions);
        ourSupport = null;
        if (state.includes(State.JBR)) {
            try {
                ourSupport = JbrApiHandler.create();
            }
            catch (Throwable th) {
                JdbcNativeUtil.logWarn("Failed to instantiate jbr-api: " + th.getMessage(), null);
            }
        }
        if (ourSupport == null && state.includes(State.TOOLKIT)) {
            try {
                ourSupport = (Setter)JdbcNativeUtil.computeSafe(ToolkitHandler::create);
            }
            catch (Throwable th) {
                JdbcNativeUtil.logWarn("Failed to instantiate awt.toolkit override: " + th.getMessage(), null);
            }
        }
        JdbcNativeUtil.logInfo("Desktop actions are " + ourSupport);
    }

    @NotNull
    public static String getActionsProperty() {
        return "intellij.desktop.actions";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "handler";
        objectArray2[1] = "com/intellij/database/remote/toolkit/RemoteDesktopActionsHandlerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum State {
        ENABLED,
        DISABLED,
        TOOLKIT,
        JBR;


        boolean includes(@NotNull State state) {
            if (state == null) {
                State.$$$reportNull$$$0(0);
            }
            return state == this || this == ENABLED && state != DISABLED;
        }

        @NotNull
        public String getId() {
            String string = this.name().toLowerCase(Locale.ENGLISH);
            if (string == null) {
                State.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return this.getId();
        }

        @NotNull
        public static State getState(@Nullable String id) {
            if (id != null) {
                if ("false".equals(id)) {
                    State state = DISABLED;
                    if (state == null) {
                        State.$$$reportNull$$$0(2);
                    }
                    return state;
                }
                for (State value : State.values()) {
                    if (!id.equals(value.getId())) continue;
                    State state = value;
                    if (state == null) {
                        State.$$$reportNull$$$0(3);
                    }
                    return state;
                }
            }
            State state = ENABLED;
            if (state == null) {
                State.$$$reportNull$$$0(4);
            }
            return state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/toolkit/RemoteDesktopActionsHandlerImpl$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/toolkit/RemoteDesktopActionsHandlerImpl$State";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "includes";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

