/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import fleet.util.ThreadDumper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J#\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002J/\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u00072\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0007H\u0002\u00a2\u0006\u0002\u0010\u001bJ!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0007H\u0002\u00a2\u0006\u0002\u0010\"J%\u0010#\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0007H\u0002\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020'H\u0002R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Lfleet/util/ThreadDumper;", "", "<init>", "()V", "dumpThreadsToString", "", "threadInfos", "", "Ljava/lang/management/ThreadInfo;", "getThreadInfos", "()[Ljava/lang/management/ThreadInfo;", "threadMXBean", "Ljava/lang/management/ThreadMXBean;", "sort", "", "(Ljava/lang/management/ThreadMXBean;Z)[Ljava/lang/management/ThreadInfo;", "isEDT", "threadName", "dumpThreadInfos", "Ljava/lang/StackTraceElement;", "threadInfo", "f", "Ljava/io/Writer;", "([Ljava/lang/management/ThreadInfo;Ljava/io/Writer;)[Ljava/lang/StackTraceElement;", "isIdleDefaultCoroutineDispatch", "name", "stackTrace", "(Ljava/lang/String;[Ljava/lang/StackTraceElement;)Z", "threads", "([Ljava/lang/management/ThreadInfo;)[Ljava/lang/management/ThreadInfo;", "dumpCallStack", "", "info", "stackTraceElements", "(Ljava/lang/management/ThreadInfo;Ljava/io/Writer;[Ljava/lang/StackTraceElement;)V", "printStackTrace", "(Ljava/io/Writer;[Ljava/lang/StackTraceElement;)V", "getReadableState", "state", "Ljava/lang/Thread$State;", "fleet.util.core"})
@SourceDebugExtension(value={"SMAP\nThreadDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadDumper.kt\nfleet/util/ThreadDumper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,146:1\n37#2,2:147\n*S KotlinDebug\n*F\n+ 1 ThreadDumper.kt\nfleet/util/ThreadDumper\n*L\n92#1:147,2\n*E\n"})
public final class ThreadDumper {
    @NotNull
    public static final ThreadDumper INSTANCE = new ThreadDumper();

    private ThreadDumper() {
    }

    @NotNull
    public final String dumpThreadsToString() {
        StringWriter writer = new StringWriter();
        this.dumpThreadInfos(this.getThreadInfos(), writer);
        String string2 = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final ThreadInfo[] getThreadInfos() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"getThreadMXBean(...)");
        return this.getThreadInfos(threadMXBean, true);
    }

    @NotNull
    public final ThreadInfo[] getThreadInfos(@NotNull ThreadMXBean threadMXBean, boolean sort2) {
        Intrinsics.checkNotNullParameter((Object)threadMXBean, (String)"threadMXBean");
        Object[] threads = null;
        try {
            Object[] objectArray = threadMXBean.dumpAllThreads(false, false);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"dumpAllThreads(...)");
            threads = objectArray;
        }
        catch (Exception exception) {
            ThreadInfo[] threadInfoArray = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)threadInfoArray, (String)"getThreadInfo(...)");
            threads = threadInfoArray;
        }
        int o = 0;
        int n = threads.length;
        for (int i2 = 0; i2 < n; ++i2) {
            ThreadInfo info = threads[i2];
            if (info == null) continue;
            threads[o++] = info;
        }
        Object[] objectArray = threads.length == o ? threads : (threads = o == 0 ? new ThreadInfo[]{} : (ThreadInfo[])ArraysKt.copyInto$default((Object[])threads, (Object[])new ThreadInfo[o], (int)0, (int)0, (int)Math.min(threads.length, o), (int)6, null));
        if (sort2) {
            this.sort((ThreadInfo[])threads);
        }
        return threads;
    }

    private final boolean isEDT(String threadName) {
        return threadName != null && (StringsKt.startsWith$default((String)threadName, (String)"AWT-EventQueue", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)threadName, (CharSequence)"AppKit", (boolean)false, (int)2, null));
    }

    private final StackTraceElement[] dumpThreadInfos(ThreadInfo[] threadInfo, Writer f) {
        StackTraceElement[] edtStack = null;
        for (ThreadInfo info : threadInfo) {
            if (info == null) continue;
            String name = info.getThreadName();
            StackTraceElement[] stackTrace = info.getStackTrace();
            if (edtStack == null && this.isEDT(name)) {
                edtStack = stackTrace;
            }
            Intrinsics.checkNotNull((Object)stackTrace);
            if (this.isIdleDefaultCoroutineDispatch(name, stackTrace)) continue;
            this.dumpCallStack(info, f, stackTrace);
        }
        return edtStack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIdleDefaultCoroutineDispatch(String name, StackTraceElement[] stackTrace) {
        if (name == null) return false;
        if (!StringsKt.startsWith$default((String)name, (String)"DefaultDispatcher-worker-", (boolean)false, (int)2, null)) return false;
        if (stackTrace.length != 6) return false;
        StackTraceElement stackTraceElement = stackTrace[0];
        Intrinsics.checkNotNull((Object)stackTraceElement);
        if (!stackTraceElement.isNativeMethod()) return false;
        StackTraceElement stackTraceElement2 = stackTrace[0];
        Intrinsics.checkNotNull((Object)stackTraceElement2);
        if (!Intrinsics.areEqual((Object)stackTraceElement2.getMethodName(), (Object)"park")) return false;
        StackTraceElement stackTraceElement3 = stackTrace[0];
        Intrinsics.checkNotNull((Object)stackTraceElement3);
        if (!Intrinsics.areEqual((Object)stackTraceElement3.getClassName(), (Object)"jdk.internal.misc.Unsafe")) return false;
        StackTraceElement stackTraceElement4 = stackTrace[1];
        Intrinsics.checkNotNull((Object)stackTraceElement4);
        if (!Intrinsics.areEqual((Object)stackTraceElement4.getMethodName(), (Object)"parkNanos")) return false;
        StackTraceElement stackTraceElement5 = stackTrace[1];
        Intrinsics.checkNotNull((Object)stackTraceElement5);
        if (!Intrinsics.areEqual((Object)stackTraceElement5.getClassName(), (Object)"java.util.concurrent.locks.LockSupport")) return false;
        StackTraceElement stackTraceElement6 = stackTrace[2];
        Intrinsics.checkNotNull((Object)stackTraceElement6);
        if (!Intrinsics.areEqual((Object)stackTraceElement6.getMethodName(), (Object)"park")) return false;
        StackTraceElement stackTraceElement7 = stackTrace[2];
        Intrinsics.checkNotNull((Object)stackTraceElement7);
        if (!Intrinsics.areEqual((Object)stackTraceElement7.getClassName(), (Object)"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker")) return false;
        StackTraceElement stackTraceElement8 = stackTrace[3];
        Intrinsics.checkNotNull((Object)stackTraceElement8);
        if (!Intrinsics.areEqual((Object)stackTraceElement8.getMethodName(), (Object)"tryPark")) return false;
        StackTraceElement stackTraceElement9 = stackTrace[3];
        Intrinsics.checkNotNull((Object)stackTraceElement9);
        if (!Intrinsics.areEqual((Object)stackTraceElement9.getClassName(), (Object)"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker")) return false;
        StackTraceElement stackTraceElement10 = stackTrace[4];
        Intrinsics.checkNotNull((Object)stackTraceElement10);
        if (!Intrinsics.areEqual((Object)stackTraceElement10.getMethodName(), (Object)"runWorker")) return false;
        StackTraceElement stackTraceElement11 = stackTrace[4];
        Intrinsics.checkNotNull((Object)stackTraceElement11);
        if (!Intrinsics.areEqual((Object)stackTraceElement11.getClassName(), (Object)"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker")) return false;
        StackTraceElement stackTraceElement12 = stackTrace[5];
        Intrinsics.checkNotNull((Object)stackTraceElement12);
        if (!Intrinsics.areEqual((Object)stackTraceElement12.getMethodName(), (Object)"run")) return false;
        StackTraceElement stackTraceElement13 = stackTrace[5];
        Intrinsics.checkNotNull((Object)stackTraceElement13);
        if (!Intrinsics.areEqual((Object)stackTraceElement13.getClassName(), (Object)"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker")) return false;
        return true;
    }

    @NotNull
    public final ThreadInfo[] sort(@NotNull ThreadInfo[] threads) {
        Intrinsics.checkNotNullParameter((Object)threads, (String)"threads");
        Iterable iterable = ArraysKt.filterNotNull((Object[])threads);
        Comparator<Object> comparator = ((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ThreadInfo threadInfo = (ThreadInfo)a;
                boolean bl = false;
                boolean bl2 = !ThreadDumper.access$isEDT(ThreadDumper.INSTANCE, threadInfo.getThreadName());
                threadInfo = (ThreadInfo)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!ThreadDumper.access$isEDT(ThreadDumper.INSTANCE, threadInfo.getThreadName())));
            }
        }).thenComparing(arg_0 -> ThreadDumper.sort$lambda$1(sort.2.INSTANCE, arg_0)).thenComparing(arg_0 -> ThreadDumper.sort$lambda$2(sort.3.INSTANCE, arg_0)).thenComparing(arg_0 -> ThreadDumper.sort$lambda$3(sort.4.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ThreadInfo[0]);
    }

    private final void dumpCallStack(ThreadInfo info, Writer f, StackTraceElement[] stackTraceElements) {
        try {
            StringBuilder stringBuilder;
            StringBuilder $this$dumpCallStack_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$dumpCallStack_u24lambda_u240.append("\"");
            $this$dumpCallStack_u24lambda_u240.append(info.getThreadName());
            $this$dumpCallStack_u24lambda_u240.append("\"");
            StringBuilder stringBuilder2 = $this$dumpCallStack_u24lambda_u240.append(" prio=0 tid=0x0 nid=0x0 ");
            Thread.State state = info.getThreadState();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)state), (String)"getThreadState(...)");
            stringBuilder2.append(INSTANCE.getReadableState(state)).append("\n");
            $this$dumpCallStack_u24lambda_u240.append("     java.lang.Thread.State: ").append((Object)info.getThreadState()).append("\n");
            if (info.getLockName() != null) {
                $this$dumpCallStack_u24lambda_u240.append(" on ").append(info.getLockName());
            }
            if (info.getLockOwnerName() != null) {
                $this$dumpCallStack_u24lambda_u240.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
            }
            if (info.isSuspended()) {
                $this$dumpCallStack_u24lambda_u240.append(" (suspended)");
            }
            if (info.isInNative()) {
                $this$dumpCallStack_u24lambda_u240.append(" (in native)");
            }
            String s = stringBuilder.toString();
            f.write(s + "\n");
            this.printStackTrace(f, stackTraceElements);
            f.write("\n");
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private final void printStackTrace(Writer f, StackTraceElement[] stackTraceElements) {
        try {
            for (StackTraceElement element : stackTraceElements) {
                f.write("\tat " + element + "\n");
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private final String getReadableState(Thread.State state) {
        return switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1 -> "blocked";
            case 2, 3 -> "waiting on condition";
            case 4 -> "runnable";
            case 5 -> "new";
            case 6 -> "terminated";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Boolean sort$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Integer sort$lambda$2(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final String sort$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isEDT(ThreadDumper $this, String threadName) {
        return $this.isEDT(threadName);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Thread.State.values().length];
            try {
                nArray[Thread.State.BLOCKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.TIMED_WAITING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.WAITING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.RUNNABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.NEW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.TERMINATED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

