/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.psi.impl.source.codeStyle.ShiftIndentInsideHelper;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiBasedFormatterModelWithShiftIndentInside
extends PsiBasedFormattingModel {
    private static final Logger LOG = Logger.getInstance(PsiBasedFormatterModelWithShiftIndentInside.class);
    private final Project myProject;

    public PsiBasedFormatterModelWithShiftIndentInside(PsiFile file, @NotNull Block rootBlock, FormattingDocumentModelImpl documentModel) {
        if (rootBlock == null) {
            PsiBasedFormatterModelWithShiftIndentInside.$$$reportNull$$$0(0);
        }
        super(file, rootBlock, documentModel);
        this.myProject = file.getProject();
    }

    public TextRange shiftIndentInsideRange(ASTNode node, TextRange textRange, int shift) {
        return PsiBasedFormatterModelWithShiftIndentInside.shiftIndentInsideWithPsi(node, textRange, shift);
    }

    private static TextRange shiftIndentInsideWithPsi(ASTNode node, TextRange textRange, int shift) {
        if (node != null && node.getTextRange().equals((Object)textRange) && ShiftIndentInsideHelper.mayShiftIndentInside(node)) {
            PsiFile file = node.getPsi().getContainingFile();
            return new ShiftIndentInsideHelper(file).shiftIndentInside(node, shift).getTextRange();
        }
        return textRange;
    }

    protected String replaceWithPsiInLeaf(TextRange textRange, String whiteSpace, ASTNode leafElement) {
        if (!this.myCanModifyAllWhiteSpaces) {
            if (leafElement.getElementType() == TokenType.WHITE_SPACE) {
                return null;
            }
            ASTNode prevNode = TreeUtil.prevLeaf((ASTNode)leafElement);
            if (prevNode != null) {
                IElementType type = prevNode.getElementType();
                if (type == TokenType.WHITE_SPACE) {
                    String text = prevNode.getText();
                    @NonNls String cdataStartMarker = "<![CDATA[";
                    int cdataPos = text.indexOf("<![CDATA[");
                    if (cdataPos != -1 && !whiteSpace.contains("<![CDATA[") && (whiteSpace = DocumentBasedFormattingModel.mergeWsWithCdataMarker((String)whiteSpace, (String)text, (int)cdataPos)) == null) {
                        return null;
                    }
                    type = (prevNode = TreeUtil.prevLeaf((ASTNode)prevNode)) != null ? prevNode.getElementType() : null;
                }
                @NonNls String cdataEndMarker = "]]>";
                if (type == XmlTokenType.XML_CDATA_END && !whiteSpace.contains("]]>")) {
                    ASTNode at = this.findElementAt(prevNode.getStartOffset());
                    if (at != null && at.getPsi() instanceof PsiWhiteSpace) {
                        String s = at.getText();
                        int cdataEndPos = s.indexOf("]]>");
                        whiteSpace = DocumentBasedFormattingModel.mergeWsWithCdataMarker((String)whiteSpace, (String)s, (int)cdataEndPos);
                        leafElement = at;
                    } else {
                        whiteSpace = null;
                    }
                    if (whiteSpace == null) {
                        return null;
                    }
                }
            }
        }
        FormatterUtil.replaceWhiteSpace((String)whiteSpace, (ASTNode)leafElement, (IElementType)TokenType.WHITE_SPACE, (TextRange)textRange);
        return whiteSpace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootBlock", "com/intellij/psi/impl/source/codeStyle/PsiBasedFormatterModelWithShiftIndentInside", "<init>"));
    }
}

