/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.util.ConfigFileWrapper;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.Nullable;

public abstract class JBossConfigProcessor<T>
extends ConfigFileWrapper<T> {
    private final String myXPath;
    private final T myDefaultValue;

    protected JBossConfigProcessor(String xPath) {
        this(xPath, null);
    }

    protected JBossConfigProcessor(String xPath, T defaultValue) {
        this.myXPath = xPath;
        this.myDefaultValue = defaultValue;
    }

    @Nullable
    public T get(File file) {
        Object result = super.get(file);
        return (T)(result == null ? this.myDefaultValue : result);
    }

    public T get(Document doc) throws JDOMException, IOException {
        T result = this.doGet(doc);
        return result == null ? this.myDefaultValue : result;
    }

    @Nullable
    protected T doGet(Document doc) throws JDOMException, IOException {
        XPath xpath = XPath.newInstance((String)this.myXPath);
        xpath.addNamespace("ns", doc.getRootElement().getNamespaceURI());
        return this.process(xpath, doc);
    }

    protected abstract T process(XPath var1, Document var2) throws JDOMException, IOException;
}

