/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.pathvars;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.jvm.pathvars.InplaceRenameQuickFix;
import com.intellij.microservices.jvm.pathvars.PathVariableMethodInspection$createRenameQuickfix$;
import com.intellij.microservices.jvm.pathvars.PathVariableQuickFix;
import com.intellij.microservices.url.parameters.PathVariableUtils;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J+\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\rH\u0002J\u0018\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020\rH\u0002J(\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\r2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\r04H\u0004R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00066"}, d2={"Lcom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "getUrlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "method", "Lorg/jetbrains/uast/UMethod;", "pathVariableAnnotationFQN", "", "getPathVariableAnnotationFQN", "()Ljava/lang/String;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getConsumedPathVariables", "", "Lcom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection$PathVariableConsumerInfo;", "extractPathVariableUsageFromTheParameter", "uParameter", "Lorg/jetbrains/uast/UParameter;", "getExplicitPathVariableNameExpression", "Lorg/jetbrains/uast/UExpression;", "pathAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "mayResolveToMethodBeanField", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "expectedName", "hasExpectedPathVariableName", "parameter", "Lcom/intellij/psi/PsiVariable;", "createRenameQuickfix", "Lcom/intellij/codeInspection/LocalQuickFix;", "psiElement", "Lcom/intellij/psi/PsiElement;", "pathVariableName", "unusedDeclarations", "", "PathVariableConsumerInfo", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nPathVariableMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathVariableMethodInspection.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,190:1\n682#2:191\n712#2,4:192\n477#2:206\n1#3:196\n12970#4:197\n12970#4:198\n12970#4,2:199\n12971#4:201\n12970#4,2:202\n12971#4:204\n171#5:205\n*S KotlinDebug\n*F\n+ 1 PathVariableMethodInspection.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection\n*L\n74#1:191\n74#1:192,4\n116#1:206\n96#1:197\n100#1:198\n101#1:199,2\n100#1:201\n104#1:202,2\n96#1:204\n110#1:205\n*E\n"})
public abstract class PathVariableMethodInspection
extends AbstractBaseUastLocalInspectionTool {
    public PathVariableMethodInspection() {
        Class[] classArray = new Class[]{UMethod.class};
        super(classArray);
    }

    public abstract boolean isApplicable(@NotNull Module var1);

    @NotNull
    public abstract UrlPathContext getUrlPathContext(@NotNull UMethod var1);

    @NotNull
    public abstract String getPathVariableAnnotationFQN();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        if (!this.isApplicable(module2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
        return psiElementVisitor;
    }

    @NotNull
    public ProblemDescriptor[] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Map<String, PathVariableConsumerInfo> consumersMap;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        UrlPathContext urlPathContext = this.getUrlPathContext(method);
        if (urlPathContext.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Set allDeclaredPathVariableNamesForContext = CollectionsKt.toSet((Iterable)PathVariableUtils.getPathVariablesFromContext((UrlPathContext)urlPathContext));
        if (Intrinsics.areEqual((Object)allDeclaredPathVariableNamesForContext, (consumersMap = this.getConsumedPathVariables(method)).keySet())) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Map undeclaredUsages = MapsKt.minus(consumersMap, (Iterable)allDeclaredPathVariableNamesForContext);
        Set unusedDeclarations = SetsKt.minus((Set)allDeclaredPathVariableNamesForContext, (Iterable)consumersMap.keySet());
        PsiElement psiElement = method.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, (PsiFile)psiElement, isOnTheFly);
        for (Map.Entry entry : undeclaredUsages.entrySet()) {
            String pathVariableName = (String)entry.getKey();
            PathVariableConsumerInfo consumerInfo = (PathVariableConsumerInfo)entry.getValue();
            if (consumerInfo.getAnchor() == null || !consumerInfo.getReportIfNotDeclared()) continue;
            Object[] objectArray = new Object[]{pathVariableName};
            String string = MicroservicesBundle.message((String)"PathVariableInspection.cannot.resolve", (Object[])objectArray);
            objectArray = LocalQuickFix.notNullElements((LocalQuickFix)this.createRenameQuickfix(consumerInfo.getAnchor(), pathVariableName, unusedDeclarations));
            holder.registerProblem(consumerInfo.getAnchor(), string, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }
        for (String unConsumedVariable : unusedDeclarations) {
            if (this.mayResolveToMethodBeanField(method.getJavaPsi(), unConsumedVariable)) continue;
            UElement uElement = method.getUastAnchor();
            if (uElement == null || (uElement = uElement.getSourcePsi()) == null) break;
            UElement identifier = uElement;
            Object[] objectArray = new Object[]{unConsumedVariable};
            String string = MicroservicesBundle.message((String)"PathVariableReference.unconsumed.path.variable", (Object[])objectArray);
            objectArray = new LocalQuickFix[]{new PathVariableQuickFix(unConsumedVariable, this.getPathVariableAnnotationFQN())};
            holder.registerProblem((PsiElement)identifier, string, ProblemHighlightType.WEAK_WARNING, (LocalQuickFix[])objectArray);
        }
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
        return problemDescriptorArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Map<String, PathVariableConsumerInfo> getConsumedPathVariables(@NotNull UMethod method) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Sequence $this$associateBy$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)method.getUastParameters()), (Function1)((Function1)new Function1<UParameter, PathVariableConsumerInfo>((Object)this){

            public final PathVariableConsumerInfo invoke(UParameter p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PathVariableMethodInspection)((Object)this.receiver)).extractPathVariableUsageFromTheParameter(p0);
            }
        }));
        boolean $i$f$associateBy = false;
        Sequence sequence2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PathVariableConsumerInfo pathVariableConsumerInfo = (PathVariableConsumerInfo)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Nullable
    protected PathVariableConsumerInfo extractPathVariableUsageFromTheParameter(@NotNull UParameter uParameter) {
        PathVariableConsumerInfo pathVariableConsumerInfo;
        Object v0;
        block6: {
            Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
            Iterable iterable = uParameter.getUAnnotations();
            for (Object t : iterable) {
                UAnnotation it = (UAnnotation)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)this.getPathVariableAnnotationFQN())) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        UAnnotation uAnnotation = v0;
        if (uAnnotation == null) {
            return null;
        }
        UAnnotation pathAnnotation = uAnnotation;
        UExpression explicitPathVariableNameExpression = this.getExplicitPathVariableNameExpression(pathAnnotation);
        if (explicitPathVariableNameExpression != null) {
            String string = UastUtils.evaluateString((UExpression)explicitPathVariableNameExpression);
            if (string != null) {
                String it = string;
                boolean bl = false;
                pathVariableConsumerInfo = new PathVariableConsumerInfo(it, explicitPathVariableNameExpression.getSourcePsi(), true);
            } else {
                pathVariableConsumerInfo = null;
            }
        } else {
            String string = uParameter.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            UElement uElement = uParameter.getUastAnchor();
            pathVariableConsumerInfo = new PathVariableConsumerInfo(string, (PsiElement)(uElement != null ? uElement.getSourcePsi() : null), true);
        }
        return pathVariableConsumerInfo;
    }

    private final UExpression getExplicitPathVariableNameExpression(UAnnotation pathAnnotation) {
        Object[] objectArray = new String[]{"value", "name"};
        return (UExpression)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray), arg_0 -> PathVariableMethodInspection.getExplicitPathVariableNameExpression$lambda$0(pathAnnotation, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean mayResolveToMethodBeanField(PsiMethod psiMethod, String expectedName) {
        PsiParameter[] psiParameterArray = psiMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Object[] $this$any$iv = psiParameterArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            boolean bl;
            Object element$iv = $this$any$iv[n];
            PsiParameter psiParameter = (PsiParameter)element$iv;
            boolean bl2 = false;
            PsiType psiType = psiParameter.getType();
            PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
                bl = false;
            } else {
                PsiClassType psiClass = psiClassType;
                List list = PropertyUtil.getSetters((PsiClass)psiClass, (String)expectedName);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSetters(...)");
                if (!((Collection)list).isEmpty()) {
                    return true;
                }
                boolean bl3 = false;
                if (bl3) return true;
                PsiMethod[] psiMethodArray = psiClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
                Object[] $this$any$iv2 = psiMethodArray;
                boolean $i$f$any2 = false;
                for (Object element$iv2 : $this$any$iv2) {
                    PsiMethod ctr = (PsiMethod)element$iv2;
                    boolean bl4 = false;
                    PsiParameter[] psiParameterArray2 = ctr.getParameterList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray2, (String)"getParameters(...)");
                    Object[] $this$any$iv3 = psiParameterArray2;
                    boolean $i$f$any3 = false;
                    for (Object element$iv3 : $this$any$iv3) {
                        PsiParameter parameter = (PsiParameter)element$iv3;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)parameter);
                        if (!this.hasExpectedPathVariableName((PsiVariable)parameter, expectedName)) continue;
                        return true;
                    }
                    boolean bl6 = false;
                    if (!bl6) continue;
                    return true;
                }
                boolean bl7 = false;
                if (bl7) return true;
                PsiField[] psiFieldArray = psiClass.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
                $this$any$iv2 = psiFieldArray;
                $i$f$any2 = false;
                for (Object element$iv2 : $this$any$iv2) {
                    PsiField it = (PsiField)element$iv2;
                    boolean bl8 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.hasExpectedPathVariableName((PsiVariable)it, expectedName)) continue;
                    return true;
                }
                boolean bl9 = false;
                if (bl9) {
                    return true;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasExpectedPathVariableName(PsiVariable parameter, String expectedName) {
        block5: {
            if (Intrinsics.areEqual((Object)parameter.getName(), (Object)expectedName)) ** GOTO lbl-1000
            v0 = parameter.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getAnnotations(...)");
            for (Object var8_7 : (PsiElement)v0) {
                it = (PsiAnnotation)var8_7;
                $i$a$-find-PathVariableMethodInspection$hasExpectedPathVariableName$1 = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)this.getPathVariableAnnotationFQN())) continue;
                v1 = var8_7;
                break block5;
            }
            v1 = null;
        }
        var3_11 = (PsiAnnotation)v1;
        if (var3_11 == null) ** GOTO lbl-1000
        var5_3 = (PsiElement)var3_11;
        $i$f$toUElementOfType = false;
        var4_12 = (UAnnotation)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UAnnotation.class);
        if (var4_12 == null) ** GOTO lbl-1000
        p0 = var4_12;
        $i$a$-let-PathVariableMethodInspection$hasExpectedPathVariableName$2 = false;
        var5_3 = this.getExplicitPathVariableNameExpression(p0);
        if (var5_3 != null) {
            v2 = UastUtils.evaluateString((UExpression)var5_3);
        } else lbl-1000:
        // 3 sources

        {
            v2 = null;
        }
        if (Intrinsics.areEqual(v2, (Object)expectedName)) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        return v3;
    }

    @Nullable
    protected final LocalQuickFix createRenameQuickfix(@NotNull PsiElement psiElement, @NotNull String pathVariableName, @NotNull Set<String> unusedDeclarations) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)pathVariableName, (String)"pathVariableName");
        Intrinsics.checkNotNullParameter(unusedDeclarations, (String)"unusedDeclarations");
        if (unusedDeclarations.isEmpty()) {
            return null;
        }
        Sequence $this$filterIsInstance$iv = SequencesKt.take((Sequence)PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)true), (int)2);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)createRenameQuickfix$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        PsiNamedElement psiNamedElement = (PsiNamedElement)SequencesKt.firstOrNull((Sequence)sequence2);
        if (psiNamedElement == null) {
            return null;
        }
        PsiNamedElement namedElement = psiNamedElement;
        return (LocalQuickFix)new InplaceRenameQuickFix(namedElement, pathVariableName, (Iterable<String>)unusedDeclarations);
    }

    private static final UExpression getExplicitPathVariableNameExpression$lambda$0(UAnnotation $pathAnnotation, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $pathAnnotation.findDeclaredAttributeValue(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection$PathVariableConsumerInfo;", "", "name", "", "anchor", "Lcom/intellij/psi/PsiElement;", "reportIfNotDeclared", "", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Z)V", "getName", "()Ljava/lang/String;", "getAnchor", "()Lcom/intellij/psi/PsiElement;", "getReportIfNotDeclared", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.microservices.jvm"})
    protected static final class PathVariableConsumerInfo {
        @NotNull
        private final String name;
        @Nullable
        private final PsiElement anchor;
        private final boolean reportIfNotDeclared;

        public PathVariableConsumerInfo(@NotNull String name, @Nullable PsiElement anchor, boolean reportIfNotDeclared) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.anchor = anchor;
            this.reportIfNotDeclared = reportIfNotDeclared;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final PsiElement getAnchor() {
            return this.anchor;
        }

        public final boolean getReportIfNotDeclared() {
            return this.reportIfNotDeclared;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final PsiElement component2() {
            return this.anchor;
        }

        public final boolean component3() {
            return this.reportIfNotDeclared;
        }

        @NotNull
        public final PathVariableConsumerInfo copy(@NotNull String name, @Nullable PsiElement anchor, boolean reportIfNotDeclared) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new PathVariableConsumerInfo(name, anchor, reportIfNotDeclared);
        }

        public static /* synthetic */ PathVariableConsumerInfo copy$default(PathVariableConsumerInfo pathVariableConsumerInfo, String string, PsiElement psiElement, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = pathVariableConsumerInfo.name;
            }
            if ((n & 2) != 0) {
                psiElement = pathVariableConsumerInfo.anchor;
            }
            if ((n & 4) != 0) {
                bl = pathVariableConsumerInfo.reportIfNotDeclared;
            }
            return pathVariableConsumerInfo.copy(string, psiElement, bl);
        }

        @NotNull
        public String toString() {
            return "PathVariableConsumerInfo(name=" + this.name + ", anchor=" + this.anchor + ", reportIfNotDeclared=" + this.reportIfNotDeclared + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + (this.anchor == null ? 0 : this.anchor.hashCode());
            result = result * 31 + Boolean.hashCode(this.reportIfNotDeclared);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathVariableConsumerInfo)) {
                return false;
            }
            PathVariableConsumerInfo pathVariableConsumerInfo = (PathVariableConsumerInfo)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)pathVariableConsumerInfo.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.anchor, (Object)pathVariableConsumerInfo.anchor)) {
                return false;
            }
            return this.reportIfNotDeclared == pathVariableConsumerInfo.reportIfNotDeclared;
        }
    }
}

