/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase;

import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0000\u001aO\u0010\u0012\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u0002H\u00132\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u0002H\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u0002H\u0013\u0012\u0006\u0012\u0004\u0018\u0001H\u00130\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"getLiquibasePlaceHolderRanges", "", "Lcom/intellij/openapi/util/TextRange;", "psiElement", "Lcom/intellij/psi/PsiElement;", "isInLiquibaseXmlChangelog", "", "isUnderDbChangelogDir", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "currentDirectory", "Lcom/intellij/psi/PsiDirectory;", "formatPropertyValue", "", "value", "dbms", "isUnderChangelogRootDir", "T", "dir", "nameFun", "Lkotlin/Function1;", "parentFun", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/intellij/openapi/project/Project;)Z", "intellij.liquibase"})
@SourceDebugExtension(value={"SMAP\nLiquibaseUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseUtil.kt\ncom/intellij/liquibase/LiquibaseUtilKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n19#2:69\n774#3:70\n865#3,2:71\n*S KotlinDebug\n*F\n+ 1 LiquibaseUtil.kt\ncom/intellij/liquibase/LiquibaseUtilKt\n*L\n21#1:69\n58#1:70\n58#1:71,2\n*E\n"})
public final class LiquibaseUtilKt {
    @NotNull
    public static final Set<TextRange> getLiquibasePlaceHolderRanges(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)psiElement.getText(), (String)"${", (String)"}");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        return set;
    }

    public static final boolean isInLiquibaseXmlChangelog(@NotNull PsiElement psiElement) {
        XmlFile xmlFile;
        XmlFile xmlFile2;
        XmlTag rootTag;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiFile $this$asSafely$iv = psiElement.getContainingFile();
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        XmlTag xmlTag = rootTag = (xmlFile2 = (xmlFile = (XmlFile)psiFile)) != null && (xmlFile2 = xmlFile2.getDocument()) != null ? xmlFile2.getRootTag() : null;
        return Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"databaseChangeLog");
    }

    public static final boolean isUnderDbChangelogDir(@NotNull VirtualFile currentFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile vFile = currentFile;
        while (vFile.getParent() != null) {
            if (LiquibaseUtilKt.isUnderChangelogRootDir(vFile, LiquibaseUtilKt::isUnderDbChangelogDir$lambda$0, LiquibaseUtilKt::isUnderDbChangelogDir$lambda$1, project)) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)vFile.getParent(), (String)"getParent(...)");
        }
        return false;
    }

    public static final boolean isUnderDbChangelogDir(@Nullable PsiDirectory currentDirectory) {
        if (currentDirectory == null) {
            return false;
        }
        for (PsiDirectory directory = currentDirectory; directory != null && directory.getParentDirectory() != null; directory = directory.getParentDirectory()) {
            Function1 function1 = LiquibaseUtilKt::isUnderDbChangelogDir$lambda$2;
            Function1 function12 = LiquibaseUtilKt::isUnderDbChangelogDir$lambda$3;
            Project project = currentDirectory.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!LiquibaseUtilKt.isUnderChangelogRootDir(directory, function1, function12, project)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final String formatPropertyValue(@NotNull String value, @Nullable String dbms) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = dbms;
        return charSequence == null || charSequence.length() == 0 ? value : value + " (" + dbms + ")";
    }

    private static final <T> boolean isUnderChangelogRootDir(T dir, Function1<? super T, String> nameFun, Function1<? super T, ? extends T> parentFun, Project project) {
        if (LiquibaseUtilKt.isUnderChangelogRootDir$checkPattern(dir, nameFun, parentFun, StringsKt.substringBefore$default((String)DatabaseMigrationConfig.Companion.getInstance(project).getState().getMainChangeLogDir(), (String)"/#", null, (int)2, null))) {
            return true;
        }
        return LiquibaseUtilKt.isUnderChangelogRootDir$checkPattern(dir, nameFun, parentFun, StringsKt.substringBefore$default((String)DatabaseMigrationConfig.Companion.getInstance(project).getState().getSecondaryChangeLogDir(), (String)"/#", null, (int)2, null));
    }

    private static final String isUnderDbChangelogDir$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final VirtualFile isUnderDbChangelogDir$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final String isUnderDbChangelogDir$lambda$2(PsiDirectory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final PsiDirectory isUnderDbChangelogDir$lambda$3(PsiDirectory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> boolean isUnderChangelogRootDir$checkPattern(T $dir, Function1<? super T, String> $nameFun, Function1<? super T, ? extends T> $parentFun, String pattern) {
        void $this$filterTo$iv$iv;
        Object dirTmp = $dir;
        char[] cArray = new char[]{'/'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)pattern, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String patternPart : CollectionsKt.reversed((Iterable)((List)destination$iv$iv))) {
            if (dirTmp == null) {
                return false;
            }
            String string = (String)$nameFun.invoke(dirTmp);
            if (!(string != null ? StringsKt.equals((String)string, (String)patternPart, (boolean)true) : false)) {
                return false;
            }
            dirTmp = $parentFun.invoke(dirTmp);
        }
        return true;
    }
}

