/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.yaml.reference;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.liquibase.yaml.reference.YamlDbChangeLogConditionKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.gist.GistAstMarker;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.AstUtilKt;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"LIQUIBASE_MARKER", "Lcom/intellij/util/gist/GistAstMarker;", "isYamlLiquibaseChangeLog", "", "element", "Lcom/intellij/psi/PsiElement;", "isYamlLiquibaseChangeLogFile", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDatabaseChangelog", "tree", "Lcom/intellij/lang/LighterAST;", "intellij.liquibase.yaml"})
public final class YamlDbChangeLogConditionKt {
    @NotNull
    private static final GistAstMarker LIQUIBASE_MARKER;

    public static final boolean isYamlLiquibaseChangeLog(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        PsiFile psiFile2 = psiFile != null ? psiFile.getOriginalFile() : null;
        YAMLFile yAMLFile = psiFile2 instanceof YAMLFile ? (YAMLFile)psiFile2 : null;
        if (yAMLFile == null) {
            return false;
        }
        YAMLFile yamlFile = yAMLFile;
        VirtualFile virtualFile = yamlFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return YamlDbChangeLogConditionKt.isYamlLiquibaseChangeLogFile(project, virtualFile2);
    }

    public static final boolean isYamlLiquibaseChangeLogFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !file.isDirectory() && LIQUIBASE_MARKER.accepts(project, file);
    }

    private static final boolean isDatabaseChangelog(LighterAST tree) {
        Ref.BooleanRef foundRecipe = new Ref.BooleanRef();
        AstUtilKt.visitTopLevelKeyPairs((LighterAST)tree, (arg_0, arg_1) -> YamlDbChangeLogConditionKt.isDatabaseChangelog$lambda$0(foundRecipe, arg_0, arg_1));
        return foundRecipe.element;
    }

    private static final boolean isDatabaseChangelog$lambda$0(Ref.BooleanRef $foundRecipe, CharSequence key, LighterASTNode lighterASTNode) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)lighterASTNode, (String)"<unused var>");
        $foundRecipe.element = Intrinsics.areEqual((Object)key, (Object)"databaseChangeLog");
        return !$foundRecipe.element;
    }

    public static final /* synthetic */ boolean access$isDatabaseChangelog(LighterAST tree) {
        return YamlDbChangeLogConditionKt.isDatabaseChangelog(tree);
    }

    static {
        YAMLFileType yAMLFileType = YAMLFileType.YML;
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YML");
        LIQUIBASE_MARKER = new GistAstMarker((FileType)yAMLFileType, "LIQUIBASE_YAML", (Function1)LIQUIBASE_MARKER.1.INSTANCE);
    }
}

