/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;

public class ChangedForeignKeyChangeGenerator
extends liquibase.diff.output.changelog.core.ChangedForeignKeyChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (ForeignKey.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        if (referenceDatabase instanceof IntellijDatabase || comparisonDatabase instanceof IntellijDatabase) {
            differences.removeDifference("deleteRule");
            differences.removeDifference("updateRule");
            differences.removeDifference("deferrable");
            differences.removeDifference("initiallyDeferred");
            differences.removeDifference("validate");
            if (!differences.hasDifferences()) {
                return null;
            }
        }
        return super.fixChanged(changedObject, differences, control, referenceDatabase, comparisonDatabase, chain);
    }
}

