/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlLightParameter;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.psi.PsiElement;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.Nullable;

abstract class FtlArgumentDependentBuiltIn
implements NullableFunction<FtlBuiltIn, FtlType> {
    static final FtlArgumentDependentBuiltIn SWITCH = new FtlArgumentDependentBuiltIn(){

        @Override
        protected FtlType getBuiltInType(FtlBuiltIn context, FtlExpression[] arguments) {
            final FtlType resultType = arguments.length > 1 ? arguments[1].getType() : null;
            FtlParameter[] params = new FtlParameter[arguments.length];
            for (int i = 0; i < params.length; ++i) {
                boolean isCase;
                int index = i / 2 + 1;
                boolean isDefault = i == arguments.length - 1 && i % 2 == 0;
                boolean bl = isCase = i % 2 == 0 && !isDefault;
                params[i] = new FtlLightParameter((String)(isDefault ? "defaultResult" : (isCase ? "case" + index : "result" + index)), (PsiElement)context, isCase ? context.getQualifierType() : resultType);
            }
            return new FtlCallableType(this, false, params){

                @Override
                @Nullable
                public FtlType getResultType() {
                    return resultType;
                }
            };
        }
    };
    static final FtlArgumentDependentBuiltIn THEN = new FtlArgumentDependentBuiltIn(){

        @Override
        protected FtlType getBuiltInType(FtlBuiltIn context, FtlExpression[] arguments) {
            FtlType argType = arguments.length > 0 ? arguments[0].getType() : null;
            return FtlCallableType.createLightFunctionType(context, argType, "true", argType, "false", argType);
        }
    };
    static final FtlArgumentDependentBuiltIn ITEM_CYCLE = new FtlArgumentDependentBuiltIn(){

        @Override
        protected FtlType getBuiltInType(FtlBuiltIn context, final FtlExpression[] arguments) {
            FtlParameter[] params = new FtlParameter[arguments.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = new FtlLightParameter("value" + i, (PsiElement)context, null);
            }
            return new FtlCallableType(this, false, params){

                @Override
                @Nullable
                public FtlType getResultType() {
                    return arguments.length > 0 ? arguments[0].getType() : null;
                }
            };
        }
    };

    FtlArgumentDependentBuiltIn() {
    }

    public FtlType fun(FtlBuiltIn context) {
        PsiElement parent = context.getParent();
        FtlExpression[] arguments = parent instanceof FtlMethodCallExpression ? ((FtlMethodCallExpression)parent).getArgumentList().getPositionalArguments() : new FtlExpression[]{};
        return this.getBuiltInType(context, arguments);
    }

    protected abstract FtlType getBuiltInType(FtlBuiltIn var1, FtlExpression[] var2);
}

