/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.ECMA6LanguageDialect;
import com.intellij.lang.javascript.dialects.FlowJSLanguageDialect;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class JSFileViewProviderFactory
implements FileViewProviderFactory {
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, Language language, @NotNull PsiManager manager, boolean eventSystemEnabled) {
        if (file == null) {
            JSFileViewProviderFactory.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            JSFileViewProviderFactory.$$$reportNull$$$0(1);
        }
        if (!SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)file)) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        }
        if (Registry.is((String)"javascript.language.level.pusher.enabled", (boolean)false)) {
            JSLanguageDialect jsLanguageDialect;
            if (language != null && language.isKindOf((Language)JavascriptLanguage.INSTANCE) && language != FlexSupportLoader.ECMA_SCRIPT_L4 && (jsLanguageDialect = DialectDetector.getLanguageDialectForJSFile(file, manager.getProject())) != null && (language == JavascriptLanguage.INSTANCE || language instanceof JSLanguageDialect && jsLanguageDialect.isAtLeast((JSLanguageDialect)language))) {
                language = jsLanguageDialect;
            }
        } else if (language == JavascriptLanguage.INSTANCE) {
            language = ECMA6LanguageDialect.INSTANCE;
        }
        if (language == ECMA6LanguageDialect.INSTANCE && FlowJSAnnotation.hasFlowPrefix(file)) {
            language = FlowJSLanguageDialect.INSTANCE;
        }
        return language != null ? new JSFileViewProvider(manager, file, eventSystemEnabled, language) : new JSFileViewProvider(manager, file, eventSystemEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/JSFileViewProviderFactory";
        objectArray[2] = "createFileViewProvider";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSFileViewProvider
    extends SingleRootFileViewProvider {
        JSFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
            if (manager == null) {
                JSFileViewProvider.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                JSFileViewProvider.$$$reportNull$$$0(1);
            }
            super(manager, virtualFile, eventSystemEnabled);
        }

        JSFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language) {
            if (manager == null) {
                JSFileViewProvider.$$$reportNull$$$0(2);
            }
            if (virtualFile == null) {
                JSFileViewProvider.$$$reportNull$$$0(3);
            }
            if (language == null) {
                JSFileViewProvider.$$$reportNull$$$0(4);
            }
            super(manager, virtualFile, eventSystemEnabled, language);
        }

        public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
            PsiElement element;
            Language baseLanguage;
            PsiFile psi;
            if (lang == null) {
                JSFileViewProvider.$$$reportNull$$$0(5);
            }
            if (lang == XMLLanguage.class && (psi = this.getPsi(baseLanguage = this.getBaseLanguage())) != null && DialectDetector.isJSX((PsiElement)psi) && JSFileViewProvider.isXmlElement(element = this.findElementAt(offset))) {
                return element;
            }
            return super.findElementAt(offset, lang);
        }

        private static boolean isXmlElement(PsiElement element) {
            if (element == null) {
                return false;
            }
            if (element.getLanguage() instanceof XMLLanguage) {
                return true;
            }
            return element instanceof PsiWhiteSpace && element.getParent() instanceof XmlTag;
        }

        public void contentsSynchronized() {
            JSLanguageDialect fileLanguage;
            super.contentsSynchronized();
            VirtualFile file = this.getVirtualFile();
            JSLanguageDialect jSLanguageDialect = fileLanguage = Registry.is((String)"javascript.language.level.pusher.enabled") ? DialectDetector.getLanguageDialectForJSFile(file, this.getManager().getProject()) : LanguageUtil.getLanguageForPsi((Project)this.getManager().getProject(), (VirtualFile)file, (FileType)file.getFileType());
            if (fileLanguage == JavascriptLanguage.INSTANCE) {
                fileLanguage = ECMA6LanguageDialect.INSTANCE;
            }
            if (fileLanguage != ECMA6LanguageDialect.INSTANCE) {
                return;
            }
            if (FlowJSAnnotation.hasFlowPrefix(file) != (this.getBaseLanguage() == FlowJSLanguageDialect.INSTANCE)) {
                ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> this.getManager().getFileManagerEx().forceReload(file)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lang";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/JSFileViewProviderFactory$JSFileViewProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findElementAt";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

