/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.actionscript.psi.impl.ActionScriptFunctionImpl;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSImportType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTopLevelNamespace;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSModuleReferenceType;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumNumberLiteralType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumStringLiteralType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.lang.invoke.StringConcatFactory;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNamedTypeFactory {
    static final char QUOTE_ESCAPE_MARK = 'q';
    static final String QUOTE_ESCAPE = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001", "\u0001"}, (String)Character.toString('q'));
    private static final String PROTOTYPE_SUFFIX = ".prototype";
    private static final String PROTOTYPE_CONSTRUCTOR_SUFFIX = ".prototype.constructor";

    @NotNull
    public static JSType createExplicitlyDeclaredType(@NotNull String typeString, @Nullable PsiElement element) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(0);
        }
        return JSNamedTypeFactory.createType(typeString, JSTypeSourceFactory.createTypeSource(element, true), JSContext.INSTANCE);
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSContext staticOrInstance) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(1);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(2);
        }
        if (staticOrInstance == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(3);
        }
        return JSNamedTypeFactory.createType(typeString, source, JSTypeContext.fromJSContext(staticOrInstance));
    }

    @NotNull
    public static JSStringType createStringPrimitiveType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(4);
        }
        return (JSStringType)JSNamedTypeFactory.createType("string", source, JSTypeContext.INSTANCE);
    }

    @NotNull
    public static JSNumberType createNumberPrimitiveType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(5);
        }
        return (JSNumberType)JSNamedTypeFactory.createType("number", source, JSTypeContext.INSTANCE);
    }

    @NotNull
    public static JSBooleanType createBooleanPrimitiveType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(6);
        }
        return (JSBooleanType)JSNamedTypeFactory.createType("boolean", source, JSTypeContext.INSTANCE);
    }

    @NotNull
    public static JSSymbolType createSymbolPrimitiveType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(7);
        }
        return (JSSymbolType)JSNamedTypeFactory.createType("symbol", source, JSTypeContext.INSTANCE);
    }

    @NotNull
    public static JSBigIntType createBigIntPrimitiveType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(8);
        }
        return (JSBigIntType)JSNamedTypeFactory.createType("bigint", source, JSTypeContext.INSTANCE);
    }

    @NotNull
    public static JSUndefinedType createUndefinedType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(9);
        }
        return (JSUndefinedType)JSNamedTypeFactory.createType("undefined", source, JSTypeContext.INSTANCE);
    }

    @NotNull
    public static JSNullType createNullType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(10);
        }
        return (JSNullType)JSNamedTypeFactory.createType("null", source, JSTypeContext.INSTANCE);
    }

    @NotNull
    public static TypeScriptNeverType createNeverType(@NotNull PsiElement element) {
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(11);
        }
        return JSNamedTypeFactory.createNeverType(JSTypeSourceFactory.createTypeSource(element, true));
    }

    @NotNull
    public static TypeScriptNeverType createNeverType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(12);
        }
        return (TypeScriptNeverType)JSNamedTypeFactory.createType("never", source, JSTypeContext.INSTANCE);
    }

    @NotNull
    public static JSVoidType createVoidType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(13);
        }
        return (JSVoidType)JSNamedTypeFactory.createType("void", source, JSTypeContext.INSTANCE);
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext typeContext) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(14);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(15);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(16);
        }
        return JSNamedTypeFactory.createType(typeString, source, typeContext, true);
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext typeContext, boolean isFromJSDoc) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(17);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(18);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(19);
        }
        return JSNamedTypeFactory.createType(typeString, source, typeContext, isFromJSDoc, false);
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext typeContext, boolean isFromJSDoc, boolean isFromJSDocStrictly) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(20);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(21);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(22);
        }
        if ("*".equals(typeString) || "any".equals(typeString) && (source.getLanguage() != JSTypeSource.SourceLanguage.AS || source.getSourceElement() instanceof JSTypeDeclaration)) {
            JSAnyType jSAnyType = JSAnyType.getWithLanguage(source.getLanguage());
            if (jSAnyType == null) {
                JSNamedTypeFactory.$$$reportNull$$$0(23);
            }
            return jSAnyType;
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.TS && "unknown".equals(typeString)) {
            JSUnknownType jSUnknownType = JSUnknownType.TS_INSTANCE;
            if (jSUnknownType == null) {
                JSNamedTypeFactory.$$$reportNull$$$0(24);
            }
            return jSUnknownType;
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.AS) {
            JSType genericArgument = null;
            if ("Vector$object".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("Object", source, JSContext.INSTANCE);
            }
            if ("Vector$int".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("int", source, JSContext.INSTANCE);
            }
            if ("Vector$uint".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("uint", source, JSContext.INSTANCE);
            }
            if ("Vector$double".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("Number", source, JSContext.INSTANCE);
            }
            if (genericArgument != null) {
                return new JSGenericTypeImpl(source, JSNamedTypeFactory.createType("Vector", source, typeContext), genericArgument);
            }
        }
        if ((typeString = StringUtil.replace((String)typeString, (String)QUOTE_ESCAPE, (String)"\"")).endsWith(PROTOTYPE_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_SUFFIX.length());
            typeContext = JSTypeContext.PROTOTYPE;
        } else if (typeString.endsWith(PROTOTYPE_CONSTRUCTOR_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_CONSTRUCTOR_SUFFIX.length());
            typeContext = JSTypeContext.STATIC;
        } else if (typeString.endsWith(".")) {
            typeString = typeString.substring(0, typeString.length() - 1);
            typeContext = JSTypeContext.STATIC;
        } else if (typeString.endsWith("#")) {
            typeString = typeString.substring(0, typeString.length() - 1);
            typeContext = JSTypeContext.INSTANCE;
        }
        if (typeString.startsWith("typeof ")) {
            typeContext = JSTypeContext.STATIC;
            typeString = typeString.substring("typeof ".length());
        }
        if (typeString.startsWith("import(")) {
            return new JSImportType(typeString, source, typeContext);
        }
        if (isFromJSDoc && isFromJSDocStrictly && typeString.startsWith("module:") && !StringUtil.containsAnyChar((String)typeString, (String)".#~")) {
            String moduleName = typeString.substring("module:".length());
            return new JSModuleReferenceType(moduleName, source);
        }
        JSType primitiveType = JSSpecialNamedTypeImpl.getSpecialType(typeString, source, typeContext, isFromJSDoc);
        return primitiveType != null ? primitiveType : new JSTypeImpl(typeString, source, typeContext, false);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(25);
        }
        return JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, false);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(26);
        }
        return JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, isStrict, true);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict, boolean isDeclaration) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(27);
        }
        return JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, isStrict, isDeclaration, false);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict, boolean isDeclaration, boolean isLocal) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(28);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, isStrict);
        JSTypeContext typeContext = JSTypeContext.fromJSContext(jsContext, isDeclaration);
        return JSNamedTypeFactory.createNamespace(qualifiedName, typeSource, typeContext, isLocal);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSTypeSource typeSource, @NotNull JSTypeContext typeContext, boolean isLocal) {
        if (typeSource == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(29);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(30);
        }
        return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.toString(qualifiedName), typeSource, typeContext, isLocal);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable String qualifiedName, @NotNull JSTypeSource typeSource, @NotNull JSTypeContext typeContext, boolean isLocal) {
        if (typeSource == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(31);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(32);
        }
        if (qualifiedName == null) {
            return new JSTopLevelNamespace(typeSource, isLocal, typeContext);
        }
        if (isLocal) {
            return new JSTypeImpl(qualifiedName, typeSource, typeContext, true);
        }
        JSType type = JSNamedTypeFactory.createType(qualifiedName, typeSource, typeContext, false);
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        JSNamespace jSNamespace = type instanceof JSNamespace ? (JSNamespace)type : JSAnyType.get(JSTypeSourceFactory.copyTypeSource(typeSource, false));
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(33);
        }
        return jSNamespace;
    }

    @Nullable
    public static JSNamespace buildProvidedNamespace(@NotNull JSElementBase element, boolean isStrict) {
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(34);
        }
        return JSNamedTypeFactory.buildProvidedNamespace(element, isStrict, null);
    }

    @Nullable
    public static JSNamespace buildProvidedNamespace(@NotNull JSElementBase element, boolean isStrict, @Nullable Set<PsiElement> visited) {
        JSContext jsContext;
        JSQualifiedName qName;
        JSNamespace ns;
        String name;
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(35);
        }
        if (StringUtil.isEmpty((String)(name = element.getName()))) {
            if (element instanceof JSClassExpression) {
                return new JSClassExpressionType((JSClassExpression)element, JSTypeContext.STATIC);
            }
            return null;
        }
        if (element instanceof ActionScriptFunctionImpl && ((ActionScriptFunctionImpl)element).getParent() instanceof JSFile) {
            return null;
        }
        JSNamespace jSNamespace = ns = visited != null && element instanceof JSDefinitionExpressionImpl ? ((JSDefinitionExpressionImpl)element).calculateSymbolNamespace(visited) : element.getJSNamespace();
        if (ns instanceof JSAnyType) {
            return ns;
        }
        if ("prototype".equals(name)) {
            qName = ns.getQualifiedName();
            jsContext = JSContext.INSTANCE;
        } else {
            qName = JSQualifiedNameImpl.create(name, ns.getQualifiedName());
            jsContext = JSContext.STATIC;
        }
        if (CommonJSUtil.isModuleExportsNamespace(qName)) {
            qName = JSQualifiedNameImpl.create("exports", null);
        }
        return JSNamedTypeFactory.createNamespace(qName, jsContext, element instanceof PsiElement ? (PsiElement)element : null, ns.isSourceStrict() && isStrict, true, ns.isLocal());
    }

    @NotNull
    public static JSNamespace buildJSNamespace(@NotNull JSElementBase element) {
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(36);
        }
        return JSNamedTypeFactory.createNamespace(element.getNamespace(), element.getJSContext(), element instanceof PsiElement ? (PsiElement)element : null, element.isNamespaceExplicitlyDeclared());
    }

    @NotNull
    public static JSNamespace fromNamepath(@NotNull String namepath, boolean isExplicitlyDeclared) {
        if (namepath == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(37);
        }
        JSContext jsContext = JSContext.STATIC;
        if (namepath.endsWith(PROTOTYPE_SUFFIX)) {
            namepath = namepath.substring(0, namepath.length() - "prototype".length() - 1);
            jsContext = JSContext.INSTANCE;
        } else if (namepath.endsWith("#")) {
            namepath = namepath.substring(0, namepath.length() - 1);
            jsContext = JSContext.INSTANCE;
        }
        return JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromNamepath(namepath), jsContext, null, isExplicitlyDeclared);
    }

    @NotNull
    public static JSNamespace copyWithJSContext(@NotNull JSNamespace namespace, @NotNull JSContext jsContext) {
        if (namespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(38);
        }
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(39);
        }
        JSNamespace jSNamespace = namespace.copyWithTypeContext(JSTypeContext.fromJSContext(jsContext, false));
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(40);
        }
        return jSNamespace;
    }

    @NotNull
    public static JSType createEnumLiteralType(@NotNull String enumName, JSFieldVariable enumField, JSTypeSource typeSource) {
        if (enumName == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(41);
        }
        String fieldName = Objects.requireNonNullElse(enumField.getName(), "null");
        if (enumField instanceof TypeScriptEnumField) {
            TypeScriptEnumField enumFieldPsi = (TypeScriptEnumField)enumField;
            JSType type = enumFieldPsi.getConstantValue().getExpandedJSType(null);
            if (type instanceof JSNumberLiteralTypeImpl) {
                JSNumberLiteralTypeImpl literalType = (JSNumberLiteralTypeImpl)type;
                return new TypeScriptEnumNumberLiteralType(literalType.getLiteral(), enumName, fieldName, typeSource, literalType.getValueAsString());
            }
            if (type instanceof JSStringLiteralTypeImpl) {
                JSStringLiteralTypeImpl literalType = (JSStringLiteralTypeImpl)type;
                return new TypeScriptEnumStringLiteralType(literalType.getLiteral(), enumName, fieldName, typeSource);
            }
            if (type instanceof JSPrimitiveLiteralType) {
                JSLiteralType jSLiteralType = ((JSPrimitiveLiteralType)type).copyWithAllowWidening(true);
                if (jSLiteralType == null) {
                    JSNamedTypeFactory.$$$reportNull$$$0(42);
                }
                return jSLiteralType;
            }
        }
        return JSNamedTypeFactory.createType(enumName + "." + fieldName, typeSource, JSTypeContext.INSTANCE, false);
    }

    @NotNull
    public static JSType createFunctionType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(43);
        }
        return source.getLanguage() == JSTypeSource.SourceLanguage.AS ? JSNamedTypeFactory.createType(JSTypeUtils.getFunctionTypeName(source.getScope(), false), source, JSTypeContext.INSTANCE) : new JSFunctionTypeImpl(source, JSFunctionTypeImpl.ANY_PARAMETERS, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23, 24, 33, 40, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 11: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 19: 
            case 22: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeContext";
                break;
            }
            case 23: 
            case 24: 
            case 33: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSNamedTypeFactory";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSNamedTypeFactory";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespace";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithJSContext";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnumLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExplicitlyDeclaredType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStringPrimitiveType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNumberPrimitiveType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBooleanPrimitiveType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolPrimitiveType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBigIntPrimitiveType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createUndefinedType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNullType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createNeverType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createVoidType";
                break;
            }
            case 23: 
            case 24: 
            case 33: 
            case 40: 
            case 42: {
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createNamespace";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildProvidedNamespace";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "buildJSNamespace";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "fromNamepath";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "copyWithJSContext";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createEnumLiteralType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23, 24, 33, 40, 42 -> new IllegalStateException(string);
        };
    }
}

