/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ws.rest.RSBundle;
import org.jetbrains.annotations.NotNull;

public class CreateMethodParamWithPathParamFix
implements LocalQuickFix {
    private final String myName;

    public CreateMethodParamWithPathParamFix(String name) {
        this.myName = name;
    }

    @NotNull
    public String getFamilyName() {
        String string = RSBundle.message("create.method.parameter", new Object[0]);
        if (string == null) {
            CreateMethodParamWithPathParamFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethod psiMethod;
        if (project == null) {
            CreateMethodParamWithPathParamFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            CreateMethodParamWithPathParamFix.$$$reportNull$$$0(2);
        }
        if ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class)) == null) {
            return;
        }
        PsiParameterList parameterList = psiMethod.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        PsiElement lastChild = parameterList.getLastChild();
        if (lastChild == null) {
            return;
        }
        int offset = lastChild.getTextOffset();
        String start = parameters.length == 0 ? "" : ", ";
        String template = start + "@PathParam(\"" + this.myName + "\") $type$ $name$";
        PsiFile psiFile = psiMethod.getContainingFile();
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        OpenFileDescriptor descriptor1 = new OpenFileDescriptor(project, virtualFile, offset);
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor1, true);
        if (editor == null) {
            return;
        }
        Template temp = TemplateManager.getInstance((Project)project).createTemplate("", "", template);
        temp.addVariable("type", "\"String\"", "String", true);
        temp.addVariable("name", "\"" + this.myName + "\"", this.myName, true);
        TemplateManager.getInstance((Project)project).startTemplate(editor, "", temp);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            CreateMethodParamWithPathParamFix.$$$reportNull$$$0(3);
        }
        if (previewDescriptor == null) {
            CreateMethodParamWithPathParamFix.$$$reportNull$$$0(4);
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)JavaFileType.INSTANCE, "", "@PathParam(\"" + this.myName + "\") String " + this.myName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/fixes/CreateMethodParamWithPathParamFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/fixes/CreateMethodParamWithPathParamFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

