/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.dnd;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.actions.DiagramDefaultAddElementAction;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlDnDSupport
extends DropTargetAdapter {
    @NotNull
    private final DiagramBuilder myBuilder;
    @Nullable
    private final DiagramDnDProvider<?> myDnDProvider;

    public UmlDnDSupport(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlDnDSupport.$$$reportNull$$$0(0);
        }
        this.myBuilder = builder;
        this.myDnDProvider = builder.getProvider().getExtras().getDnDProvider();
    }

    @Override
    public void dragEnter(@NotNull DropTargetDragEvent event) {
        Object[] values;
        if (event == null) {
            UmlDnDSupport.$$$reportNull$$$0(1);
        }
        if (this.myDnDProvider == null || (values = this.getValues(event.getTransferable())).length == 0) {
            event.rejectDrag();
            return;
        }
        for (Object value : values) {
            if (this.myDnDProvider.isAcceptedForDnD(value, this.myBuilder.getProject())) continue;
            event.rejectDrag();
            return;
        }
        event.acceptDrag(3);
    }

    private Object @NotNull [] getValues(@NotNull Transferable transferable) {
        block11: {
            Object[] objectArray;
            block10: {
                Object[] customValues;
                if (transferable == null) {
                    UmlDnDSupport.$$$reportNull$$$0(2);
                }
                if (this.myDnDProvider != null && (customValues = this.myDnDProvider.getCustomValues(transferable)) != null) {
                    if (customValues == null) {
                        UmlDnDSupport.$$$reportNull$$$0(3);
                    }
                    return customValues;
                }
                TreeNode[] treeNodes = AbstractProjectViewPane.getTransferedTreeNodes((Transferable)transferable);
                if (treeNodes == null) break block10;
                ArrayList<Object> values = new ArrayList<Object>();
                for (TreeNode treeNode : treeNodes) {
                    AbstractTreeNode node = TreeUtil.getAbstractTreeNode((Object)treeNode);
                    if (node == null) continue;
                    values.add(node.getValue());
                }
                Object[] objectArray2 = ArrayUtil.toObjectArray(values);
                if (objectArray2 == null) {
                    UmlDnDSupport.$$$reportNull$$$0(4);
                }
                return objectArray2;
            }
            try {
                Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
                if (!(transferData instanceof Object[])) break block11;
                objectArray = (Object[])transferData;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (objectArray == null) {
                UmlDnDSupport.$$$reportNull$$$0(5);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            UmlDnDSupport.$$$reportNull$$$0(6);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void drop(@NotNull DropTargetDropEvent event) {
        if (event == null) {
            UmlDnDSupport.$$$reportNull$$$0(7);
        }
        if (this.myDnDProvider == null) {
            event.rejectDrop();
            return;
        }
        Project project = this.myBuilder.getProject();
        Object[] valuesToDrop = this.getValues(event.getTransferable());
        List<Object> newElementsForDataModel = Arrays.stream(valuesToDrop).filter(it -> this.myDnDProvider.isAcceptedForDnD(it, project)).map(it -> this.myDnDProvider.wrapToModelObject(it, project)).filter(it -> it != null && ((Object[])it).length > 0).flatMap(it -> Arrays.stream(it)).collect(Collectors.toList());
        if (!newElementsForDataModel.isEmpty()) {
            DiagramDefaultAddElementAction.addElements(this.myBuilder, newElementsForDataModel);
        }
        event.dropComplete(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/dnd/UmlDnDSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/dnd/UmlDnDSupport";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dragEnter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

