/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.monorepo;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\nJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\nH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "workspaceMonorepoCached", "Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$CachedResult;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "guessContextPackageRoot", "file", "context", "Lcom/intellij/psi/PsiElement;", "getRelatedProjects", "", "getModuleName", "", "Lorg/jetbrains/annotations/Nullable;", "it", "getRoots", "isWorkspaceMonorepo", "", "calcIsWorkspaceMonorepo", "hasPackageJsonWithWorkspaces", "root", "dispose", "", "CachedResult", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSMonorepoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSMonorepoManager.kt\ncom/intellij/javascript/nodejs/monorepo/JSMonorepoManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1#2:111\n1#2:122\n1617#3,9:112\n1869#3:121\n1870#3:123\n1626#3:124\n*S KotlinDebug\n*F\n+ 1 JSMonorepoManager.kt\ncom/intellij/javascript/nodejs/monorepo/JSMonorepoManager\n*L\n70#1:122\n70#1:112,9\n70#1:121\n70#1:123\n70#1:124\n*E\n"})
public final class JSMonorepoManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private volatile CachedResult workspaceMonorepoCached;
    @Nullable
    private Set<? extends VirtualFile> roots;
    @NotNull
    public static final String PNPM_WORKSPACE_YAML_FILENAME = "pnpm-workspace.yaml";

    public JSMonorepoManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<PackageJsonFileManager.PackageJsonChangesListener> topic = PackageJsonFileManager.CHANGES_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"CHANGES_TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> JSMonorepoManager._init_$lambda$0(this, arg_0));
    }

    @Nullable
    public final VirtualFile guessContextPackageRoot(@Nullable VirtualFile file) {
        Object object;
        VirtualFile foundRoot;
        if (file == null) {
            return null;
        }
        if (!JSMonorepoManager.Companion.isEnabled()) {
            return null;
        }
        if (!this.isWorkspaceMonorepo()) {
            return null;
        }
        Set<VirtualFile> roots = this.getRoots();
        if (roots.isEmpty()) {
            return null;
        }
        VirtualFile virtualFile = foundRoot = JSProjectUtil.traverseUpAndFindFirst(file, arg_0 -> JSMonorepoManager.guessContextPackageRoot$lambda$1(arg_0 -> JSMonorepoManager.guessContextPackageRoot$lambda$0(roots, arg_0), arg_0));
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = !Intrinsics.areEqual((Object)it, (Object)ProjectUtil.guessProjectDir((Project)this.project)) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile guessContextPackageRoot(PsiElement context2) {
        if (context2 == null) return null;
        PsiElement it = context2;
        boolean bl = false;
        VirtualFile virtualFile = InjectedLanguageManager.getInstance((Project)this.project).getTopLevelFile(it).getOriginalFile().getVirtualFile();
        if (virtualFile == null) return null;
        it = virtualFile;
        boolean bl2 = false;
        VirtualFile virtualFile2 = this.guessContextPackageRoot((VirtualFile)it);
        return virtualFile2;
    }

    @NotNull
    public final Collection<VirtualFile> getRelatedProjects(@NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        VirtualFile virtualFile = this.guessContextPackageRoot(context2);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile root = virtualFile;
        VirtualFile virtualFile2 = PackageJsonUtil.findChildPackageJsonFile(root);
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile packageJson = virtualFile2;
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
        Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
        PackageJsonData packageJsonData2 = packageJsonData;
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getRoots()), arg_0 -> JSMonorepoManager.getRelatedProjects$lambda$0(projectDir, root, arg_0)), JSMonorepoManager::getRelatedProjects$lambda$1), arg_0 -> JSMonorepoManager.getRelatedProjects$lambda$2(packageJsonData2, this, arg_0)));
    }

    private final String getModuleName(VirtualFile it) {
        String string = PackageJsonData.getOrCreate(it).getName();
        if (string == null) {
            String string2 = it.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VirtualFile> getRoots() {
        Set result2 = this.roots;
        if (result2 == null) {
            void $this$mapNotNullTo$iv$iv;
            Set<VirtualFile> set = PackageJsonFileManager.getInstance(this.project).getValidPackageJsonFiles();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getValidPackageJsonFiles(...)");
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (it.getParent() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            this.roots = result2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        return result2;
    }

    public final boolean isWorkspaceMonorepo() {
        long vfsModCount = VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS.getModificationCount();
        CachedResult result2 = this.workspaceMonorepoCached;
        if (result2 == null || result2.getVfsModCount() != vfsModCount) {
            this.workspaceMonorepoCached = result2 = new CachedResult(vfsModCount, this.calcIsWorkspaceMonorepo());
        }
        return result2.isWorkspaceMonorepo();
    }

    private final boolean calcIsWorkspaceMonorepo() {
        Object object;
        block3: {
            block2: {
                VirtualFile virtualFile;
                object = ProjectUtil.guessProjectDir((Project)this.project);
                if (object == null) break block2;
                VirtualFile it = virtualFile = object;
                boolean bl = false;
                object = it.isValid() ? virtualFile : null;
                if (object != null) break block3;
            }
            return false;
        }
        VirtualFile root = object;
        return root.findChild(PNPM_WORKSPACE_YAML_FILENAME) != null || this.hasPackageJsonWithWorkspaces(root);
    }

    private final boolean hasPackageJsonWithWorkspaces(VirtualFile root) {
        VirtualFile virtualFile = PackageJsonUtil.findChildPackageJsonFile(root);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile packageJson = virtualFile;
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
        Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
        PackageJsonData data2 = packageJsonData;
        return data2.getWorkspaces() != null;
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(JSMonorepoManager this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.workspaceMonorepoCached = null;
        this$0.roots = null;
    }

    private static final VirtualFile guessContextPackageRoot$lambda$0(Set $roots, VirtualFile it) {
        return $roots.contains(it) ? it : null;
    }

    private static final VirtualFile guessContextPackageRoot$lambda$1(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }

    private static final boolean getRelatedProjects$lambda$0(VirtualFile $projectDir, VirtualFile $root, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$projectDir) && !Intrinsics.areEqual((Object)it, (Object)$root);
    }

    private static final VirtualFile getRelatedProjects$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PackageJsonUtil.findChildPackageJsonFile(it);
    }

    private static final boolean getRelatedProjects$lambda$2(PackageJsonData $packageJsonData, JSMonorepoManager this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $packageJsonData.isDependencyOfAnyType(this$0.getModuleName(it));
    }

    @JvmStatic
    @NotNull
    public static final JSMonorepoManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$CachedResult;", "", "vfsModCount", "", "isWorkspaceMonorepo", "", "<init>", "(JZ)V", "getVfsModCount", "()J", "()Z", "intellij.javascript.backend"})
    private static final class CachedResult {
        private final long vfsModCount;
        private final boolean isWorkspaceMonorepo;

        public CachedResult(long vfsModCount, boolean isWorkspaceMonorepo) {
            this.vfsModCount = vfsModCount;
            this.isWorkspaceMonorepo = isWorkspaceMonorepo;
        }

        public final long getVfsModCount() {
            return this.vfsModCount;
        }

        public final boolean isWorkspaceMonorepo() {
            return this.isWorkspaceMonorepo;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager;", "project", "Lcom/intellij/openapi/project/Project;", "isEnabled", "", "PNPM_WORKSPACE_YAML_FILENAME", "", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nJSMonorepoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSMonorepoManager.kt\ncom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,110:1\n30#2,2:111\n*S KotlinDebug\n*F\n+ 1 JSMonorepoManager.kt\ncom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$Companion\n*L\n103#1:111,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JSMonorepoManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JSMonorepoManager> serviceClass$iv = JSMonorepoManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JSMonorepoManager)object;
        }

        private final boolean isEnabled() {
            return Registry.Companion.is("js.show.package_name.in.run.configuration", true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

