/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.JsonObject;
import com.intellij.codeWithMe.ClientId;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.DefaultProjectNpmRegistryServiceWrapper;
import com.intellij.javascript.nodejs.npm.registry.FullTextSearchQuery;
import com.intellij.javascript.nodejs.npm.registry.NpmjsComSearchService;
import com.intellij.javascript.nodejs.npm.registry.NpmsIoService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H&J6\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00a6@\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&J*\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00a6@\u00a2\u0006\u0002\u0010\u001cJ*\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&\u00a8\u0006 "}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService;", "", "<init>", "()V", "findPackages", "", "searchQuery", "Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$SearchQuery;", "limit", "", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "filter", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "consumer", "Ljava/util/function/Consumer;", "Lkotlinx/coroutines/flow/Flow;", "getCachedOrFetchPackageVersions", "Lcom/intellij/javascript/nodejs/npm/AvailablePackageVersions;", "packageName", "", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCachedOrFetchPackageVersionsFuture", "Ljava/util/concurrent/CompletableFuture;", "fetchPackageJson", "Lcom/google/gson/JsonObject;", "versionOrRange", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchPackageJsonFuture", "SearchQuery", "Companion", "intellij.javascript.backend"})
public abstract class NpmRegistryService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public abstract void findPackages(@NotNull SearchQuery var1, int var2, @Nullable VirtualFile var3, @NotNull Condition<NodePackageBasicInfo> var4, @NotNull Consumer<NodePackageBasicInfo> var5) throws IOException, CancellationException;

    @NotNull
    public abstract Flow<NodePackageBasicInfo> findPackages(@NotNull SearchQuery var1, int var2, @Nullable VirtualFile var3, @NotNull Condition<NodePackageBasicInfo> var4);

    @Nullable
    public abstract Object getCachedOrFetchPackageVersions(@NotNull String var1, @Nullable VirtualFile var2, @NotNull Continuation<? super AvailablePackageVersions> var3);

    @NotNull
    public abstract CompletableFuture<AvailablePackageVersions> getCachedOrFetchPackageVersionsFuture(@NotNull String var1, @Nullable VirtualFile var2);

    @Nullable
    public abstract Object fetchPackageJson(@NotNull String var1, @NotNull String var2, @Nullable VirtualFile var3, @NotNull Continuation<? super JsonObject> var4);

    @NotNull
    public abstract CompletableFuture<JsonObject> fetchPackageJsonFuture(@NotNull String var1, @NotNull String var2, @Nullable VirtualFile var3);

    @JvmStatic
    @NotNull
    public static final SearchQuery fullTextSearch(@NotNull String text) {
        return Companion.fullTextSearch(text);
    }

    @JvmStatic
    @NotNull
    public static final SearchQuery namePrefixSearch(@NotNull String prefix) {
        return Companion.namePrefixSearch(prefix);
    }

    @JvmStatic
    @NotNull
    public static final NpmRegistryService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$Companion;", "", "<init>", "()V", "fullTextSearch", "Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$SearchQuery;", "text", "", "namePrefixSearch", "prefix", "getInstance", "Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nNpmRegistryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmRegistryService.kt\ncom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,93:1\n30#2,2:94\n42#3,3:96\n*S KotlinDebug\n*F\n+ 1 NpmRegistryService.kt\ncom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$Companion\n*L\n83#1:94,2\n87#1:96,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SearchQuery fullTextSearch(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new FullTextSearchQuery(text);
        }

        @JvmStatic
        @NotNull
        public final SearchQuery namePrefixSearch(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            SearchQuery query = NpmsIoService.createSearchQuery$intellij_javascript_backend(prefix, true);
            if (query != null) {
                return query;
            }
            return NpmjsComSearchService.createSearchQuery(prefix);
        }

        @JvmStatic
        @NotNull
        public final NpmRegistryService getInstance(@NotNull Project project) {
            NpmRegistryService npmRegistryService;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            try {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<NpmRegistryService> serviceClass$iv = NpmRegistryService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                npmRegistryService = (NpmRegistryService)object;
            }
            catch (IllegalStateException e) {
                if (project.isDefault()) {
                    boolean $i$f$service = false;
                    Class<DefaultProjectNpmRegistryServiceWrapper> serviceClass$iv = DefaultProjectNpmRegistryServiceWrapper.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    return ((DefaultProjectNpmRegistryServiceWrapper)object).getRegistryService$intellij_javascript_backend(project);
                }
                throw e;
            }
            return npmRegistryService;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH&J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H&R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$SearchQuery;", "", "query", "", "<init>", "(Ljava/lang/String;)V", "getQueryUrl", "from", "", "limit", "maxQueryBatchSize", "getMaxQueryBatchSize", "()I", "parseContent", "", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "content", "intellij.javascript.backend"})
    public static abstract class SearchQuery {
        @JvmField
        @NotNull
        public final String query;

        protected SearchQuery(@NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.query = query;
        }

        @NotNull
        public abstract String getQueryUrl(int var1, int var2);

        public abstract int getMaxQueryBatchSize();

        @NotNull
        public abstract List<NodePackageBasicInfo> parseContent(@NotNull String var1) throws IOException;
    }
}

