/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.JSXmlAttributePathUtil;
import com.intellij.lang.javascript.patterns.JSLiteralExpressionPattern;
import com.intellij.lang.javascript.patterns.JSPatterns;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.impl.util.CssInHtmlClassOrIdReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdRefReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JSXReferenceContributor.$$$reportNull$$$0(0);
        }
        CssInHtmlClassOrIdReferenceProvider htmlClassOrIdReferenceProvider = this.createClassOrIdProvider();
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"className", "class"}, (ElementFilter)htmlClassOrIdReferenceProvider.getFilter(), (boolean)false, (PsiReferenceProvider)htmlClassOrIdReferenceProvider);
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"htmlFor"}, (ElementFilter)new ElementFilter(this){

            public boolean isAcceptable(Object element2, @Nullable PsiElement context2) {
                if (!(element2 instanceof XmlAttributeValue)) {
                    return false;
                }
                XmlAttributeValue attributeValue = (XmlAttributeValue)element2;
                return DialectDetector.isJSX((PsiElement)attributeValue) && StringUtil.isQuotedString((String)attributeValue.getText());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }, (PsiReferenceProvider)this.createIdProvider());
        registrar.registerReferenceProvider((ElementPattern)JSXReferenceContributor.createPathJSXAttributePattern(), JSXReferenceContributor.createPathReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)JSXReferenceContributor.createPathAttributePattern(false), JSXReferenceContributor.createPathReferenceProvider());
    }

    @NotNull
    public PsiReferenceProvider createIdProvider() {
        return new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!(element2 instanceof XmlAttributeValue)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new IdRefReference(this, element2){

                    public boolean isSoft() {
                        return true;
                    }
                }};
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/JSXReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXReferenceContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    public CssInHtmlClassOrIdReferenceProvider createClassOrIdProvider() {
        return new CssInHtmlClassOrIdReferenceProvider(this){

            protected boolean isSuitableContextElement(@NotNull PsiElement psiElement) {
                if (psiElement == null) {
                    3.$$$reportNull$$$0(0);
                }
                return DialectDetector.isJSX((PsiElement)psiElement);
            }

            protected boolean isSuitableAttribute(String attrName, XmlAttribute xmlAttribute) {
                XmlAttributeValue valueElement = xmlAttribute.getValueElement();
                return valueElement != null && StringUtil.isQuotedString((String)valueElement.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/frameworks/jsx/JSXReferenceContributor$3", "isSuitableContextElement"));
            }
        };
    }

    public static PsiReferenceProvider createPathReferenceProvider() {
        return new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
                String text;
                if (element2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (HtmlUtil.hasHtmlPrefix((String)(text = StringUtil.unquoteString((String)element2.getText()))) || StringUtil.startsWithIgnoreCase((String)text, (String)"javascript:") || GlobalPathReferenceProvider.startsWithAllowedPrefix((String)text)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(element2, false, false, true, FileType.EMPTY_ARRAY, new PathReferenceProvider[0]);
                if (psiReferenceArray == null) {
                    4.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/JSXReferenceContributor$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXReferenceContributor$4";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static ElementFilter createPathContainedTagFilter(final Boolean allowHtmlNames) {
        return new ElementFilter(){

            public boolean isAcceptable(Object element2, @Nullable PsiElement context2) {
                if (!(element2 instanceof XmlTag)) {
                    return false;
                }
                XmlTag tag = (XmlTag)element2;
                String name = tag.getName();
                if (!allowHtmlNames.booleanValue() && (name.equals("a") || name.equals("link"))) {
                    return false;
                }
                if (!name.toLowerCase(Locale.ROOT).endsWith("link")) {
                    return false;
                }
                return !JSXmlAttributePathUtil.additionalRoots((PsiElement)tag).isEmpty();
            }

            public boolean isClassAcceptable(Class<?> hintClass) {
                return XmlTag.class.isAssignableFrom(hintClass);
            }
        };
    }

    public static JSLiteralExpressionPattern createPathJSXAttributePattern() {
        return (JSLiteralExpressionPattern)((Object)JSPatterns.jsLiteral().inJSXEmbeddedContent((ElementPattern<PsiElement>)PlatformPatterns.psiElement().withParent((ElementPattern)JSXReferenceContributor.createPathAttributePattern(true))));
    }

    public static XmlAttributeValuePattern createPathAttributePattern(Boolean allowHtmlNames) {
        return (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"href", "to"}).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().and((ElementPattern)new FilterPattern(JSXReferenceContributor.createPathContainedTagFilter(allowHtmlNames))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/frameworks/jsx/JSXReferenceContributor", "registerReferenceProviders"));
    }
}

