/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.OrderedSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class JSClosureCompilerSyntaxInspection
extends JSInspection {
    private static final int MAGIC_INITIAL_CAPACITY = 3;

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitJSDocComment(@NotNull JSDocComment docComment) {
                if (docComment == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DialectDetector.isJavaScript((PsiElement)docComment)) {
                    return;
                }
                PsiElement errorElement = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
                HashSet<String> commentInterfaces = new HashSet<String>();
                boolean hasImplements = false;
                boolean hasExtends = false;
                for (JSDocTag tag : docComment.getTags()) {
                    if (tag.is((JSDocTagDefinition)JSDocBlockTags.IMPLEMENTS)) {
                        hasImplements = true;
                        String typeText = (String)ObjectUtils.doIfNotNull((Object)tag.getType(), JSDocTagType::getTypeText);
                        if (typeText == null) continue;
                        JSType type2 = JSTypeParser.createType((Project)docComment.getProject(), (String)typeText, (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)docComment, (boolean)true));
                        if (type2 instanceof JSGenericTypeImpl) {
                            type2 = ((JSGenericTypeImpl)type2).getType();
                        }
                        if (!(type2 instanceof JSTypeImpl)) continue;
                        JSResolvedTypeInfo info = ((JSTypeImpl)type2).resolveType();
                        Collection declarations = info.getDeclarations();
                        boolean hasResolvedInterfaces = false;
                        for (PsiElement declaration : declarations) {
                            String name2;
                            if (!(declaration instanceof JSElementBase) || ((JSElementBase)declaration).isClassOrInterface() != JSElementBase.ClassOrInterface.INTERFACE || (name2 = ((JSElementBase)declaration).getQualifiedName()) == null) continue;
                            commentInterfaces.add(name2);
                            hasResolvedInterfaces = true;
                        }
                        if (hasResolvedInterfaces || JSClassIndex.isInterface(type2.getTypeText(JSType.TypeTextFormat.SIMPLE), (PsiElement)docComment)) {
                            commentInterfaces.add(typeText);
                            continue;
                        }
                        holder.registerProblem((PsiElement)tag.getType(), JavaScriptBundle.message((String)"js.closure.compiler.syntax.implements.not.interface", (Object[])new Object[]{typeText}), new LocalQuickFix[0]);
                        continue;
                    }
                    if (tag.is((JSDocTagDefinition)JSDocBlockTags.EXTENDS)) {
                        hasExtends = true;
                        continue;
                    }
                    this.checkTypeInDocTag(tag);
                }
                String className = docComment.findNameOfClassAppliedTo();
                Object qualifiedClassName = className;
                JSQualifiedName namespace = docComment.getNamespace();
                if (namespace != null && className != null && className.indexOf(46) == -1) {
                    qualifiedClassName = namespace.getQualifiedName() + "." + className;
                }
                if (className != null && (hasImplements || hasExtends)) {
                    PsiElement elementToHighlight = errorElement != null ? errorElement : docComment;
                    OrderedSet implementedInterfaces = new OrderedSet();
                    OrderedSet classesInHierarchy = new OrderedSet();
                    implementedInterfaces.addAll(commentInterfaces);
                    JSClosureCompilerSyntaxInspection.collectHierarchyMembers((String)qualifiedClassName, docComment, (OrderedSet<? super String>)implementedInterfaces, (OrderedSet<? super String>)classesInHierarchy, (Consumer<? super String>)((Consumer)s -> JSClosureCompilerSyntaxInspection.reportCyclicReference(holder, elementToHighlight, s)), commentInterfaces);
                    if (JSClassIndex.isInterface((String)qualifiedClassName, (PsiElement)docComment)) {
                        return;
                    }
                    GlobalSearchScope scope2 = JSResolveUtil.getResolveScope((PsiElement)elementToHighlight);
                    Function classMembersCollector = name -> JSClassResolver.getInstance().findNamespaceMembers(name, scope2);
                    JSClosureCompilerSyntaxInspection.processUnimplementedMethods(className, elementToHighlight, implementedInterfaces, classesInHierarchy, classMembersCollector, t -> t, holder);
                }
            }

            private void checkTypeInDocTag(@NotNull JSDocTag psiTag) {
                JSDocTagType typeElement;
                String type2;
                if (psiTag == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((type2 = (String)ObjectUtils.doIfNotNull((Object)(typeElement = psiTag.getType()), JSDocTagType::getTypeText)) != null) {
                    if (type2.trim().isEmpty()) {
                        holder.registerProblem((PsiElement)typeElement, JavaScriptBundle.message((String)"js.closure.compiler.syntax.empty.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else {
                        boolean parsedCorrectly;
                        boolean bl = parsedCorrectly = (JSClosureCompilerSyntaxInspection.isParameterLikeTag(psiTag) ? new JSTypeParser(psiTag.getProject(), type2, JSTypeSource.EMPTY).parseParameterType() : new JSTypeParser(psiTag.getProject(), type2, JSTypeSource.EMPTY).parse()) != null;
                        if (!parsedCorrectly && !(typeElement.getLastChild() instanceof PsiErrorElement)) {
                            if (typeElement.getFirstChild().getNode().getElementType() == JSDocTokenTypes.DOC_LBRACE && typeElement.getLastChild().getNode().getElementType() == JSDocTokenTypes.DOC_RBRACE) {
                                TextRange range = new TextRange(1, typeElement.getTextLength() - 1);
                                holder.registerProblem((PsiElement)typeElement, range, JavaScriptBundle.message((String)"js.closure.compiler.syntax.invalid.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                            } else {
                                holder.registerProblem((PsiElement)typeElement, JavaScriptBundle.message((String)"js.closure.compiler.syntax.invalid.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                            }
                        }
                    }
                }
            }

            public void visitJSNewExpression(@NotNull JSNewExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitJSNewExpression(node);
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                JSExpression expression = node.getMethodExpression();
                if (expression instanceof JSReferenceExpression) {
                    JSDocComment docComment;
                    PsiElement resolveResult = ((JSReferenceExpression)expression).resolve();
                    if (resolveResult == null) {
                        return;
                    }
                    JSElementBase classOrInterface = (JSElementBase)ObjectUtils.tryCast((Object)JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)resolveResult), JSElementBase.class);
                    if (classOrInterface == null) {
                        return;
                    }
                    if (classOrInterface.isClassOrInterface() == JSElementBase.ClassOrInterface.INTERFACE) {
                        holder.registerProblem((PsiElement)expression, JavaScriptBundle.message((String)"javascript.interface.can.not.be.instantiated.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else if (classOrInterface.isClassOrInterface() == JSElementBase.ClassOrInterface.CLASS && (docComment = JSClosureCompilerSyntaxInspection.findDocComment((JSElement)classOrInterface)) != null && docComment.hasAbstractTag()) {
                        holder.registerProblem((PsiElement)expression, JavaScriptBundle.message((String)"javascript.abstract.class.can.not.be.instantiated.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitJSParameterList(@NotNull JSParameterList node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)node, () -> {
                    boolean foundRest = false;
                    for (JSParameterListElement parameter : node.getParameters()) {
                        if (parameter.getTypeDecorator().isRest() && !parameter.isRest()) {
                            foundRest = true;
                            continue;
                        }
                        if (!foundRest) continue;
                        holder.registerProblem((PsiElement)parameter, JavaScriptBundle.message((String)"javascript.validation.message.parameter.is.not.allowed.after.rest.parameter", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                });
            }

            public void visitJSClass(@NotNull JSClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!DialectDetector.isJavaScript((PsiElement)aClass)) {
                    return;
                }
                JSDocComment docComment = JSClosureCompilerSyntaxInspection.findDocComment((JSElement)aClass);
                if (docComment != null && docComment.hasAbstractTag()) {
                    return;
                }
                Set<JSClass> superClasses = JSClosureCompilerSyntaxInspection.collectSuperClasses(aClass);
                JSClosureCompilerSyntaxInspection.processUnimplementedMethods(aClass, (PsiElement)aClass, Collections.emptySet(), superClasses, superClass -> Arrays.asList(superClass.getFunctions()), JSClass::getName, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "docComment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiTag";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDocComment";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypeInDocTag";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSNewExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSParameterList";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isParameterLikeTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(2);
        }
        return tag.is((JSDocTagDefinition)JSDocBlockTags.PARAM) || tag.is((JSDocTagDefinition)JSDocBlockTags.PROPERTY);
    }

    public static void collectHierarchyMembers(@Nullable String typeName, JSDocComment docComment, OrderedSet<? super String> implementedInterfaces, OrderedSet<? super String> classesInHierarchy, Consumer<? super String> highlightCyclicReference, Set<String> commentInterfaces) {
        if (typeName == null) {
            return;
        }
        classesInHierarchy.add((Object)typeName);
        JSNamespace ns = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName((String)typeName), (JSContext)JSContext.INSTANCE, (PsiElement)docComment);
        ArrayList baseTypeNames = new ArrayList();
        JSTypeEvaluateManager.iterateTypeHierarchy((JSNamespace)ns, clazz -> {
            String name = clazz.getQualifiedName();
            if (name != null) {
                baseTypeNames.add(name);
            }
            return true;
        }, type2 -> {
            String qName = JSTypeUtils.getQualifiedNameMatchingType((JSType)type2, (boolean)false);
            if (qName != null) {
                baseTypeNames.add(qName);
            }
            return true;
        }, (PsiElement)docComment, (boolean)false);
        for (String qName : baseTypeNames) {
            if (typeName.equals(qName)) {
                highlightCyclicReference.consume((Object)typeName);
                continue;
            }
            if (commentInterfaces.contains(qName) || JSClassIndex.isInterface(qName, (PsiElement)docComment)) {
                implementedInterfaces.add((Object)qName);
                continue;
            }
            classesInHierarchy.add((Object)qName);
        }
    }

    private static void reportCyclicReference(ProblemsHolder holder, PsiElement elementToHighlight, String className) {
        holder.registerProblem(elementToHighlight, JavaScriptBundle.message((String)"js.closure.compiler.syntax.cyclic.inheritance", (Object[])new Object[]{className}), new LocalQuickFix[0]);
    }

    @NotNull
    public static Set<JSClass> collectSuperClasses(JSClass aClass) {
        OrderedSet superClasses = new OrderedSet();
        JSClassUtils.processClassesInHierarchy((JSClass)aClass, (boolean)false, (arg_0, arg_1, arg_2) -> JSClosureCompilerSyntaxInspection.lambda$collectSuperClasses$2((Set)superClasses, arg_0, arg_1, arg_2));
        OrderedSet orderedSet = superClasses;
        if (orderedSet == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(3);
        }
        return orderedSet;
    }

    public static @PropertyKey(resourceBundle="messages.JavaScriptBundle") @NotNull String getNotImplementedTextId(boolean isAbstract, boolean isGetter, boolean isSetter) {
        if (isGetter) {
            return isAbstract ? "javascript.validation.message.abstract.get.accessor.not.implemented" : "javascript.validation.message.interface.get.accessor.not.implemented";
        }
        if (isSetter) {
            return isAbstract ? "javascript.validation.message.abstract.set.accessor.not.implemented" : "javascript.validation.message.interface.set.accessor.not.implemented";
        }
        return isAbstract ? "javascript.validation.message.abstract.method.not.implemented" : "javascript.validation.message.interface.method.not.implemented";
    }

    private static <T> void processUnimplementedMethods(@NotNull T sourceClass, @NotNull PsiElement errorElement, @NotNull Set<? extends T> implementedInterfaces, @NotNull Set<? extends T> classesInHierarchy, @NotNull Function<? super T, ? extends Collection<JSPsiElementBase>> getClassMethods, @NotNull Function<? super T, String> getName, @NotNull ProblemsHolder holder) {
        JSSourceElement parent;
        List<JSMethodToImplement> notImplemented;
        if (sourceClass == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(4);
        }
        if (errorElement == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(5);
        }
        if (implementedInterfaces == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(6);
        }
        if (classesInHierarchy == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(7);
        }
        if (getClassMethods == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(8);
        }
        if (getName == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(10);
        }
        if (!(notImplemented = JSClosureCompilerSyntaxInspection.getNotImplementedMethods(sourceClass, implementedInterfaces, classesInHierarchy, getClassMethods, getName)).isEmpty() && (parent = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)errorElement, JSSourceElement.class, (boolean)false)) != null) {
            HashMap<JSMethodToImplement.MethodKey, JSMethodToImplement> notImplementedNames = new HashMap<JSMethodToImplement.MethodKey, JSMethodToImplement>(notImplemented.size());
            for (int i = 0; i < notImplemented.size(); ++i) {
                PsiElement nameIdentifier;
                LocalQuickFix[] fix;
                JSMethodToImplement toImplement = notImplemented.get(i);
                JSMethodToImplement.MethodKey notImplementedName = toImplement.getKey();
                notImplementedNames.put(notImplementedName, toImplement);
                String key = JSClosureCompilerSyntaxInspection.getNotImplementedTextId(toImplement.isAbstractMethod(), toImplement.isGetAccessor(), toImplement.isSetAccessor());
                String message = JavaScriptBundle.message((String)key, (Object[])new Object[]{toImplement.getName(), toImplement.getBaseClassName()});
                String className = (String)getName.fun(sourceClass);
                if (className == null) {
                    className = "<doc>";
                }
                if (i == notImplemented.size() - 1) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                    v1 = localQuickFixArray;
                    localQuickFixArray[0] = JSFixFactory.getInstance().implementJSDocMethodsFix(className, notImplementedNames);
                } else {
                    v1 = fix = LocalQuickFix.EMPTY_ARRAY;
                }
                if (errorElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)errorElement).getNameIdentifier()) != null) {
                    errorElement = nameIdentifier;
                }
                holder.registerProblem(errorElement, message, fix);
            }
        }
    }

    @NotNull
    public static <T> List<JSMethodToImplement> getNotImplementedMethods(@NotNull T sourceClass, @NotNull Set<? extends T> implementedInterfaces, @NotNull Set<? extends T> classesInHierarchy, @NotNull Function<? super T, ? extends Collection<JSPsiElementBase>> getClassMethods, @NotNull Function<? super T, String> getName) {
        if (sourceClass == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(11);
        }
        if (implementedInterfaces == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(12);
        }
        if (classesInHierarchy == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(13);
        }
        if (getClassMethods == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(14);
        }
        if (getName == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(15);
        }
        HashMap<JSMethodToImplement.MethodKey, JSMethodToImplement> methodsToImplement = new HashMap<JSMethodToImplement.MethodKey, JSMethodToImplement>();
        HashSet<JSMethodToImplement.MethodKey> implementedMethods = new HashSet<JSMethodToImplement.MethodKey>(3);
        for (T superClass : classesInHierarchy) {
            for (JSPsiElementBase member : (Collection)getClassMethods.fun(superClass)) {
                if (member.getJSContext() == JSContext.STATIC) continue;
                JSDocComment docComment = JSClosureCompilerSyntaxInspection.findDocComment((JSElement)member);
                if (docComment != null && docComment.hasAbstractTag() && !sourceClass.equals(superClass)) {
                    methodsToImplement.putIfAbsent(JSMethodToImplement.MethodKey.create((JSElement)member), new JSMethodToImplement(member, true, (String)getName.fun(superClass)));
                    continue;
                }
                implementedMethods.add(JSMethodToImplement.MethodKey.create((JSElement)member));
            }
        }
        for (T implementedInterface : implementedInterfaces) {
            for (JSPsiElementBase member : (Collection)getClassMethods.fun(implementedInterface)) {
                if (member.getJSContext() != JSContext.INSTANCE) continue;
                methodsToImplement.putIfAbsent(JSMethodToImplement.MethodKey.create((JSElement)member), new JSMethodToImplement(member, false, (String)getName.fun(implementedInterface)));
            }
        }
        ArrayList<JSMethodToImplement> notImplemented = new ArrayList<JSMethodToImplement>(3);
        for (Map.Entry entry : methodsToImplement.entrySet()) {
            JSMethodToImplement.MethodKey methodToImplement = (JSMethodToImplement.MethodKey)entry.getKey();
            if (implementedMethods.contains(methodToImplement)) continue;
            notImplemented.add((JSMethodToImplement)entry.getValue());
        }
        ArrayList<JSMethodToImplement> arrayList = notImplemented;
        if (arrayList == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    private static JSDocComment findDocComment(@NotNull JSElement member) {
        if (member == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(17);
        }
        return JSStubBasedPsiTreeUtil.findDocComment((PsiElement)member);
    }

    private static /* synthetic */ boolean lambda$collectSuperClasses$2(Set superClasses, JSClass superClass, JSTypeSubstitutor substitutor, boolean __) {
        superClasses.add(superClass);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorElement";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedInterfaces";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesInHierarchy";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getClassMethods";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSuperClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotImplementedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isParameterLikeTag";
                break;
            }
            case 3: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processUnimplementedMethods";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNotImplementedMethods";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 16 -> new IllegalStateException(string);
        };
    }
}

