/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.remote;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.DownloadLibraryQuickFix;
import com.intellij.lang.javascript.modules.remote.JSRemoteModule;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesDownloader;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesRegistry;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.ui.AppUIUtil;
import java.util.Collection;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDownloadRemoteModuleQuickFix
implements LocalQuickFix,
PriorityAction {
    private final String myUrl;

    public JSDownloadRemoteModuleQuickFix(@NotNull String url) {
        if (url == null) {
            JSDownloadRemoteModuleQuickFix.$$$reportNull$$$0(0);
        }
        this.myUrl = url;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            JSDownloadRemoteModuleQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            JSDownloadRemoteModuleQuickFix.$$$reportNull$$$0(2);
        }
        this.downloadInBackground(project);
    }

    @NotNull
    public Future<?> downloadInBackground(final @NotNull Project project) {
        if (project == null) {
            JSDownloadRemoteModuleQuickFix.$$$reportNull$$$0(3);
        }
        final Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        Task.Backgroundable task = new Task.Backgroundable(project, JavaScriptBundle.message((String)"js.url.import.usage.inspection.download.module.0.quick.fix.progress", (Object[])new Object[]{this.myUrl}), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                JSRemoteModulesDownloader.JSRemoteModuleDownloadResult result2;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((result2 = JSDownloadRemoteModuleQuickFix.this.invoke(project, indicator)) == null) {
                    return;
                }
                if (editor != null) {
                    this.showResultStatus(editor, result2);
                }
            }

            private void showResultStatus(@NotNull Editor editor2, @NotNull JSRemoteModulesDownloader.JSRemoteModuleDownloadResult result2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!result2.hasErrors()) {
                    AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> DownloadLibraryQuickFix.showStatus(project, editor2, JavaScriptBundle.message((String)"js.url.import.usage.inspection.download.module.0.quick.fix.success", (Object[])new Object[]{JSDownloadRemoteModuleQuickFix.this.myUrl}), MessageType.INFO, true));
                    return;
                }
                Collection<JSRemoteModule> modules = result2.getModules();
                if (!modules.isEmpty()) {
                    HtmlBuilder builder2 = new HtmlBuilder().append(JavaScriptBundle.message((String)"js.url.import.usage.inspection.download.module.0.quick.fix.warning", (Object[])new Object[]{JSDownloadRemoteModuleQuickFix.this.myUrl})).br().br().append(JavaScriptBundle.message((String)"js.url.import.usage.inspection.download.module.0.quick.fix.warning.urls", (Object[])new Object[0])).br();
                    for (String url : result2.getFailedRequests().keySet()) {
                        builder2.appendLink(url, url).br();
                    }
                    AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> DownloadLibraryQuickFix.showStatus(project, editor2, builder2.toString(), MessageType.WARNING, false));
                } else {
                    AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> DownloadLibraryQuickFix.showStatus(project, editor2, JavaScriptBundle.message((String)"js.url.import.usage.inspection.download.module.0.quick.fix.failed", (Object[])new Object[]{JSDownloadRemoteModuleQuickFix.this.myUrl}), MessageType.ERROR, true));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSDownloadRemoteModuleQuickFix$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "showResultStatus";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Future future = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task), null);
        if (future == null) {
            JSDownloadRemoteModuleQuickFix.$$$reportNull$$$0(4);
        }
        return future;
    }

    @Nullable
    private JSRemoteModulesDownloader.JSRemoteModuleDownloadResult invoke(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        JSRemoteModulesDownloader downloader;
        JSRemoteModulesDownloader.JSRemoteModuleDownloadResult result2;
        if (project == null) {
            JSDownloadRemoteModuleQuickFix.$$$reportNull$$$0(5);
        }
        if ((result2 = (downloader = JSRemoteModulesDownloader.getInstance(project)).downloadModule(this.myUrl, indicator)) == null) {
            return null;
        }
        Collection<JSRemoteModule> modules = result2.getModules();
        for (JSRemoteModule module : modules) {
            JSRemoteModulesRegistry.getInstance().registerModule(module);
        }
        return result2;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.url.import.usage.inspection.download.module.quick.fix.name", (Object[])new Object[0]);
        if (string == null) {
            JSDownloadRemoteModuleQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.TOP;
        if (priority == null) {
            JSDownloadRemoteModuleQuickFix.$$$reportNull$$$0(7);
        }
        return priority;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSDownloadRemoteModuleQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSDownloadRemoteModuleQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadInBackground";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "downloadInBackground";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

